/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.range;

import com.davidsoergel.dsutils.range.Interval;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicInterval<T extends Number>
implements Interval<T> {
    private static final Logger logger = Logger.getLogger(BasicInterval.class);
    protected final T left;
    protected final T right;
    final boolean closedLeft;
    final boolean closedRight;

    public BasicInterval(T left, T right, boolean closedLeft, boolean closedRight) {
        this.left = left;
        this.right = right;
        this.closedLeft = closedLeft;
        this.closedRight = closedRight;
    }

    @Override
    public boolean isClosedLeft() {
        return this.closedLeft;
    }

    @Override
    public boolean isClosedRight() {
        return this.closedRight;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicInterval that = (BasicInterval)o;
        if (this.closedLeft != that.closedLeft) {
            return false;
        }
        if (this.closedRight != that.closedRight) {
            return false;
        }
        if (this.left != null ? !this.left.equals(that.left) : that.left != null) {
            return false;
        }
        return !(this.right != null ? !this.right.equals(that.right) : that.right != null);
    }

    public int hashCode() {
        int result = this.left != null ? this.left.hashCode() : 0;
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        result = 31 * result + (this.closedLeft ? 1 : 0);
        result = 31 * result + (this.closedRight ? 1 : 0);
        return result;
    }

    public String toString() {
        return (this.closedLeft ? "[" : "(") + this.left + "," + this.right + (this.closedRight ? "]" : ")");
    }

    @Override
    public int compareTo(Interval<T> o) {
        int result = ((Comparable)this.getMin()).compareTo(o.getMin());
        if (result == 0) {
            if (this.closedLeft && !o.isClosedLeft()) {
                result = -1;
            } else if (!this.closedLeft && o.isClosedLeft()) {
                result = 1;
            }
        }
        return result;
    }

    @Override
    public boolean encompassesValue(T value) {
        int leftCompare = ((Comparable)this.left).compareTo(value);
        int rightCompare = ((Comparable)this.right).compareTo(value);
        if (this.closedLeft && leftCompare == 0) {
            return true;
        }
        if (this.closedRight && rightCompare == 0) {
            return true;
        }
        return leftCompare < 0 && rightCompare > 0;
    }

    @Override
    public T getMax() {
        return this.right;
    }

    @Override
    public T getMin() {
        return this.left;
    }

    public boolean isZeroWidth() {
        return this.right.equals(this.left);
    }
}

