/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.math;

import org.apache.log4j.Logger;

public class MathUtils {
    public static int logMinOrderOfMagnitude;
    public static int logMaxOrderOfMagnitude;
    public static int logOrdersOfMagnitudePerLevel;
    public static int logBinsPerLevel;
    private static int logLevels;
    private static double[] logBinIncrement;
    private static double[] logBinLimit;
    private static final Logger logger;
    private static final int FACTORIAL_LIMIT = 100;
    private static double[] factorials;
    static double MAX_EXPONENT;
    static double LOG_TWO_PI;
    private static double[][] logTable;
    public static final double LOGTWO;
    public static final double LOGTEN;

    public static double minmax(double min, double b, double max) {
        return Math.max(Math.min(b, max), min);
    }

    public static long choose(int n, int m) {
        if (m == 0) {
            return 1L;
        }
        double result = 1.0;
        for (int i = n; i > n - m; --i) {
            result *= (double)i;
        }
        return (long)(result /= MathUtils.factorial(m));
    }

    public static double factorial(int n) throws ArithmeticException {
        if (n > 100) {
            return MathUtils.stirlingFactorial(n);
        }
        if (factorials[n] == 0.0) {
            MathUtils.factorials[n] = (double)n * MathUtils.factorial(n - 1);
        }
        return factorials[n];
    }

    public static double stirlingFactorial(int n) {
        if (n >= 144) {
            throw new ArithmeticException("Factorials greater than 144 don't fit in Double.");
        }
        double result = Math.sqrt(Math.PI * 2 * (double)n) * Math.pow(n, n) * Math.pow(Math.E, -n);
        return result;
    }

    public static double stirlingLogFactorial(double d) {
        return (d + 0.5) * Math.log(d) - d + 0.5 * LOG_TWO_PI;
    }

    public static double approximateLog(double x) {
        if (x <= logBinIncrement[0]) {
            if (x < 0.0) {
                throw new Error("Can't take log < 0");
            }
            return Math.log(x);
        }
        for (int level = 0; level < logLevels; ++level) {
            if (!(x < logBinLimit[level])) continue;
            return logTable[level][(int)(x / logBinIncrement[level])];
        }
        return Math.log(x);
    }

    public static double approximateLog2(double d) {
        return MathUtils.approximateLog(d) / LOGTWO;
    }

    public static double logsum(double x, double y) {
        if (x == Double.NEGATIVE_INFINITY) {
            return y;
        }
        if (y == Double.NEGATIVE_INFINITY) {
            return x;
        }
        double B = MAX_EXPONENT - Math.log(3.0) - Math.max(x, y);
        double result = Math.log(Math.exp(x + B) + Math.exp(y + B)) - B;
        return result;
    }

    public static double logsum(double x, double y, double z) {
        if (x == Double.NEGATIVE_INFINITY) {
            return MathUtils.logsum(y, z);
        }
        if (y == Double.NEGATIVE_INFINITY) {
            return MathUtils.logsum(x, z);
        }
        if (z == Double.NEGATIVE_INFINITY) {
            return MathUtils.logsum(x, y);
        }
        double B = MAX_EXPONENT - Math.log(3.0) - Math.max(x, Math.max(y, z));
        double result = Math.log(Math.exp(x + B) + Math.exp(y + B) + Math.exp(z + B)) - B;
        if (Double.isNaN(result)) {
            result = Double.NEGATIVE_INFINITY;
        }
        return result;
    }

    public static void initApproximateLog(int minOrderOfMagnitude, int maxOrderOfMagnitude, int ordersOfMagnitudePerLevel, int binsPerLevel) {
        logMinOrderOfMagnitude = minOrderOfMagnitude += ordersOfMagnitudePerLevel;
        logMaxOrderOfMagnitude = maxOrderOfMagnitude;
        logOrdersOfMagnitudePerLevel = ordersOfMagnitudePerLevel;
        logBinsPerLevel = binsPerLevel;
        logLevels = (maxOrderOfMagnitude - minOrderOfMagnitude) / ordersOfMagnitudePerLevel + 1;
        logTable = new double[logLevels][binsPerLevel];
        logBinIncrement = new double[logLevels];
        logBinLimit = new double[logLevels];
        int level = 0;
        for (int order = minOrderOfMagnitude; order <= maxOrderOfMagnitude; order += ordersOfMagnitudePerLevel) {
            MathUtils.logBinLimit[level] = Math.pow(10.0, order);
            MathUtils.logBinIncrement[level] = logBinLimit[level] / (double)binsPerLevel;
            for (int i = 0; i < binsPerLevel; ++i) {
                MathUtils.logTable[level][i] = Math.log((double)i * Math.pow(10.0, order) / (double)binsPerLevel);
            }
            ++level;
        }
        logLevels = level;
    }

    public static boolean equalWithinFPError(double a, double b) {
        if (a == b) {
            return true;
        }
        double nearlyZero = a - b;
        return -1.0E-10 < nearlyZero && nearlyZero < 1.0E-10;
    }

    public static long[] extendedGCD(long x, long y) throws ArithmeticException {
        long[] u = new long[]{1L, 0L, x};
        long[] v = new long[]{0L, 1L, y};
        long[] t = new long[3];
        while (v[2] != 0L) {
            long q = u[2] / v[2];
            for (int i = 0; i < 3; ++i) {
                t[i] = u[i] - v[i] * q;
                u[i] = v[i];
                v[i] = t[i];
            }
        }
        return u;
    }

    public static long[] extendedGCDPositive(long x, long y) throws ArithmeticException {
        long[] u = MathUtils.extendedGCD(x, y);
        if (u[2] < 0L) {
            u[0] = u[0] * -1L;
            u[1] = u[1] * -1L;
            u[2] = u[2] * -1L;
        }
        if (u[0] > 0L) {
            return u;
        }
        long n = -u[0] / y;
        n = y > 0L ? ++n : --n;
        u[0] = u[0] + n * y;
        u[1] = u[1] - n * x;
        return u;
    }

    public static long GCD(long x, long y) {
        return MathUtils.extendedGCD(x, y)[2];
    }

    public static double runningMean(int sampleCount, double priorMean, double value) {
        double d = sampleCount;
        return priorMean + (value - priorMean) / d;
    }

    public static double runningStddevQ(int sampleCount, double priorMean, double priorQ, double value) {
        double d = value - priorMean;
        return priorQ + (double)(sampleCount - 1) * d * d / (double)sampleCount;
    }

    public static double[] runningStddevQtoStddev(double[] stddevQ, int sampleCount) {
        double[] result = new double[stddevQ.length];
        double d = sampleCount;
        for (int i = 0; i < result.length; ++i) {
            result[i] = Math.sqrt(stddevQ[i] / d);
        }
        return result;
    }

    static {
        logger = Logger.getLogger(MathUtils.class);
        factorials = new double[101];
        MAX_EXPONENT = Math.log(Double.MAX_VALUE);
        LOG_TWO_PI = Math.log(Math.PI * 2);
        LOGTWO = Math.log(2.0);
        LOGTEN = Math.log(10.0);
        MathUtils.factorials[0] = 1.0;
        MathUtils.factorials[1] = 1.0;
    }
}

