/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.math;

import com.davidsoergel.dsutils.math.LongRational;
import com.davidsoergel.dsutils.math.MathUtils;
import com.davidsoergel.dsutils.math.SafeIntegerArithmetic;
import org.apache.log4j.Logger;

public class FareyFractionUtils {
    private static final Logger logger = Logger.getLogger(FareyFractionUtils.class);

    public static LongRational rgt(LongRational lft) throws ArithmeticException {
        long[] u = MathUtils.extendedGCDPositive(lft.denominator, -lft.numerator);
        long rgtDenominator = u[1];
        try {
            long mult = SafeIntegerArithmetic.mul(lft.numerator, rgtDenominator);
            long rgtNumerator = (mult + 1L) / lft.denominator;
            return new LongRational(rgtNumerator, rgtDenominator);
        }
        catch (SafeIntegerArithmetic.IllegalArithArgsException e) {
            throw new ArithmeticException("Exhausted resolution of Farey fractions looking for rgt(" + lft + ")");
        }
    }
}

