/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.increment;

import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public abstract class Incrementor {
    private final String clientName;
    private static final Logger logger = Logger.getLogger(Incrementor.class);
    private Set<Listener> listeners = new ConcurrentSkipListSet<Listener>();
    private final int id = idGenerator.incrementAndGet();
    private static AtomicInteger idGenerator = new AtomicInteger(0);

    public abstract void increment();

    public abstract void done();

    public abstract void setMaximum(int var1);

    public abstract void setNote(String var1);

    public abstract void incrementMaximum(int var1);

    public abstract void resetWithNote(String var1);

    public abstract int getCount();

    public abstract int getMax();

    public int getPercent() {
        int m = this.getMax();
        if (m != 0) {
            int p = 100 * this.getCount() / m;
            if (p > 100) {
                logger.warn("progress counter exceeds maximum");
                p = 100;
            }
            return p;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireIncrementableUpdatedEvent(Integer changedI, Integer changedMax) {
        if (changedI >= changedMax) {
            Incrementor incrementor = this;
            synchronized (incrementor) {
                this.notifyAll();
            }
            IncrementorDoneEvent ev = new IncrementorDoneEvent(this.id);
            for (Listener listener : this.listeners) {
                listener.incrementableDone(ev);
            }
        } else {
            IncrementorProgressEvent ev = new IncrementorProgressEvent(this.id, changedI, changedMax);
            for (Listener listener : this.listeners) {
                listener.incrementableProgressUpdated(ev);
            }
        }
    }

    public void fireIncrementableNoteEvent(String note) {
        IncrementorNoteEvent ev = new IncrementorNoteEvent(this.clientName, this.id, note);
        for (Listener listener : this.listeners) {
            listener.incrementableNoteUpdated(ev);
        }
    }

    public void addListener(Listener l) {
        this.listeners.add(l);
    }

    public void removeListener(Listener l) {
        this.listeners.remove(l);
    }

    public int getId() {
        return this.id;
    }

    public Incrementor(String clientName) {
        this.clientName = clientName;
    }

    public static interface Listener
    extends Comparable {
        public void incrementableProgressUpdated(IncrementorProgressEvent var1);

        public void incrementableDone(IncrementorDoneEvent var1);

        public void incrementableNoteUpdated(IncrementorNoteEvent var1);
    }

    public static final class IncrementorProgressEvent
    extends IncrementorEvent {
        private final Integer i;
        private final Integer max;

        public IncrementorProgressEvent(int id, int changedI, int changedMax) {
            super(id);
            this.i = changedI;
            this.max = changedMax;
        }

        public Integer getCount() {
            return this.i;
        }

        public Integer getMax() {
            return this.max;
        }

        public int getPercent() {
            if (this.max != 0) {
                int p = 100 * this.i / this.max;
                if (p > 100) {
                    logger.warn("progress counter exceeds maximum");
                    p = 100;
                }
                return p;
            }
            return 0;
        }
    }

    public static final class IncrementorNoteEvent
    extends IncrementorEvent {
        private final String note;
        private final String clientName;

        public IncrementorNoteEvent(String clientName, int id, String changedNote) {
            super(id);
            this.note = changedNote;
            this.clientName = clientName;
        }

        public String getNote() {
            return this.note;
        }

        public String getClientName() {
            return this.clientName;
        }
    }

    public static final class IncrementorDoneEvent
    extends IncrementorEvent {
        public IncrementorDoneEvent(int id) {
            super(id);
        }
    }

    public static abstract class IncrementorEvent
    implements Serializable {
        private final int id;

        public int getId() {
            return this.id;
        }

        protected IncrementorEvent(int id) {
            this.id = id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IncrementorEventBatch
    implements Serializable {
        private final Set<IncrementorDoneEvent> doneEvents;
        private final Set<IncrementorNoteEvent> noteEvents;
        private final Set<IncrementorProgressEvent> progressEvents;

        public IncrementorEventBatch(Set<IncrementorDoneEvent> doneEvents, Set<IncrementorNoteEvent> noteEvents, Set<IncrementorProgressEvent> progressEvents) {
            this.doneEvents = doneEvents;
            this.noteEvents = noteEvents;
            this.progressEvents = progressEvents;
        }

        public boolean isEmpty() {
            return this.progressEvents.isEmpty() && this.doneEvents.isEmpty() && this.noteEvents.isEmpty();
        }

        public Set<IncrementorDoneEvent> getDoneEvents() {
            return this.doneEvents;
        }

        public Set<IncrementorNoteEvent> getNoteEvents() {
            return this.noteEvents;
        }

        public Set<IncrementorProgressEvent> getProgressEvents() {
            return this.progressEvents;
        }
    }
}

