/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.collections;

import com.davidsoergel.dsutils.collections.SortedSymmetric2dBiMapImpl;
import com.davidsoergel.dsutils.collections.UnorderedPair;
import java.io.Serializable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedSymmetric2dBiMapWithDefault<K extends Comparable<K> & Serializable, V extends Comparable<V> & Serializable>
extends SortedSymmetric2dBiMapImpl<K, V> {
    protected V defaultValue;
    int maxId = 0;

    public SortedSymmetric2dBiMapWithDefault() {
    }

    public SortedSymmetric2dBiMapWithDefault(V defaultValue) {
        this.defaultValue = defaultValue;
    }

    public SortedSymmetric2dBiMapWithDefault(SortedSymmetric2dBiMapWithDefault<K, V> cloneFrom) {
        super(cloneFrom);
        this.defaultValue = cloneFrom.defaultValue;
    }

    @Override
    public V get(K key1, K key2) {
        Object result = super.get(key1, key2);
        if (result == null) {
            result = this.defaultValue;
        }
        return result;
    }

    @Override
    public synchronized void put(K key1, K key2, V d) {
        if (d.equals(this.defaultValue)) {
            this.addKey(key1);
            this.addKey(key2);
        } else {
            super.put(key1, key2, d);
        }
    }

    @Override
    public synchronized void putAll(Map<UnorderedPair<K>, V> result) {
        for (Map.Entry<UnorderedPair<K>, V> entry : result.entrySet()) {
            Comparable value = (Comparable)entry.getValue();
            UnorderedPair<K> pair = entry.getKey();
            K key1 = pair.getKey1();
            K key2 = pair.getKey2();
            assert (!key1.equals(key2));
            if (value.equals(this.defaultValue)) {
                this.addKey(key1);
                this.addKey(key2);
                continue;
            }
            this.keyToKeyPairs.put((Serializable)key1, pair);
            this.keyToKeyPairs.put((Serializable)key2, pair);
            this.keyPairToValueSorted.put(pair, value);
        }
    }

    public V getDefaultValue() {
        return this.defaultValue;
    }

    public void setMaxId(int maxId) {
        this.maxId = maxId;
    }

    public int getMaxId() {
        return this.maxId;
    }

    public void setDefaultValue(V defaultValue) {
        this.defaultValue = defaultValue;
    }
}

