/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.collections;

import java.io.Serializable;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedPair<A, B>
implements Serializable {
    private A key1;
    private B key2;

    public OrderedPair(A key1, B key2) {
        this.key1 = key1;
        this.key2 = key2;
    }

    public A getKey1() {
        return this.key1;
    }

    public B getKey2() {
        return this.key2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderedPair that = (OrderedPair)o;
        if (this.key1 != null ? !this.key1.equals(that.key1) : that.key1 != null) {
            return false;
        }
        return !(this.key2 != null ? !this.key2.equals(that.key2) : that.key2 != null);
    }

    public int hashCode() {
        int result = this.key1 != null ? this.key1.hashCode() : 0;
        result = 31 * result + (this.key2 != null ? this.key2.hashCode() : 0);
        return result;
    }

    public int compareTo(OrderedPair<A, B> o) {
        int c = this.key1.toString().compareTo(o.key1.toString());
        if (c == 0) {
            c = this.key2.toString().compareTo(o.key2.toString());
        }
        return c;
    }

    public static Comparator getRowMajorComparator() {
        return new ValuesPrimaryStringComparator();
    }

    public String toString() {
        return "[" + this.key1 + ", " + this.key2 + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ValuesPrimaryComparator
    implements Comparator<OrderedPair>,
    Serializable {
        @Override
        public int compare(OrderedPair o1, OrderedPair o2) {
            int c = ((Comparable)o1.key2).compareTo(o2.key2);
            if (c == 0) {
                c = ((Comparable)o1.key1).compareTo(o2.key1);
            }
            return c;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ValuesPrimaryStringComparator
    implements Comparator<OrderedPair> {
        @Override
        public int compare(OrderedPair o1, OrderedPair o2) {
            int c = o1.key2.toString().compareTo(o2.key2.toString());
            if (c == 0) {
                c = o1.key1.toString().compareTo(o2.key1.toString());
            }
            return c;
        }
    }
}

