/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.collections;

import com.davidsoergel.dsutils.collections.Map2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class HashMap2D
implements Map2D,
Cloneable,
Serializable {
    public static final long serialVersionUID = 42L;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private transient int modCount = 0;
    private transient Set keySet = null;
    private transient Set entrySet = null;
    private transient Collection values = null;

    public HashMap2D() {
        this(101, 0.75f);
    }

    public HashMap2D(Map2D t) {
        this(Math.max(2 * t.size(), 11), 0.75f);
        this.putAll(t);
    }

    public void putAll(Map2D t) {
        for (Map2D.Entry e : t.entrySet()) {
            this.put(e.getKey1(), null, e.getValue());
        }
    }

    public HashMap2D(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public HashMap2D(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public Object clone() {
        try {
            HashMap2D t = (HashMap2D)super.clone();
            t.table = new Entry[this.table.length];
            int i = this.table.length;
            while (i-- > 0) {
                t.table[i] = this.table[i] != null ? (Entry)this.table[i].clone() : null;
            }
            t.keySet = null;
            t.entrySet = null;
            t.values = null;
            t.modCount = 0;
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public void clear() {
        Entry[] tab = this.table;
        ++this.modCount;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public boolean containsKey(Object key1, Object key2) {
        Entry[] tab = this.table;
        if (key1 != null || key2 != null) {
            int hash1 = key1 != null ? key1.hashCode() : 0;
            int hash2 = key2 != null ? key2.hashCode() : 0;
            int hash = hash1 ^ hash2;
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            while (e != null) {
                if (e.hash == hash && key1.equals(e.key1) && key2.equals(e.key2)) {
                    return true;
                }
                e = e.next;
            }
        } else {
            Entry e = tab[0];
            while (e != null) {
                if (e.key1 == null && e.key2 == null) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean containsValue(Object value) {
        Entry[] tab = this.table;
        if (value == null) {
            int i = tab.length;
            while (i-- > 0) {
                Entry e = tab[i];
                while (e != null) {
                    if (e.value == null) {
                        return true;
                    }
                    e = e.next;
                }
            }
        } else {
            int i = tab.length;
            while (i-- > 0) {
                Entry e = tab[i];
                while (e != null) {
                    if (value.equals(e.value)) {
                        return true;
                    }
                    e = e.next;
                }
            }
        }
        return false;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet(){

                public Iterator iterator() {
                    return new HashIterator(2);
                }

                public boolean contains(Object o) {
                    int hash1;
                    if (!(o instanceof Map2D.Entry)) {
                        return false;
                    }
                    Map2D.Entry entry = (Map2D.Entry)o;
                    Object key1 = entry.getKey1();
                    Entry[] tab = HashMap2D.this.table;
                    int hash = hash1 = key1 == null ? 0 : key1.hashCode();
                    int index = (hash & Integer.MAX_VALUE) % tab.length;
                    Entry e = tab[index];
                    while (e != null) {
                        if (e.hash == hash && e.equals(entry)) {
                            return true;
                        }
                        e = e.next;
                    }
                    return false;
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Map2D.Entry)) {
                        return false;
                    }
                    Map2D.Entry entry = (Map2D.Entry)o;
                    Object key1 = entry.getKey1();
                    Object key2 = entry.getKey2();
                    Entry[] tab = HashMap2D.this.table;
                    int hash1 = key1 == null ? 0 : key1.hashCode();
                    int hash2 = key2 == null ? 0 : key2.hashCode();
                    int hash = hash1 ^ hash2;
                    int index = (hash & Integer.MAX_VALUE) % tab.length;
                    Entry e = tab[index];
                    Entry prev = null;
                    while (e != null) {
                        if (e.hash == hash && e.equals(entry)) {
                            HashMap2D.this.modCount++;
                            if (prev != null) {
                                prev.next = e.next;
                            } else {
                                tab[index] = e.next;
                            }
                            HashMap2D.this.count--;
                            e.value = null;
                            return true;
                        }
                        prev = e;
                        e = e.next;
                    }
                    return false;
                }

                public int size() {
                    return HashMap2D.this.count;
                }

                public void clear() {
                    HashMap2D.this.clear();
                }
            };
        }
        return this.entrySet;
    }

    public Object get(Object key1, Object key2) {
        Entry[] tab = this.table;
        if (key1 != null || key2 != null) {
            int hash1 = key1 != null ? key1.hashCode() : 0;
            int hash2 = key2 != null ? key2.hashCode() : 0;
            int hash = hash1 ^ hash2;
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            while (e != null) {
                if (e.hash == hash && (key1 == null ? e.key1 == null : key1.equals(e.key1)) && (key2 == null ? e.key2 == null : key2.equals(e.key2))) {
                    return e.value;
                }
                e = e.next;
            }
        } else {
            Entry e = tab[0];
            while (e != null) {
                if (e.key1 == null && e.key2 == null) {
                    return e.value;
                }
                e = e.next;
            }
        }
        return null;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                public Iterator iterator() {
                    return new HashIterator(0);
                }

                public int size() {
                    return HashMap2D.this.count;
                }

                public boolean contains(Object o) {
                    return HashMap2D.this.containsKey(o);
                }

                public boolean remove(Object o) {
                    return HashMap2D.this.remove(o) != null;
                }

                public void clear() {
                    HashMap2D.this.clear();
                }
            };
        }
        return this.keySet;
    }

    public Object remove(Object key1, Object key2) {
        Entry[] tab = this.table;
        if (key1 != null || key2 != null) {
            int hash1 = key1 != null ? key1.hashCode() : 0;
            int hash2 = key2 != null ? key2.hashCode() : 0;
            int hash = hash1 ^ hash2;
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            Entry prev = null;
            while (e != null) {
                if (e.hash == hash && (key1 == null ? e.key1 == null : key1.equals(e.key1)) && (key2 == null ? e.key2 == null : key2.equals(e.key2))) {
                    ++this.modCount;
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[index] = e.next;
                    }
                    --this.count;
                    Object oldValue = e.value;
                    e.value = null;
                    return oldValue;
                }
                prev = e;
                e = e.next;
            }
        } else {
            Entry e = tab[0];
            Entry prev = null;
            while (e != null) {
                if (e.key1 == null && e.key2 == null) {
                    ++this.modCount;
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[0] = e.next;
                    }
                    --this.count;
                    Object oldValue = e.value;
                    e.value = null;
                    return oldValue;
                }
                prev = e;
                e = e.next;
            }
        }
        return null;
    }

    public int size() {
        return this.count;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                public Iterator iterator() {
                    return new HashIterator(1);
                }

                public int size() {
                    return HashMap2D.this.count;
                }

                public boolean contains(Object o) {
                    return HashMap2D.this.containsValue(o);
                }

                public void clear() {
                    HashMap2D.this.clear();
                }
            };
        }
        return this.values;
    }

    int capacity() {
        return this.table.length;
    }

    public boolean containsKey(Object key) {
        return false;
    }

    public Object get(Object key) {
        return null;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    public Object put(Object key, Object value) {
        return null;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numBuckets = s.readInt();
        this.table = new Entry[numBuckets];
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            Object key1 = s.readObject();
            Object key2 = s.readObject();
            Object value = s.readObject();
            this.put(key1, key2, value);
        }
    }

    public Object put(Object key1, Object key2, Object value) {
        Entry e;
        Entry[] tab = this.table;
        int hash = 0;
        int index = 0;
        if (key1 != null || key2 != null) {
            int hash1 = key1 != null ? key1.hashCode() : 0;
            int hash2 = key2 != null ? key2.hashCode() : 0;
            hash = hash1 ^ hash2;
            index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry e2 = tab[index];
            while (e2 != null) {
                if (e2.hash == hash && (key1 == null ? e2.key1 == null : key1.equals(e2.key1)) && (key2 == null ? e2.key2 == null : key2.equals(e2.key2))) {
                    Object old = e2.value;
                    e2.value = value;
                    return old;
                }
                e2 = e2.next;
            }
        } else {
            Entry e3 = tab[0];
            while (e3 != null) {
                if (e3.key1 == null && e3.key2 == null) {
                    Object old = e3.value;
                    e3.value = value;
                    return old;
                }
                e3 = e3.next;
            }
        }
        ++this.modCount;
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e = new Entry(hash, key1, key2, value, tab[index]);
        ++this.count;
        return null;
    }

    private void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        ++this.modCount;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldMap[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public Object remove(Object key) {
        return null;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.count);
        for (int index = this.table.length - 1; index >= 0; --index) {
            Entry entry = this.table[index];
            while (entry != null) {
                s.writeObject(entry.key1);
                s.writeObject(entry.key2);
                s.writeObject(entry.value);
                entry = entry.next;
            }
        }
    }

    private class HashIterator
    implements Iterator {
        Entry[] table;
        int index;
        Entry entry;
        Entry lastReturned;
        int type;
        private int expectedModCount;

        HashIterator(int type2) {
            this.table = HashMap2D.this.table;
            this.index = this.table.length;
            this.entry = null;
            this.lastReturned = null;
            this.expectedModCount = HashMap2D.this.modCount;
            this.type = type2;
        }

        public boolean hasNext() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            return this.entry != null;
        }

        public Object next() {
            if (HashMap2D.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            if (this.entry != null) {
                Entry e = this.lastReturned = this.entry;
                this.entry = e.next;
                return this.type == 0 ? e.key1 : (this.type == 1 ? e.value : e);
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (HashMap2D.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry[] tab = HashMap2D.this.table;
            int index = (this.lastReturned.hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            Entry prev = null;
            while (e != null) {
                if (e == this.lastReturned) {
                    HashMap2D.this.modCount++;
                    ++this.expectedModCount;
                    if (prev == null) {
                        tab[index] = e.next;
                    } else {
                        prev.next = e.next;
                    }
                    HashMap2D.this.count--;
                    this.lastReturned = null;
                    return;
                }
                prev = e;
                e = e.next;
            }
            throw new ConcurrentModificationException();
        }
    }

    private static class Entry
    implements Map2D.Entry {
        int hash;
        Object key1;
        Object key2;
        Object value;
        Entry next;

        Entry(int hash, Object key1, Object key2, Object value, Entry next) {
            this.hash = hash;
            this.key1 = key1;
            this.key2 = key2;
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            return new Entry(this.hash, this.key1, this.key2, this.value, this.next == null ? null : (Entry)this.next.clone());
        }

        public Object getKey() {
            return this.key1;
        }

        public Object getKey1() {
            return this.key1;
        }

        public Object getKey2() {
            return this.key2;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map2D.Entry)) {
                return false;
            }
            Map2D.Entry e = (Map2D.Entry)o;
            return (this.key1 == null ? e.getKey1() == null : this.key1.equals(e.getKey1())) && (this.key2 == null ? e.getKey2() == null : this.key2.equals(e.getKey2())) && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        public int hashCode() {
            return this.hash ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key1.toString() + ":" + this.key2.toString() + "=" + this.value.toString();
        }
    }
}

