/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.collections;

import com.davidsoergel.dsutils.DSArrayUtils;
import com.davidsoergel.dsutils.collections.ConcurrentHashWeightedSet;
import com.davidsoergel.dsutils.math.MersenneTwisterFast;
import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections15.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSCollectionUtils
extends CollectionUtils {
    public static <T> ArrayList<T> arrayList(Collection<T> c) {
        if (c instanceof ArrayList) {
            return (ArrayList)c;
        }
        return new ArrayList<T>(c);
    }

    public static ArrayList<Double> plus(List<Number> a, List<Number> b) {
        if (a.size() != b.size()) {
            throw new IndexOutOfBoundsException("Can't add arrays of different sizes");
        }
        ArrayList<Double> result = new ArrayList<Double>(a.size());
        for (int i = 0; i < a.size(); ++i) {
            result.add(a.get(i).doubleValue() + b.get(i).doubleValue());
        }
        return result;
    }

    public static ArrayList<Double> minus(List<Number> a, List<Number> b) {
        if (a.size() != b.size()) {
            throw new IndexOutOfBoundsException("Can't add arrays of different sizes");
        }
        ArrayList<Double> result = new ArrayList<Double>(a.size());
        for (int i = 0; i < a.size(); ++i) {
            result.add(a.get(i).doubleValue() - b.get(i).doubleValue());
        }
        return result;
    }

    public static boolean deepEqualsWithinFPError(Set<Double> a, Set<Double> b) {
        Object[] aa = a.toArray(new Double[0]);
        Object[] bb = b.toArray(new Double[0]);
        Arrays.sort(aa);
        Arrays.sort(bb);
        return DSArrayUtils.equalWithinFPError((Double[])aa, (Double[])bb);
    }

    public static void retainRandom(List list, int numElements) {
        while (list.size() > numElements) {
            list.remove(MersenneTwisterFast.randomInt(list.size()));
        }
    }

    public static void retainRandom(Collection set, int numElements) {
        LinkedList list = new LinkedList(set);
        while (set.size() > numElements) {
            int pos = MersenneTwisterFast.randomInt(set.size());
            set.remove(list.get(pos));
            list.remove(pos);
        }
    }

    public static void retainRandom(Map map, int numElements) {
        LinkedList list = new LinkedList(map.keySet());
        while (map.size() > numElements) {
            int pos = MersenneTwisterFast.randomInt(map.size());
            map.remove(list.get(pos));
            list.remove(pos);
        }
    }

    public static <K, V> List<V> mapAll(Map<K, V> m, Iterable<K> keys) {
        ArrayList<V> result = new ArrayList<V>();
        for (K key : keys) {
            result.add(m.get(key));
        }
        return result;
    }

    public static <K, V> List<V> mapAll(Function<K, V> f, Iterable<K> keys) {
        ArrayList<V> result = new ArrayList<V>();
        for (K key : keys) {
            result.add(f.apply(key));
        }
        return result;
    }

    public static <K, V> List<V> mapAllIgnoringNulls(Map<K, V> m, Iterator<? extends K> keys) {
        ArrayList<V> result = new ArrayList<V>();
        while (keys.hasNext()) {
            V value = m.get(keys.next());
            if (value == null) continue;
            result.add(value);
        }
        return result;
    }

    public static <T> T getDominantFirstElement(Set<List<T>> theLists, int numberThatMustAgree) {
        ConcurrentHashWeightedSet counts = new ConcurrentHashWeightedSet();
        for (List<T> l : theLists) {
            if (l.isEmpty()) continue;
            counts.add(l.get(0), 1.0, 1);
        }
        Object result = counts.getDominantKey();
        if (counts.get(result) < (double)numberThatMustAgree) {
            throw new NoSuchElementException();
        }
        return result;
    }

    public static <T> boolean allFirstElementsEqual(Set<List<? extends T>> theLists) {
        Object o = null;
        if (theLists.isEmpty()) {
            return false;
        }
        for (List<T> l : theLists) {
            if (l.isEmpty()) {
                return false;
            }
            if (o != null) {
                if (!o.equals(l.get(0))) {
                    return false;
                }
            } else {
                o = l.get(0);
            }
            if (o != null) continue;
            return false;
        }
        return true;
    }

    public static <T> Set<List<T>> filterByAndRemoveFirstElement(Set<List<T>> theLists, T firstElement) {
        HashSet<List<T>> result = new HashSet<List<T>>();
        Object o = null;
        for (List<T> theAncestorList : theLists) {
            if (theAncestorList.isEmpty() || theAncestorList.get(0) != firstElement) continue;
            theAncestorList.remove(0);
            result.add(theAncestorList);
        }
        return result;
    }

    public static <T> T removeAllFirstElements(Set<List<? extends T>> theLists) {
        T o = null;
        for (List<T> l : theLists) {
            if (l.isEmpty() && l.isEmpty()) {
                throw new IndexOutOfBoundsException("Can't remove first element from an empty list.");
            }
            o = l.remove(0);
        }
        return o;
    }

    public static <T> Collection<T> getAllFirstElements(Set<List<T>> theLists) {
        HashSet<T> result = new HashSet<T>();
        for (List<T> l : theLists) {
            if (l.isEmpty()) {
                throw new IndexOutOfBoundsException("Can't get first element from an empty list.");
            }
            result.add(l.get(0));
        }
        return result;
    }

    public static <T> T chooseRandom(Collection<T> coll) {
        Object[] ar = coll.toArray();
        return (T)ar[MersenneTwisterFast.randomInt(ar.length)];
    }

    public static <T> T getFirst(Collection<T> coll) {
        return coll.iterator().next();
    }

    public static <T> Set<T> setOf(T ... things) {
        return new HashSet<T>(Arrays.asList(things));
    }

    public static <T> List<T> listOf(T ... things) {
        return new ArrayList<T>(Arrays.asList(things));
    }

    public static <K, V> boolean isEqualMap(Map<K, V> mapA, Map<K, V> mapB) {
        if (mapA.size() != mapB.size()) {
            return false;
        }
        for (Map.Entry<K, V> entry : mapA.entrySet()) {
            if (entry.getValue().equals(mapB.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public static boolean allElementsEqual(Collection list, Object o) {
        if (list == null) {
            return o == null;
        }
        for (Object p : list) {
            if (p.equals(o)) continue;
            return false;
        }
        return true;
    }

    public static boolean allElementsNaN(Collection<Double> list) {
        if (list == null) {
            return true;
        }
        for (Double p : list) {
            if (p.isNaN()) continue;
            return false;
        }
        return true;
    }

    public static double sum(Iterable<Double> a) {
        double result = 0.0;
        for (double d : a) {
            result += d;
        }
        return result;
    }

    public static <T> Set<T> intersectionSet(Collection<T> a, Collection<T> b) {
        return new HashSet<T>(DSCollectionUtils.intersection(a, b));
    }

    public static String[] mapToString(Collection os) {
        ArrayList<String> result = new ArrayList<String>(os.size());
        for (Object o : os) {
            result.add(o.toString());
        }
        return result.toArray(DSArrayUtils.EMPTY_STRING_ARRAY);
    }

    public static <T> Set<Set<T>> subsetsOfSize(Set<T> entries, int i) {
        HashSet<Set<T>> result = new HashSet<Set<T>>();
        Iterator<T> it = entries.iterator();
        while (it.hasNext()) {
            HashSet<T> block = new HashSet<T>();
            try {
                for (int j = 0; j < i; ++j) {
                    block.add(it.next());
                }
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
            result.add(block);
        }
        return result;
    }
}

