/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.collections;

import java.util.BitSet;

public class CircularBitField {
    private BitSet buf;
    private int size;
    private int start;

    public CircularBitField(int size) {
        this.size = size;
        this.buf = new BitSet(size);
        this.start = 0;
    }

    public void clear() {
        this.buf.clear();
    }

    public boolean get(int pos) {
        return this.buf.get((this.start + pos + this.size) % this.size);
    }

    public boolean getLast() {
        return this.buf.get((this.start - 1 + this.size) % this.size);
    }

    public void retain(BitSet mask) {
        int i = this.buf.nextSetBit(0);
        while (i >= 0) {
            int pos = (i - this.start + this.size) % this.size;
            if (!mask.get(pos)) {
                this.buf.set(i, false);
            }
            i = this.buf.nextSetBit(i + 1);
        }
    }

    public void set(int pos, boolean val) {
        this.buf.set((this.start + pos + this.size) % this.size, val);
    }

    public void shift(int steps) {
        this.start = (this.start - steps + this.size) % this.size;
    }
}

