/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils.collections;

import com.davidsoergel.dsutils.collections.ConcurrentHashWeightedSet;
import com.davidsoergel.dsutils.collections.WeightedSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWeightedSet<T>
implements WeightedSet<T> {
    protected Map<T, Double> backingMap;
    protected int itemCount = 0;

    @Override
    public Map<T, Double> getMap() {
        return this.backingMap;
    }

    @Override
    public synchronized SortedSet<T> keysInDecreasingWeightOrder(final Comparator<T> secondarySort) {
        TreeSet<T> result = new TreeSet<T>(new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                int result = -AbstractWeightedSet.this.backingMap.get(o1).compareTo(AbstractWeightedSet.this.backingMap.get(o2));
                if (result == 0 && secondarySort != null) {
                    result = secondarySort.compare(o1, o2);
                }
                return result;
            }
        });
        result.addAll(this.backingMap.keySet());
        return result;
    }

    @Override
    public synchronized double getNormalized(T key) {
        return this.backingMap.get(key) / (double)this.itemCount;
    }

    @Override
    @NotNull
    public synchronized Map<T, Double> getItemNormalizedMap() {
        if (this.itemCount == 0) {
            throw new NoSuchElementException("Can't normalize an empty HashWeightedSet");
        }
        HashMap<T, Double> result = new HashMap<T, Double>(this.backingMap.size());
        double dEntries = this.itemCount;
        for (Map.Entry<T, Double> entry : this.entrySet()) {
            result.put(entry.getKey(), entry.getValue() / dEntries);
        }
        return result;
    }

    @Override
    public int getItemCount() {
        return this.itemCount;
    }

    @Override
    public T getDominantKeyInSet(@NotNull Set<T> keys) {
        Map.Entry<T, Double> result = null;
        for (Map.Entry<T, Double> entry : this.entrySet()) {
            if (!keys.contains(entry.getKey()) || result != null && !(entry.getValue() > result.getValue())) continue;
            result = entry;
        }
        if (result == null) {
            throw new NoSuchElementException();
        }
        return (T)result.getKey();
    }

    @Override
    public T getDominantKey() {
        Map.Entry<T, Double> result = null;
        for (Map.Entry<T, Double> entry : this.entrySet()) {
            if (result != null && !(entry.getValue() > result.getValue())) continue;
            result = entry;
        }
        if (result == null) {
            throw new NoSuchElementException();
        }
        return (T)result.getKey();
    }

    @Override
    public Set<Map.Entry<T, Double>> entrySet() {
        return this.backingMap.entrySet();
    }

    @Override
    public double get(T s) {
        Double d = this.backingMap.get(s);
        return d == null ? 0.0 : d;
    }

    @Override
    public Set<T> keySet() {
        return this.backingMap.keySet();
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public SortedSet<T> keysInDecreasingWeightOrder() {
        return this.keysInDecreasingWeightOrder(null);
    }

    @Override
    public List<Double> weightsInDecreasingOrder() {
        ArrayList<Double> result = new ArrayList<Double>(this.backingMap.values());
        Collections.sort(result, Collections.reverseOrder());
        return result;
    }

    private synchronized Map<T, Double> limitBackingMap(Collection<T> okKeys) {
        HashMap<T, Double> limitedMap = new HashMap<T, Double>();
        for (T okKey : okKeys) {
            Double val = this.backingMap.get(okKey);
            if (val == null || val.equals(0.0)) continue;
            limitedMap.put(okKey, val);
        }
        return limitedMap;
    }

    @Override
    public synchronized WeightedSet<T> extractWithKeys(Collection<T> okKeys) {
        return new ConcurrentHashWeightedSet<T>(this.limitBackingMap(okKeys), this.itemCount);
    }
}

