/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils;

import com.davidsoergel.dsutils.TypeUtils;
import com.davidsoergel.dsutils.increment.Incrementor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubclassFinder {
    private static final Logger logger = Logger.getLogger(SubclassFinder.class);
    private static ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    public static List<Class> findRecursive(String pckgname, Class tosubclass, Incrementor incrementor) throws IOException {
        return SubclassFinder.find(pckgname, tosubclass, true, false, null, incrementor);
    }

    public static void setClassLoader(ClassLoader classLoader) {
        SubclassFinder.classLoader = classLoader;
    }

    private static List<Class> find(@NotNull String pckgname, @NotNull Class tosubclass, boolean recurse, boolean includeInterfaces, Class<? extends Annotation> requiredAnnotation, Incrementor incrementor) throws IOException {
        return SubclassFinder.find(pckgname, tosubclass, recurse, includeInterfaces, requiredAnnotation, null, incrementor);
    }

    public static List<Class> findRecursive(String pckgname, ParameterizedType tosubclass, Incrementor incrementor) throws IOException {
        Class c = (Class)tosubclass.getRawType();
        return SubclassFinder.find(pckgname, c, true, false, null, tosubclass, incrementor);
    }

    private static List<Class> find(@NotNull String pckgname, @NotNull Class tosubclass, boolean recurse, boolean includeInterfaces, Class<? extends Annotation> requiredAnnotation, ParameterizedType requiredParameterizedType, Incrementor incrementor) throws IOException {
        ArrayList<Class> result = new ArrayList<Class>();
        String name = pckgname;
        name = name.replace('.', '/');
        Enumeration<URL> e = null;
        logger.trace("Looking for resources: " + name);
        e = classLoader.getResources(name);
        while (e.hasMoreElements()) {
            URL url = e.nextElement();
            logger.trace("Found resource: " + url);
            result.addAll(SubclassFinder.find(url, pckgname, tosubclass, recurse, includeInterfaces, requiredAnnotation, requiredParameterizedType, incrementor));
        }
        return result;
    }

    public static List<Class> findRecursive(String pckgname, Class tosubclass, Class<? extends Annotation> requiredAnnotation, Incrementor incrementor) throws IOException {
        return SubclassFinder.find(pckgname, tosubclass, true, false, requiredAnnotation, incrementor);
    }

    public static List<Class> find(String pckgname, Class tosubclass, Incrementor incrementor) throws IOException {
        return SubclassFinder.find(pckgname, tosubclass, false, false, null, incrementor);
    }

    public static List<Class> find(String pckgname, ParameterizedType tosubclass, Incrementor incrementor) throws IOException {
        Class c = (Class)tosubclass.getRawType();
        return SubclassFinder.find(pckgname, c, false, false, null, tosubclass, incrementor);
    }

    public static List<Class> find(String pckgname, Type tosubclass, Incrementor incrementor) throws IOException {
        if (tosubclass instanceof Class) {
            return SubclassFinder.find(pckgname, (Class)tosubclass, incrementor);
        }
        if (tosubclass instanceof ParameterizedType) {
            return SubclassFinder.find(pckgname, (ParameterizedType)tosubclass, incrementor);
        }
        throw new Error("Unknown Type: " + tosubclass);
    }

    public static List<Class> find(String pckgname, Class tosubclass, Class<? extends Annotation> requiredAnnotation, Incrementor incrementor) throws IOException {
        return SubclassFinder.find(pckgname, tosubclass, false, false, requiredAnnotation, incrementor);
    }

    private static List find(URL url, String pckgname, Class tosubclass, boolean recurse, boolean includeInterfaces, Class<? extends Annotation> requiredAnnotation, ParameterizedType requiredParameterizedType, Incrementor incrementor) throws IOException {
        ArrayList result = new ArrayList();
        File directory = new File(url.getFile());
        if (directory.exists() && directory.isDirectory()) {
            logger.trace("Directory to check: " + directory);
            String[] files = directory.list();
            incrementor.incrementMaximum(files.length);
            if (files == null) {
                new FileInputStream("/bin/sh");
                throw new IOException("Could not read directory: " + url);
            }
            logger.trace("Files to check: " + files.length);
            block11: for (int i = 0; i < files.length; ++i) {
                incrementor.increment();
                logger.trace("Checking: " + url.getFile() + "/" + files[i]);
                if (recurse && new File(url.getFile() + "/" + files[i]).isDirectory()) {
                    logger.trace("Recursing into package: " + pckgname + "." + files[i]);
                    try {
                        result.addAll(SubclassFinder.find(new URL(url.toString() + "/" + files[i]), pckgname + "." + files[i], tosubclass, recurse, includeInterfaces, requiredAnnotation, requiredParameterizedType, incrementor));
                    }
                    catch (MalformedURLException e) {
                        logger.error("Error", e);
                    }
                    continue;
                }
                if (!files[i].endsWith(".class")) continue;
                String classname = files[i].substring(0, files[i].length() - 6);
                try {
                    logger.trace("Checking class file: " + pckgname + "." + classname);
                    Class<?> c = Class.forName(pckgname + "." + classname, true, classLoader);
                    logger.trace("Is " + c.getName() + " an instance of " + tosubclass.getName() + "?");
                    if (!tosubclass.isAssignableFrom(c) || !includeInterfaces && (Modifier.isAbstract(c.getModifiers()) || c.isInterface())) continue;
                    logger.trace("......YES!");
                    if (requiredAnnotation != null && !c.isAnnotationPresent(requiredAnnotation)) continue;
                    if (requiredParameterizedType == null) {
                        result.add(c);
                        continue;
                    }
                    List<Type> types = Arrays.asList(c.getGenericInterfaces());
                    for (Type t : types) {
                        logger.trace(t);
                        if (!TypeUtils.isAssignableFrom(requiredParameterizedType, t)) continue;
                        result.add(c);
                        continue block11;
                    }
                    continue;
                }
                catch (ClassNotFoundException cnfex) {
                    logger.error("Error", cnfex);
                    continue;
                }
                catch (NoClassDefFoundError cnfex) {
                    logger.error("Error", cnfex);
                    continue;
                }
                catch (ExceptionInInitializerError ex) {
                    logger.error("Error", ex.getCause());
                    logger.error("Error", ex);
                }
            }
        } else {
            try {
                JarURLConnection conn = (JarURLConnection)url.openConnection();
                String starts = conn.getEntryName();
                JarFile jfile = conn.getJarFile();
                Enumeration<JarEntry> e = jfile.entries();
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    incrementor.increment();
                    String entryname = entry.getName();
                    logger.trace("Checking: " + entryname);
                    if (!entryname.startsWith(starts) || !entryname.endsWith(".class") || !recurse && entryname.lastIndexOf(47) > starts.length()) continue;
                    String classname = entryname.substring(0, entryname.length() - 6);
                    if (classname.startsWith("/")) {
                        classname = classname.substring(1);
                    }
                    classname = classname.replace('/', '.');
                    try {
                        logger.trace("Checking class in jar: " + classname);
                        Class<?> c = Class.forName(classname, true, classLoader);
                        logger.trace("Is " + c.getName() + " an instance of " + tosubclass.getName() + "?");
                        if (!tosubclass.isAssignableFrom(c) || !includeInterfaces && c.isInterface()) continue;
                        logger.trace("......YES!");
                        if (requiredAnnotation != null && !c.isAnnotationPresent(requiredAnnotation)) continue;
                        if (requiredParameterizedType == null) {
                            result.add(c);
                            continue;
                        }
                        List<Type> types = Arrays.asList(c.getGenericInterfaces());
                        for (Type t : types) {
                            logger.trace(t);
                            if (!TypeUtils.isAssignableFrom(requiredParameterizedType, t)) continue;
                            result.add(c);
                        }
                    }
                    catch (ClassNotFoundException cnfex) {
                        logger.error("Error", cnfex);
                    }
                    catch (ExceptionInInitializerError ex) {
                        logger.error("Error", ex.getCause());
                        logger.error("Error", ex);
                    }
                }
            }
            catch (IOException ioex) {
                logger.error("Error", ioex);
            }
        }
        return result;
    }

    public static List<Class> findIncludingInterfaces(String pckgname, Class tosubclass, Incrementor incrementor) throws IOException {
        return SubclassFinder.find(pckgname, tosubclass, false, true, null, incrementor);
    }

    public static List<Class> findIncludingInterfaces(String pckgname, Class tosubclass, Class<? extends Annotation> requiredAnnotation, Incrementor incrementor) throws IOException {
        return SubclassFinder.find(pckgname, tosubclass, false, true, requiredAnnotation, incrementor);
    }

    public static List<Class> findRecursiveIncludingInterfaces(String pckgname, Class tosubclass, Incrementor incrementor) throws IOException {
        return SubclassFinder.find(pckgname, tosubclass, true, true, null, incrementor);
    }

    public static List<Class> findRecursiveIncludingInterfaces(@NotNull String pckgname, @NotNull Class tosubclass, Class<? extends Annotation> requiredAnnotation, Incrementor incrementor) throws IOException {
        return SubclassFinder.find(pckgname, tosubclass, true, true, requiredAnnotation, incrementor);
    }
}

