/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils;

import com.davidsoergel.dsutils.PropertiesToMapAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesUtils {
    private static final Logger logger = Logger.getLogger(PropertiesUtils.class);

    public static File findPropertiesFile(String environmentVariableName, String homeDirSubdirName, String defaultFileName) throws FileNotFoundException {
        File result;
        String propsFilename = System.getenv(environmentVariableName);
        logger.debug("Looking for properties file: " + propsFilename);
        if (propsFilename != null && (result = new File(propsFilename)).exists() && result.canRead()) {
            return result;
        }
        propsFilename = System.getProperty("user.dir") + System.getProperty("file.separator") + defaultFileName;
        logger.debug("Looking for properties file: " + propsFilename);
        result = new File(propsFilename);
        if (result.exists() && result.canRead()) {
            return result;
        }
        propsFilename = System.getProperty("user.home") + System.getProperty("file.separator") + homeDirSubdirName + System.getProperty("file.separator") + defaultFileName;
        logger.debug("Looking for properties file: " + propsFilename);
        result = new File(propsFilename);
        if (result.exists() && result.canRead()) {
            return result;
        }
        URL resource = ClassLoader.getSystemClassLoader().getResource(defaultFileName);
        logger.debug("Looking for properties file: " + resource);
        if (resource != null && (result = new File(propsFilename = resource.getFile())).exists() && result.canRead()) {
            return result;
        }
        logger.error("Could not find properties file: " + defaultFileName);
        throw new FileNotFoundException("Could not find properties file: " + defaultFileName);
    }

    public static Map<String, Properties> splitPeriodDelimitedProperties(Properties p) {
        PropertiesToMapAdapter pm = new PropertiesToMapAdapter(p);
        HashMap<String, Properties> result = new HashMap<String, Properties>();
        for (Map.Entry<String, Object> entry : pm.entrySet()) {
            Properties props;
            String[] keyparts = entry.getKey().split("\\.");
            String dbname = keyparts[0];
            if (keyparts.length > 1) {
                props = (Properties)result.get(dbname);
                if (props == null) {
                    props = new Properties();
                    result.put(dbname, props);
                }
                props.put(keyparts[1], entry.getValue());
                continue;
            }
            props = (Properties)result.get("NODATABASE");
            if (props == null) {
                props = new Properties();
                result.put("NODATABASE", props);
            }
            props.put(keyparts[0], entry.getValue());
        }
        return result;
    }

    public static Map<String, Properties> splitPeriodDelimitedPropertiesFromStream(InputStream s) throws IOException {
        Properties p = new Properties();
        p.load(s);
        return PropertiesUtils.splitPeriodDelimitedProperties(p);
    }

    public static Map<String, Properties> splitPeriodDelimitedPropertiesFromFilename(String propsFilename) throws IOException {
        return PropertiesUtils.splitPeriodDelimitedPropertiesFromStream(new FileInputStream(propsFilename));
    }

    public static Map<String, Properties> splitPeriodDelimitedPropertiesFromFile(File propsFile) throws IOException {
        return PropertiesUtils.splitPeriodDelimitedPropertiesFromStream(new FileInputStream(propsFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadPropsFromFile(File propsFile) throws IOException {
        Properties props = new Properties();
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(propsFile);
            props.load(inStream);
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
        }
        return props;
    }
}

