/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils;

import com.davidsoergel.dsutils.PluginException;
import com.davidsoergel.dsutils.SubclassFinder;
import com.davidsoergel.dsutils.increment.Incrementor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginManager<T> {
    private static final Logger logger = Logger.getLogger(PluginManager.class);
    private static Map<Type, PluginManager> _managers = new HashMap<Type, PluginManager>();
    private Type theInterface;
    private Set<String> registeredPackages = new HashSet<String>();
    private HashMap<String, Class> classes = new HashMap();
    private HashMap<String, T> instances = new HashMap();
    private static Collection<String> defaultPackageNames;

    public static void setDefaultPackageNames(Collection<String> defaultPackageNames) {
        PluginManager.defaultPackageNames = defaultPackageNames;
    }

    public static void setDefaultPackageNames(File defaultPackageNameFile) throws IOException {
        defaultPackageNames = new HashSet<String>();
        BufferedReader br = new BufferedReader(new FileReader(defaultPackageNameFile));
        String line = br.readLine();
        while (line != null) {
            defaultPackageNames.add(line);
            line = br.readLine();
        }
    }

    public static <T> void registerPluginsFromDefaultPackages(Type T, Incrementor incrementor) throws IOException {
        if (defaultPackageNames == null || defaultPackageNames.isEmpty()) {
            logger.error("Can't search for plugins of type " + T + ": no default search packages have been set");
        }
        PluginManager<T> m = PluginManager.getManagerForInterface(T);
        m.registerPackages(defaultPackageNames, incrementor);
    }

    public static <T> void registerPluginsFromPackages(Type T, Collection<String> packagenames, Incrementor incrementor) throws IOException {
        PluginManager<T> m = PluginManager.getManagerForInterface(T);
        m.registerPackages(packagenames, incrementor);
    }

    public static <T> void registerPluginsFromPackage(Type T, String packagename, Incrementor incrementor) throws IOException {
        PluginManager<T> m = PluginManager.getManagerForInterface(T);
        m.registerPackage(packagename, incrementor);
    }

    public static <T> PluginManager<T> getManagerForInterface(Type T) {
        PluginManager<T> result;
        if (_managers == null) {
            _managers = new HashMap<Type, PluginManager>();
        }
        if ((result = _managers.get(T)) == null) {
            result = new PluginManager<T>(T);
            _managers.put(T, result);
        }
        return result;
    }

    public static <T> T getSingletonByName(Type T, String s) throws PluginException {
        return PluginManager.getManagerForInterface(T).getSingletonByName(s);
    }

    public static Class getClassByName(Class T, String s) throws PluginException {
        return PluginManager.getManagerForInterface(T).getClassByName(s);
    }

    public static Set<String> getKeySet(Type T) throws PluginException {
        return PluginManager.getManagerForInterface(T).getKeySet();
    }

    public static Collection<Class> getPlugins(Type T) {
        return PluginManager.getManagerForInterface(T).getValues();
    }

    public Collection<Class> getValues() {
        return this.classes.values();
    }

    public static <T> T getNewInstanceByName(Class T, String s) throws PluginException {
        return PluginManager.getManagerForInterface(T).getNewInstanceByName(s);
    }

    public PluginManager(Type T) {
        this.theInterface = T;
    }

    public Class getClassByName(String s) throws PluginException {
        if (s == null) {
            return null;
        }
        Class result = this.classes.get(s);
        if (result == null) {
            logger.trace("Classes: " + this.classes);
            logger.trace("Classpath: " + System.getProperty("java.class.path"));
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            logger.trace("contextClassLoader: " + contextClassLoader);
            ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
            logger.trace("systemClassLoader: " + systemClassLoader);
            String name = this.theInterface instanceof Class ? ((Class)this.theInterface).getSimpleName() : this.theInterface.toString();
            throw new PluginException("Can't find plugin " + s + ".  Available plugins of type " + name + ": \n" + StringUtils.join(this.classes.keySet().iterator(), "\n"));
        }
        return result;
    }

    public Set<String> getKeySet() {
        return this.classes.keySet();
    }

    public T getNewInstanceByName(String s) throws PluginException {
        try {
            return this.getClassByName(s).newInstance();
        }
        catch (Exception e) {
            throw new PluginException(e);
        }
    }

    public T getSingletonByName(String s) throws PluginException {
        T result = this.instances.get(s);
        if (result == null) {
            Class c = this.classes.get(s);
            if (c != null) {
                try {
                    this.instances.put(c.getCanonicalName(), c.newInstance());
                    result = this.instances.get(s);
                }
                catch (InstantiationException e) {
                    logger.error("Error", e);
                }
                catch (IllegalAccessException e) {
                    logger.error("Error", e);
                }
            } else {
                String name = this.theInterface instanceof Class ? ((Class)this.theInterface).getSimpleName() : this.theInterface.toString();
                throw new PluginException("Can't find plugin " + s + ".  Available plugins of type " + name + ": \n" + StringUtils.join(this.classes.keySet().iterator(), "\n"));
            }
        }
        return result;
    }

    public void registerPackages(Collection<String> packagenames, Incrementor incrementor) throws IOException {
        for (String packagename : packagenames) {
            this.registerPackage(packagename, incrementor);
        }
    }

    public void registerPackage(String packagename, Incrementor incrementor) throws IOException {
        if (!this.registeredPackages.contains(packagename)) {
            List<Class> found;
            this.registeredPackages.add(packagename);
            if (this.theInterface instanceof Class) {
                found = SubclassFinder.findRecursive(packagename, (Class)this.theInterface, incrementor);
            } else if (this.theInterface instanceof ParameterizedType) {
                found = SubclassFinder.findRecursive(packagename, (ParameterizedType)this.theInterface, incrementor);
            } else {
                throw new Error("Not a Class or a ParameterizedType: " + this.theInterface);
            }
            for (Class c : found) {
                if (c.isInterface() || Modifier.isAbstract(c.getModifiers()) || c.getAnnotation(Deprecated.class) != null) continue;
                this.classes.put(c.getCanonicalName(), c);
            }
        }
    }
}

