/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class EnvironmentUtils {
    private static final Logger logger = Logger.getLogger(EnvironmentUtils.class);
    static String cacheRoot = "/tmp/";

    public static void init(File propFile) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(propFile);
            Properties p = new Properties(System.getProperties());
            p.load(in);
            System.setProperties(p);
            cacheRoot = System.getProperty("CACHEROOT");
            if (cacheRoot == null) {
                logger.warn("No CACHEROOT set, using /tmp");
                cacheRoot = "/tmp/";
            }
        }
        catch (Exception e) {
            throw new Error(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error("Error", e);
                }
            }
        }
        if (!cacheRoot.endsWith(File.separator)) {
            cacheRoot = cacheRoot + File.separator;
        }
    }

    public static String getCacheRoot() {
        if (cacheRoot == null) {
            throw new Error("EnvironmentUtils has not been initialized");
        }
        return cacheRoot;
    }

    public static void setCacheRoot(String cacheRoot) {
        EnvironmentUtils.cacheRoot = cacheRoot;
    }
}

