/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils;

import com.davidsoergel.dsutils.DSArrayUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSStringUtils
extends StringUtils {
    private static final Logger logger = Logger.getLogger(DSStringUtils.class);

    public static String s(Object o) {
        if (o == null) {
            return "";
        }
        String s = o.toString();
        if (s.equals("null")) {
            s = "";
        }
        return s;
    }

    public static String htmlEncode(String val) {
        return StringEscapeUtils.escapeHtml(val);
    }

    public static String cap(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static String oracleEscapeSingleQuotes(String s) {
        if (s == null) {
            return null;
        }
        int i = s.indexOf("'");
        if (i == -1) {
            return s;
        }
        try {
            return s.substring(0, i) + "''" + DSStringUtils.oracleEscapeSingleQuotes(s.substring(i + 1));
        }
        catch (StringIndexOutOfBoundsException e) {
            return s.substring(0, i) + "''";
        }
    }

    public static Set<String> tokenSet(String s, String delim) {
        StringTokenizer st = new StringTokenizer(s, delim);
        HashSet<String> result = new HashSet<String>();
        while (st.hasMoreTokens()) {
            result.add(st.nextToken());
        }
        return result;
    }

    public static String join(Iterable s, String delim) {
        return DSStringUtils.join(s.iterator(), delim);
    }

    public static String joinSorted(Set s, String delim) {
        return DSStringUtils.join(new TreeSet(s), delim);
    }

    public static String join(char[] chars, String delim) {
        return DSArrayUtils.asString(chars, delim);
    }

    public static String join(double[] doubles, String delim) {
        return DSStringUtils.join((Object[])ArrayUtils.toObject(doubles), delim);
    }

    public static String month2name(int i) {
        switch (i) {
            case 0: {
                return "January";
            }
            case 1: {
                return "February";
            }
            case 2: {
                return "March";
            }
            case 3: {
                return "April";
            }
            case 4: {
                return "May";
            }
            case 5: {
                return "June";
            }
            case 6: {
                return "July";
            }
            case 7: {
                return "August";
            }
            case 8: {
                return "September";
            }
            case 9: {
                return "October";
            }
            case 10: {
                return "November";
            }
            case 11: {
                return "December";
            }
        }
        return "Invalid Month";
    }

    public static String escapeHTML(String s) {
        return StringEscapeUtils.escapeHtml(s);
    }

    public static void trimAll(String[] result) {
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i].trim();
        }
    }
}

