/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils;

import com.davidsoergel.dsutils.DSClassUtils;
import com.davidsoergel.dsutils.math.MathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class DSArrayUtils
extends ArrayUtils {
    private static final Logger logger = Logger.getLogger(DSArrayUtils.class);

    public static boolean equalWithinFPError(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new IndexOutOfBoundsException("Can't compare arrays of different sizes");
        }
        for (int i = 0; i < a.length; ++i) {
            if (MathUtils.equalWithinFPError(a[i], b[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equalWithinFPError(Double[] a, Double[] b) {
        if (a.length != b.length) {
            throw new IndexOutOfBoundsException("Can't compare arrays of different sizes");
        }
        for (int i = 0; i < a.length; ++i) {
            if (MathUtils.equalWithinFPError(a[i], b[i])) continue;
            return false;
        }
        return true;
    }

    public static double[] minus(double[] a, double[] b) {
        double[] result = (double[])a.clone();
        DSArrayUtils.decrementBy(result, b);
        return result;
    }

    public static void decrementBy(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new IndexOutOfBoundsException("Can't add arrays of different sizes");
        }
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            a[n] = a[n] - b[i];
        }
    }

    public static void decrementByWeighted(double[] a, double[] b, double weight) {
        if (a.length != b.length) {
            throw new IndexOutOfBoundsException("Can't add arrays of different sizes");
        }
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            a[n] = a[n] - b[i] * weight;
        }
    }

    public static double[][] plus(double[][] a, double[][] b) {
        if (a.length != b.length) {
            throw new ArrayIndexOutOfBoundsException("Can't add arrays of different sizes");
        }
        double[][] result = new double[a.length][];
        for (int i = 0; i < a.length; ++i) {
            result[i] = new double[a[i].length];
            if (a[i].length != b[i].length) {
                throw new ArrayIndexOutOfBoundsException("Can't add arrays of different sizes");
            }
            for (int j = 0; j < a[i].length; ++j) {
                result[i][j] = a[i][j] + b[i][j];
            }
        }
        return result;
    }

    public static double[] plus(double[] a, double[] b) {
        double[] result = (double[])a.clone();
        DSArrayUtils.incrementBy(result, b);
        return result;
    }

    public static void incrementBy(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new IndexOutOfBoundsException("Can't add arrays of different sizes");
        }
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            a[n] = a[n] + b[i];
        }
    }

    public static void incrementByWeighted(double[] a, double[] b, double weight) {
        if (a.length != b.length) {
            throw new IndexOutOfBoundsException("Can't add arrays of different sizes");
        }
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            a[n] = a[n] + b[i] * weight;
        }
    }

    @Nullable
    public static double[][] deepcopy(double[][] copyFrom) {
        return DSArrayUtils.deepcopy(copyFrom, 0, 0.0);
    }

    public static int[] deepcopy(int[] copyFrom) {
        int[] to = new int[copyFrom.length];
        for (int j = 0; j < copyFrom.length; ++j) {
            to[j] = copyFrom[j];
        }
        return to;
    }

    public static int[][] deepcopy(int[][] copyFrom) {
        return DSArrayUtils.deepcopy(copyFrom, 0, 0);
    }

    public static char[][] deepcopy(char[][] copyFrom) {
        return DSArrayUtils.deepcopy(copyFrom, 0, ' ');
    }

    public static byte[][] deepcopy(byte[][] copyFrom) {
        return DSArrayUtils.deepcopy(copyFrom, 0, (byte)32);
    }

    @Nullable
    public static double[][] deepcopy(double[][] copyFrom, int newcolumns, double newval) {
        if (copyFrom == null) {
            return null;
        }
        double[][] to = new double[copyFrom.length][];
        for (int i = 0; i < copyFrom.length; ++i) {
            int j;
            if (copyFrom[i] == null) continue;
            to[i] = new double[copyFrom[i].length + newcolumns];
            if (newcolumns < 0) {
                for (j = 0; j < copyFrom[i].length + newcolumns; ++j) {
                    to[i][j] = copyFrom[i][j];
                }
                continue;
            }
            for (j = 0; j < copyFrom[i].length; ++j) {
                to[i][j] = copyFrom[i][j];
            }
            for (j = copyFrom[i].length; j < copyFrom[i].length + newcolumns; ++j) {
                to[i][j] = newval;
            }
        }
        return to;
    }

    public static int[][] deepcopy(int[][] copyFrom, int newcolumns, int newval) {
        int[][] to = new int[copyFrom.length][];
        for (int i = 0; i < copyFrom.length; ++i) {
            int j;
            to[i] = new int[copyFrom[i].length + newcolumns];
            if (newcolumns < 0) {
                for (j = 0; j < copyFrom[i].length + newcolumns; ++j) {
                    to[i][j] = copyFrom[i][j];
                }
                continue;
            }
            for (j = 0; j < copyFrom[i].length; ++j) {
                to[i][j] = copyFrom[i][j];
            }
            for (j = copyFrom[i].length; j < copyFrom[i].length + newcolumns; ++j) {
                to[i][j] = newval;
            }
        }
        return to;
    }

    public static char[][] deepcopy(char[][] copyFrom, int newcolumns, char newval) {
        char[][] to = new char[copyFrom.length][];
        for (int i = 0; i < copyFrom.length; ++i) {
            int j;
            to[i] = new char[copyFrom[i].length + newcolumns];
            if (newcolumns < 0) {
                for (j = 0; j < copyFrom[i].length + newcolumns; ++j) {
                    to[i][j] = copyFrom[i][j];
                }
                continue;
            }
            for (j = 0; j < copyFrom[i].length; ++j) {
                to[i][j] = copyFrom[i][j];
            }
            for (j = copyFrom[i].length; j < copyFrom[i].length + newcolumns; ++j) {
                to[i][j] = newval;
            }
        }
        return to;
    }

    public static byte[][] deepcopy(byte[][] copyFrom, int newcolumns, byte newval) {
        byte[][] to = new byte[copyFrom.length][];
        for (int i = 0; i < copyFrom.length; ++i) {
            int j;
            to[i] = new byte[copyFrom[i].length + newcolumns];
            if (newcolumns < 0) {
                for (j = 0; j < copyFrom[i].length + newcolumns; ++j) {
                    to[i][j] = copyFrom[i][j];
                }
                continue;
            }
            for (j = 0; j < copyFrom[i].length; ++j) {
                to[i][j] = copyFrom[i][j];
            }
            for (j = copyFrom[i].length; j < copyFrom[i].length + newcolumns; ++j) {
                to[i][j] = newval;
            }
        }
        return to;
    }

    public static int sum(int[] a) {
        int result = 0;
        for (int i = 0; i < a.length; ++i) {
            result += a[i];
        }
        return result;
    }

    public static int sum(Integer[] a) {
        int result = 0;
        for (int i = 0; i < a.length; ++i) {
            result += a[i].intValue();
        }
        return result;
    }

    public static double sum(double[] a) {
        double result = 0.0;
        for (int i = 0; i < a.length; ++i) {
            result += a[i];
        }
        return result;
    }

    public static double sumOfSquares(double[] a) {
        double result = 0.0;
        for (int i = 0; i < a.length; ++i) {
            result += a[i] * a[i];
        }
        return result;
    }

    public static double sum(double[][] a) {
        return DSArrayUtils.sumFirstNColumns(a, a[0].length);
    }

    public static double sumFirstNColumns(double[][] a, int cols) {
        double result = 0.0;
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < cols; ++j) {
                result += a[i][j];
            }
        }
        return result;
    }

    public static double product(double[] a) {
        double result = 0.0;
        for (int i = 0; i < a.length; ++i) {
            result *= a[i];
        }
        return result;
    }

    public static int max(int[] x) {
        int result = Integer.MIN_VALUE;
        for (int col = 0; col < x.length; ++col) {
            result = Math.max(result, x[col]);
        }
        return result;
    }

    public static double max(double[] x) {
        double result = Double.NEGATIVE_INFINITY;
        for (int col = 0; col < x.length; ++col) {
            result = Math.max(result, x[col]);
        }
        return result;
    }

    public static Double max(Double[] x) {
        double result = Double.NEGATIVE_INFINITY;
        for (int col = 0; col < x.length; ++col) {
            result = Math.max(result, x[col]);
        }
        return result;
    }

    public static int argmax(double[] x) {
        int posmax = 0;
        for (int col = 0; col < x.length; ++col) {
            if (!(x[col] > x[posmax])) continue;
            posmax = col;
        }
        return posmax;
    }

    public static int min(int[] x) {
        int result = Integer.MAX_VALUE;
        for (int col = 0; col < x.length; ++col) {
            result = Math.min(result, x[col]);
        }
        return result;
    }

    public static double min(double[] x) {
        double result = Double.POSITIVE_INFINITY;
        for (int col = 0; col < x.length; ++col) {
            result = Math.min(result, x[col]);
        }
        return result;
    }

    public static int argmin(double[] x) {
        int posmax = 0;
        for (int col = 0; col < x.length; ++col) {
            if (!(x[col] < x[posmax])) continue;
            posmax = col;
        }
        return posmax;
    }

    public static int[] positions(int[] x, int value) {
        int[] result = new int[x.length];
        int count = 0;
        for (int col = 0; col < x.length; ++col) {
            if (x[col] != value) continue;
            result[count] = col;
            ++count;
        }
        result = DSArrayUtils.prefix(result, count);
        return result;
    }

    public static boolean[] mapEquals(double[] x, double value) {
        boolean[] result = new boolean[x.length];
        for (int col = 0; col < x.length; ++col) {
            result[col] = x[col] == value;
        }
        return result;
    }

    public static boolean[] mapEquals(double[] x, double value, boolean[] mask) {
        boolean[] result = new boolean[x.length];
        for (int col = 0; col < x.length; ++col) {
            result[col] = mask[col] && x[col] == value;
        }
        return result;
    }

    public static boolean[] mapNotEquals(double[] x, double value) {
        boolean[] result = new boolean[x.length];
        for (int col = 0; col < x.length; ++col) {
            result[col] = x[col] != value;
        }
        return result;
    }

    public static boolean[] mapNotEquals(double[] x, double value, boolean[] mask) {
        boolean[] result = new boolean[x.length];
        for (int col = 0; col < x.length; ++col) {
            result[col] = mask[col] && x[col] != value;
        }
        return result;
    }

    public static boolean[] mapNotNaN(double[] x) {
        boolean[] result = new boolean[x.length];
        for (int col = 0; col < x.length; ++col) {
            result[col] = !Double.isNaN(x[col]);
        }
        return result;
    }

    public static boolean[] mapNotNaN(double[] x, boolean[] mask) {
        boolean[] result = new boolean[x.length];
        for (int col = 0; col < x.length; ++col) {
            result[col] = mask[col] && !Double.isNaN(x[col]);
        }
        return result;
    }

    public static boolean[] mapNotNaNOrInfinite(double[] x) {
        boolean[] result = new boolean[x.length];
        for (int col = 0; col < x.length; ++col) {
            result[col] = !Double.isNaN(x[col]) && !Double.isInfinite(x[col]);
        }
        return result;
    }

    public static boolean[] mapNotNaNOrInfinite(double[] x, boolean[] mask) {
        boolean[] result = new boolean[x.length];
        for (int col = 0; col < x.length; ++col) {
            result[col] = mask[col] && !Double.isNaN(x[col]) && !Double.isInfinite(x[col]);
        }
        return result;
    }

    public static int count(double[] x, double value) {
        int count = 0;
        for (int col = 0; col < x.length; ++col) {
            if (x[col] != value) continue;
            ++count;
        }
        return count;
    }

    public static int count(boolean[] x, boolean value) {
        int count = 0;
        for (int col = 0; col < x.length; ++col) {
            if (x[col] != value) continue;
            ++count;
        }
        return count;
    }

    public static int countNot(double[] x, double value) {
        int count = 0;
        for (int col = 0; col < x.length; ++col) {
            if (x[col] == value) continue;
            ++count;
        }
        return count;
    }

    public static int countNotNaN(double[] x) {
        int count = 0;
        for (int col = 0; col < x.length; ++col) {
            if (Double.isNaN(x[col])) continue;
            ++count;
        }
        return count;
    }

    public static int countNotNaNOrInfinite(double[] x) {
        int count = 0;
        for (int col = 0; col < x.length; ++col) {
            if (Double.isNaN(x[col]) || Double.isInfinite(x[col])) continue;
            ++count;
        }
        return count;
    }

    public static double[] grow(double[] a, int x) {
        double[] result = new double[a.length + x];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i];
        }
        return result;
    }

    public static String asString(char[] x, String separator) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < x.length; ++i) {
            char i1 = x[i];
            sb.append(i1);
            if (i == x.length - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String asString(int[] x, String separator) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < x.length; ++i) {
            int i1 = x[i];
            sb.append(i1);
            if (i == x.length - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static boolean contains(Object[] a, Object o) {
        for (int i = 0; i < a.length; ++i) {
            if (!a[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    public static double[] castToDouble(int[] p) {
        double[] result = new double[p.length];
        for (int i = 0; i < p.length; ++i) {
            result[i] = p[i];
        }
        return result;
    }

    public static double[] castToDouble(float[] p) {
        double[] result = new double[p.length];
        for (int i = 0; i < p.length; ++i) {
            result[i] = p[i];
        }
        return result;
    }

    public static byte[] prefix(byte[] s, int i) {
        byte[] result = new byte[i];
        System.arraycopy(s, 0, result, 0, i);
        return result;
    }

    public static double[] prefix(double[] s, int i) {
        double[] result = new double[i];
        System.arraycopy(s, 0, result, 0, i);
        return result;
    }

    public static int[] prefix(int[] s, int i) {
        int[] result = new int[i];
        System.arraycopy(s, 0, result, 0, i);
        return result;
    }

    public static byte[] suffix(byte[] s, int startpos) {
        byte[] result = new byte[s.length - startpos];
        System.arraycopy(s, startpos, result, 0, s.length - startpos);
        return result;
    }

    public static double[] suffix(double[] s, int startpos) {
        double[] result = new double[s.length - startpos];
        System.arraycopy(s, startpos, result, 0, s.length - startpos);
        return result;
    }

    public static String[] suffix(String[] s, int startpos) {
        String[] result = new String[s.length - startpos];
        System.arraycopy(s, startpos, result, 0, s.length - startpos);
        return result;
    }

    public static byte[] suffixOfLength(byte[] s, int length) {
        if (length > s.length) {
            throw new IndexOutOfBoundsException("Requested suffix is longer than the array");
        }
        byte[] result = new byte[length];
        System.arraycopy(s, s.length - length, result, 0, length);
        return result;
    }

    public static byte[] prepend(byte b, byte[] s) {
        byte[] result = new byte[s.length + 1];
        result[0] = b;
        System.arraycopy(s, 0, result, 1, s.length);
        return result;
    }

    public static byte[] append(byte[] s, byte b) {
        byte[] result = new byte[s.length + 1];
        System.arraycopy(s, 0, result, 0, s.length);
        result[s.length] = b;
        return result;
    }

    public static double mean(double[] counts) {
        double sum = 0.0;
        for (int i = 0; i < counts.length; ++i) {
            sum += counts[i];
        }
        return sum / (double)counts.length;
    }

    public static double mean(int[] counts) {
        double sum = 0.0;
        for (int i = 0; i < counts.length; ++i) {
            sum += (double)counts[i];
        }
        return sum / (double)counts.length;
    }

    public static double stddev(double[] x, double mean) {
        double sumsq = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double dev = x[i] - mean;
            sumsq += dev * dev;
        }
        return Math.sqrt(sumsq / (double)x.length);
    }

    public static double stddev(int[] x, double mean) {
        double sumsq = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double dev = (double)x[i] - mean;
            sumsq += dev * dev;
        }
        return Math.sqrt(sumsq / (double)x.length);
    }

    public static double mean(Collection<Double> counts) {
        double sum = 0.0;
        for (Double d : counts) {
            sum += d.doubleValue();
        }
        return sum / (double)counts.size();
    }

    public static double stddev(Collection<Double> x, double mean) {
        double sumsq = 0.0;
        for (Double d : x) {
            double dev = d - mean;
            sumsq += dev * dev;
        }
        return Math.sqrt(sumsq / (double)x.size());
    }

    public static double[] times(double[] data, double scalar) {
        double[] result = (double[])data.clone();
        DSArrayUtils.multiplyBy(result, scalar);
        return result;
    }

    public static void multiplyBy(double[] a, double scalar) {
        int i = 0;
        while (i < a.length) {
            int n = i++;
            a[n] = a[n] * scalar;
        }
    }

    public static double norm(int[] x) {
        int sumsq = 0;
        for (int i = 0; i < x.length; ++i) {
            sumsq += x[i] * x[i];
        }
        return Math.sqrt(sumsq);
    }

    public static double norm(double[] x) {
        double sumsq = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sumsq += x[i] * x[i];
        }
        return Math.sqrt(sumsq);
    }

    public static void rescale(double[] x, double newMin, double newMax) {
        double newSpan = newMax - newMin;
        double oldMin = DSArrayUtils.min(x);
        double oldMax = DSArrayUtils.max(x);
        double oldSpan = oldMax - oldMin;
        for (int i = 0; i < x.length; ++i) {
            x[i] = newMin + (x[i] - oldMin) / oldSpan * newSpan;
        }
    }

    public static int compare(int[] a, int[] b) {
        if (a.length < b.length) {
            return -1;
        }
        if (b.length < a.length) {
            return 1;
        }
        for (int i = 0; i < a.length; ++i) {
            int result;
            int n = a[i] < b[i] ? -1 : (result = a[i] > b[i] ? 1 : 0);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public static int compare(char[] a, char[] b) {
        if (a.length < b.length) {
            return -1;
        }
        if (b.length < a.length) {
            return 1;
        }
        for (int i = 0; i < a.length; ++i) {
            int result;
            int n = a[i] < b[i] ? -1 : (result = a[i] > b[i] ? 1 : 0);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public static double[] toPrimitiveArray(Collection<Double> c) {
        double[] result = new double[c.size()];
        int i = 0;
        for (Double d : c) {
            result[i] = d;
            ++i;
        }
        return result;
    }

    public static int[] toPrimitiveArray(Collection<Integer> c) {
        int[] result = new int[c.size()];
        int i = 0;
        for (Integer d : c) {
            result[i] = d;
            ++i;
        }
        return result;
    }

    public static boolean allValuesAreNumeric(double[] value) {
        for (double v : value) {
            if (!Double.isInfinite(v) && !Double.isNaN(v)) continue;
            return false;
        }
        return true;
    }

    public static double[] createIncrementingDoubleArray(int size, double start, double increment) {
        double[] result = new double[size];
        double trav = start;
        for (int i = 0; i < size; ++i) {
            result[i] = trav;
            trav += increment;
        }
        return result;
    }

    public static int[] createIncrementingIntArray(int size, int start, int increment) {
        int[] result = new int[size];
        int trav = start;
        for (int i = 0; i < size; ++i) {
            result[i] = trav;
            trav += increment;
        }
        return result;
    }

    public static int floorElement(int[] nastWidths, int nastWidth) {
        int i = Arrays.binarySearch(nastWidths, nastWidth);
        if (i >= 0) {
            return nastWidths[i];
        }
        int insertionPoint = -(i + 1);
        return nastWidths[insertionPoint];
    }

    public static int[] castToInt(Double[] p) {
        int[] result = new int[p.length];
        for (int i = 0; i < p.length; ++i) {
            result[i] = p[i].intValue();
        }
        return result;
    }

    public static int[] castToInt(boolean[] p) {
        int[] result = new int[p.length];
        for (int i = 0; i < p.length; ++i) {
            result[i] = p[i] ? 1 : 0;
        }
        return result;
    }

    public static byte[] castToByte(char[] p) {
        byte[] result = new byte[p.length];
        for (int i = 0; i < p.length; ++i) {
            result[i] = (byte)p[i];
        }
        return result;
    }

    public static byte[] toByteArray(String s) {
        return DSArrayUtils.castToByte(s.toCharArray());
    }

    public static double[] toDoubleArray(List<String> l) throws NumberFormatException {
        double[] result = new double[l.size()];
        int i = 0;
        for (String s : l) {
            result[i] = Double.parseDouble(s);
            ++i;
        }
        return result;
    }

    public static boolean isNumberArray(Object o) {
        Class<?> arrayType = o.getClass().getComponentType();
        return o.getClass().isArray() && DSClassUtils.isAssignable(arrayType, Number.class);
    }

    public static boolean isPrimitiveArray(Object o) {
        Class<?> arrayType = o.getClass().getComponentType();
        return o.getClass().isArray() && arrayType.isPrimitive();
    }

    public static String[] mapToString(Object[] os) {
        ArrayList<String> result = new ArrayList<String>(os.length);
        for (Object o : os) {
            result.add(o.toString());
        }
        return result.toArray(EMPTY_STRING_ARRAY);
    }

    public static double[] select(double[] d, boolean[] mask) {
        int s = DSArrayUtils.count(mask, true);
        double[] result = new double[s];
        int di = 0;
        for (int i = 0; i < s; ++i) {
            while (!mask[di]) {
                ++di;
            }
            result[i] = d[di];
            ++di;
        }
        return result;
    }
}

