/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.dsutils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ClasspathFromFileClassLoader {
    private static final Logger logger = Logger.getLogger(ClasspathFromFileClassLoader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL[] getURLs(File classpathFile) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        BufferedReader is = new BufferedReader(new FileReader(classpathFile));
        try {
            String s = is.readLine();
            while (s != null) {
                if (!s.contains(":") && !s.trim().startsWith("#")) {
                    if (!s.startsWith("/")) {
                        throw new IOException("Classpath entries must be absolute: " + s);
                    }
                    if (!s.endsWith("/") && !s.endsWith(".jar")) {
                        s = s + "/";
                    }
                    s = "file:" + s;
                    URL url = new URL(s);
                    logger.debug("Adding classpath entry: " + url);
                    urls.add(url);
                }
                s = is.readLine();
            }
            URL[] uRLArray = urls.toArray(new URL[0]);
            return uRLArray;
        }
        finally {
            is.close();
        }
    }

    public URLClassLoader getClassLoader(File classpathFile) throws IOException {
        return this.getClassLoader(this.getURLs(classpathFile));
    }

    protected URLClassLoader getClassLoader(final URL[] urls) {
        return (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new URLClassLoader(urls);
            }
        });
    }
}

