/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.conja;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadPoolPerformanceStats {
    long cpuTime;
    long userTime;
    long waitedTime;
    long blockedTime;

    public ThreadPoolPerformanceStats(Collection<Long> ids) {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        if (bean.isThreadCpuTimeSupported()) {
            for (long id : ids) {
                long tu;
                long tc = bean.getThreadCpuTime(id);
                if (tc != -1L) {
                    this.cpuTime += tc;
                }
                if ((tu = bean.getThreadUserTime(id)) == -1L) continue;
                this.userTime += tu;
            }
        }
        for (long id : ids) {
            ThreadInfo ti = bean.getThreadInfo(id);
            this.blockedTime += ti.getBlockedTime();
            this.waitedTime += ti.getWaitedTime();
        }
    }

    public double getCpuSeconds() {
        return (double)this.cpuTime / 1.0E9;
    }

    public double getUserSeconds() {
        return (double)this.userTime / 1.0E9;
    }

    public double getSystemSeconds() {
        return (double)(this.cpuTime - this.userTime) / 1.0E9;
    }

    public double getBlockedSeconds() {
        return (double)this.blockedTime / 1000.0;
    }

    public double getWaitedSeconds() {
        return (double)this.waitedTime / 1000.0;
    }

    public String toString() {
        return "ThreadPoolPerformanceStats{blockedTime=" + this.blockedTime + ", cpuTime=" + this.cpuTime + ", userTime=" + this.userTime + ", waitedTime=" + this.waitedTime + '}';
    }
}

