/*
 * Decompiled with CFR 0.152.
 */
package com.davidsoergel.conja;

import com.davidsoergel.conja.DepthFirstThreadPoolExecutor;
import com.davidsoergel.conja.Function;
import com.davidsoergel.conja.IntegerIterator;
import com.davidsoergel.conja.IteratorAsThreadSafeNextOnlyIterator;
import com.davidsoergel.conja.ThreadSafeNextOnlyIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parallel {
    private static final Logger logger = Logger.getLogger(Parallel.class);

    public static <T> void forEach(ThreadSafeNextOnlyIterator<T> tasks, final Function<T, Void> function) {
        DepthFirstThreadPoolExecutor.getInstance().submitAndWaitForAll(new ForEach<T>(tasks){

            @Override
            public void performAction(T o) {
                function.apply(o);
            }
        });
    }

    public static <T> void forEach(Iterator<T> tasks, Function<T, Void> function) {
        Parallel.forEach(new IteratorAsThreadSafeNextOnlyIterator<T>(tasks), function);
    }

    public static <T> void forEach(int repetitions, final Function<Integer, Void> function) {
        DepthFirstThreadPoolExecutor.getInstance().submitAndWaitForAll(new ForEach<Integer>((ThreadSafeNextOnlyIterator)new IntegerIterator(0, repetitions)){

            @Override
            public void performAction(Integer o) {
                function.apply(o);
            }
        });
    }

    public static <T> void forEachThread(Function<Integer, Void> function) {
        int threads = DepthFirstThreadPoolExecutor.getInstance().getPoolSize();
        Parallel.forEach(threads, function);
    }

    public static void emergencyAbort() {
        DepthFirstThreadPoolExecutor.getInstance().shutdownNow();
    }

    public static <T> void forEach(Iterable<T> tasks, Function<T, Void> function) {
        Parallel.forEach(tasks.iterator(), function);
    }

    public static <T, V> Map<T, V> map(ThreadSafeNextOnlyIterator<T> tasks, final Function<T, V> function) {
        final ConcurrentHashMap result = new ConcurrentHashMap();
        DepthFirstThreadPoolExecutor.getInstance().submitAndWaitForAll(new ForEach<T>(tasks){

            @Override
            public void performAction(T o) {
                result.put(o, function.apply(o));
            }
        });
        return result;
    }

    public static <T, V> Map<T, V> map(Iterator<T> tasks, Function<T, V> function) {
        return Parallel.map(new IteratorAsThreadSafeNextOnlyIterator<T>(tasks), function);
    }

    public static <T, V> Map<T, V> map(Iterable<T> tasks, Function<T, V> function) {
        return Parallel.map(tasks.iterator(), function);
    }

    public static void shutdown() {
        logger.warn("Shutting down Parallel thread pool");
        DepthFirstThreadPoolExecutor.getInstance().shutdown();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class ForEach<T>
    implements Iterator<Runnable> {
        ThreadSafeNextOnlyIterator<T> iter;
        boolean hasNext = true;

        public ForEach(ThreadSafeNextOnlyIterator<T> tasks) {
            this.iter = tasks;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public Runnable next() {
            return new Runnable(){

                public void run() {
                    Object o;
                    try {
                        o = ForEach.this.iter.next();
                    }
                    catch (NoSuchElementException e) {
                        ForEach.this.hasNext = false;
                        return;
                    }
                    catch (OutOfMemoryError e) {
                        Parallel.emergencyAbort();
                        throw e;
                    }
                    try {
                        ForEach.this.performAction(o);
                    }
                    catch (OutOfMemoryError e) {
                        Parallel.emergencyAbort();
                        throw e;
                    }
                }
            };
        }

        @Override
        public void remove() {
        }

        public abstract void performAction(T var1);
    }
}

