/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import weka.classifiers.AggregateableEvaluation;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.evaluation.ThresholdCurve;
import weka.classifiers.misc.InputMappedClassifier;
import weka.core.BatchPredictor;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.experiment.Task;
import weka.experiment.TaskStatusInfo;
import weka.gui.beans.AbstractEvaluator;
import weka.gui.beans.BatchClassifierEvent;
import weka.gui.beans.BatchClassifierListener;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.TextEvent;
import weka.gui.beans.TextListener;
import weka.gui.beans.ThresholdDataEvent;
import weka.gui.beans.ThresholdDataListener;
import weka.gui.beans.UserRequestAcceptor;
import weka.gui.beans.VisualizableErrorEvent;
import weka.gui.beans.VisualizableErrorListener;
import weka.gui.explorer.ClassifierErrorsPlotInstances;
import weka.gui.explorer.ExplorerDefaults;
import weka.gui.visualize.PlotData2D;

public class ClassifierPerformanceEvaluator
extends AbstractEvaluator
implements BatchClassifierListener,
Serializable,
UserRequestAcceptor,
EventConstraints {
    private static final long serialVersionUID = -3511801418192148690L;
    private transient AggregateableEvaluation m_eval;
    private transient Instances m_aggregatedPlotInstances = null;
    private transient FastVector m_aggregatedPlotSizes = null;
    private transient FastVector m_aggregatedPlotShapes = null;
    private transient long m_currentBatchIdentifier;
    private transient int m_setsComplete;
    private Vector m_textListeners = new Vector();
    private Vector m_thresholdListeners = new Vector();
    private Vector m_visualizableErrorListeners = new Vector();
    protected transient ThreadPoolExecutor m_executorPool;
    protected transient List<EvaluationTask> m_tasks;
    protected int m_executionSlots = 2;
    private transient ClassifierErrorsPlotInstances m_PlotInstances = null;

    public ClassifierPerformanceEvaluator() {
        this.m_visual.loadIcons("weka/gui/beans/icons/ClassifierPerformanceEvaluator.gif", "weka/gui/beans/icons/ClassifierPerformanceEvaluator_animated.gif");
        this.m_visual.setText("ClassifierPerformanceEvaluator");
    }

    public int getExecutionSlots() {
        return this.m_executionSlots;
    }

    public void setExecutionSlots(int slots) {
        this.m_executionSlots = slots;
    }

    public String executionSlotsTipText() {
        return "Set the number of evaluation tasks to run in parallel.";
    }

    private void startExecutorPool() {
        if (this.m_executorPool != null) {
            this.m_executorPool.shutdownNow();
        }
        this.m_executorPool = new ThreadPoolExecutor(this.m_executionSlots, this.m_executionSlots, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    public String globalInfo() {
        return "Evaluate the performance of batch trained classifiers.";
    }

    protected static Evaluation adjustForInputMappedClassifier(Evaluation eval, Classifier classifier, Instances inst, ClassifierErrorsPlotInstances plotInstances) throws Exception {
        Instances mappedClassifierHeader;
        if (classifier instanceof InputMappedClassifier && !(eval = new Evaluation(new Instances(mappedClassifierHeader = ((InputMappedClassifier)classifier).getModelHeader(new Instances(inst, 0)), 0))).getHeader().equalHeaders(inst)) {
            Instances mappedClassifierDataset = ((InputMappedClassifier)classifier).getModelHeader(new Instances(mappedClassifierHeader, 0));
            for (int zz = 0; zz < inst.numInstances(); ++zz) {
                Instance mapped = ((InputMappedClassifier)classifier).constructMappedInstance(inst.instance(zz));
                mappedClassifierDataset.add(mapped);
            }
            eval.setPriors(mappedClassifierDataset);
            plotInstances.setInstances(mappedClassifierDataset);
            plotInstances.setClassifier(classifier);
            plotInstances.setClassIndex(mappedClassifierDataset.classIndex());
            plotInstances.setEvaluation(eval);
        }
        return eval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void aggregateEvalTask(Evaluation eval, Classifier classifier, Instances testData, ClassifierErrorsPlotInstances plotInstances, int setNum, int maxSetNum) {
        this.m_eval.aggregate(eval);
        if (this.m_aggregatedPlotInstances == null) {
            this.m_aggregatedPlotInstances = new Instances(plotInstances.getPlotInstances());
            this.m_aggregatedPlotShapes = plotInstances.getPlotShapes();
            this.m_aggregatedPlotSizes = plotInstances.getPlotSizes();
        } else {
            Instances temp = plotInstances.getPlotInstances();
            for (int i = 0; i < temp.numInstances(); ++i) {
                this.m_aggregatedPlotInstances.add(temp.get(i));
                this.m_aggregatedPlotShapes.addElement(plotInstances.getPlotShapes().get(i));
                this.m_aggregatedPlotSizes.addElement(plotInstances.getPlotSizes().get(i));
            }
        }
        ++this.m_setsComplete;
        if (this.m_logger != null && this.m_setsComplete < maxSetNum) {
            this.m_logger.statusMessage(this.statusMessagePrefix() + "Finished (" + this.m_setsComplete + ").");
        }
        if (this.m_setsComplete == maxSetNum) {
            try {
                String textTitle = classifier.getClass().getName();
                String textOptions = "";
                if (classifier instanceof OptionHandler) {
                    textOptions = Utils.joinOptions(((OptionHandler)((Object)classifier)).getOptions());
                }
                textTitle = textTitle.substring(textTitle.lastIndexOf(46) + 1, textTitle.length());
                String resultT = "=== Evaluation result ===\n\nScheme: " + textTitle + "\n" + (textOptions.length() > 0 ? "Options: " + textOptions + "\n" : "") + "Relation: " + testData.relationName() + "\n\n" + this.m_eval.toSummaryString();
                if (testData.classAttribute().isNominal()) {
                    resultT = resultT + "\n" + this.m_eval.toClassDetailsString() + "\n" + this.m_eval.toMatrixString();
                }
                TextEvent te = new TextEvent(this, resultT, textTitle);
                this.notifyTextListeners(te);
                if (this.m_visualizableErrorListeners.size() > 0) {
                    PlotData2D errorD = new PlotData2D(this.m_aggregatedPlotInstances);
                    errorD.setShapeSize(this.m_aggregatedPlotSizes);
                    errorD.setShapeType(this.m_aggregatedPlotShapes);
                    errorD.setPlotName(textTitle + " " + textOptions);
                    VisualizableErrorEvent vel = new VisualizableErrorEvent(this, errorD);
                    this.notifyVisualizableErrorListeners(vel);
                    this.m_PlotInstances.cleanUp();
                }
                if (testData.classAttribute().isNominal() && this.m_thresholdListeners.size() > 0) {
                    String[] options;
                    ThresholdCurve tc = new ThresholdCurve();
                    Instances result = tc.getCurve(this.m_eval.predictions(), 0);
                    result.setRelationName(testData.relationName());
                    PlotData2D pd = new PlotData2D(result);
                    String htmlTitle = "<html><font size=-2>" + textTitle;
                    String newOptions = "";
                    if (classifier instanceof OptionHandler && (options = ((OptionHandler)((Object)classifier)).getOptions()).length > 0) {
                        for (int ii = 0; ii < options.length; ++ii) {
                            if (options[ii].length() == 0) continue;
                            if (options[ii].charAt(0) == '-' && (options[ii].charAt(1) < '0' || options[ii].charAt(1) > '9')) {
                                newOptions = newOptions + "<br>";
                            }
                            newOptions = newOptions + options[ii];
                        }
                    }
                    htmlTitle = htmlTitle + " " + newOptions + "<br>" + " (class: " + testData.classAttribute().value(0) + ")" + "</font></html>";
                    pd.setPlotName(textTitle + " (class: " + testData.classAttribute().value(0) + ")");
                    pd.setPlotNameHTML(htmlTitle);
                    boolean[] connectPoints = new boolean[result.numInstances()];
                    for (int jj = 1; jj < connectPoints.length; ++jj) {
                        connectPoints[jj] = true;
                    }
                    pd.setConnectPoints(connectPoints);
                    ThresholdDataEvent rde = new ThresholdDataEvent(this, pd, testData.classAttribute());
                    this.notifyThresholdListeners(rde);
                }
                if (this.m_logger != null) {
                    this.m_logger.statusMessage(this.statusMessagePrefix() + "Finished.");
                }
            }
            catch (Exception ex) {
                if (this.m_logger != null) {
                    this.m_logger.logMessage("[ClassifierPerformanceEvaluator] " + this.statusMessagePrefix() + " problem constructing evaluation results. " + ex.getMessage());
                }
                ex.printStackTrace();
            }
            finally {
                this.m_visual.setStatic();
                this.m_PlotInstances = null;
                this.m_setsComplete = 0;
                this.m_tasks = null;
                this.m_aggregatedPlotInstances = null;
            }
        }
    }

    @Override
    public void acceptClassifier(BatchClassifierEvent ce) {
        if (ce.getTestSet() == null || ce.getTestSet().isStructureOnly()) {
            return;
        }
        Classifier classifier = ce.getClassifier();
        try {
            if (ce.getGroupIdentifier() != this.m_currentBatchIdentifier) {
                Evaluation eval;
                if (this.m_setsComplete > 0) {
                    if (this.m_logger != null) {
                        this.m_logger.statusMessage(this.statusMessagePrefix() + "BUSY. Can't accept data " + "at this time.");
                        this.m_logger.logMessage("[ClassifierPerformanceEvaluator] " + this.statusMessagePrefix() + " BUSY. Can't accept data at this time.");
                    }
                    return;
                }
                if (ce.getTrainSet().getDataSet() == null || ce.getTrainSet().getDataSet().numInstances() == 0) {
                    eval = new Evaluation(ce.getTestSet().getDataSet());
                    this.m_PlotInstances = ExplorerDefaults.getClassifierErrorsPlotInstances();
                    this.m_PlotInstances.setInstances(ce.getTestSet().getDataSet());
                    this.m_PlotInstances.setClassifier(ce.getClassifier());
                    this.m_PlotInstances.setClassIndex(ce.getTestSet().getDataSet().classIndex());
                    this.m_PlotInstances.setEvaluation(eval);
                    eval = ClassifierPerformanceEvaluator.adjustForInputMappedClassifier(eval, ce.getClassifier(), ce.getTestSet().getDataSet(), this.m_PlotInstances);
                    eval.useNoPriors();
                    this.m_eval = new AggregateableEvaluation(eval);
                } else {
                    eval = new Evaluation(ce.getTrainSet().getDataSet());
                    this.m_PlotInstances = ExplorerDefaults.getClassifierErrorsPlotInstances();
                    this.m_PlotInstances.setInstances(ce.getTrainSet().getDataSet());
                    this.m_PlotInstances.setClassifier(ce.getClassifier());
                    this.m_PlotInstances.setClassIndex(ce.getTestSet().getDataSet().classIndex());
                    this.m_PlotInstances.setEvaluation(eval);
                    eval = ClassifierPerformanceEvaluator.adjustForInputMappedClassifier(eval, ce.getClassifier(), ce.getTrainSet().getDataSet(), this.m_PlotInstances);
                    this.m_eval = new AggregateableEvaluation(eval);
                }
                this.m_PlotInstances.setUp();
                this.m_currentBatchIdentifier = ce.getGroupIdentifier();
                this.m_setsComplete = 0;
                this.m_aggregatedPlotInstances = null;
                String msg = "[ClassifierPerformanceEvaluator] " + this.statusMessagePrefix() + " starting executor pool (" + this.getExecutionSlots() + " slots)...";
                this.startExecutorPool();
                this.m_tasks = new ArrayList<EvaluationTask>();
                if (this.m_logger != null) {
                    this.m_logger.logMessage(msg);
                } else {
                    System.out.println(msg);
                }
            }
            if (this.m_setsComplete < ce.getMaxSetNumber() && this.m_tasks != null) {
                EvaluationTask newTask = new EvaluationTask(classifier, ce.getTrainSet().getDataSet(), ce.getTestSet().getDataSet(), ce.getSetNumber(), ce.getMaxSetNumber());
                String msg = "[ClassifierPerformanceEvaluator] " + this.statusMessagePrefix() + " scheduling " + " evaluation of fold " + ce.getSetNumber() + " for execution...";
                if (this.m_logger != null) {
                    this.m_logger.logMessage(msg);
                } else {
                    System.out.println(msg);
                }
                this.m_tasks.add(newTask);
                this.m_executorPool.execute(newTask);
            }
        }
        catch (Exception ex) {
            this.stop();
        }
    }

    @Override
    public boolean isBusy() {
        return this.m_executorPool != null && (this.m_executorPool.getQueue().size() != 0 || this.m_executorPool.getActiveCount() != 0 || this.m_setsComplete != 0);
    }

    @Override
    public void stop() {
        if (this.m_listenee instanceof BeanCommon) {
            ((BeanCommon)this.m_listenee).stop();
        }
        if (this.m_tasks != null) {
            for (EvaluationTask t : this.m_tasks) {
                t.setStopped();
            }
        }
        this.m_tasks = null;
        this.m_visual.setStatic();
        this.m_setsComplete = 0;
        if (this.m_executorPool != null) {
            this.m_executorPool.shutdownNow();
            this.m_executorPool.purge();
            this.m_executorPool = null;
        }
    }

    @Override
    public Enumeration enumerateRequests() {
        Vector<String> newVector = new Vector<String>(0);
        if (this.m_executorPool != null && (this.m_executorPool.getQueue().size() > 0 || this.m_executorPool.getActiveCount() > 0)) {
            newVector.addElement("Stop");
        }
        return newVector.elements();
    }

    @Override
    public void performRequest(String request) {
        if (request.compareTo("Stop") != 0) {
            throw new IllegalArgumentException(request + " not supported (ClassifierPerformanceEvaluator)");
        }
        this.stop();
    }

    public synchronized void addTextListener(TextListener cl) {
        this.m_textListeners.addElement(cl);
    }

    public synchronized void removeTextListener(TextListener cl) {
        this.m_textListeners.remove(cl);
    }

    public synchronized void addThresholdDataListener(ThresholdDataListener cl) {
        this.m_thresholdListeners.addElement(cl);
    }

    public synchronized void removeThresholdDataListener(ThresholdDataListener cl) {
        this.m_thresholdListeners.remove(cl);
    }

    public synchronized void addVisualizableErrorListener(VisualizableErrorListener vel) {
        this.m_visualizableErrorListeners.add(vel);
    }

    public synchronized void removeVisualizableErrorListener(VisualizableErrorListener vel) {
        this.m_visualizableErrorListeners.remove(vel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTextListeners(TextEvent te) {
        Vector l;
        ClassifierPerformanceEvaluator classifierPerformanceEvaluator = this;
        synchronized (classifierPerformanceEvaluator) {
            l = (Vector)this.m_textListeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                ((TextListener)l.elementAt(i)).acceptText(te);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyThresholdListeners(ThresholdDataEvent re) {
        Vector l;
        ClassifierPerformanceEvaluator classifierPerformanceEvaluator = this;
        synchronized (classifierPerformanceEvaluator) {
            l = (Vector)this.m_thresholdListeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                ((ThresholdDataListener)l.elementAt(i)).acceptDataSet(re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyVisualizableErrorListeners(VisualizableErrorEvent re) {
        Vector l;
        ClassifierPerformanceEvaluator classifierPerformanceEvaluator = this;
        synchronized (classifierPerformanceEvaluator) {
            l = (Vector)this.m_visualizableErrorListeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                ((VisualizableErrorListener)l.elementAt(i)).acceptDataSet(re);
            }
        }
    }

    @Override
    public boolean eventGeneratable(String eventName) {
        if (this.m_listenee == null) {
            return false;
        }
        return !(this.m_listenee instanceof EventConstraints) || ((EventConstraints)this.m_listenee).eventGeneratable("batchClassifier");
    }

    private String statusMessagePrefix() {
        return this.getCustomName() + "$" + this.hashCode() + "|";
    }

    protected class EvaluationTask
    implements Runnable,
    Task {
        private static final long serialVersionUID = -8939077467030259059L;
        protected Instances m_testData;
        protected Instances m_trainData;
        protected int m_setNum;
        protected int m_maxSetNum;
        protected Classifier m_classifier;
        protected boolean m_stopped;

        public EvaluationTask(Classifier classifier, Instances trainData, Instances testData, int setNum, int maxSetNum) {
            this.m_classifier = classifier;
            this.m_setNum = setNum;
            this.m_maxSetNum = maxSetNum;
            this.m_testData = testData;
            this.m_trainData = trainData;
        }

        public void setStopped() {
            this.m_stopped = true;
        }

        @Override
        public void run() {
            this.execute();
        }

        @Override
        public void execute() {
            if (this.m_stopped) {
                return;
            }
            if (ClassifierPerformanceEvaluator.this.m_logger != null) {
                ClassifierPerformanceEvaluator.this.m_logger.statusMessage(ClassifierPerformanceEvaluator.this.statusMessagePrefix() + "Evaluating (" + this.m_setNum + ")...");
            }
            try {
                ClassifierErrorsPlotInstances plotInstances = ExplorerDefaults.getClassifierErrorsPlotInstances();
                Evaluation eval = null;
                if (this.m_trainData == null || this.m_trainData.numInstances() == 0) {
                    eval = new Evaluation(this.m_testData);
                    plotInstances.setInstances(this.m_testData);
                    plotInstances.setClassifier(this.m_classifier);
                    plotInstances.setClassIndex(this.m_testData.classIndex());
                    plotInstances.setEvaluation(eval);
                    eval = ClassifierPerformanceEvaluator.adjustForInputMappedClassifier(eval, this.m_classifier, this.m_testData, plotInstances);
                    eval.useNoPriors();
                } else {
                    eval = new Evaluation(this.m_trainData);
                    plotInstances.setInstances(this.m_trainData);
                    plotInstances.setClassifier(this.m_classifier);
                    plotInstances.setClassIndex(this.m_trainData.classIndex());
                    plotInstances.setEvaluation(eval);
                    eval = ClassifierPerformanceEvaluator.adjustForInputMappedClassifier(eval, this.m_classifier, this.m_trainData, plotInstances);
                }
                plotInstances.setUp();
                if (this.m_classifier instanceof BatchPredictor) {
                    double[][] predictions = ((BatchPredictor)((Object)this.m_classifier)).distributionsForInstances(this.m_testData);
                    plotInstances.process(this.m_testData, predictions, eval);
                } else {
                    for (int i = 0; i < this.m_testData.numInstances() && !this.m_stopped; ++i) {
                        Instance temp = this.m_testData.instance(i);
                        plotInstances.process(temp, this.m_classifier, eval);
                    }
                }
                if (this.m_stopped) {
                    return;
                }
                ClassifierPerformanceEvaluator.this.aggregateEvalTask(eval, this.m_classifier, this.m_testData, plotInstances, this.m_setNum, this.m_maxSetNum);
            }
            catch (Exception ex) {
                ClassifierPerformanceEvaluator.this.stop();
                if (ClassifierPerformanceEvaluator.this.m_logger != null) {
                    ClassifierPerformanceEvaluator.this.m_logger.logMessage("[ClassifierPerformanceEvaluator] " + ClassifierPerformanceEvaluator.this.statusMessagePrefix() + " problem evaluating classifier. " + ex.getMessage());
                }
                ex.printStackTrace();
            }
        }

        @Override
        public TaskStatusInfo getTaskStatus() {
            return null;
        }
    }
}

