/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.Utils;
import weka.filters.SimpleStreamFilter;

public class SortLabels
extends SimpleStreamFilter {
    private static final long serialVersionUID = 7815204879694105691L;
    public static final int SORT_CASESENSITIVE = 0;
    public static final int SORT_CASEINSENSITIVE = 1;
    public static final Tag[] TAGS_SORTTYPE = new Tag[]{new Tag(0, "case", "Case-sensitive"), new Tag(1, "non-case", "Case-insensitive")};
    protected Range m_AttributeIndices = new Range("first-last");
    protected int[][] m_NewOrder = null;
    protected int m_SortType = 1;
    protected Comparator m_Comparator = new CaseSensitiveComparator();

    @Override
    public String globalInfo() {
        return "A simple filter for sorting the labels of nominal attributes.";
    }

    @Override
    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement(en.nextElement());
        }
        result.addElement(new Option("\tSpecify list of string attributes to convert to words.\n\t(default: select all relational attributes)", "R", 1, "-R <index1,index2-index4,...>"));
        result.addElement(new Option("\tInverts the matching sense of the selection.", "V", 0, "-V"));
        String desc = "";
        for (int i = 0; i < TAGS_SORTTYPE.length; ++i) {
            SelectedTag tag = new SelectedTag(TAGS_SORTTYPE[i].getID(), TAGS_SORTTYPE);
            desc = desc + "\t" + tag.getSelectedTag().getIDStr() + " = " + tag.getSelectedTag().getReadable() + "\n";
        }
        result.addElement(new Option("\tDetermines the type of sorting:\n" + desc + "\t(default: " + new SelectedTag(0, TAGS_SORTTYPE) + ")", "S", 1, "-S " + Tag.toOptionList(TAGS_SORTTYPE)));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('R', options);
        if (tmpStr.length() != 0) {
            this.setAttributeIndices(tmpStr);
        } else {
            this.setAttributeIndices("first-last");
        }
        this.setInvertSelection(Utils.getFlag('V', options));
        tmpStr = Utils.getOption('S', options);
        if (tmpStr.length() != 0) {
            this.setSortType(new SelectedTag(tmpStr, TAGS_SORTTYPE));
        } else {
            this.setSortType(new SelectedTag(0, TAGS_SORTTYPE));
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        result.add("-R");
        result.add(this.getAttributeIndices().getRanges());
        if (this.getInvertSelection()) {
            result.add("-V");
        }
        result.add("-S");
        result.add("" + this.getSortType());
        return result.toArray(new String[result.size()]);
    }

    public String attributeIndicesTipText() {
        return "Specify range of attributes to act on; this is a comma separated list of attribute indices, with \"first\" and \"last\" valid values; Specify an inclusive range with \"-\"; eg: \"first-3,5,6-10,last\".";
    }

    public void setAttributeIndices(String value) {
        this.m_AttributeIndices = new Range(value);
    }

    public Range getAttributeIndices() {
        return this.m_AttributeIndices;
    }

    public String invertSelectionTipText() {
        return "Set attribute selection mode. If false, only selected attributes in the range will be worked on; if true, only non-selected attributes will be processed.";
    }

    public void setInvertSelection(boolean value) {
        this.m_AttributeIndices.setInvert(value);
    }

    public boolean getInvertSelection() {
        return this.m_AttributeIndices.getInvert();
    }

    public String sortTypeTipText() {
        return "The type of sorting to use.";
    }

    public void setSortType(SelectedTag type2) {
        if (type2.getTags() == TAGS_SORTTYPE) {
            this.m_SortType = type2.getSelectedTag().getID();
            if (this.m_SortType == 0) {
                this.m_Comparator = new CaseSensitiveComparator();
            } else if (this.m_SortType == 1) {
                this.m_Comparator = new CaseInsensitiveComparator();
            } else {
                throw new IllegalStateException("Unhandled sort type '" + type2 + "'!");
            }
        }
    }

    public SelectedTag getSortType() {
        return new SelectedTag(this.m_SortType, TAGS_SORTTYPE);
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        this.m_AttributeIndices.setUpper(inputFormat.numAttributes() - 1);
        FastVector<Attribute> atts = new FastVector<Attribute>();
        this.m_NewOrder = new int[inputFormat.numAttributes()][];
        for (int i = 0; i < inputFormat.numAttributes(); ++i) {
            int n;
            Attribute att = inputFormat.attribute(i);
            if (!att.isNominal() || !this.m_AttributeIndices.isInRange(i)) {
                this.m_NewOrder[i] = new int[0];
                atts.addElement((Attribute)inputFormat.attribute(i).copy());
                continue;
            }
            Vector<String> sorted = new Vector<String>();
            for (n = 0; n < att.numValues(); ++n) {
                sorted.add(att.value(n));
            }
            Collections.sort(sorted, this.m_Comparator);
            this.m_NewOrder[i] = new int[att.numValues()];
            FastVector<String> values = new FastVector<String>();
            for (n = 0; n < att.numValues(); ++n) {
                this.m_NewOrder[i][n] = sorted.indexOf(att.value(n));
                values.addElement((String)sorted.get(n));
            }
            Attribute attSorted = new Attribute(att.name(), values);
            attSorted.setWeight(att.weight());
            atts.addElement(attSorted);
        }
        Instances result = new Instances(inputFormat.relationName(), atts, 0);
        result.setClassIndex(inputFormat.classIndex());
        return result;
    }

    @Override
    protected Instance process(Instance instance) throws Exception {
        double[] values = new double[instance.numAttributes()];
        for (int i = 0; i < instance.numAttributes(); ++i) {
            Attribute att = instance.attribute(i);
            values[i] = !att.isNominal() || !this.m_AttributeIndices.isInRange(i) || instance.isMissing(i) ? instance.value(i) : (double)this.m_NewOrder[i][(int)instance.value(i)];
        }
        DenseInstance result = new DenseInstance(instance.weight(), values);
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] args) {
        SortLabels.runFilter(new SortLabels(), args);
    }

    public static class CaseInsensitiveComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = -4515292733342486066L;

        public int compare(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            String s1 = (String)o1;
            String s2 = (String)o2;
            return s1.toLowerCase().compareTo(s2.toLowerCase());
        }
    }

    public static class CaseSensitiveComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 7071450356783873277L;

        public int compare(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            String s1 = (String)o1;
            String s2 = (String)o2;
            return s1.compareTo(s2);
        }
    }
}

