/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.List;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.experiment.CSVResultListener;
import weka.experiment.ResultProducer;

public class InstancesResultListener
extends CSVResultListener {
    static final long serialVersionUID = -2203808461809311178L;
    protected transient FastVector m_Instances;
    protected transient int[] m_AttributeTypes;
    protected transient Hashtable[] m_NominalIndexes;
    protected transient FastVector[] m_NominalStrings;

    public InstancesResultListener() {
        File resultsFile;
        try {
            resultsFile = File.createTempFile("weka_experiment", ".arff");
            resultsFile.deleteOnExit();
        }
        catch (Exception e) {
            System.err.println("Cannot create temp file, writing to standard out.");
            resultsFile = new File("-");
        }
        this.setOutputFile(resultsFile);
        this.setOutputFileName("");
    }

    @Override
    public String globalInfo() {
        return "Outputs the received results in arff format to a Writer. All results must be received before the instances can be written out.";
    }

    @Override
    public void preProcess(ResultProducer rp) throws Exception {
        this.m_RP = rp;
        this.m_Out = this.m_OutputFile == null || this.m_OutputFile.getName().equals("-") ? new PrintWriter(System.out, true) : new PrintWriter(new BufferedOutputStream(new FileOutputStream(this.m_OutputFile)), true);
        Object[] keyTypes = this.m_RP.getKeyTypes();
        Object[] resultTypes = this.m_RP.getResultTypes();
        this.m_AttributeTypes = new int[keyTypes.length + resultTypes.length];
        this.m_NominalIndexes = new Hashtable[this.m_AttributeTypes.length];
        this.m_NominalStrings = new FastVector[this.m_AttributeTypes.length];
        this.m_Instances = new FastVector();
        for (int i = 0; i < this.m_AttributeTypes.length; ++i) {
            Object attribute = null;
            attribute = i < keyTypes.length ? keyTypes[i] : resultTypes[i - keyTypes.length];
            if (attribute instanceof String) {
                this.m_AttributeTypes[i] = 1;
                this.m_NominalIndexes[i] = new Hashtable();
                this.m_NominalStrings[i] = new FastVector();
                continue;
            }
            if (attribute instanceof Double) {
                this.m_AttributeTypes[i] = 0;
                continue;
            }
            throw new Exception("Unknown attribute type in column " + (i + 1));
        }
    }

    @Override
    public void postProcess(ResultProducer rp) throws Exception {
        int i;
        if (this.m_RP != rp) {
            throw new Error("Unrecognized ResultProducer sending results!!");
        }
        String[] keyNames = this.m_RP.getKeyNames();
        String[] resultNames = this.m_RP.getResultNames();
        FastVector<Attribute> attribInfo = new FastVector<Attribute>();
        block5: for (int i2 = 0; i2 < this.m_AttributeTypes.length; ++i2) {
            String attribName = "Unknown";
            attribName = i2 < keyNames.length ? "Key_" + keyNames[i2] : resultNames[i2 - keyNames.length];
            switch (this.m_AttributeTypes[i2]) {
                case 1: {
                    if (this.m_NominalStrings[i2].size() > 0) {
                        attribInfo.addElement(new Attribute(attribName, this.m_NominalStrings[i2]));
                        continue block5;
                    }
                    attribInfo.addElement(new Attribute(attribName, (List<String>)null));
                    continue block5;
                }
                case 0: {
                    attribInfo.addElement(new Attribute(attribName));
                    continue block5;
                }
                case 2: {
                    attribInfo.addElement(new Attribute(attribName, (List<String>)null));
                    continue block5;
                }
                default: {
                    throw new Exception("Unknown attribute type");
                }
            }
        }
        Instances result = new Instances("InstanceResultListener", attribInfo, this.m_Instances.size());
        for (i = 0; i < this.m_Instances.size(); ++i) {
            result.add((Instance)this.m_Instances.elementAt(i));
        }
        this.m_Out.println(new Instances(result, 0));
        for (i = 0; i < result.numInstances(); ++i) {
            this.m_Out.println(result.instance(i));
        }
        if (this.m_OutputFile != null && !this.m_OutputFile.getName().equals("-")) {
            this.m_Out.close();
        }
    }

    @Override
    public void acceptResult(ResultProducer rp, Object[] key, Object[] result) throws Exception {
        if (this.m_RP != rp) {
            throw new Error("Unrecognized ResultProducer sending results!!");
        }
        DenseInstance newInst = new DenseInstance(this.m_AttributeTypes.length);
        block4: for (int i = 0; i < this.m_AttributeTypes.length; ++i) {
            Object val = null;
            val = i < key.length ? key[i] : result[i - key.length];
            if (val == null) {
                newInst.setValue(i, Utils.missingValue());
                continue;
            }
            switch (this.m_AttributeTypes[i]) {
                case 1: {
                    String str = (String)val;
                    Double index = (Double)this.m_NominalIndexes[i].get(str);
                    if (index == null) {
                        index = new Double(this.m_NominalStrings[i].size());
                        this.m_NominalIndexes[i].put(str, index);
                        this.m_NominalStrings[i].addElement(str);
                    }
                    newInst.setValue(i, (double)index);
                    continue block4;
                }
                case 0: {
                    double dou = (Double)val;
                    newInst.setValue(i, dou);
                    continue block4;
                }
                default: {
                    newInst.setValue(i, Utils.missingValue());
                }
            }
        }
        this.m_Instances.addElement(newInst);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

