/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import weka.core.ClassDiscovery;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.ArffLoader;
import weka.core.converters.ArffSaver;
import weka.core.converters.CSVLoader;
import weka.core.converters.CSVSaver;
import weka.core.converters.DatabaseConverter;
import weka.core.converters.FileSourcedConverter;
import weka.core.converters.IncrementalConverter;
import weka.core.converters.Loader;
import weka.core.converters.Saver;
import weka.core.converters.SerializedInstancesLoader;
import weka.core.converters.SerializedInstancesSaver;
import weka.core.converters.TextDirectoryLoader;
import weka.core.converters.URLSourcedLoader;
import weka.core.converters.XRFFLoader;
import weka.core.converters.XRFFSaver;
import weka.gui.ConverterFileChooser;
import weka.gui.GenericObjectEditor;
import weka.gui.GenericPropertiesCreator;

public class ConverterUtils
implements Serializable,
RevisionHandler {
    static final long serialVersionUID = -2460855349276148760L;
    public static final String CORE_FILE_LOADERS = ArffLoader.class.getName() + "," + CSVLoader.class.getName() + "," + DatabaseConverter.class.getName() + "," + SerializedInstancesLoader.class.getName() + "," + TextDirectoryLoader.class.getName() + "," + XRFFLoader.class.getName();
    public static final String CORE_FILE_SAVERS = ArffSaver.class.getName() + "," + CSVSaver.class.getName() + "," + DatabaseConverter.class.getName() + "," + SerializedInstancesSaver.class.getName() + "," + XRFFSaver.class.getName();
    protected static Hashtable<String, String> m_FileLoaders;
    protected static Hashtable<String, String> m_URLFileLoaders;
    protected static Hashtable<String, String> m_FileSavers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void initialize() {
        block12: {
            try {
                ConverterUtils.m_FileLoaders = new Hashtable<K, V>();
                ConverterUtils.m_URLFileLoaders = new Hashtable<K, V>();
                ConverterUtils.m_FileSavers = new Hashtable<K, V>();
                props = GenericPropertiesCreator.getGlobalOutputProperties();
                if (props == null) {
                    creator = new GenericPropertiesCreator();
                    creator.execute(false);
                    props = creator.getOutputProperties();
                }
                ConverterUtils.m_FileLoaders = ConverterUtils.getFileConverters(props.getProperty(Loader.class.getName(), ConverterUtils.CORE_FILE_LOADERS), new String[]{FileSourcedConverter.class.getName()});
                ConverterUtils.m_URLFileLoaders = ConverterUtils.getFileConverters(props.getProperty(Loader.class.getName(), ConverterUtils.CORE_FILE_LOADERS), new String[]{FileSourcedConverter.class.getName(), URLSourcedLoader.class.getName()});
                ConverterUtils.m_FileSavers = ConverterUtils.getFileConverters(props.getProperty(Saver.class.getName(), ConverterUtils.CORE_FILE_SAVERS), new String[]{FileSourcedConverter.class.getName()});
                if (ConverterUtils.m_FileLoaders.size() != 0) break block12;
            }
            catch (Exception e) {
                block13: {
                    try {
                        e.printStackTrace();
                        if (ConverterUtils.m_FileLoaders.size() != 0) break block13;
                    }
                    catch (Throwable var3_6) {
                        if (ConverterUtils.m_FileLoaders.size() == 0) {
                            classnames = GenericObjectEditor.getClassnames(AbstractFileLoader.class.getName());
                            ConverterUtils.m_FileLoaders = classnames.size() > 0 ? ConverterUtils.getFileConverters(classnames, new String[]{FileSourcedConverter.class.getName()}) : ConverterUtils.getFileConverters(ConverterUtils.CORE_FILE_LOADERS, new String[]{FileSourcedConverter.class.getName()});
                        }
                        if (ConverterUtils.m_URLFileLoaders.size() == 0) {
                            classnames = GenericObjectEditor.getClassnames(AbstractFileLoader.class.getName());
                            ConverterUtils.m_URLFileLoaders = classnames.size() > 0 ? ConverterUtils.getFileConverters(classnames, new String[]{FileSourcedConverter.class.getName(), URLSourcedLoader.class.getName()}) : ConverterUtils.getFileConverters(ConverterUtils.CORE_FILE_LOADERS, new String[]{FileSourcedConverter.class.getName(), URLSourcedLoader.class.getName()});
                        }
                        if (ConverterUtils.m_FileSavers.size() == 0) {
                            classnames = GenericObjectEditor.getClassnames(AbstractFileSaver.class.getName());
                            ConverterUtils.m_FileSavers = classnames.size() > 0 ? ConverterUtils.getFileConverters(classnames, new String[]{FileSourcedConverter.class.getName()}) : ConverterUtils.getFileConverters(ConverterUtils.CORE_FILE_SAVERS, new String[]{FileSourcedConverter.class.getName()});
                        }
                        throw var3_6;
                    }
                    classnames = GenericObjectEditor.getClassnames(AbstractFileLoader.class.getName());
                    ConverterUtils.m_FileLoaders = classnames.size() > 0 ? ConverterUtils.getFileConverters(classnames, new String[]{FileSourcedConverter.class.getName()}) : ConverterUtils.getFileConverters(ConverterUtils.CORE_FILE_LOADERS, new String[]{FileSourcedConverter.class.getName()});
                }
                if (ConverterUtils.m_URLFileLoaders.size() == 0) {
                    classnames = GenericObjectEditor.getClassnames(AbstractFileLoader.class.getName());
                    ConverterUtils.m_URLFileLoaders = classnames.size() > 0 ? ConverterUtils.getFileConverters(classnames, new String[]{FileSourcedConverter.class.getName(), URLSourcedLoader.class.getName()}) : ConverterUtils.getFileConverters(ConverterUtils.CORE_FILE_LOADERS, new String[]{FileSourcedConverter.class.getName(), URLSourcedLoader.class.getName()});
                }
                if (ConverterUtils.m_FileSavers.size() == 0) {
                    classnames = GenericObjectEditor.getClassnames(AbstractFileSaver.class.getName());
                    ConverterUtils.m_FileSavers = classnames.size() > 0 ? ConverterUtils.getFileConverters(classnames, new String[]{FileSourcedConverter.class.getName()}) : ConverterUtils.getFileConverters(ConverterUtils.CORE_FILE_SAVERS, new String[]{FileSourcedConverter.class.getName()});
                } else {
                    ** GOTO lbl49
                }
            }
            classnames = GenericObjectEditor.getClassnames(AbstractFileLoader.class.getName());
            ConverterUtils.m_FileLoaders = classnames.size() > 0 ? ConverterUtils.getFileConverters(classnames, new String[]{FileSourcedConverter.class.getName()}) : ConverterUtils.getFileConverters(ConverterUtils.CORE_FILE_LOADERS, new String[]{FileSourcedConverter.class.getName()});
        }
        if (ConverterUtils.m_URLFileLoaders.size() == 0) {
            classnames = GenericObjectEditor.getClassnames(AbstractFileLoader.class.getName());
            ConverterUtils.m_URLFileLoaders = classnames.size() > 0 ? ConverterUtils.getFileConverters(classnames, new String[]{FileSourcedConverter.class.getName(), URLSourcedLoader.class.getName()}) : ConverterUtils.getFileConverters(ConverterUtils.CORE_FILE_LOADERS, new String[]{FileSourcedConverter.class.getName(), URLSourcedLoader.class.getName()});
        }
        if (ConverterUtils.m_FileSavers.size() == 0) {
            classnames = GenericObjectEditor.getClassnames(AbstractFileSaver.class.getName());
            ConverterUtils.m_FileSavers = classnames.size() > 0 ? ConverterUtils.getFileConverters(classnames, new String[]{FileSourcedConverter.class.getName()}) : ConverterUtils.getFileConverters(ConverterUtils.CORE_FILE_SAVERS, new String[]{FileSourcedConverter.class.getName()});
        }
        ConverterFileChooser.initDefaultFilters();
    }

    protected static Hashtable<String, String> getFileConverters(String classnames, String[] intf) {
        Vector<String> list = new Vector<String>();
        String[] names = classnames.split(",");
        for (int i = 0; i < names.length; ++i) {
            list.add(names[i]);
        }
        return ConverterUtils.getFileConverters(list, intf);
    }

    protected static Hashtable<String, String> getFileConverters(Vector classnames, String[] intf) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        for (int i = 0; i < classnames.size(); ++i) {
            String[] ext;
            FileSourcedConverter converter;
            Class<?> cls;
            int n;
            String classname = (String)classnames.get(i);
            for (n = 0; n < intf.length; ++n) {
                if (ClassDiscovery.hasInterface(intf[n], classname)) continue;
            }
            try {
                cls = Class.forName(classname);
                converter = (FileSourcedConverter)cls.newInstance();
                ext = converter.getFileExtensions();
            }
            catch (Exception e) {
                cls = null;
                converter = null;
                ext = new String[]{};
            }
            if (converter == null) continue;
            for (n = 0; n < ext.length; ++n) {
                result.put(ext[n], classname);
            }
        }
        return result;
    }

    public static void getFirstToken(StreamTokenizer tokenizer) throws IOException {
        while (tokenizer.nextToken() == 10) {
        }
        if (tokenizer.ttype == 39 || tokenizer.ttype == 34) {
            tokenizer.ttype = -3;
        } else if (tokenizer.ttype == -3 && tokenizer.sval.equals("?")) {
            tokenizer.ttype = 63;
        }
    }

    public static void getToken(StreamTokenizer tokenizer) throws IOException {
        tokenizer.nextToken();
        if (tokenizer.ttype == 10) {
            return;
        }
        if (tokenizer.ttype == 39 || tokenizer.ttype == 34) {
            tokenizer.ttype = -3;
        } else if (tokenizer.ttype == -3 && tokenizer.sval.equals("?")) {
            tokenizer.ttype = 63;
        }
    }

    public static void errms(StreamTokenizer tokenizer, String theMsg) throws IOException {
        throw new IOException(theMsg + ", read " + tokenizer.toString());
    }

    protected static Vector<String> getConverters(Hashtable<String, String> ht) {
        Vector<String> result = new Vector<String>();
        Enumeration<String> enm = ht.elements();
        while (enm.hasMoreElements()) {
            String converter = enm.nextElement();
            if (result.contains(converter)) continue;
            result.add(converter);
        }
        Collections.sort(result);
        return result;
    }

    protected static Object getConverterForFile(String filename, Hashtable<String, String> ht) {
        Object result = null;
        int index = filename.lastIndexOf(46);
        if (index > -1) {
            String extension = filename.substring(index).toLowerCase();
            result = ConverterUtils.getConverterForExtension(extension, ht);
            if (extension.equals(".gz") && result == null) {
                index = filename.lastIndexOf(46, index - 1);
                extension = filename.substring(index).toLowerCase();
                result = ConverterUtils.getConverterForExtension(extension, ht);
            }
        }
        return result;
    }

    protected static Object getConverterForExtension(String extension, Hashtable<String, String> ht) {
        Object result = null;
        String classname = ht.get(extension);
        if (classname != null) {
            try {
                result = Class.forName(classname).newInstance();
            }
            catch (Exception e) {
                result = null;
                e.printStackTrace();
            }
        }
        return result;
    }

    public static boolean isCoreFileLoader(String classname) {
        Object[] classnames = CORE_FILE_LOADERS.split(",");
        boolean result = Arrays.binarySearch(classnames, classname) >= 0;
        return result;
    }

    public static Vector<String> getFileLoaders() {
        return ConverterUtils.getConverters(m_FileLoaders);
    }

    public static AbstractFileLoader getLoaderForFile(String filename) {
        return (AbstractFileLoader)ConverterUtils.getConverterForFile(filename, m_FileLoaders);
    }

    public static AbstractFileLoader getLoaderForFile(File file) {
        return ConverterUtils.getLoaderForFile(file.getAbsolutePath());
    }

    public static AbstractFileLoader getLoaderForExtension(String extension) {
        return (AbstractFileLoader)ConverterUtils.getConverterForExtension(extension, m_FileLoaders);
    }

    public static Vector<String> getURLFileLoaders() {
        return ConverterUtils.getConverters(m_URLFileLoaders);
    }

    public static AbstractFileLoader getURLLoaderForFile(String filename) {
        return (AbstractFileLoader)ConverterUtils.getConverterForFile(filename, m_URLFileLoaders);
    }

    public static AbstractFileLoader getURLLoaderForFile(File file) {
        return ConverterUtils.getURLLoaderForFile(file.getAbsolutePath());
    }

    public static AbstractFileLoader getURLLoaderForExtension(String extension) {
        return (AbstractFileLoader)ConverterUtils.getConverterForExtension(extension, m_URLFileLoaders);
    }

    public static boolean isCoreFileSaver(String classname) {
        Object[] classnames = CORE_FILE_SAVERS.split(",");
        boolean result = Arrays.binarySearch(classnames, classname) >= 0;
        return result;
    }

    public static Vector<String> getFileSavers() {
        return ConverterUtils.getConverters(m_FileSavers);
    }

    public static AbstractFileSaver getSaverForFile(String filename) {
        return (AbstractFileSaver)ConverterUtils.getConverterForFile(filename, m_FileSavers);
    }

    public static AbstractFileSaver getSaverForFile(File file) {
        return ConverterUtils.getSaverForFile(file.getAbsolutePath());
    }

    public static AbstractFileSaver getSaverForExtension(String extension) {
        return (AbstractFileSaver)ConverterUtils.getConverterForExtension(extension, m_FileSavers);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    static {
        ConverterUtils.initialize();
    }

    public static class DataSink
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = -1504966891136411204L;
        protected Saver m_Saver = null;
        protected OutputStream m_Stream = null;

        public DataSink(String filename) throws Exception {
            this.m_Stream = null;
            this.m_Saver = DataSource.isArff(filename) ? new ArffSaver() : ConverterUtils.getSaverForFile(filename);
            ((AbstractFileSaver)this.m_Saver).setFile(new File(filename));
        }

        public DataSink(Saver saver) {
            this.m_Saver = saver;
            this.m_Stream = null;
        }

        public DataSink(OutputStream stream) {
            this.m_Saver = null;
            this.m_Stream = stream;
        }

        public void write(Instances data) throws Exception {
            if (this.m_Saver != null) {
                this.m_Saver.setInstances(data);
                this.m_Saver.writeBatch();
            } else {
                this.m_Stream.write(data.toString().getBytes());
                this.m_Stream.flush();
            }
        }

        public static void write(String filename, Instances data) throws Exception {
            DataSink sink = new DataSink(filename);
            sink.write(data);
        }

        public static void write(Saver saver, Instances data) throws Exception {
            DataSink sink = new DataSink(saver);
            sink.write(data);
        }

        public static void write(OutputStream stream, Instances data) throws Exception {
            DataSink sink = new DataSink(stream);
            sink.write(data);
        }

        public static void main(String[] args) throws Exception {
            if (args.length != 2) {
                System.out.println("\nUsage: " + DataSource.class.getName() + " <input-file> <output-file>\n");
                System.exit(1);
            }
            Instances data = DataSource.read(args[0]);
            DataSink.write(args[1], data);
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 8034 $");
        }
    }

    public static class DataSource
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = -613122395928757332L;
        protected File m_File;
        protected URL m_URL;
        protected Loader m_Loader;
        protected boolean m_Incremental;
        protected int m_BatchCounter;
        protected Instance m_IncrementalBuffer;
        protected Instances m_BatchBuffer;

        public DataSource(String location) throws Exception {
            if (location.startsWith("http://") || location.startsWith("https://") || location.startsWith("ftp://") || location.startsWith("file://")) {
                this.m_URL = new URL(location);
            } else {
                this.m_File = new File(location);
            }
            if (DataSource.isArff(location)) {
                this.m_Loader = new ArffLoader();
            } else {
                this.m_Loader = this.m_File != null ? ConverterUtils.getLoaderForFile(location) : ConverterUtils.getURLLoaderForFile(location);
                if (this.m_Loader == null) {
                    throw new IllegalArgumentException("No suitable converter found for '" + location + "'!");
                }
            }
            this.m_Incremental = this.m_Loader instanceof IncrementalConverter;
            this.reset();
        }

        public DataSource(Instances inst) {
            this.m_BatchBuffer = inst;
            this.m_Loader = null;
            this.m_File = null;
            this.m_URL = null;
            this.m_Incremental = false;
        }

        public DataSource(Loader loader) {
            this.m_BatchBuffer = null;
            this.m_Loader = loader;
            this.m_File = null;
            this.m_URL = null;
            this.m_Incremental = this.m_Loader instanceof IncrementalConverter;
            this.initBatchBuffer();
        }

        public DataSource(InputStream stream) {
            this.m_BatchBuffer = null;
            this.m_Loader = new ArffLoader();
            try {
                this.m_Loader.setSource(stream);
            }
            catch (Exception e) {
                this.m_Loader = null;
            }
            this.m_File = null;
            this.m_URL = null;
            this.m_Incremental = this.m_Loader instanceof IncrementalConverter;
            this.initBatchBuffer();
        }

        protected void initBatchBuffer() {
            try {
                this.m_BatchBuffer = !this.isIncremental() ? this.m_Loader.getDataSet() : null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public static boolean isArff(String location) {
            return location.toLowerCase().endsWith(ArffLoader.FILE_EXTENSION.toLowerCase()) || location.toLowerCase().endsWith(ArffLoader.FILE_EXTENSION_COMPRESSED.toLowerCase());
        }

        public boolean isIncremental() {
            return this.m_Incremental;
        }

        public Loader getLoader() {
            return this.m_Loader;
        }

        public Instances getDataSet() throws Exception {
            Instances result = null;
            this.reset();
            try {
                result = this.m_BatchBuffer == null ? this.m_Loader.getDataSet() : this.m_BatchBuffer;
            }
            catch (Exception e) {
                e.printStackTrace();
                result = null;
            }
            return result;
        }

        public Instances getDataSet(int classIndex) throws Exception {
            Instances result = this.getDataSet();
            if (result != null) {
                result.setClassIndex(classIndex);
            }
            return result;
        }

        public void reset() throws Exception {
            if (this.m_File != null) {
                ((AbstractFileLoader)this.m_Loader).setFile(this.m_File);
            } else if (this.m_URL != null) {
                ((URLSourcedLoader)((Object)this.m_Loader)).setURL(this.m_URL.toString());
            } else if (this.m_Loader != null) {
                this.m_Loader.reset();
            }
            this.m_BatchCounter = 0;
            this.m_IncrementalBuffer = null;
            if (this.m_Loader != null) {
                this.m_BatchBuffer = !this.isIncremental() ? this.m_Loader.getDataSet() : null;
            }
        }

        public Instances getStructure() throws Exception {
            if (this.m_BatchBuffer == null) {
                return this.m_Loader.getStructure();
            }
            return new Instances(this.m_BatchBuffer, 0);
        }

        public Instances getStructure(int classIndex) throws Exception {
            Instances result = this.getStructure();
            if (result != null) {
                result.setClassIndex(classIndex);
            }
            return result;
        }

        public boolean hasMoreElements(Instances structure) {
            boolean result = false;
            if (this.isIncremental()) {
                if (this.m_IncrementalBuffer != null) {
                    result = true;
                } else {
                    try {
                        this.m_IncrementalBuffer = this.m_Loader.getNextInstance(structure);
                        result = this.m_IncrementalBuffer != null;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        result = false;
                    }
                }
            } else {
                result = this.m_BatchCounter < this.m_BatchBuffer.numInstances();
            }
            return result;
        }

        public Instance nextElement(Instances dataset) {
            Instance result = null;
            if (this.isIncremental()) {
                if (this.m_IncrementalBuffer != null) {
                    result = this.m_IncrementalBuffer;
                    this.m_IncrementalBuffer = null;
                } else {
                    try {
                        result = this.m_Loader.getNextInstance(dataset);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        result = null;
                    }
                }
            } else if (this.m_BatchCounter < this.m_BatchBuffer.numInstances()) {
                result = this.m_BatchBuffer.instance(this.m_BatchCounter);
                ++this.m_BatchCounter;
            }
            if (result != null) {
                result.setDataset(dataset);
            }
            return result;
        }

        public static Instances read(String location) throws Exception {
            DataSource source = new DataSource(location);
            Instances result = source.getDataSet();
            return result;
        }

        public static Instances read(InputStream stream) throws Exception {
            DataSource source = new DataSource(stream);
            Instances result = source.getDataSet();
            return result;
        }

        public static Instances read(Loader loader) throws Exception {
            DataSource source = new DataSource(loader);
            Instances result = source.getDataSet();
            return result;
        }

        public static void main(String[] args) throws Exception {
            if (args.length != 1) {
                System.out.println("\nUsage: " + DataSource.class.getName() + " <file>\n");
                System.exit(1);
            }
            DataSource loader = new DataSource(args[0]);
            System.out.println("Incremental? " + loader.isIncremental());
            System.out.println("Loader: " + loader.getLoader().getClass().getName());
            System.out.println("Data:\n");
            Instances structure = loader.getStructure();
            System.out.println(structure);
            while (loader.hasMoreElements(structure)) {
                System.out.println(loader.nextElement(structure));
            }
            Instances inst = loader.getDataSet();
            loader = new DataSource(inst);
            System.out.println("\n\nProxy-Data:\n");
            System.out.println(loader.getStructure());
            while (loader.hasMoreElements(structure)) {
                System.out.println(loader.nextElement(inst));
            }
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 8034 $");
        }
    }
}

