/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.util.vector;

import it.uniroma2.util.vector.VectorProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticVectorProvider
implements VectorProvider {
    private Hashtable<String, double[]> distributionalSemanticDictionary;
    private int vectorSize;

    public SemanticVectorProvider(int vectorSize, File semanticVectors) throws Exception {
        this.vectorSize = vectorSize;
        this.distributionalSemanticDictionary = new Hashtable();
        this.loadVectors(null, semanticVectors, SemanticVectorFileType.dense);
    }

    @Override
    public double[] getVector(String word) throws Exception {
        if (this.distributionalSemanticDictionary != null && this.distributionalSemanticDictionary.get(word.toLowerCase()) != null) {
            return this.distributionalSemanticDictionary.get(word.toLowerCase());
        }
        throw new Exception("\nMissing term: " + word.toLowerCase());
    }

    @Override
    public int getVectorSize() {
        return this.vectorSize;
    }

    private void loadVectors(ArrayList<String> termsToLoad, File vectorsFile, SemanticVectorFileType type2) throws Exception {
        BufferedReader input = new BufferedReader(new FileReader(vectorsFile));
        if (type2 == SemanticVectorFileType.dense) {
            input.readLine();
        }
        String line = input.readLine();
        while (line != null) {
            String[] values;
            if (type2 == SemanticVectorFileType.dense) {
                int vectorStart;
                values = line.split(" ");
                for (vectorStart = 1; vectorStart < values.length - 1; ++vectorStart) {
                    try {
                        Double.parseDouble(values[vectorStart]);
                        break;
                    }
                    catch (Exception e) {
                        continue;
                    }
                }
                String term = values[0].toLowerCase();
                for (int i = 1; i < vectorStart; ++i) {
                    term = term + " " + values[i];
                }
                if (termsToLoad == null || termsToLoad.contains(term)) {
                    int size = values.length - vectorStart;
                    if (this.vectorSize != 0 && this.vectorSize <= size) {
                        size = this.vectorSize;
                    } else if (this.vectorSize != 0) {
                        System.out.println("Warning! " + this.vectorSize + " features required, but only " + size + " available!");
                    }
                    double[] semanticVector = new double[size];
                    for (int i = vectorStart; i < size + vectorStart; ++i) {
                        semanticVector[i - vectorStart] = Double.parseDouble(values[i]);
                    }
                    this.distributionalSemanticDictionary.put(term, semanticVector);
                    if (termsToLoad != null) {
                        termsToLoad.remove(term);
                    }
                }
            } else {
                values = line.split("\t");
                if (termsToLoad == null || termsToLoad.contains(values[0].substring(0, values[0].length() - 1))) {
                    double[] semanticVector = new double[this.vectorSize];
                    for (int i = 1; i < values.length; ++i) {
                        String[] indexValue = values[i].split(":");
                        if (indexValue.length != 2) {
                            System.out.println("Warning! Wrong format for feature:value in term " + values[0]);
                        }
                        if (Integer.valueOf(indexValue[0]) > this.vectorSize) break;
                        semanticVector[Integer.valueOf((String)indexValue[0]).intValue() - 1] = Double.parseDouble(indexValue[1]);
                    }
                    this.distributionalSemanticDictionary.put(values[0].substring(0, values[0].length() - 1), semanticVector);
                    if (termsToLoad != null) {
                        termsToLoad.remove(values[0].substring(0, values[0].length() - 1));
                    }
                }
            }
            line = input.readLine();
        }
        input.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SemanticVectorFileType {
        dense,
        sparse;

    }
}

