/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.util.math;

import it.uniroma2.util.math.Complex;

public class FFT {
    private Complex[][] wks = null;

    public void initialize(int grade) {
        int dimension = (int)Math.pow(2.0, grade);
        this.wks = new Complex[grade + 1][dimension];
        for (int g = 0; g < grade + 1; ++g) {
            dimension = (int)Math.pow(2.0, g);
            for (int k = 0; k < dimension; ++k) {
                double kth = (double)(-2 * k) * Math.PI / (double)dimension;
                this.wks[g][k] = new Complex(Math.cos(kth), Math.sin(kth));
            }
        }
    }

    public Complex[] fft(Complex[] x, int grade) {
        int N = x.length;
        if (N == 1) {
            return new Complex[]{x[0]};
        }
        if (N % 2 != 0) {
            throw new RuntimeException("N is not a power of 2");
        }
        Complex[] even = new Complex[N / 2];
        for (int k = 0; k < N / 2; ++k) {
            even[k] = x[2 * k];
        }
        Complex[] q = this.fft(even, grade - 1);
        Complex[] odd = even;
        for (int k = 0; k < N / 2; ++k) {
            odd[k] = x[2 * k + 1];
        }
        Complex[] r = this.fft(odd, grade - 1);
        Complex[] y = new Complex[N];
        for (int k = 0; k < N / 2; ++k) {
            y[k] = q[k].plus(this.wks[grade][k].times(r[k]));
            y[k + N / 2] = q[k].minus(this.wks[grade][k].times(r[k]));
        }
        return y;
    }

    public Complex[] real_fft(Complex[] x, int grade) {
        int N = x.length;
        if (N == 1) {
            return new Complex[]{x[0]};
        }
        if (N % 2 != 0) {
            throw new RuntimeException("N is not a power of 2");
        }
        Complex[] even = new Complex[N / 2];
        for (int k = 0; k < N / 2; ++k) {
            even[k] = x[2 * k];
        }
        Complex[] q = this.fft(even, grade - 1);
        Complex[] odd = even;
        for (int k = 0; k < N / 2; ++k) {
            odd[k] = x[2 * k + 1];
        }
        Complex[] r = this.fft(odd, grade - 1);
        Complex[] y = new Complex[N];
        y[0] = q[0].plus(this.wks[grade][0].times(r[0]));
        y[0 + N / 2] = q[0].minus(this.wks[grade][0].times(r[0]));
        for (int k = 1; k < N / 2; ++k) {
            y[k] = q[k].plus(this.wks[grade][k].times(r[k]));
            y[N - k] = y[k].conjugate();
        }
        return y;
    }

    public static boolean equal(Complex c1, Complex c2) {
        return c1.re() == c2.re() && c1.im() == c2.im();
    }

    public static int grado(int N) {
        int grado = 0;
        while (N != 1) {
            ++grado;
            N /= 2;
        }
        return grado;
    }

    public Complex[] ifft(Complex[] x, int grade) {
        int i;
        int N = x.length;
        Complex[] y = new Complex[N];
        for (i = 0; i < N; ++i) {
            y[i] = x[i].conjugate();
        }
        y = this.fft(y, grade);
        for (i = 0; i < N; ++i) {
            y[i] = y[i].conjugate();
        }
        for (i = 0; i < N; ++i) {
            y[i] = y[i].times(1.0 / (double)N);
        }
        return y;
    }

    public Complex[] cconvolve(Complex[] x, Complex[] y, int grade) {
        if (x.length != y.length) {
            throw new RuntimeException("Dimensions don't agree");
        }
        int N = x.length;
        Complex[] a = this.fft(x, grade);
        Complex[] b = this.fft(y, grade);
        Complex[] c = new Complex[N];
        for (int i = 0; i < N; ++i) {
            c[i] = a[i].times(b[i]);
        }
        return this.ifft(c, grade);
    }

    public Complex[] real_cconvolve(Complex[] x, Complex[] y, int grade) {
        if (x.length != y.length) {
            throw new RuntimeException("Dimensions don't agree");
        }
        int N = x.length;
        Complex[] a = this.real_fft(x, grade);
        Complex[] b = this.real_fft(y, grade);
        Complex[] c = new Complex[N];
        for (int i = 0; i < N; ++i) {
            c[i] = a[i].times(b[i]);
        }
        return this.ifft(c, grade);
    }
}

