/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.tk;

import it.uniroma2.util.tree.Tree;
import java.util.HashMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubpathTreeKernel {
    public static double lambda = 1.0;
    private static int nodeCount = 0;
    private static HashMap<String, Double> deltaMatrix;
    private static HashMap<Tree, Integer> nodeIndices;

    public static double value(Tree a, Tree b) {
        deltaMatrix = new HashMap();
        nodeIndices = new HashMap();
        nodeCount = 0;
        double sum = 0.0;
        for (Tree aa : SubpathTreeKernel.allNodes(a)) {
            for (Tree bb : SubpathTreeKernel.allNodes(b)) {
                sum += SubpathTreeKernel.delta(aa, bb);
            }
        }
        return sum;
    }

    private static double delta(Tree a, Tree b) {
        double k = 0.0;
        if (!nodeIndices.containsKey(a)) {
            nodeIndices.put(a, nodeCount);
            ++nodeCount;
        }
        if (!nodeIndices.containsKey(b)) {
            nodeIndices.put(b, nodeCount);
            ++nodeCount;
        }
        if (deltaMatrix.containsKey(nodeIndices.get(a) + ":" + nodeIndices.get(b))) {
            return deltaMatrix.get(nodeIndices.get(a) + ":" + nodeIndices.get(b));
        }
        if (a.getRootLabel().equals(b.getRootLabel())) {
            k = 1.0;
            for (Tree c1 : a.getChildren()) {
                for (Tree c2 : b.getChildren()) {
                    if (!c1.getRootLabel().equals(c2.getRootLabel())) continue;
                    k += SubpathTreeKernel.delta(c1, c2);
                }
            }
            k = lambda * k;
        }
        deltaMatrix.put(nodeIndices.get(a) + ":" + nodeIndices.get(b), k);
        return k;
    }

    private static Vector<Tree> allNodes(Tree node) {
        Vector<Tree> all = new Vector<Tree>();
        all.add(node);
        for (Tree child : node.getChildren()) {
            all.addAll(SubpathTreeKernel.allNodes(child));
        }
        return all;
    }
}

