/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.exp.dtk;

import it.uniroma2.exp.AbstractExperiment;
import it.uniroma2.exp.tools.AvgVarCalculator;
import it.uniroma2.tk.TreeKernel;
import it.uniroma2.util.math.ArrayMath;
import it.uniroma2.util.tree.RandomTreeGenerator;
import it.uniroma2.util.tree.Tree;
import it.uniroma2.util.vector.RandomVectorGenerator;

public class TimeTester
extends AbstractExperiment {
    public static final int TREES_PER_SIZE = 10;
    public static final int LABELS = 15;
    public static final int DEGREE = 5;
    public static final int MAX_NODES = 200;
    public static final int[] VECTOR_SIZES = new int[]{1024, 2048, 4096, 8192};

    protected void runExperiment() throws Exception {
        AvgVarCalculator time = new AvgVarCalculator();
        this.out.println("TK times");
        RandomTreeGenerator rtg = new RandomTreeGenerator(this.randomOffset);
        for (int nodes = 2; nodes < 200; ++nodes) {
            time.reset();
            for (int j = 0; j < 10; ++j) {
                Tree t1 = Tree.fromPennTree(rtg.generateRandomTree(15, 5, nodes));
                Tree t2 = Tree.fromPennTree(rtg.generateRandomTree(15, 5, nodes));
                System.gc();
                long start = System.currentTimeMillis();
                TreeKernel.value(t1, t2);
                time.addSample(System.currentTimeMillis() - start);
            }
            this.out.println(nodes + "\t" + time.getAvg());
        }
        this.out.println("DTK times");
        for (int size : VECTOR_SIZES) {
            time.reset();
            RandomVectorGenerator rvg = new RandomVectorGenerator(size, this.randomOffset);
            for (int i = 0; i < 2000; ++i) {
                double[] v1 = rvg.generateRandomVector();
                double[] v2 = rvg.generateRandomVector();
                long start = System.currentTimeMillis();
                ArrayMath.dot(v1, v2);
                time.addSample(System.currentTimeMillis() - start);
            }
            this.out.println(size + "\t" + time.getAvg());
        }
    }

    public static void main(String[] args) {
        TimeTester tt = new TimeTester();
        tt.setRandomOffset(0);
        tt.runAll();
    }
}

