/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.exp.dtk;

import it.uniroma2.dtk.dt.GenericDT;
import it.uniroma2.exp.AbstractExperiment;
import it.uniroma2.exp.tools.AvgVarCalculator;
import it.uniroma2.tk.TreeKernel;
import it.uniroma2.util.math.ArrayMath;
import it.uniroma2.util.math.statistical.SpearmanCorrelation;
import it.uniroma2.util.tree.RandomTreeGenerator;
import it.uniroma2.util.tree.Tree;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.Vector;

public class KernelComparison
extends AbstractExperiment {
    public final String inputTreesQC = "/home/lorenzo/esperimenti/dtk/qc/correlationTestData/corr_test_data.dat";
    private static final String rte_base_dir = "/home/lorenzo/workspace/arte/data/experiments/preprocessing/CPW/";
    public static final String[] inputTreePairsRTE = new String[]{"/home/lorenzo/workspace/arte/data/experiments/preprocessing/CPW/RTE1_dev.xml", "/home/lorenzo/workspace/arte/data/experiments/preprocessing/CPW/RTE1_test.xml", "/home/lorenzo/workspace/arte/data/experiments/preprocessing/CPW/RTE2_dev.xml", "/home/lorenzo/workspace/arte/data/experiments/preprocessing/CPW/RTE2_test.xml", "/home/lorenzo/workspace/arte/data/experiments/preprocessing/CPW/RTE3_dev.xml", "/home/lorenzo/workspace/arte/data/experiments/preprocessing/CPW/RTE3_test.xml", "/home/lorenzo/workspace/arte/data/experiments/preprocessing/CPW/RTE4_test.xml", "/home/lorenzo/workspace/arte/data/experiments/preprocessing/CPW/RTE5_dev.xml", "/home/lorenzo/workspace/arte/data/experiments/preprocessing/CPW/RTE5_test.xml"};
    private GenericDT dtk = null;
    private OPS OP1;
    private OPS OP2;
    private TYPES TYPE;
    private int TRIALS = 1;

    public static void main(String[] argv) throws Exception {
        KernelComparison kc = new KernelComparison();
        try {
            kc.setOutputStream(new PrintStream(new File("kernel_comparison.dat")));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(0);
        }
        kc.setVectorSizeArray(new int[]{512, 1024, 2048, 4096, 8192});
        kc.setRandomTreeNodes(30);
        kc.setLambdaArray(new double[]{0.2, 0.4, 0.6, 0.8, 1.0});
        kc.setCustomParameters(new int[]{3});
        kc.runAll();
    }

    protected void runExperiment() throws Exception {
        this.TYPE = TYPES.rte;
        this.usePos = this.TYPE != TYPES.artificial;
        TreeKernel.lexicalized = this.lexicalized;
        TreeKernel.lambda = this.lambda;
        if (this.currentCustomParameters[0] == 0) {
            this.OP1 = OPS.DTK;
            this.OP2 = OPS.TK;
        } else if (this.currentCustomParameters[0] == 1) {
            this.OP1 = OPS.DTK;
            this.OP2 = OPS.ZTK;
        } else if (this.currentCustomParameters[0] == 2) {
            this.OP1 = OPS.ZTK;
            this.OP2 = OPS.TK;
        }
        AvgVarCalculator avgSpearCor = new AvgVarCalculator();
        AvgVarCalculator avgRatioCor = new AvgVarCalculator();
        for (int trial = 0; trial < this.TRIALS; ++trial) {
            this.dtk = new GenericDT(trial + this.randomOffset, this.vectorSize, this.usePos, this.lexicalized, this.compositionType);
            this.dtk.setLambda(this.lambda);
            this.out.println("****** trial " + (trial + 1) + " of " + this.TRIALS + " *******");
            switch (this.TYPE) {
                case artificial: {
                    this.computeArtificial(avgSpearCor, avgRatioCor);
                    break;
                }
                case rte: {
                    this.computeRTE(avgSpearCor, avgRatioCor);
                    break;
                }
                case qc: {
                    this.computeQC(avgSpearCor, avgRatioCor);
                }
            }
            this.out.print(String.format("spearman %.3f\t", avgSpearCor.getLastSample()));
            this.out.println(String.format("ratio %.3f\t", avgRatioCor.getAvg()));
        }
        this.out.println("\n******* FINAL RESULTS ******");
        this.out.println(this.OP1.toString() + " vs " + this.OP2.toString());
        this.out.println("Corpus: " + this.TYPE.toString());
        this.out.println("Trials: " + this.TRIALS);
        this.out.println("Spearman\t\tRatio");
        this.out.print(String.format("%.3f\t%.3f\t", avgSpearCor.getAvg(), avgSpearCor.getVar()));
        this.out.println(String.format("%.3f\t%.3f\t", avgRatioCor.getAvg(), avgRatioCor.getVar()));
    }

    public void computeRTE(AvgVarCalculator spear, AvgVarCalculator ratio) throws Exception {
        double[] resultsSpear = new double[inputTreePairsRTE.length];
        for (int n = 0; n < inputTreePairsRTE.length; ++n) {
            String treet;
            BufferedReader in = new BufferedReader(new FileReader(inputTreePairsRTE[n]));
            SpearmanCorrelation corr = new SpearmanCorrelation();
            Vector<Double> a_vec = new Vector<Double>();
            Vector<Double> b_vec = new Vector<Double>();
            int count = 0;
            while ((treet = in.readLine()) != null) {
                String treeh;
                if (!(treet = treet.trim()).startsWith("<t>") || !(treeh = in.readLine().trim()).startsWith("<h>")) continue;
                treet = treet.substring(3, treet.indexOf("</t>")).trim();
                Tree xt = Tree.fromPennTree(treet);
                treeh = treeh.substring(3, treeh.indexOf("</h>")).trim();
                Tree xh = Tree.fromPennTree(treeh);
                double value1 = this.op(xt, xh, this.OP1);
                double value2 = this.op(xt, xh, this.OP2);
                a_vec.add(value1);
                b_vec.add(value2);
                if (value2 != 0.0) {
                    ratio.addSample(value1 / value2);
                }
                this.out.print('.');
                if (count % 100 == 0) {
                    this.out.println("" + count);
                }
                count += 2;
            }
            float[] a = new float[a_vec.size()];
            for (int i = 0; i < a_vec.size(); ++i) {
                a[i] = ((Double)a_vec.elementAt(i)).floatValue();
            }
            float[] b = new float[b_vec.size()];
            for (int i = 0; i < b_vec.size(); ++i) {
                b[i] = ((Double)b_vec.elementAt(i)).floatValue();
            }
            resultsSpear[n] = corr.spearmanCorrelationCoefficient(a, b);
            this.out.println("end");
        }
        double tot = 0.0;
        for (double d : resultsSpear) {
            tot += d;
        }
        spear.addSample(tot / (double)inputTreePairsRTE.length);
    }

    public void computeArtificial(AvgVarCalculator spear, AvgVarCalculator ratio) throws Exception {
        RandomTreeGenerator rtg = new RandomTreeGenerator(this.randomOffset);
        Vector<Double> a_vec = new Vector<Double>();
        Vector<Double> b_vec = new Vector<Double>();
        SpearmanCorrelation corr = new SpearmanCorrelation();
        for (int i = 0; i < 1000; ++i) {
            this.out.print('.');
            if (i % 100 == 0) {
                this.out.println("" + i);
            }
            String treeh = rtg.generateRandomTree(this.randomTreeLabels, this.randomTreeMaxDegree, this.randomTreeNodes);
            Tree xh = Tree.fromPennTree(treeh);
            String treet = rtg.generateRandomTree(this.randomTreeLabels, this.randomTreeMaxDegree, this.randomTreeNodes);
            Tree xt = Tree.fromPennTree(treet);
            try {
                double value1 = this.op(xt, xh, this.OP1);
                double value2 = this.op(xt, xh, this.OP2);
                a_vec.add(value1);
                b_vec.add(value2);
                if (value2 == 0.0) continue;
                ratio.addSample(value1 / value2);
                continue;
            }
            catch (Exception e) {
                this.out.println(e.getMessage());
            }
        }
        this.out.println("end");
        float[] a = new float[a_vec.size()];
        for (int i = 0; i < a_vec.size(); ++i) {
            a[i] = ((Double)a_vec.elementAt(i)).floatValue();
        }
        float[] b = new float[b_vec.size()];
        for (int i = 0; i < b_vec.size(); ++i) {
            b[i] = ((Double)b_vec.elementAt(i)).floatValue();
        }
        spear.addSample(corr.spearmanCorrelationCoefficient(a, b));
    }

    public void computeQC(AvgVarCalculator spear, AvgVarCalculator ratio) throws Exception {
        Vector<Double> a_vec = new Vector<Double>();
        Vector<Double> b_vec = new Vector<Double>();
        SpearmanCorrelation corr = new SpearmanCorrelation();
        BufferedReader in = new BufferedReader(new FileReader("/home/lorenzo/esperimenti/dtk/qc/correlationTestData/corr_test_data.dat"));
        int count = 0;
        while (true) {
            String treet = in.readLine();
            String treeh = in.readLine();
            if (treet == null || treeh == null) break;
            treet = treet.substring(treet.indexOf("|BT|") + 4, treet.indexOf("|ET|")).trim();
            Tree xt = Tree.fromPennTree(treet);
            treeh = treeh.substring(treeh.indexOf("|BT|") + 4, treeh.indexOf("|ET|")).trim();
            Tree xh = Tree.fromPennTree(treeh);
            double value1 = this.op(xt, xh, this.OP1);
            double value2 = this.op(xt, xh, this.OP2);
            a_vec.add(value1);
            b_vec.add(value2);
            if (value2 != 0.0) {
                ratio.addSample(value1 / value2);
            }
            this.out.print('.');
            if (count % 100 == 0) {
                this.out.println("" + count);
            }
            count += 2;
        }
        in.close();
        float[] a = new float[a_vec.size()];
        for (int i = 0; i < a_vec.size(); ++i) {
            a[i] = ((Double)a_vec.elementAt(i)).floatValue();
        }
        float[] b = new float[b_vec.size()];
        for (int i = 0; i < b_vec.size(); ++i) {
            b[i] = ((Double)b_vec.elementAt(i)).floatValue();
        }
        spear.addSample(corr.spearmanCorrelationCoefficient(a, b));
    }

    public double op(Tree xt, Tree xh, OPS op) throws Exception {
        switch (op) {
            case TK: {
                return this.TK(xt, xh);
            }
            case DTK: {
                return this.DTK(xt, xh);
            }
            case ZTK: {
                return this.ZTK(xt, xh);
            }
        }
        throw new Exception("Unknown operation!");
    }

    public double TK(Tree xt, Tree xh) {
        return TreeKernel.value(xt, xh);
    }

    public double DTK(Tree xt, Tree xh) throws Exception {
        double[] vectort = this.dtk.dt(xt);
        double[] vectorh = this.dtk.dt(xh);
        return ArrayMath.dot(vectort, vectorh);
    }

    public double ZTK(Tree xt, Tree xh) {
        double oldLambda = TreeKernel.lambda;
        TreeKernel.lambda = 0.0;
        double result = this.TK(xt, xh);
        TreeKernel.lambda = oldLambda;
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TYPES {
        artificial,
        rte,
        qc;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OPS {
        TK,
        DTK,
        ZTK;

    }
}

