/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma2.dtk.op.convolution;

import it.uniroma2.dtk.op.TransformAndCompose;
import it.uniroma2.util.math.Complex;
import it.uniroma2.util.math.FFT;
import it.uniroma2.util.vector.VectorProvider;
import java.util.Arrays;

public class CircularConvolution
extends TransformAndCompose {
    protected FFT fft = null;
    protected int spaceGrade = 0;

    public double[] op(double[] x, double[] y) {
        if (x == null) {
            return y;
        }
        if (y == null) {
            return x;
        }
        if (this.fft == null) {
            return this.circularConvolutionBasic(x, y);
        }
        return this.circularConvolutionFFT(x, y);
    }

    protected double[] circularConvolutionBasic(double[] firstVector, double[] secondVector) {
        int size = firstVector.length;
        double[] result = new double[size];
        Arrays.fill(result, 0.0);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                int n = i;
                result[n] = result[n] + firstVector[j] * secondVector[i - j < 0 ? i - j + size : i - j];
            }
        }
        return result;
    }

    protected double[] circularConvolutionFFT(double[] firstVector, double[] secondVector) {
        return Complex.extract(this.fft.real_cconvolve(Complex.generate(firstVector), Complex.generate(secondVector), this.spaceGrade));
    }

    public void initialize(VectorProvider vp) throws Exception {
        super.initialize(vp);
        int exp = this.log2(vp.getVectorSize());
        if (exp < 0) {
            return;
        }
        this.fft = new FFT();
        this.fft.initialize(exp);
        this.spaceGrade = exp;
    }

    protected int log2(int arg) {
        int exp = 0;
        double pow;
        while ((pow = Math.pow(2.0, exp)) != (double)arg) {
            if (pow > (double)arg) {
                return -1;
            }
            ++exp;
        }
        return exp;
    }
}

