/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.processor;

import clojure.lang.Compiler;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.core.scripts.ScriptException;
import org.springframework.extensions.webscripts.ScriptContent;
import org.springframework.extensions.webscripts.processor.AbstractScriptProcessor;
import spring.surf.webscript.WebScript;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClojureScriptProcessor
extends AbstractScriptProcessor {
    private static final Log log = LogFactory.getLog(ClojureScriptProcessor.class);

    public String getExtension() {
        return "clj";
    }

    public String getName() {
        return "clojure";
    }

    protected Object executeClojureScript(InputStream is, Writer out, Map<String, Object> model) {
        log.debug((Object)"Executing Clojure script");
        log.debug((Object)("This line is to get rid of an IDEA warning: " + out));
        this.addProcessorModelExtensions(model);
        try {
            WebScript script = (WebScript)Compiler.load((Reader)new InputStreamReader(is));
            Map cljModel = (Map)script.run(is, out, model);
            return cljModel;
        }
        catch (Exception exception) {
            throw new ScriptException("Error executing Clojure script", (Throwable)exception);
        }
    }

    public ScriptContent findScript(String path) {
        return this.getScriptLoader().getScript(path);
    }

    public Object executeScript(String path, Map<String, Object> model) {
        ScriptContent scriptContent = this.findScript(path);
        if (scriptContent == null) {
            throw new ScriptException("Unable to locate: " + path);
        }
        return this.executeScript(scriptContent, model);
    }

    public Object executeScript(ScriptContent scriptContent, Map<String, Object> model) {
        return this.executeClojureScript(scriptContent.getInputStream(), null, model);
    }

    public Object unwrapValue(Object value) {
        return value;
    }

    public void reset() {
        this.init();
    }
}

