(ns swim.seq)

(defn distinct-by
  "Returns a lazy sequence of the elements of coll with duplicate keys removed."
  [keyfn coll]
    (let [step (fn step [xs seen]
                   (lazy-seq
                    ((fn [[x :as xs] seen]
                       (when-let [s (seq xs)]
                         (let [k (keyfn x)]
                           (if (contains? seen k)
                             (recur (rest s) seen)
                             (cons x (step (rest s) (conj seen k)))))))
                     xs seen)))]
      (step coll #{})))

;;;;;;;;;;;; This file autogenerated from src/swim/seq.cljx
