goog.provide('taoensso.telemere.utils');
/**
 * `:info` -> "INFO",
 *     `5` -> "LEVEL:5", etc.
 */
taoensso.telemere.utils.format_level = taoensso.encore.signals.format_level;

/**
 * `:foo.bar/baz` -> "::baz", etc.
 */
taoensso.telemere.utils.format_id = taoensso.encore.signals.format_id;
/**
 * Alpha, subject to change.
 *   Returns a (fn nano-uid [root?]) that returns a random nano-style uid string like:
 *  "r76-B8LoIPs5lBG1_Uhdy" - 126 bit (21 char)     root         uid
 *  "tMEYoZH0K-"            - 60  bit (10 char) non-root (child) uid
 */
taoensso.telemere.utils.nano_uid_fn = (function taoensso$telemere$utils$nano_uid_fn(var_args){
var G__50726 = arguments.length;
switch (G__50726) {
case 0:
return taoensso.telemere.utils.nano_uid_fn.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.telemere.utils.nano_uid_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(taoensso.telemere.utils.nano_uid_fn.cljs$core$IFn$_invoke$arity$0 = (function (){
return taoensso.telemere.utils.nano_uid_fn.cljs$core$IFn$_invoke$arity$1(null);
}));

(taoensso.telemere.utils.nano_uid_fn.cljs$core$IFn$_invoke$arity$1 = (function (p__50727){
var map__50728 = p__50727;
var map__50728__$1 = cljs.core.__destructure_map(map__50728);
var secure_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50728__$1,new cljs.core.Keyword(null,"secure?","secure?",-368029718));
var root_len = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__50728__$1,new cljs.core.Keyword(null,"root-len","root-len",-204417175),(21));
var child_len = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__50728__$1,new cljs.core.Keyword(null,"child-len","child-len",1548141543),(10));
var root_len__$1 = cljs.core.long$(root_len);
var child_len__$1 = cljs.core.long$(child_len);
return (function taoensso$telemere$utils$nano_uid(root_QMARK_){
if(cljs.core.truth_(root_QMARK_)){
return taoensso.encore.nanoid.cljs$core$IFn$_invoke$arity$2(secure_QMARK_,root_len__$1);
} else {
return taoensso.encore.nanoid.cljs$core$IFn$_invoke$arity$2(secure_QMARK_,child_len__$1);
}
});
}));

(taoensso.telemere.utils.nano_uid_fn.cljs$lang$maxFixedArity = 1);

/**
 * Alpha, subject to change.
 *   Returns a (fn hex-uid [root?]) that returns a random hex-style uid string like:
 *  "05039666eb9dc3206475f44ab9f3d843" - 128 bit (32 char)     root         uid
 *  "721fcef639a51513"                 - 64  bit (16 char) non-root (child) uid
 */
taoensso.telemere.utils.hex_uid_fn = (function taoensso$telemere$utils$hex_uid_fn(var_args){
var G__50730 = arguments.length;
switch (G__50730) {
case 0:
return taoensso.telemere.utils.hex_uid_fn.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.telemere.utils.hex_uid_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(taoensso.telemere.utils.hex_uid_fn.cljs$core$IFn$_invoke$arity$0 = (function (){
return taoensso.telemere.utils.hex_uid_fn.cljs$core$IFn$_invoke$arity$1(null);
}));

(taoensso.telemere.utils.hex_uid_fn.cljs$core$IFn$_invoke$arity$1 = (function (p__50731){
var map__50732 = p__50731;
var map__50732__$1 = cljs.core.__destructure_map(map__50732);
var secure_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50732__$1,new cljs.core.Keyword(null,"secure?","secure?",-368029718));
var root_len = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__50732__$1,new cljs.core.Keyword(null,"root-len","root-len",-204417175),(32));
var child_len = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__50732__$1,new cljs.core.Keyword(null,"child-len","child-len",1548141543),(16));
var root_len__$1 = cljs.core.long$(root_len);
var child_len__$1 = cljs.core.long$(child_len);
var rand_bytes_fn = (cljs.core.truth_(secure_QMARK_)?cljs.core.partial.cljs$core$IFn$_invoke$arity$2(taoensso.encore.rand_bytes,true):cljs.core.partial.cljs$core$IFn$_invoke$arity$2(taoensso.encore.rand_bytes,false));
var hex_uid_root = taoensso.encore.rand_id_fn(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"chars","chars",-1094630317),new cljs.core.Keyword(null,"hex-lowercase","hex-lowercase",1090135664),new cljs.core.Keyword(null,"len","len",1423657078),root_len__$1,new cljs.core.Keyword(null,"rand-bytes-fn","rand-bytes-fn",501267911),rand_bytes_fn], null));
var hex_uid_child = taoensso.encore.rand_id_fn(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"chars","chars",-1094630317),new cljs.core.Keyword(null,"hex-lowercase","hex-lowercase",1090135664),new cljs.core.Keyword(null,"len","len",1423657078),child_len__$1,new cljs.core.Keyword(null,"rand-bytes-fn","rand-bytes-fn",501267911),rand_bytes_fn], null));
return (function taoensso$telemere$utils$hex_uid(root_QMARK_){
if(cljs.core.truth_(root_QMARK_)){
return hex_uid_root();
} else {
return hex_uid_child();
}
});
}));

(taoensso.telemere.utils.hex_uid_fn.cljs$lang$maxFixedArity = 1);

/**
 * Private, don't use.
 *   Returns (fn uid [root?]) for given uid kind.
 */
taoensso.telemere.utils.parse_uid_fn = (function taoensso$telemere$utils$parse_uid_fn(kind){
var G__50733 = kind;
var G__50733__$1 = (((G__50733 instanceof cljs.core.Keyword))?G__50733.fqn:null);
switch (G__50733__$1) {
case "uuid":
return (function (_root_QMARK_){
return taoensso.encore.uuid();
});

break;
case "uuid-str":
return (function (_root_QMARK_){
return taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$0();
});

break;
case "default":
return taoensso.telemere.utils.nano_uid_fn.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"secure?","secure?",-368029718),false], null));

break;
case "nano/insecure":
return taoensso.telemere.utils.nano_uid_fn.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"secure?","secure?",-368029718),false], null));

break;
case "nano/secure":
return taoensso.telemere.utils.nano_uid_fn.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"secure?","secure?",-368029718),true], null));

break;
case "hex/insecure":
return taoensso.telemere.utils.hex_uid_fn.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"secure?","secure?",-368029718),false], null));

break;
case "hex/secure":
return taoensso.telemere.utils.hex_uid_fn.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"secure?","secure?",-368029718),true], null));

break;
default:
var or__5002__auto__ = ((cljs.core.vector_QMARK_(kind))?(function (){var vec__50734 = kind;
var kind__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50734,(0),null);
var root_len = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50734,(1),null);
var child_len = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50734,(2),null);
var G__50737 = kind__$1;
var G__50737__$1 = (((G__50737 instanceof cljs.core.Keyword))?G__50737.fqn:null);
switch (G__50737__$1) {
case "nano/insecure":
return taoensso.telemere.utils.nano_uid_fn.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"secure?","secure?",-368029718),false,new cljs.core.Keyword(null,"root-len","root-len",-204417175),root_len,new cljs.core.Keyword(null,"child-len","child-len",1548141543),child_len], null));

break;
case "nano/secure":
return taoensso.telemere.utils.nano_uid_fn.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"secure?","secure?",-368029718),true,new cljs.core.Keyword(null,"root-len","root-len",-204417175),root_len,new cljs.core.Keyword(null,"child-len","child-len",1548141543),child_len], null));

break;
case "hex/insecure":
return taoensso.telemere.utils.hex_uid_fn.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"secure?","secure?",-368029718),false,new cljs.core.Keyword(null,"root-len","root-len",-204417175),root_len,new cljs.core.Keyword(null,"child-len","child-len",1548141543),child_len], null));

break;
case "hex/secure":
return taoensso.telemere.utils.hex_uid_fn.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"secure?","secure?",-368029718),true,new cljs.core.Keyword(null,"root-len","root-len",-204417175),root_len,new cljs.core.Keyword(null,"child-len","child-len",1548141543),child_len], null));

break;
default:
return null;

}
})():null);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return taoensso.truss.unexpected_arg_BANG__STAR_("taoensso.telemere.utils",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [122,7], null),kind,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"param","param",2013631823),new cljs.core.Symbol(null,"kind","kind",923265724,null),new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Symbol("taoensso.telemere.utils","uid-fn","taoensso.telemere.utils/uid-fn",790130699,null),new cljs.core.Keyword(null,"expected","expected",1583670997),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"default","default",-1987822328),"null",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nano","insecure","nano/insecure",-1399463185),new cljs.core.Symbol(null,"<root-len>","<root-len>",-540063912,null),new cljs.core.Symbol(null,"<child-len>","<child-len>",-1454733286,null)], null),"null",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nano","secure","nano/secure",174489112),new cljs.core.Symbol(null,"<root-len>","<root-len>",-540063912,null),new cljs.core.Symbol(null,"<child-len>","<child-len>",-1454733286,null)], null),"null",new cljs.core.Keyword("nano","insecure","nano/insecure",-1399463185),"null",new cljs.core.Keyword(null,"uuid-str","uuid-str",358395442),"null",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("hex","insecure","hex/insecure",-1411913130),new cljs.core.Symbol(null,"<root-len>","<root-len>",-540063912,null),new cljs.core.Symbol(null,"<child-len>","<child-len>",-1454733286,null)], null),"null",new cljs.core.Keyword("hex","insecure","hex/insecure",-1411913130),"null",new cljs.core.Keyword("nano","secure","nano/secure",174489112),"null",new cljs.core.Keyword(null,"uuid","uuid",-2145095719),"null",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("hex","secure","hex/secure",177509789),new cljs.core.Symbol(null,"<root-len>","<root-len>",-540063912,null),new cljs.core.Symbol(null,"<child-len>","<child-len>",-1454733286,null)], null),"null",new cljs.core.Keyword("hex","secure","hex/secure",177509789),"null"], null), null)], null));
}

}
});
/**
 * Single system newline
 */
taoensso.telemere.utils.newline = "\n";

/**
 * Prints given arg to an edn string readable with `read-edn`.
 */
taoensso.telemere.utils.pr_edn = taoensso.encore.pr_edn;

/**
 * Returns a random UUID string of given length (max 36).
 *   Uses strong randomness when possible. See also `uuid`, `nanoid`, `rand-id-fn`.
 */
taoensso.telemere.utils.uuid_str = taoensso.encore.uuid_str;

/**
 * Returns given Cljs argument as JSON string.
 */
taoensso.telemere.utils.pr_json = taoensso.encore.pr_json;
/**
 * Returns JavaScript console logger to match given signal level:
 *     `:debug` -> `js/console.debug`,
 *     `:error` -> `js/console.error`, etc.
 * 
 *   Defaults to `js.console.log` for unmatched signal levels.
 *   NB: assumes that `js/console` exists, handler constructors should check first!
 */
taoensso.telemere.utils.js_console_logger = (function taoensso$telemere$utils$js_console_logger(level){
var G__50738 = level;
var G__50738__$1 = (((G__50738 instanceof cljs.core.Keyword))?G__50738.fqn:null);
switch (G__50738__$1) {
case "trace":
return console.debug;

break;
case "debug":
return console.debug;

break;
case "info":
return console.info;

break;
case "warn":
return console.warn;

break;
case "error":
return console.error;

break;
case "fatal":
return console.error;

break;
case "report":
return console.info;

break;
default:
return console.log;

}
});
/**
 * Returns true iff given signal has an `:error` value, or a `:kind` or `:level`
 *   that indicates that it's an error.
 */
taoensso.telemere.utils.error_signal_QMARK_ = (function taoensso$telemere$utils$error_signal_QMARK_(signal){
var and__5000__auto__ = signal;
if(cljs.core.truth_(and__5000__auto__)){
return cljs.core.boolean$((function (){var or__5002__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(signal,new cljs.core.Keyword(null,"error","error",-978969032));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
var or__5002__auto____$1 = cljs.core.keyword_identical_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(signal,new cljs.core.Keyword(null,"kind","kind",-717265803)),new cljs.core.Keyword(null,"error","error",-978969032));
if(or__5002__auto____$1){
return or__5002__auto____$1;
} else {
var or__5002__auto____$2 = (function (){var G__50739 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(signal,new cljs.core.Keyword(null,"level","level",1290497552));
var G__50739__$1 = (((G__50739 instanceof cljs.core.Keyword))?G__50739.fqn:null);
switch (G__50739__$1) {
case "error":
case "fatal":
return true;

break;
default:
return false;

}
})();
if(cljs.core.truth_(or__5002__auto____$2)){
return or__5002__auto____$2;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(signal,new cljs.core.Keyword(null,"error?","error?",-460689159));
}
}
}
})());
} else {
return and__5000__auto__;
}
});
/**
 * Private, don't use.
 *   Returns given signal without app-level kvs or `:kvs` key.
 */
taoensso.telemere.utils.remove_signal_kvs = (function taoensso$telemere$utils$remove_signal_kvs(signal){
var temp__5821__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(signal,new cljs.core.Keyword(null,"kvs","kvs",958455492));
if(cljs.core.truth_(temp__5821__auto__)){
var kvs = temp__5821__auto__;
return cljs.core.reduce_kv((function (m,k,_v){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m,k);
}),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(signal,new cljs.core.Keyword(null,"kvs","kvs",958455492)),kvs);
} else {
return signal;
}
});
/**
 * Private, don't use.
 *   Returns given signal with nil-valued keys removed.
 */
taoensso.telemere.utils.remove_signal_nils = (function taoensso$telemere$utils$remove_signal_nils(signal){
if(taoensso.encore.editable_QMARK_(signal)){
return cljs.core.persistent_BANG_(cljs.core.reduce_kv((function (m,k,v){
if((v == null)){
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2(m,k);
} else {
return m;
}
}),cljs.core.transient$(signal),signal));
} else {
return cljs.core.persistent_BANG_(cljs.core.reduce_kv((function (m,k,v){
if((v == null)){
return m;
} else {
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),signal));
}
});
/**
 * Private, don't use.
 *   Returns given signal with possible `:msg_` value forced (realized when a delay).
 */
taoensso.telemere.utils.force_signal_msg = (function taoensso$telemere$utils$force_signal_msg(signal){
var temp__5821__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(signal,new cljs.core.Keyword(null,"msg_","msg_",-1925147000));
if(cljs.core.truth_(temp__5821__auto__)){
var msg_ = temp__5821__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(signal,new cljs.core.Keyword(null,"msg_","msg_",-1925147000),cljs.core.force(msg_));
} else {
return signal;
}
});
/**
 * Private, don't use.
 *   Returns given signal with possible `:error` replaced by
 *   [{:keys [type msg data]} ...] cause chain.
 */
taoensso.telemere.utils.expand_signal_error = (function taoensso$telemere$utils$expand_signal_error(signal){
var b2__39812__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(signal,new cljs.core.Keyword(null,"error","error",-978969032));
if(cljs.core.truth_(b2__39812__auto__)){
var error = b2__39812__auto__;
var b2__39812__auto____$1 = taoensso.truss.ex_chain.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"as-map","as-map",633645847),error);
if(cljs.core.truth_(b2__39812__auto____$1)){
var chain = b2__39812__auto____$1;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(signal,new cljs.core.Keyword(null,"error","error",-978969032),chain);
} else {
return signal;
}
} else {
return signal;
}
});
/**
 * Alpha, subject to change.
 *   Returns a (fn format [nanosecs]) that:
 *  - Takes a long nanoseconds (e.g. runtime).
 *  - Returns a human-readable string like:
 *    "1.00m", "4.20s", "340ms", "822μs", etc.
 */
taoensso.telemere.utils.format_nsecs_fn = (function taoensso$telemere$utils$format_nsecs_fn(var_args){
var G__50741 = arguments.length;
switch (G__50741) {
case 0:
return taoensso.telemere.utils.format_nsecs_fn.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.telemere.utils.format_nsecs_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(taoensso.telemere.utils.format_nsecs_fn.cljs$core$IFn$_invoke$arity$0 = (function (){
return taoensso.telemere.utils.format_nsecs_fn.cljs$core$IFn$_invoke$arity$1(null);
}));

(taoensso.telemere.utils.format_nsecs_fn.cljs$core$IFn$_invoke$arity$1 = (function (p__50742){
var map__50743 = p__50742;
var map__50743__$1 = cljs.core.__destructure_map(map__50743);
var _opts = map__50743__$1;
return (function taoensso$telemere$utils$format_nsecs(nanosecs){
return taoensso.encore.format_nsecs(nanosecs);
});
}));

(taoensso.telemere.utils.format_nsecs_fn.cljs$lang$maxFixedArity = 1);

/**
 * Experimental, subject to change without notice.
 * 
 *   Returns a (fn format [instant]) that:
 *  - Takes a platform instant (`java.time.Instant` or `js/Date`).
 *  - Returns a formatted human-readable instant string.
 * 
 *   Options:
 *  `:formatter`
 *    Clj:  `java.time.format.DateTimeFormatter`
 *    Cljs: `goog.i18n.DateTimeFormat`
 * 
 *    Defaults to `ISO8601` formatter (`YYYY-MM-DDTHH:mm:ss.sssZ`),
 *    e.g.: "2011-12-03T10:15:130Z".
 * 
 *  `:zone` (Clj only) `java.time.ZoneOffset` (defaults to UTC).
 *   Note that zone may be ignored by some `DateTimeFormatter`s,
 *   including the default (`DateTimeFormatter/ISO_INSTANT`)!
 */
taoensso.telemere.utils.format_inst_fn = taoensso.encore.format_inst_fn;
/**
 * Alpha, subject to change.
 *   Returns a (fn format [error]) that:
 *  - Takes a platform error (`Throwable` or `js/Error`).
 *  - Returns a human-readable error string.
 */
taoensso.telemere.utils.format_error_fn = (function taoensso$telemere$utils$format_error_fn(var_args){
var G__50745 = arguments.length;
switch (G__50745) {
case 0:
return taoensso.telemere.utils.format_error_fn.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.telemere.utils.format_error_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(taoensso.telemere.utils.format_error_fn.cljs$core$IFn$_invoke$arity$0 = (function (){
return taoensso.telemere.utils.format_error_fn.cljs$core$IFn$_invoke$arity$1(null);
}));

(taoensso.telemere.utils.format_error_fn.cljs$core$IFn$_invoke$arity$1 = (function (p__50746){
var map__50747 = p__50746;
var map__50747__$1 = cljs.core.__destructure_map(map__50747);
var _opts = map__50747__$1;
var nl = "\n";
var nls = taoensso.encore.newlines;
return (function taoensso$telemere$utils$format_error(error){
var temp__5823__auto__ = taoensso.truss.ex_map(error);
if(cljs.core.truth_(temp__5823__auto__)){
var em = temp__5823__auto__;
var sb = taoensso.encore.str_builder.cljs$core$IFn$_invoke$arity$0();
var s_PLUS_ = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(taoensso.encore.sb_append,sb);
var map__50748 = em;
var map__50748__$1 = cljs.core.__destructure_map(map__50748);
var chain = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50748__$1,new cljs.core.Keyword(null,"chain","chain",15631029));
var trace = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50748__$1,new cljs.core.Keyword(null,"trace","trace",-1082747415));
var s_PLUS_cause_50824 = taoensso.encore.sb_appender.cljs$core$IFn$_invoke$arity$2(sb,[nls,"Caused: "].join(''));
s_PLUS_("Root: ");

var seq__50749_50825 = cljs.core.seq(cljs.core.rseq(chain));
var chunk__50750_50826 = null;
var count__50751_50827 = (0);
var i__50752_50828 = (0);
while(true){
if((i__50752_50828 < count__50751_50827)){
var map__50755_50829 = chunk__50750_50826.cljs$core$IIndexed$_nth$arity$2(null, i__50752_50828);
var map__50755_50830__$1 = cljs.core.__destructure_map(map__50755_50829);
var type_50831 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50755_50830__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var msg_50832 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50755_50830__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var data_50833 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50755_50830__$1,new cljs.core.Keyword(null,"data","data",-232669377));
s_PLUS_cause_50824(type_50831," - ",msg_50832);

if(cljs.core.truth_(data_50833)){
s_PLUS_(nl,"data: ",taoensso.encore.pr_edn_STAR_(data_50833));
} else {
}


var G__50834 = seq__50749_50825;
var G__50835 = chunk__50750_50826;
var G__50836 = count__50751_50827;
var G__50837 = (i__50752_50828 + (1));
seq__50749_50825 = G__50834;
chunk__50750_50826 = G__50835;
count__50751_50827 = G__50836;
i__50752_50828 = G__50837;
continue;
} else {
var temp__5823__auto___50838__$1 = cljs.core.seq(seq__50749_50825);
if(temp__5823__auto___50838__$1){
var seq__50749_50839__$1 = temp__5823__auto___50838__$1;
if(cljs.core.chunked_seq_QMARK_(seq__50749_50839__$1)){
var c__5525__auto___50840 = cljs.core.chunk_first(seq__50749_50839__$1);
var G__50841 = cljs.core.chunk_rest(seq__50749_50839__$1);
var G__50842 = c__5525__auto___50840;
var G__50843 = cljs.core.count(c__5525__auto___50840);
var G__50844 = (0);
seq__50749_50825 = G__50841;
chunk__50750_50826 = G__50842;
count__50751_50827 = G__50843;
i__50752_50828 = G__50844;
continue;
} else {
var map__50756_50845 = cljs.core.first(seq__50749_50839__$1);
var map__50756_50846__$1 = cljs.core.__destructure_map(map__50756_50845);
var type_50847 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50756_50846__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var msg_50848 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50756_50846__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var data_50849 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50756_50846__$1,new cljs.core.Keyword(null,"data","data",-232669377));
s_PLUS_cause_50824(type_50847," - ",msg_50848);

if(cljs.core.truth_(data_50849)){
s_PLUS_(nl,"data: ",taoensso.encore.pr_edn_STAR_(data_50849));
} else {
}


var G__50850 = cljs.core.next(seq__50749_50839__$1);
var G__50851 = null;
var G__50852 = (0);
var G__50853 = (0);
seq__50749_50825 = G__50850;
chunk__50750_50826 = G__50851;
count__50751_50827 = G__50852;
i__50752_50828 = G__50853;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(trace)){
s_PLUS_(nl,nl,"Root stack trace:",nl);

s_PLUS_(trace);
} else {
}

return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb);
} else {
return null;
}
});
}));

(taoensso.telemere.utils.format_error_fn.cljs$lang$maxFixedArity = 1);

/**
 * Alpha, subject to change.
 *   Returns a (fn preamble [signal]) that:
 *  - Takes a Telemere signal (map).
 *  - Returns a signal preamble ?string like:
 *    "2024-03-26T11:14:51.806Z INFO EVENT Hostname taoensso.telemere[2,21] ::ev-id msg"
 * 
 *   Options:
 *  `:format-inst-fn` - (fn format [instant]) => string.
 *  `:format-id-fn` --- (fn format [ns id])   => string.
 *  `:format-msg-fn` -- (fn format [msg])     => string.
 */
taoensso.telemere.utils.signal_preamble_fn = (function taoensso$telemere$utils$signal_preamble_fn(var_args){
var G__50758 = arguments.length;
switch (G__50758) {
case 0:
return taoensso.telemere.utils.signal_preamble_fn.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.telemere.utils.signal_preamble_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(taoensso.telemere.utils.signal_preamble_fn.cljs$core$IFn$_invoke$arity$0 = (function (){
return taoensso.telemere.utils.signal_preamble_fn.cljs$core$IFn$_invoke$arity$1(null);
}));

(taoensso.telemere.utils.signal_preamble_fn.cljs$core$IFn$_invoke$arity$1 = (function (p__50759){
var map__50760 = p__50759;
var map__50760__$1 = cljs.core.__destructure_map(map__50760);
var format_inst_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__50760__$1,new cljs.core.Keyword(null,"format-inst-fn","format-inst-fn",518148350),(taoensso.telemere.utils.format_inst_fn.cljs$core$IFn$_invoke$arity$0 ? taoensso.telemere.utils.format_inst_fn.cljs$core$IFn$_invoke$arity$0() : taoensso.telemere.utils.format_inst_fn.call(null, )));
var format_id_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__50760__$1,new cljs.core.Keyword(null,"format-id-fn","format-id-fn",513589829),taoensso.telemere.utils.format_id);
var format_msg_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__50760__$1,new cljs.core.Keyword(null,"format-msg-fn","format-msg-fn",-1387049398),cljs.core.identity);
return (function taoensso$telemere$utils$signal_preamble(signal){
var map__50761 = signal;
var map__50761__$1 = cljs.core.__destructure_map(map__50761);
var inst = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50761__$1,new cljs.core.Keyword(null,"inst","inst",645962501));
var level = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50761__$1,new cljs.core.Keyword(null,"level","level",1290497552));
var kind = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50761__$1,new cljs.core.Keyword(null,"kind","kind",-717265803));
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50761__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50761__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var msg_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50761__$1,new cljs.core.Keyword(null,"msg_","msg_",-1925147000));
var sb = taoensso.encore.str_builder.cljs$core$IFn$_invoke$arity$0();
var s_PLUS_spc = taoensso.encore.sb_appender.cljs$core$IFn$_invoke$arity$2(sb," ");
if(cljs.core.truth_(inst)){
var temp__5823__auto___50855 = format_inst_fn;
if(cljs.core.truth_(temp__5823__auto___50855)){
var ff_50856 = temp__5823__auto___50855;
s_PLUS_spc((ff_50856.cljs$core$IFn$_invoke$arity$1 ? ff_50856.cljs$core$IFn$_invoke$arity$1(inst) : ff_50856.call(null, inst)));
} else {
}
} else {
}

if(cljs.core.truth_(level)){
s_PLUS_spc((taoensso.telemere.utils.format_level.cljs$core$IFn$_invoke$arity$1 ? taoensso.telemere.utils.format_level.cljs$core$IFn$_invoke$arity$1(level) : taoensso.telemere.utils.format_level.call(null, level)));
} else {
}

if(cljs.core.truth_(kind)){
s_PLUS_spc((taoensso.encore.signals.upper_qn.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.signals.upper_qn.cljs$core$IFn$_invoke$arity$1(kind) : taoensso.encore.signals.upper_qn.call(null, kind)));
} else {
}

if(cljs.core.truth_(ns)){
s_PLUS_spc(taoensso.encore.signals.format_callsite.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.get.cljs$core$IFn$_invoke$arity$2(signal,new cljs.core.Keyword(null,"coords","coords",-599429112))));
} else {
}

if(cljs.core.truth_(id)){
var temp__5823__auto___50857 = format_id_fn;
if(cljs.core.truth_(temp__5823__auto___50857)){
var ff_50858 = temp__5823__auto___50857;
s_PLUS_spc((ff_50858.cljs$core$IFn$_invoke$arity$2 ? ff_50858.cljs$core$IFn$_invoke$arity$2(ns,id) : ff_50858.call(null, ns,id)));
} else {
}
} else {
}

var b2__39812__auto___50859 = format_msg_fn;
if(cljs.core.truth_(b2__39812__auto___50859)){
var ff_50860 = b2__39812__auto___50859;
var b2__39812__auto___50861__$1 = cljs.core.force(msg_);
if(cljs.core.truth_(b2__39812__auto___50861__$1)){
var msg_50862 = b2__39812__auto___50861__$1;
s_PLUS_spc((ff_50860.cljs$core$IFn$_invoke$arity$1 ? ff_50860.cljs$core$IFn$_invoke$arity$1(msg_50862) : ff_50860.call(null, msg_50862)));
} else {
}
} else {
}

if((taoensso.encore.sb_length(sb) === (0))){
return null;
} else {
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb);
}
});
}));

(taoensso.telemere.utils.signal_preamble_fn.cljs$lang$maxFixedArity = 1);

taoensso.telemere.utils.format_parent = (function taoensso$telemere$utils$format_parent(ns,p__50762){
var map__50763 = p__50762;
var map__50763__$1 = cljs.core.__destructure_map(map__50763);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50763__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var uid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50763__$1,new cljs.core.Keyword(null,"uid","uid",-1447769400));
if(cljs.core.truth_(id)){
if(cljs.core.truth_(uid)){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((taoensso.telemere.utils.format_id.cljs$core$IFn$_invoke$arity$2 ? taoensso.telemere.utils.format_id.cljs$core$IFn$_invoke$arity$2(ns,id) : taoensso.telemere.utils.format_id.call(null, ns,id))),new cljs.core.Keyword(null,"uid","uid",-1447769400),uid], null);
} else {
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((taoensso.telemere.utils.format_id.cljs$core$IFn$_invoke$arity$2 ? taoensso.telemere.utils.format_id.cljs$core$IFn$_invoke$arity$2(ns,id) : taoensso.telemere.utils.format_id.call(null, ns,id)))], null);
}
} else {
if(cljs.core.truth_(uid)){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"uid","uid",-1447769400),uid], null);
} else {
return null;
}
}
});
/**
 * Alpha, subject to change.
 *   Returns a (fn content [signal]) that:
 *  - Takes a Telemere signal (map).
 *  - Returns a human-readable signal content ?string (incl. data, ctx, etc.).
 * 
 *   Options:
 *  `:raw-error?` ------ Retain unformatted error? (default false)
 *  `:incl-keys` ------- Subset of signal keys to retain from those
 *                       otherwise excluded by default: #{:kvs :host :thread}
 *  `:format-nsecs-fn` - (fn [nanosecs]) => string.
 *  `:format-error-fn` - (fn [error])    => string.
 */
taoensso.telemere.utils.signal_content_fn = (function taoensso$telemere$utils$signal_content_fn(var_args){
var G__50765 = arguments.length;
switch (G__50765) {
case 0:
return taoensso.telemere.utils.signal_content_fn.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.telemere.utils.signal_content_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(taoensso.telemere.utils.signal_content_fn.cljs$core$IFn$_invoke$arity$0 = (function (){
return taoensso.telemere.utils.signal_content_fn.cljs$core$IFn$_invoke$arity$1(null);
}));

(taoensso.telemere.utils.signal_content_fn.cljs$core$IFn$_invoke$arity$1 = (function (p__50766){
var map__50767 = p__50766;
var map__50767__$1 = cljs.core.__destructure_map(map__50767);
var raw_error_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50767__$1,new cljs.core.Keyword(null,"raw-error?","raw-error?",-39485940));
var incl_keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50767__$1,new cljs.core.Keyword(null,"incl-keys","incl-keys",625658308));
var format_nsecs_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__50767__$1,new cljs.core.Keyword(null,"format-nsecs-fn","format-nsecs-fn",-1487810716),taoensso.telemere.utils.format_nsecs_fn.cljs$core$IFn$_invoke$arity$0());
var format_error_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__50767__$1,new cljs.core.Keyword(null,"format-error-fn","format-error-fn",-560488578),taoensso.telemere.utils.format_error_fn.cljs$core$IFn$_invoke$arity$0());
var nl = taoensso.telemere.utils.newline;
var err_start = [nl,"<<< error <<<",nl].join('');
var err_stop = [nl,">>> error >>>"].join('');
var incl_kvs_QMARK_ = cljs.core.contains_QMARK_(incl_keys,new cljs.core.Keyword(null,"kvs","kvs",958455492));
var incl_host_QMARK_ = cljs.core.contains_QMARK_(incl_keys,new cljs.core.Keyword(null,"host","host",-1558485167));
var incl_thread_QMARK_ = cljs.core.contains_QMARK_(incl_keys,new cljs.core.Keyword(null,"thread","thread",947001524));
return (function() {
var taoensso$telemere$utils$signal_content = null;
var taoensso$telemere$utils$signal_content__1 = (function (signal){
var sb = taoensso.encore.str_builder.cljs$core$IFn$_invoke$arity$0();
var s_PLUS__PLUS_ = taoensso.encore.sb_appender.cljs$core$IFn$_invoke$arity$2(sb,nl);
taoensso$telemere$utils$signal_content.cljs$core$IFn$_invoke$arity$3(signal,s_PLUS__PLUS_,taoensso.encore.pr_edn_STAR_);

if((taoensso.encore.sb_length(sb) === (0))){
return null;
} else {
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb);
}
});
var taoensso$telemere$utils$signal_content__3 = (function (signal,append_fn,val_fn){
var af = append_fn;
var vf = val_fn;
var map__50768_50864 = signal;
var map__50768_50865__$1 = cljs.core.__destructure_map(map__50768_50864);
var ns_50866 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50768_50865__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var uid_50867 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50768_50865__$1,new cljs.core.Keyword(null,"uid","uid",-1447769400));
var parent_50868 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50768_50865__$1,new cljs.core.Keyword(null,"parent","parent",-878878779));
var root_50869 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50768_50865__$1,new cljs.core.Keyword(null,"root","root",-448657453));
var data_50870 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50768_50865__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var kvs_50871 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50768_50865__$1,new cljs.core.Keyword(null,"kvs","kvs",958455492));
var ctx_50872 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50768_50865__$1,new cljs.core.Keyword(null,"ctx","ctx",-493610118));
var sample_50873 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50768_50865__$1,new cljs.core.Keyword(null,"sample","sample",79023601));
if(cljs.core.truth_(sample_50873)){
var G__50769_50874 = " sample: ";
var G__50770_50875 = (vf.cljs$core$IFn$_invoke$arity$1 ? vf.cljs$core$IFn$_invoke$arity$1(sample_50873) : vf.call(null, sample_50873));
(af.cljs$core$IFn$_invoke$arity$2 ? af.cljs$core$IFn$_invoke$arity$2(G__50769_50874,G__50770_50875) : af.call(null, G__50769_50874,G__50770_50875));
} else {
}

if(cljs.core.truth_(uid_50867)){
var G__50771_50876 = "    uid: ";
var G__50772_50877 = (vf.cljs$core$IFn$_invoke$arity$1 ? vf.cljs$core$IFn$_invoke$arity$1(uid_50867) : vf.call(null, uid_50867));
(af.cljs$core$IFn$_invoke$arity$2 ? af.cljs$core$IFn$_invoke$arity$2(G__50771_50876,G__50772_50877) : af.call(null, G__50771_50876,G__50772_50877));
} else {
}

if(cljs.core.truth_((function (){var and__5000__auto__ = parent_50868;
if(cljs.core.truth_(and__5000__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(parent_50868,root_50869);
} else {
return and__5000__auto__;
}
})())){
var G__50773_50878 = " parent: ";
var G__50774_50879 = (function (){var G__50775 = taoensso.telemere.utils.format_parent(ns_50866,parent_50868);
return (vf.cljs$core$IFn$_invoke$arity$1 ? vf.cljs$core$IFn$_invoke$arity$1(G__50775) : vf.call(null, G__50775));
})();
(af.cljs$core$IFn$_invoke$arity$2 ? af.cljs$core$IFn$_invoke$arity$2(G__50773_50878,G__50774_50879) : af.call(null, G__50773_50878,G__50774_50879));
} else {
}

if(cljs.core.truth_(root_50869)){
var G__50776_50880 = "   root: ";
var G__50777_50881 = (function (){var G__50778 = taoensso.telemere.utils.format_parent(ns_50866,root_50869);
return (vf.cljs$core$IFn$_invoke$arity$1 ? vf.cljs$core$IFn$_invoke$arity$1(G__50778) : vf.call(null, G__50778));
})();
(af.cljs$core$IFn$_invoke$arity$2 ? af.cljs$core$IFn$_invoke$arity$2(G__50776_50880,G__50777_50881) : af.call(null, G__50776_50880,G__50777_50881));
} else {
}

if(cljs.core.truth_(taoensso.encore.not_empty_coll(data_50870))){
var G__50779_50882 = "   data: ";
var G__50780_50883 = (vf.cljs$core$IFn$_invoke$arity$1 ? vf.cljs$core$IFn$_invoke$arity$1(data_50870) : vf.call(null, data_50870));
(af.cljs$core$IFn$_invoke$arity$2 ? af.cljs$core$IFn$_invoke$arity$2(G__50779_50882,G__50780_50883) : af.call(null, G__50779_50882,G__50780_50883));
} else {
}

if(cljs.core.truth_(taoensso.encore.not_empty_coll(ctx_50872))){
var G__50781_50884 = "    ctx: ";
var G__50782_50885 = (vf.cljs$core$IFn$_invoke$arity$1 ? vf.cljs$core$IFn$_invoke$arity$1(ctx_50872) : vf.call(null, ctx_50872));
(af.cljs$core$IFn$_invoke$arity$2 ? af.cljs$core$IFn$_invoke$arity$2(G__50781_50884,G__50782_50885) : af.call(null, G__50781_50884,G__50782_50885));
} else {
}

if((cljs.core.truth_(kvs_50871)?incl_kvs_QMARK_:false)){
var G__50783_50886 = "    kvs: ";
var G__50784_50887 = (vf.cljs$core$IFn$_invoke$arity$1 ? vf.cljs$core$IFn$_invoke$arity$1(kvs_50871) : vf.call(null, kvs_50871));
(af.cljs$core$IFn$_invoke$arity$2 ? af.cljs$core$IFn$_invoke$arity$2(G__50783_50886,G__50784_50887) : af.call(null, G__50783_50886,G__50784_50887));
} else {
}

var map__50785 = signal;
var map__50785__$1 = cljs.core.__destructure_map(map__50785);
var run_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50785__$1,new cljs.core.Keyword(null,"run-form","run-form",405647397));
var error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50785__$1,new cljs.core.Keyword(null,"error","error",-978969032));
if(cljs.core.truth_(run_form)){
var map__50786_50888 = signal;
var map__50786_50889__$1 = cljs.core.__destructure_map(map__50786_50888);
var run_val_50890 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50786_50889__$1,new cljs.core.Keyword(null,"run-val","run-val",-304326520));
var run_nsecs_50891 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50786_50889__$1,new cljs.core.Keyword(null,"run-nsecs","run-nsecs",32621724));
var run_time_50892 = (cljs.core.truth_(run_nsecs_50891)?(function (){var temp__5823__auto__ = format_nsecs_fn;
if(cljs.core.truth_(temp__5823__auto__)){
var ff = temp__5823__auto__;
return (ff.cljs$core$IFn$_invoke$arity$1 ? ff.cljs$core$IFn$_invoke$arity$1(run_nsecs_50891) : ff.call(null, run_nsecs_50891));
} else {
return null;
}
})():null);
var run_info_50893 = (cljs.core.truth_(error)?new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"form","form",-1624062471),run_form,new cljs.core.Keyword(null,"time","time",1385887882),run_time_50892,new cljs.core.Keyword(null,"nsecs","nsecs",1510077757),run_nsecs_50891], null):new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"form","form",-1624062471),run_form,new cljs.core.Keyword(null,"time","time",1385887882),run_time_50892,new cljs.core.Keyword(null,"nsecs","nsecs",1510077757),run_nsecs_50891,new cljs.core.Keyword(null,"val","val",128701612),run_val_50890], null));
var G__50787_50894 = "    run: ";
var G__50788_50895 = (vf.cljs$core$IFn$_invoke$arity$1 ? vf.cljs$core$IFn$_invoke$arity$1(run_info_50893) : vf.call(null, run_info_50893));
(af.cljs$core$IFn$_invoke$arity$2 ? af.cljs$core$IFn$_invoke$arity$2(G__50787_50894,G__50788_50895) : af.call(null, G__50787_50894,G__50788_50895));
} else {
}

if(cljs.core.truth_(error)){
if(cljs.core.truth_(raw_error_QMARK_)){
return (af.cljs$core$IFn$_invoke$arity$2 ? af.cljs$core$IFn$_invoke$arity$2("  error: ",error) : af.call(null, "  error: ",error));
} else {
var temp__5823__auto__ = format_error_fn;
if(cljs.core.truth_(temp__5823__auto__)){
var ff = temp__5823__auto__;
var G__50789 = err_start;
var G__50790 = (ff.cljs$core$IFn$_invoke$arity$1 ? ff.cljs$core$IFn$_invoke$arity$1(error) : ff.call(null, error));
var G__50791 = err_stop;
return (af.cljs$core$IFn$_invoke$arity$3 ? af.cljs$core$IFn$_invoke$arity$3(G__50789,G__50790,G__50791) : af.call(null, G__50789,G__50790,G__50791));
} else {
return null;
}
}
} else {
return null;
}
});
taoensso$telemere$utils$signal_content = function(signal,append_fn,val_fn){
switch(arguments.length){
case 1:
return taoensso$telemere$utils$signal_content__1.call(this,signal);
case 3:
return taoensso$telemere$utils$signal_content__3.call(this,signal,append_fn,val_fn);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$telemere$utils$signal_content.cljs$core$IFn$_invoke$arity$1 = taoensso$telemere$utils$signal_content__1;
taoensso$telemere$utils$signal_content.cljs$core$IFn$_invoke$arity$3 = taoensso$telemere$utils$signal_content__3;
return taoensso$telemere$utils$signal_content;
})()
}));

(taoensso.telemere.utils.signal_content_fn.cljs$lang$maxFixedArity = 1);

/**
 * Alpha, subject to change.
 *   Returns a (fn clean [signal]) that:
 *  - Takes a Telemere  signal (map).
 *  - Returns a minimal signal (map) ready for printing, etc.
 * 
 *   Signals are optimized for cheap creation and easy handling, so tend to be
 *   verbose and may contain things like nil values and duplicated content.
 * 
 *   This util efficiently cleans signals of such noise, helping reduce
 *   storage/transmission size, and making key info easier to see.
 * 
 *   Options:
 *  `:incl-nils?` - Include signal's keys with nil values? (default false)
 *  `:incl-kvs?` -- Include signal's app-level root kvs?   (default false)
 *  `:incl-keys` -- Subset of signal keys to retain from those otherwise
 *                  excluded by default: #{:schema :kvs :host :thread}
 */
taoensso.telemere.utils.clean_signal_fn = (function taoensso$telemere$utils$clean_signal_fn(var_args){
var G__50793 = arguments.length;
switch (G__50793) {
case 0:
return taoensso.telemere.utils.clean_signal_fn.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.telemere.utils.clean_signal_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(taoensso.telemere.utils.clean_signal_fn.cljs$core$IFn$_invoke$arity$0 = (function (){
return taoensso.telemere.utils.clean_signal_fn.cljs$core$IFn$_invoke$arity$1(null);
}));

(taoensso.telemere.utils.clean_signal_fn.cljs$core$IFn$_invoke$arity$1 = (function (p__50794){
var map__50795 = p__50794;
var map__50795__$1 = cljs.core.__destructure_map(map__50795);
var opts = map__50795__$1;
var incl_kvs_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50795__$1,new cljs.core.Keyword(null,"incl-kvs?","incl-kvs?",1936239040));
var incl_nils_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50795__$1,new cljs.core.Keyword(null,"incl-nils?","incl-nils?",-1704506526));
var incl_keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50795__$1,new cljs.core.Keyword(null,"incl-keys","incl-keys",625658308));
var assoc_BANG__STAR_ = ((cljs.core.not(incl_nils_QMARK_))?(function (m,k,v){
if((v == null)){
return m;
} else {
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
}):cljs.core.assoc_BANG_);
var incl_schema_QMARK_ = cljs.core.contains_QMARK_(incl_keys,new cljs.core.Keyword(null,"schema","schema",-1582001791));
var incl_kvs_key_QMARK_ = cljs.core.contains_QMARK_(incl_keys,new cljs.core.Keyword(null,"kvs","kvs",958455492));
var incl_host_QMARK_ = cljs.core.contains_QMARK_(incl_keys,new cljs.core.Keyword(null,"host","host",-1558485167));
var incl_thread_QMARK_ = cljs.core.contains_QMARK_(incl_keys,new cljs.core.Keyword(null,"thread","thread",947001524));
return (function taoensso$telemere$utils$clean_signal(signal){
if(cljs.core.map_QMARK_(signal)){
return cljs.core.persistent_BANG_(cljs.core.reduce_kv((function (m,k,v){
var G__50800 = k;
var G__50800__$1 = (((G__50800 instanceof cljs.core.Keyword))?G__50800.fqn:null);
switch (G__50800__$1) {
case "data":
case "run-nsecs":
case "ctx":
case "kind":
case "id":
case "root":
case "sample":
case "level":
case "ns":
case "uid":
case "run-val":
case "coords":
case "parent":
case "inst":
case "run-form":
case "end-inst":
return (assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3 ? assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3(m,k,v) : assoc_BANG__STAR_.call(null, m,k,v));

break;
case "error":
var temp__5821__auto__ = taoensso.truss.ex_chain.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"as-map","as-map",633645847),v);
if(cljs.core.truth_(temp__5821__auto__)){
var chain = temp__5821__auto__;
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m,k,chain);
} else {
return m;
}

break;
case "msg_":
var G__50801 = m;
var G__50802 = k;
var G__50803 = cljs.core.force(v);
return (assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3 ? assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3(G__50801,G__50802,G__50803) : assoc_BANG__STAR_.call(null, G__50801,G__50802,G__50803));

break;
case "_otel-context":
return m;

break;
case "schema":
if(incl_schema_QMARK_){
return (assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3 ? assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3(m,k,v) : assoc_BANG__STAR_.call(null, m,k,v));
} else {
return m;
}

break;
case "kvs":
if(incl_kvs_key_QMARK_){
return (assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3 ? assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3(m,k,v) : assoc_BANG__STAR_.call(null, m,k,v));
} else {
return m;
}

break;
case "thread":
if(incl_thread_QMARK_){
return (assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3 ? assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3(m,k,v) : assoc_BANG__STAR_.call(null, m,k,v));
} else {
return m;
}

break;
case "host":
if(incl_host_QMARK_){
return (assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3 ? assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3(m,k,v) : assoc_BANG__STAR_.call(null, m,k,v));
} else {
return m;
}

break;
default:
if(cljs.core.truth_(incl_kvs_QMARK_)){
return (assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3 ? assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3(m,k,v) : assoc_BANG__STAR_.call(null, m,k,v));
} else {
if(cljs.core.contains_QMARK_(incl_keys,k)){
return (assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3 ? assoc_BANG__STAR_.cljs$core$IFn$_invoke$arity$3(m,k,v) : assoc_BANG__STAR_.call(null, m,k,v));
} else {
return m;
}
}

}
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),signal));
} else {
return null;
}
});
}));

(taoensso.telemere.utils.clean_signal_fn.cljs$lang$maxFixedArity = 1);

/**
 * Alpha, subject to change.
 *   Returns a (fn pr [signal]) that:
 *  - Takes a Telemere signal (map).
 *  - Returns a machine-readable signal string.
 * 
 *   Options:
 *  `:pr-fn` --------- ∈ #{<unary-fn> :edn (default) :json (Cljs only)}
 *  `:clean-fn` ------ (fn [signal]) => clean signal map, see [1]
 *  `:incl-newline?` - Include terminating system newline? (default true)
 * 
 *   Examples:
 * 
 *  ;; To print as edn:
 *  (pr-signal-fn {:pr-fn :edn})
 * 
 *  ;; To print as JSON:
 *  ;; Ref.  <https://github.com/metosin/jsonista> (or any alt JSON lib)
 *  #?(:clj (require '[jsonista.core :as jsonista]))
 *  (pr-signal-fn
 *    {:pr-fn
 *      #?(:cljs :json ; Use js/JSON.stringify
 *         :clj  jsonista/write-value-as-string)})
 * 
 *   [1] `taoensso.telemere.utils/clean-signal-fn`, etc.
 * 
 *   See also `format-signal-fn` for an alternative to `pr-signal-fn`
 *   that produces human-readable output.
 */
taoensso.telemere.utils.pr_signal_fn = (function taoensso$telemere$utils$pr_signal_fn(var_args){
var G__50805 = arguments.length;
switch (G__50805) {
case 0:
return taoensso.telemere.utils.pr_signal_fn.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.telemere.utils.pr_signal_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(taoensso.telemere.utils.pr_signal_fn.cljs$core$IFn$_invoke$arity$0 = (function (){
return taoensso.telemere.utils.pr_signal_fn.cljs$core$IFn$_invoke$arity$1(null);
}));

(taoensso.telemere.utils.pr_signal_fn.cljs$core$IFn$_invoke$arity$1 = (function (p__50806){
var map__50807 = p__50806;
var map__50807__$1 = cljs.core.__destructure_map(map__50807);
var opts = map__50807__$1;
var pr_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__50807__$1,new cljs.core.Keyword(null,"pr-fn","pr-fn",2001500794),new cljs.core.Keyword(null,"edn","edn",1317840885));
var clean_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__50807__$1,new cljs.core.Keyword(null,"clean-fn","clean-fn",-1262646726),taoensso.telemere.utils.clean_signal_fn.cljs$core$IFn$_invoke$arity$0());
var incl_newline_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__50807__$1,new cljs.core.Keyword(null,"incl-newline?","incl-newline?",1384416974),true);
var nl = taoensso.telemere.utils.newline;
var pr_fn__$1 = (function (){var G__50808 = pr_fn;
var G__50808__$1 = (((G__50808 instanceof cljs.core.Keyword))?G__50808.fqn:null);
switch (G__50808__$1) {
case "edn":
return taoensso.telemere.utils.pr_edn;

break;
case "json":
return taoensso.telemere.utils.pr_json;

break;
default:
if(cljs.core.fn_QMARK_(pr_fn)){
return pr_fn;
} else {
return taoensso.truss.unexpected_arg_BANG__STAR_("taoensso.telemere.utils",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [762,16], null),pr_fn,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"param","param",2013631823),new cljs.core.Symbol(null,"pr-fn","pr-fn",-652934975,null),new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Symbol("taoensso.telemere.utils","pr-signal-fn","taoensso.telemere.utils/pr-signal-fn",-829484633,null),new cljs.core.Keyword(null,"expected","expected",1583670997),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Symbol(null,"unary-fn","unary-fn",1332940686,null),"null",new cljs.core.Keyword(null,"edn","edn",1317840885),"null",new cljs.core.Keyword(null,"json","json",1279968570),"null"], null), null)], null));
}

}
})();
return (function taoensso$telemere$utils$pr_signal(signal){
if(cljs.core.map_QMARK_(signal)){
if(cljs.core.truth_(incl_newline_QMARK_)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__50810 = (clean_fn.cljs$core$IFn$_invoke$arity$1 ? clean_fn.cljs$core$IFn$_invoke$arity$1(signal) : clean_fn.call(null, signal));
return (pr_fn__$1.cljs$core$IFn$_invoke$arity$1 ? pr_fn__$1.cljs$core$IFn$_invoke$arity$1(G__50810) : pr_fn__$1.call(null, G__50810));
})()),nl].join('');
} else {
var G__50811 = (clean_fn.cljs$core$IFn$_invoke$arity$1 ? clean_fn.cljs$core$IFn$_invoke$arity$1(signal) : clean_fn.call(null, signal));
return (pr_fn__$1.cljs$core$IFn$_invoke$arity$1 ? pr_fn__$1.cljs$core$IFn$_invoke$arity$1(G__50811) : pr_fn__$1.call(null, G__50811));
}
} else {
return null;
}
});
}));

(taoensso.telemere.utils.pr_signal_fn.cljs$lang$maxFixedArity = 1);

/**
 * Alpha, subject to change.
 *   Returns a (fn format [signal]) that:
 *  - Takes a Telemere signal (map).
 *  - Returns a human-readable signal string.
 * 
 *   Options:
 *  `:incl-newline?` - Include terminating system newline? (default true)
 *  `:preamble-fn` --- (fn [signal]) => signal preamble string, see [1]
 *  `:content-fn` ---- (fn [signal]) => signal content  string, see [2]
 * 
 *   [1] `taoensso.telemere.utils/signal-preamble-fn`, etc.
 *   [2] `taoensso.telemere.utils/signal-content-fn`,  etc.
 * 
 *   See also `pr-signal-fn` for an alternative to `format-signal-fn`
 *   that produces machine-readable output (edn, JSON, etc.).
 */
taoensso.telemere.utils.format_signal_fn = (function taoensso$telemere$utils$format_signal_fn(var_args){
var G__50813 = arguments.length;
switch (G__50813) {
case 0:
return taoensso.telemere.utils.format_signal_fn.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.telemere.utils.format_signal_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(taoensso.telemere.utils.format_signal_fn.cljs$core$IFn$_invoke$arity$0 = (function (){
return taoensso.telemere.utils.format_signal_fn.cljs$core$IFn$_invoke$arity$1(null);
}));

(taoensso.telemere.utils.format_signal_fn.cljs$core$IFn$_invoke$arity$1 = (function (p__50814){
var map__50815 = p__50814;
var map__50815__$1 = cljs.core.__destructure_map(map__50815);
var incl_newline_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__50815__$1,new cljs.core.Keyword(null,"incl-newline?","incl-newline?",1384416974),true);
var preamble_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__50815__$1,new cljs.core.Keyword(null,"preamble-fn","preamble-fn",-900320209),taoensso.telemere.utils.signal_preamble_fn.cljs$core$IFn$_invoke$arity$0());
var content_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__50815__$1,new cljs.core.Keyword(null,"content-fn","content-fn",-1280686114),taoensso.telemere.utils.signal_content_fn.cljs$core$IFn$_invoke$arity$0());
var nl = taoensso.telemere.utils.newline;
return (function taoensso$telemere$utils$format_signal(signal){
var preamble = (cljs.core.truth_(preamble_fn)?(preamble_fn.cljs$core$IFn$_invoke$arity$1 ? preamble_fn.cljs$core$IFn$_invoke$arity$1(signal) : preamble_fn.call(null, signal)):null);
var content = (cljs.core.truth_(content_fn)?(content_fn.cljs$core$IFn$_invoke$arity$1 ? content_fn.cljs$core$IFn$_invoke$arity$1(signal) : content_fn.call(null, signal)):null);
if(cljs.core.truth_((function (){var and__5000__auto__ = preamble;
if(cljs.core.truth_(and__5000__auto__)){
return content;
} else {
return and__5000__auto__;
}
})())){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(preamble),nl,cljs.core.str.cljs$core$IFn$_invoke$arity$1(content),(cljs.core.truth_(incl_newline_QMARK_)?nl:null)].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(preamble),cljs.core.str.cljs$core$IFn$_invoke$arity$1(content),(cljs.core.truth_(incl_newline_QMARK_)?nl:null)].join('');
}
});
}));

(taoensso.telemere.utils.format_signal_fn.cljs$lang$maxFixedArity = 1);


//# sourceMappingURL=taoensso.telemere.utils.js.map
