goog.provide('taoensso.telemere.consoles');
/**
 * Alpha, subject to change.
 *   If `js/console` exists, returns a signal handler that:
 *     - Takes a Telemere signal (map).
 *     - Writes the signal as a string to JavaScript console.
 * 
 *   A general-purpose `println`-style handler that's well suited for outputting
 *   signals as human or machine-readable (edn, JSON) strings.
 * 
 *   Options:
 *     `:output-fn` - (fn [signal]) => string, see `format-signal-fn` or `pr-signal-fn`
 */
taoensso.telemere.consoles.handler_COLON_console = (function taoensso$telemere$consoles$handler_COLON_console(var_args){
var G__60552 = arguments.length;
switch (G__60552) {
case 0:
return taoensso.telemere.consoles.handler_COLON_console.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.telemere.consoles.handler_COLON_console.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(taoensso.telemere.consoles.handler_COLON_console.cljs$core$IFn$_invoke$arity$0 = (function (){
return taoensso.telemere.consoles.handler_COLON_console.cljs$core$IFn$_invoke$arity$1(null);
}));

(taoensso.telemere.consoles.handler_COLON_console.cljs$core$IFn$_invoke$arity$1 = (function (p__60555){
var map__60557 = p__60555;
var map__60557__$1 = cljs.core.__destructure_map(map__60557);
var output_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__60557__$1,new cljs.core.Keyword(null,"output-fn","output-fn",1600951539),taoensso.telemere.utils.format_signal_fn.cljs$core$IFn$_invoke$arity$0());
if((typeof console !== 'undefined')){
var js_console_logger = taoensso.telemere.utils.js_console_logger;
return (function() {
var taoensso$telemere$consoles$a_handler_COLON_console = null;
var taoensso$telemere$consoles$a_handler_COLON_console__0 = (function (){
return null;
});
var taoensso$telemere$consoles$a_handler_COLON_console__1 = (function (signal){
var temp__5823__auto__ = (output_fn.cljs$core$IFn$_invoke$arity$1 ? output_fn.cljs$core$IFn$_invoke$arity$1(signal) : output_fn.call(null, signal));
if(cljs.core.truth_(temp__5823__auto__)){
var output = temp__5823__auto__;
var logger = (function (){var G__60560 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(signal,new cljs.core.Keyword(null,"level","level",1290497552));
return (js_console_logger.cljs$core$IFn$_invoke$arity$1 ? js_console_logger.cljs$core$IFn$_invoke$arity$1(G__60560) : js_console_logger.call(null, G__60560));
})();
return logger.call(logger,cljs.core.str.cljs$core$IFn$_invoke$arity$1(output));
} else {
return null;
}
});
taoensso$telemere$consoles$a_handler_COLON_console = function(signal){
switch(arguments.length){
case 0:
return taoensso$telemere$consoles$a_handler_COLON_console__0.call(this);
case 1:
return taoensso$telemere$consoles$a_handler_COLON_console__1.call(this,signal);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$telemere$consoles$a_handler_COLON_console.cljs$core$IFn$_invoke$arity$0 = taoensso$telemere$consoles$a_handler_COLON_console__0;
taoensso$telemere$consoles$a_handler_COLON_console.cljs$core$IFn$_invoke$arity$1 = taoensso$telemere$consoles$a_handler_COLON_console__1;
return taoensso$telemere$consoles$a_handler_COLON_console;
})()
} else {
return null;
}
}));

(taoensso.telemere.consoles.handler_COLON_console.cljs$lang$maxFixedArity = 1);

taoensso.telemere.consoles.logger_fn = (function taoensso$telemere$consoles$logger_fn(logger){
return (function() {
var G__60572 = null;
var G__60572__1 = (function (x1){
return logger.call(logger,x1);
});
var G__60572__2 = (function (x1,x2){
return logger.call(logger,x1,x2);
});
var G__60572__3 = (function (x1,x2,x3){
return logger.call(logger,x1,x2,x3);
});
var G__60572__4 = (function() { 
var G__60574__delegate = function (x1,x2,x3,more){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(logger,x1,x2,x3,more);
};
var G__60574 = function (x1,x2,x3,var_args){
var more = null;
if (arguments.length > 3) {
var G__60575__i = 0, G__60575__a = new Array(arguments.length -  3);
while (G__60575__i < G__60575__a.length) {G__60575__a[G__60575__i] = arguments[G__60575__i + 3]; ++G__60575__i;}
  more = new cljs.core.IndexedSeq(G__60575__a,0,null);
} 
return G__60574__delegate.call(this,x1,x2,x3,more);};
G__60574.cljs$lang$maxFixedArity = 3;
G__60574.cljs$lang$applyTo = (function (arglist__60577){
var x1 = cljs.core.first(arglist__60577);
arglist__60577 = cljs.core.next(arglist__60577);
var x2 = cljs.core.first(arglist__60577);
arglist__60577 = cljs.core.next(arglist__60577);
var x3 = cljs.core.first(arglist__60577);
var more = cljs.core.rest(arglist__60577);
return G__60574__delegate(x1,x2,x3,more);
});
G__60574.cljs$core$IFn$_invoke$arity$variadic = G__60574__delegate;
return G__60574;
})()
;
G__60572 = function(x1,x2,x3,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return G__60572__1.call(this,x1);
case 2:
return G__60572__2.call(this,x1,x2);
case 3:
return G__60572__3.call(this,x1,x2,x3);
default:
var G__60578 = null;
if (arguments.length > 3) {
var G__60579__i = 0, G__60579__a = new Array(arguments.length -  3);
while (G__60579__i < G__60579__a.length) {G__60579__a[G__60579__i] = arguments[G__60579__i + 3]; ++G__60579__i;}
G__60578 = new cljs.core.IndexedSeq(G__60579__a,0,null);
}
return G__60572__4.cljs$core$IFn$_invoke$arity$variadic(x1,x2,x3, G__60578);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__60572.cljs$lang$maxFixedArity = 3;
G__60572.cljs$lang$applyTo = G__60572__4.cljs$lang$applyTo;
G__60572.cljs$core$IFn$_invoke$arity$1 = G__60572__1;
G__60572.cljs$core$IFn$_invoke$arity$2 = G__60572__2;
G__60572.cljs$core$IFn$_invoke$arity$3 = G__60572__3;
G__60572.cljs$core$IFn$_invoke$arity$variadic = G__60572__4.cljs$core$IFn$_invoke$arity$variadic;
return G__60572;
})()
});
/**
 * Alpha, subject to change.
 *   If `js/console` exists, returns a signal handler that:
 *     - Takes a Telemere signal (map).
 *     - Writes the raw signal to JavaScript console.
 * 
 *   Intended for use with browser formatting tools like `binaryage/devtools`,
 *   Ref. <https://github.com/binaryage/cljs-devtools>.
 * 
 *   Options:
 *     `:preamble-fn` ----- (fn [signal])   => string, see [1].
 *     `:format-nsecs-fn` - (fn [nanosecs]) => string.
 * 
 *   [1] `taoensso.telemere.utils/signal-preamble-fn`, etc.
 */
taoensso.telemere.consoles.handler_COLON_console_raw = (function taoensso$telemere$consoles$handler_COLON_console_raw(var_args){
var G__60565 = arguments.length;
switch (G__60565) {
case 0:
return taoensso.telemere.consoles.handler_COLON_console_raw.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.telemere.consoles.handler_COLON_console_raw.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(taoensso.telemere.consoles.handler_COLON_console_raw.cljs$core$IFn$_invoke$arity$0 = (function (){
return taoensso.telemere.consoles.handler_COLON_console_raw.cljs$core$IFn$_invoke$arity$1(null);
}));

(taoensso.telemere.consoles.handler_COLON_console_raw.cljs$core$IFn$_invoke$arity$1 = (function (p__60567){
var map__60568 = p__60567;
var map__60568__$1 = cljs.core.__destructure_map(map__60568);
var opts = map__60568__$1;
var preamble_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__60568__$1,new cljs.core.Keyword(null,"preamble-fn","preamble-fn",-900320209),taoensso.telemere.utils.signal_preamble_fn.cljs$core$IFn$_invoke$arity$0());
var format_nsecs_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__60568__$1,new cljs.core.Keyword(null,"format-nsecs-fn","format-nsecs-fn",-1487810716),taoensso.telemere.utils.format_nsecs_fn.cljs$core$IFn$_invoke$arity$0());
if((((typeof console !== 'undefined')) && ((typeof console !== 'undefined') && (typeof console.group !== 'undefined')))){
var js_console_logger = taoensso.telemere.utils.js_console_logger;
var content_fn = taoensso.telemere.utils.signal_content_fn.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"format-nsecs-fn","format-nsecs-fn",-1487810716),format_nsecs_fn,new cljs.core.Keyword(null,"format-error-fn","format-error-fn",-560488578),null,new cljs.core.Keyword(null,"raw-error?","raw-error?",-39485940),true], null));
return (function() {
var taoensso$telemere$consoles$a_handler_COLON_console_raw = null;
var taoensso$telemere$consoles$a_handler_COLON_console_raw__0 = (function (){
return null;
});
var taoensso$telemere$consoles$a_handler_COLON_console_raw__1 = (function (signal){
var map__60569 = signal;
var map__60569__$1 = cljs.core.__destructure_map(map__60569);
var level = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60569__$1,new cljs.core.Keyword(null,"level","level",1290497552));
var error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60569__$1,new cljs.core.Keyword(null,"error","error",-978969032));
var logger = (js_console_logger.cljs$core$IFn$_invoke$arity$1 ? js_console_logger.cljs$core$IFn$_invoke$arity$1(level) : js_console_logger.call(null, level));
console.group((preamble_fn.cljs$core$IFn$_invoke$arity$1 ? preamble_fn.cljs$core$IFn$_invoke$arity$1(signal) : preamble_fn.call(null, signal)));

content_fn(signal,taoensso.telemere.consoles.logger_fn(logger),cljs.core.identity);

var temp__5823__auto___60584 = (function (){var and__5000__auto__ = error;
if(cljs.core.truth_(and__5000__auto__)){
return taoensso.truss.ex_root(error).stack;
} else {
return and__5000__auto__;
}
})();
if(cljs.core.truth_(temp__5823__auto___60584)){
var stack_60585 = temp__5823__auto___60584;
logger.call(logger,stack_60585);
} else {
}

return console.groupEnd();
});
taoensso$telemere$consoles$a_handler_COLON_console_raw = function(signal){
switch(arguments.length){
case 0:
return taoensso$telemere$consoles$a_handler_COLON_console_raw__0.call(this);
case 1:
return taoensso$telemere$consoles$a_handler_COLON_console_raw__1.call(this,signal);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$telemere$consoles$a_handler_COLON_console_raw.cljs$core$IFn$_invoke$arity$0 = taoensso$telemere$consoles$a_handler_COLON_console_raw__0;
taoensso$telemere$consoles$a_handler_COLON_console_raw.cljs$core$IFn$_invoke$arity$1 = taoensso$telemere$consoles$a_handler_COLON_console_raw__1;
return taoensso$telemere$consoles$a_handler_COLON_console_raw;
})()
} else {
return null;
}
}));

(taoensso.telemere.consoles.handler_COLON_console_raw.cljs$lang$maxFixedArity = 1);


//# sourceMappingURL=taoensso.telemere.consoles.js.map
