goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_42132 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (shadow.dom._to_dom[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null, this$));
} else {
var m__5349__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null, this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_42132(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_42134 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (shadow.dom._to_svg[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null, this$));
} else {
var m__5349__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null, this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_42134(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__40830 = coll;
var G__40831 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__40830,G__40831) : shadow.dom.lazy_native_coll_seq.call(null, G__40830,G__40831));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__5002__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null, );
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__40973 = arguments.length;
switch (G__40973) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__41016 = arguments.length;
switch (G__41016) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__41067 = arguments.length;
switch (G__41067) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__41109 = arguments.length;
switch (G__41109) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__41151 = arguments.length;
switch (G__41151) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__41195 = arguments.length;
switch (G__41195) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__5002__auto__ = (!((typeof document !== 'undefined')));
if(or__5002__auto__){
return or__5002__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null, e,el));
}));
}catch (e41221){if((e41221 instanceof Object)){
var e = e41221;
return console.log("didnt support attachEvent",el,e);
} else {
throw e41221;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__5002__auto__ = (!((typeof document !== 'undefined')));
if(or__5002__auto__){
return or__5002__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__41235 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__41236 = null;
var count__41237 = (0);
var i__41238 = (0);
while(true){
if((i__41238 < count__41237)){
var el = chunk__41236.cljs$core$IIndexed$_nth$arity$2(null, i__41238);
var handler_42162__$1 = ((function (seq__41235,chunk__41236,count__41237,i__41238,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null, e,el));
});})(seq__41235,chunk__41236,count__41237,i__41238,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_42162__$1);


var G__42165 = seq__41235;
var G__42166 = chunk__41236;
var G__42167 = count__41237;
var G__42168 = (i__41238 + (1));
seq__41235 = G__42165;
chunk__41236 = G__42166;
count__41237 = G__42167;
i__41238 = G__42168;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__41235);
if(temp__5823__auto__){
var seq__41235__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__41235__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__41235__$1);
var G__42170 = cljs.core.chunk_rest(seq__41235__$1);
var G__42171 = c__5525__auto__;
var G__42172 = cljs.core.count(c__5525__auto__);
var G__42173 = (0);
seq__41235 = G__42170;
chunk__41236 = G__42171;
count__41237 = G__42172;
i__41238 = G__42173;
continue;
} else {
var el = cljs.core.first(seq__41235__$1);
var handler_42175__$1 = ((function (seq__41235,chunk__41236,count__41237,i__41238,el,seq__41235__$1,temp__5823__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null, e,el));
});})(seq__41235,chunk__41236,count__41237,i__41238,el,seq__41235__$1,temp__5823__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_42175__$1);


var G__42177 = cljs.core.next(seq__41235__$1);
var G__42178 = null;
var G__42179 = (0);
var G__42180 = (0);
seq__41235 = G__42177;
chunk__41236 = G__42178;
count__41237 = G__42179;
i__41238 = G__42180;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__41262 = arguments.length;
switch (G__41262) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null, e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__41275 = cljs.core.seq(events);
var chunk__41276 = null;
var count__41277 = (0);
var i__41278 = (0);
while(true){
if((i__41278 < count__41277)){
var vec__41302 = chunk__41276.cljs$core$IIndexed$_nth$arity$2(null, i__41278);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41302,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41302,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__42185 = seq__41275;
var G__42186 = chunk__41276;
var G__42187 = count__41277;
var G__42188 = (i__41278 + (1));
seq__41275 = G__42185;
chunk__41276 = G__42186;
count__41277 = G__42187;
i__41278 = G__42188;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__41275);
if(temp__5823__auto__){
var seq__41275__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__41275__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__41275__$1);
var G__42189 = cljs.core.chunk_rest(seq__41275__$1);
var G__42190 = c__5525__auto__;
var G__42191 = cljs.core.count(c__5525__auto__);
var G__42192 = (0);
seq__41275 = G__42189;
chunk__41276 = G__42190;
count__41277 = G__42191;
i__41278 = G__42192;
continue;
} else {
var vec__41308 = cljs.core.first(seq__41275__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41308,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41308,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__42193 = cljs.core.next(seq__41275__$1);
var G__42194 = null;
var G__42195 = (0);
var G__42196 = (0);
seq__41275 = G__42193;
chunk__41276 = G__42194;
count__41277 = G__42195;
i__41278 = G__42196;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__41313 = cljs.core.seq(styles);
var chunk__41314 = null;
var count__41315 = (0);
var i__41316 = (0);
while(true){
if((i__41316 < count__41315)){
var vec__41330 = chunk__41314.cljs$core$IIndexed$_nth$arity$2(null, i__41316);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41330,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41330,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__42198 = seq__41313;
var G__42199 = chunk__41314;
var G__42200 = count__41315;
var G__42201 = (i__41316 + (1));
seq__41313 = G__42198;
chunk__41314 = G__42199;
count__41315 = G__42200;
i__41316 = G__42201;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__41313);
if(temp__5823__auto__){
var seq__41313__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__41313__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__41313__$1);
var G__42202 = cljs.core.chunk_rest(seq__41313__$1);
var G__42203 = c__5525__auto__;
var G__42204 = cljs.core.count(c__5525__auto__);
var G__42205 = (0);
seq__41313 = G__42202;
chunk__41314 = G__42203;
count__41315 = G__42204;
i__41316 = G__42205;
continue;
} else {
var vec__41346 = cljs.core.first(seq__41313__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41346,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41346,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__42206 = cljs.core.next(seq__41313__$1);
var G__42207 = null;
var G__42208 = (0);
var G__42209 = (0);
seq__41313 = G__42206;
chunk__41314 = G__42207;
count__41315 = G__42208;
i__41316 = G__42209;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__41366_42210 = key;
var G__41366_42211__$1 = (((G__41366_42210 instanceof cljs.core.Keyword))?G__41366_42210.fqn:null);
switch (G__41366_42211__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_42214 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__5002__auto__ = goog.string.startsWith(ks_42214,"data-");
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return goog.string.startsWith(ks_42214,"aria-");
}
})())){
el.setAttribute(ks_42214,value);
} else {
(el[ks_42214] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__41433){
var map__41434 = p__41433;
var map__41434__$1 = cljs.core.__destructure_map(map__41434);
var props = map__41434__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41434__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__41436 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41436,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41436,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41436,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__41442 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__41442,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__41442;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__41453 = arguments.length;
switch (G__41453) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5823__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5823__auto__)){
var n = temp__5823__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5823__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5823__auto__)){
var n = temp__5823__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__41454){
var vec__41455 = p__41454;
var seq__41456 = cljs.core.seq(vec__41455);
var first__41457 = cljs.core.first(seq__41456);
var seq__41456__$1 = cljs.core.next(seq__41456);
var nn = first__41457;
var first__41457__$1 = cljs.core.first(seq__41456__$1);
var seq__41456__$2 = cljs.core.next(seq__41456__$1);
var np = first__41457__$1;
var nc = seq__41456__$2;
var node = vec__41455;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__41459 = nn;
var G__41460 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__41459,G__41460) : create_fn.call(null, G__41459,G__41460));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null, nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__41462 = nn;
var G__41463 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__41462,G__41463) : create_fn.call(null, G__41462,G__41463));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__41464 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41464,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41464,(1),null);
var seq__41468_42224 = cljs.core.seq(node_children);
var chunk__41469_42225 = null;
var count__41470_42226 = (0);
var i__41471_42227 = (0);
while(true){
if((i__41471_42227 < count__41470_42226)){
var child_struct_42228 = chunk__41469_42225.cljs$core$IIndexed$_nth$arity$2(null, i__41471_42227);
var children_42229 = shadow.dom.dom_node(child_struct_42228);
if(cljs.core.seq_QMARK_(children_42229)){
var seq__41506_42230 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_42229));
var chunk__41508_42231 = null;
var count__41509_42232 = (0);
var i__41510_42233 = (0);
while(true){
if((i__41510_42233 < count__41509_42232)){
var child_42234 = chunk__41508_42231.cljs$core$IIndexed$_nth$arity$2(null, i__41510_42233);
if(cljs.core.truth_(child_42234)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_42234);


var G__42235 = seq__41506_42230;
var G__42236 = chunk__41508_42231;
var G__42237 = count__41509_42232;
var G__42238 = (i__41510_42233 + (1));
seq__41506_42230 = G__42235;
chunk__41508_42231 = G__42236;
count__41509_42232 = G__42237;
i__41510_42233 = G__42238;
continue;
} else {
var G__42240 = seq__41506_42230;
var G__42241 = chunk__41508_42231;
var G__42242 = count__41509_42232;
var G__42243 = (i__41510_42233 + (1));
seq__41506_42230 = G__42240;
chunk__41508_42231 = G__42241;
count__41509_42232 = G__42242;
i__41510_42233 = G__42243;
continue;
}
} else {
var temp__5823__auto___42244 = cljs.core.seq(seq__41506_42230);
if(temp__5823__auto___42244){
var seq__41506_42245__$1 = temp__5823__auto___42244;
if(cljs.core.chunked_seq_QMARK_(seq__41506_42245__$1)){
var c__5525__auto___42246 = cljs.core.chunk_first(seq__41506_42245__$1);
var G__42247 = cljs.core.chunk_rest(seq__41506_42245__$1);
var G__42248 = c__5525__auto___42246;
var G__42249 = cljs.core.count(c__5525__auto___42246);
var G__42250 = (0);
seq__41506_42230 = G__42247;
chunk__41508_42231 = G__42248;
count__41509_42232 = G__42249;
i__41510_42233 = G__42250;
continue;
} else {
var child_42251 = cljs.core.first(seq__41506_42245__$1);
if(cljs.core.truth_(child_42251)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_42251);


var G__42252 = cljs.core.next(seq__41506_42245__$1);
var G__42253 = null;
var G__42254 = (0);
var G__42255 = (0);
seq__41506_42230 = G__42252;
chunk__41508_42231 = G__42253;
count__41509_42232 = G__42254;
i__41510_42233 = G__42255;
continue;
} else {
var G__42256 = cljs.core.next(seq__41506_42245__$1);
var G__42257 = null;
var G__42258 = (0);
var G__42259 = (0);
seq__41506_42230 = G__42256;
chunk__41508_42231 = G__42257;
count__41509_42232 = G__42258;
i__41510_42233 = G__42259;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_42229);
}


var G__42260 = seq__41468_42224;
var G__42261 = chunk__41469_42225;
var G__42262 = count__41470_42226;
var G__42263 = (i__41471_42227 + (1));
seq__41468_42224 = G__42260;
chunk__41469_42225 = G__42261;
count__41470_42226 = G__42262;
i__41471_42227 = G__42263;
continue;
} else {
var temp__5823__auto___42264 = cljs.core.seq(seq__41468_42224);
if(temp__5823__auto___42264){
var seq__41468_42265__$1 = temp__5823__auto___42264;
if(cljs.core.chunked_seq_QMARK_(seq__41468_42265__$1)){
var c__5525__auto___42266 = cljs.core.chunk_first(seq__41468_42265__$1);
var G__42267 = cljs.core.chunk_rest(seq__41468_42265__$1);
var G__42268 = c__5525__auto___42266;
var G__42269 = cljs.core.count(c__5525__auto___42266);
var G__42270 = (0);
seq__41468_42224 = G__42267;
chunk__41469_42225 = G__42268;
count__41470_42226 = G__42269;
i__41471_42227 = G__42270;
continue;
} else {
var child_struct_42271 = cljs.core.first(seq__41468_42265__$1);
var children_42272 = shadow.dom.dom_node(child_struct_42271);
if(cljs.core.seq_QMARK_(children_42272)){
var seq__41520_42273 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_42272));
var chunk__41522_42274 = null;
var count__41523_42275 = (0);
var i__41524_42276 = (0);
while(true){
if((i__41524_42276 < count__41523_42275)){
var child_42279 = chunk__41522_42274.cljs$core$IIndexed$_nth$arity$2(null, i__41524_42276);
if(cljs.core.truth_(child_42279)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_42279);


var G__42281 = seq__41520_42273;
var G__42282 = chunk__41522_42274;
var G__42283 = count__41523_42275;
var G__42284 = (i__41524_42276 + (1));
seq__41520_42273 = G__42281;
chunk__41522_42274 = G__42282;
count__41523_42275 = G__42283;
i__41524_42276 = G__42284;
continue;
} else {
var G__42286 = seq__41520_42273;
var G__42287 = chunk__41522_42274;
var G__42288 = count__41523_42275;
var G__42289 = (i__41524_42276 + (1));
seq__41520_42273 = G__42286;
chunk__41522_42274 = G__42287;
count__41523_42275 = G__42288;
i__41524_42276 = G__42289;
continue;
}
} else {
var temp__5823__auto___42290__$1 = cljs.core.seq(seq__41520_42273);
if(temp__5823__auto___42290__$1){
var seq__41520_42291__$1 = temp__5823__auto___42290__$1;
if(cljs.core.chunked_seq_QMARK_(seq__41520_42291__$1)){
var c__5525__auto___42292 = cljs.core.chunk_first(seq__41520_42291__$1);
var G__42293 = cljs.core.chunk_rest(seq__41520_42291__$1);
var G__42294 = c__5525__auto___42292;
var G__42295 = cljs.core.count(c__5525__auto___42292);
var G__42296 = (0);
seq__41520_42273 = G__42293;
chunk__41522_42274 = G__42294;
count__41523_42275 = G__42295;
i__41524_42276 = G__42296;
continue;
} else {
var child_42297 = cljs.core.first(seq__41520_42291__$1);
if(cljs.core.truth_(child_42297)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_42297);


var G__42298 = cljs.core.next(seq__41520_42291__$1);
var G__42299 = null;
var G__42300 = (0);
var G__42301 = (0);
seq__41520_42273 = G__42298;
chunk__41522_42274 = G__42299;
count__41523_42275 = G__42300;
i__41524_42276 = G__42301;
continue;
} else {
var G__42302 = cljs.core.next(seq__41520_42291__$1);
var G__42303 = null;
var G__42304 = (0);
var G__42305 = (0);
seq__41520_42273 = G__42302;
chunk__41522_42274 = G__42303;
count__41523_42275 = G__42304;
i__41524_42276 = G__42305;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_42272);
}


var G__42306 = cljs.core.next(seq__41468_42265__$1);
var G__42307 = null;
var G__42308 = (0);
var G__42309 = (0);
seq__41468_42224 = G__42306;
chunk__41469_42225 = G__42307;
count__41470_42226 = G__42308;
i__41471_42227 = G__42309;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__41563 = cljs.core.seq(node);
var chunk__41564 = null;
var count__41565 = (0);
var i__41566 = (0);
while(true){
if((i__41566 < count__41565)){
var n = chunk__41564.cljs$core$IIndexed$_nth$arity$2(null, i__41566);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null, n));


var G__42313 = seq__41563;
var G__42314 = chunk__41564;
var G__42315 = count__41565;
var G__42316 = (i__41566 + (1));
seq__41563 = G__42313;
chunk__41564 = G__42314;
count__41565 = G__42315;
i__41566 = G__42316;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__41563);
if(temp__5823__auto__){
var seq__41563__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__41563__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__41563__$1);
var G__42318 = cljs.core.chunk_rest(seq__41563__$1);
var G__42319 = c__5525__auto__;
var G__42320 = cljs.core.count(c__5525__auto__);
var G__42321 = (0);
seq__41563 = G__42318;
chunk__41564 = G__42319;
count__41565 = G__42320;
i__41566 = G__42321;
continue;
} else {
var n = cljs.core.first(seq__41563__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null, n));


var G__42322 = cljs.core.next(seq__41563__$1);
var G__42323 = null;
var G__42324 = (0);
var G__42325 = (0);
seq__41563 = G__42322;
chunk__41564 = G__42323;
count__41565 = G__42324;
i__41566 = G__42325;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__41616 = arguments.length;
switch (G__41616) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__41648 = arguments.length;
switch (G__41648) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__41673 = arguments.length;
switch (G__41673) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__5002__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__5732__auto__ = [];
var len__5726__auto___42330 = arguments.length;
var i__5727__auto___42331 = (0);
while(true){
if((i__5727__auto___42331 < len__5726__auto___42330)){
args__5732__auto__.push((arguments[i__5727__auto___42331]));

var G__42332 = (i__5727__auto___42331 + (1));
i__5727__auto___42331 = G__42332;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((0) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__5733__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__41701_42334 = cljs.core.seq(nodes);
var chunk__41702_42335 = null;
var count__41703_42336 = (0);
var i__41704_42337 = (0);
while(true){
if((i__41704_42337 < count__41703_42336)){
var node_42338 = chunk__41702_42335.cljs$core$IIndexed$_nth$arity$2(null, i__41704_42337);
fragment.appendChild(shadow.dom._to_dom(node_42338));


var G__42339 = seq__41701_42334;
var G__42340 = chunk__41702_42335;
var G__42341 = count__41703_42336;
var G__42342 = (i__41704_42337 + (1));
seq__41701_42334 = G__42339;
chunk__41702_42335 = G__42340;
count__41703_42336 = G__42341;
i__41704_42337 = G__42342;
continue;
} else {
var temp__5823__auto___42343 = cljs.core.seq(seq__41701_42334);
if(temp__5823__auto___42343){
var seq__41701_42344__$1 = temp__5823__auto___42343;
if(cljs.core.chunked_seq_QMARK_(seq__41701_42344__$1)){
var c__5525__auto___42345 = cljs.core.chunk_first(seq__41701_42344__$1);
var G__42346 = cljs.core.chunk_rest(seq__41701_42344__$1);
var G__42347 = c__5525__auto___42345;
var G__42348 = cljs.core.count(c__5525__auto___42345);
var G__42349 = (0);
seq__41701_42334 = G__42346;
chunk__41702_42335 = G__42347;
count__41703_42336 = G__42348;
i__41704_42337 = G__42349;
continue;
} else {
var node_42350 = cljs.core.first(seq__41701_42344__$1);
fragment.appendChild(shadow.dom._to_dom(node_42350));


var G__42351 = cljs.core.next(seq__41701_42344__$1);
var G__42352 = null;
var G__42353 = (0);
var G__42354 = (0);
seq__41701_42334 = G__42351;
chunk__41702_42335 = G__42352;
count__41703_42336 = G__42353;
i__41704_42337 = G__42354;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq41692){
var self__5712__auto__ = this;
return self__5712__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41692));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__41711_42356 = cljs.core.seq(scripts);
var chunk__41712_42357 = null;
var count__41713_42358 = (0);
var i__41714_42359 = (0);
while(true){
if((i__41714_42359 < count__41713_42358)){
var vec__41723_42360 = chunk__41712_42357.cljs$core$IIndexed$_nth$arity$2(null, i__41714_42359);
var script_tag_42361 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41723_42360,(0),null);
var script_body_42362 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41723_42360,(1),null);
eval(script_body_42362);


var G__42363 = seq__41711_42356;
var G__42364 = chunk__41712_42357;
var G__42365 = count__41713_42358;
var G__42366 = (i__41714_42359 + (1));
seq__41711_42356 = G__42363;
chunk__41712_42357 = G__42364;
count__41713_42358 = G__42365;
i__41714_42359 = G__42366;
continue;
} else {
var temp__5823__auto___42367 = cljs.core.seq(seq__41711_42356);
if(temp__5823__auto___42367){
var seq__41711_42368__$1 = temp__5823__auto___42367;
if(cljs.core.chunked_seq_QMARK_(seq__41711_42368__$1)){
var c__5525__auto___42369 = cljs.core.chunk_first(seq__41711_42368__$1);
var G__42370 = cljs.core.chunk_rest(seq__41711_42368__$1);
var G__42371 = c__5525__auto___42369;
var G__42372 = cljs.core.count(c__5525__auto___42369);
var G__42373 = (0);
seq__41711_42356 = G__42370;
chunk__41712_42357 = G__42371;
count__41713_42358 = G__42372;
i__41714_42359 = G__42373;
continue;
} else {
var vec__41727_42374 = cljs.core.first(seq__41711_42368__$1);
var script_tag_42375 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41727_42374,(0),null);
var script_body_42376 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41727_42374,(1),null);
eval(script_body_42376);


var G__42377 = cljs.core.next(seq__41711_42368__$1);
var G__42378 = null;
var G__42379 = (0);
var G__42380 = (0);
seq__41711_42356 = G__42377;
chunk__41712_42357 = G__42378;
count__41713_42358 = G__42379;
i__41714_42359 = G__42380;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__41731){
var vec__41732 = p__41731;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41732,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41732,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__41748 = arguments.length;
switch (G__41748) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__41765 = cljs.core.seq(style_keys);
var chunk__41766 = null;
var count__41767 = (0);
var i__41768 = (0);
while(true){
if((i__41768 < count__41767)){
var it = chunk__41766.cljs$core$IIndexed$_nth$arity$2(null, i__41768);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__42386 = seq__41765;
var G__42387 = chunk__41766;
var G__42388 = count__41767;
var G__42389 = (i__41768 + (1));
seq__41765 = G__42386;
chunk__41766 = G__42387;
count__41767 = G__42388;
i__41768 = G__42389;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__41765);
if(temp__5823__auto__){
var seq__41765__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__41765__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__41765__$1);
var G__42392 = cljs.core.chunk_rest(seq__41765__$1);
var G__42393 = c__5525__auto__;
var G__42394 = cljs.core.count(c__5525__auto__);
var G__42395 = (0);
seq__41765 = G__42392;
chunk__41766 = G__42393;
count__41767 = G__42394;
i__41768 = G__42395;
continue;
} else {
var it = cljs.core.first(seq__41765__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__42396 = cljs.core.next(seq__41765__$1);
var G__42397 = null;
var G__42398 = (0);
var G__42399 = (0);
seq__41765 = G__42396;
chunk__41766 = G__42397;
count__41767 = G__42398;
i__41768 = G__42399;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5300__auto__,k__5301__auto__){
var self__ = this;
var this__5300__auto____$1 = this;
return this__5300__auto____$1.cljs$core$ILookup$_lookup$arity$3(null, k__5301__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5302__auto__,k41773,else__5303__auto__){
var self__ = this;
var this__5302__auto____$1 = this;
var G__41780 = k41773;
var G__41780__$1 = (((G__41780 instanceof cljs.core.Keyword))?G__41780.fqn:null);
switch (G__41780__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k41773,else__5303__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5320__auto__,f__5321__auto__,init__5322__auto__){
var self__ = this;
var this__5320__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5323__auto__,p__41781){
var vec__41782 = p__41781;
var k__5324__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41782,(0),null);
var v__5325__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41782,(1),null);
return (f__5321__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5321__auto__.cljs$core$IFn$_invoke$arity$3(ret__5323__auto__,k__5324__auto__,v__5325__auto__) : f__5321__auto__.call(null, ret__5323__auto__,k__5324__auto__,v__5325__auto__));
}),init__5322__auto__,this__5320__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5315__auto__,writer__5316__auto__,opts__5317__auto__){
var self__ = this;
var this__5315__auto____$1 = this;
var pr_pair__5318__auto__ = (function (keyval__5319__auto__){
return cljs.core.pr_sequential_writer(writer__5316__auto__,cljs.core.pr_writer,""," ","",opts__5317__auto__,keyval__5319__auto__);
});
return cljs.core.pr_sequential_writer(writer__5316__auto__,pr_pair__5318__auto__,"#shadow.dom.Coordinate{",", ","}",opts__5317__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__41772){
var self__ = this;
var G__41772__$1 = this;
return (new cljs.core.RecordIter((0),G__41772__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5298__auto__){
var self__ = this;
var this__5298__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5295__auto__){
var self__ = this;
var this__5295__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5304__auto__){
var self__ = this;
var this__5304__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5296__auto__){
var self__ = this;
var this__5296__auto____$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = (function (coll__5297__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__5297__auto__));
})(this__5296__auto____$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this41774,other41775){
var self__ = this;
var this41774__$1 = this;
return (((!((other41775 == null)))) && ((((this41774__$1.constructor === other41775.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41774__$1.x,other41775.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41774__$1.y,other41775.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41774__$1.__extmap,other41775.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5310__auto__,k__5311__auto__){
var self__ = this;
var this__5310__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__5311__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5310__auto____$1),self__.__meta),k__5311__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5311__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5307__auto__,k41773){
var self__ = this;
var this__5307__auto____$1 = this;
var G__41793 = k41773;
var G__41793__$1 = (((G__41793 instanceof cljs.core.Keyword))?G__41793.fqn:null);
switch (G__41793__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k41773);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5308__auto__,k__5309__auto__,G__41772){
var self__ = this;
var this__5308__auto____$1 = this;
var pred__41794 = cljs.core.keyword_identical_QMARK_;
var expr__41795 = k__5309__auto__;
if(cljs.core.truth_((pred__41794.cljs$core$IFn$_invoke$arity$2 ? pred__41794.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__41795) : pred__41794.call(null, new cljs.core.Keyword(null,"x","x",2099068185),expr__41795)))){
return (new shadow.dom.Coordinate(G__41772,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__41794.cljs$core$IFn$_invoke$arity$2 ? pred__41794.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__41795) : pred__41794.call(null, new cljs.core.Keyword(null,"y","y",-1757859776),expr__41795)))){
return (new shadow.dom.Coordinate(self__.x,G__41772,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5309__auto__,G__41772),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5313__auto__){
var self__ = this;
var this__5313__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5299__auto__,G__41772){
var self__ = this;
var this__5299__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__41772,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5305__auto__,entry__5306__auto__){
var self__ = this;
var this__5305__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5306__auto__)){
return this__5305__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null, cljs.core._nth(entry__5306__auto__,(0)),cljs.core._nth(entry__5306__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5305__auto____$1,entry__5306__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__5346__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__5346__auto__,writer__5347__auto__){
return cljs.core._write(writer__5347__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__41777){
var extmap__5342__auto__ = (function (){var G__41806 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__41777,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__41777)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__41806);
} else {
return G__41806;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__41777),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__41777),null,cljs.core.not_empty(extmap__5342__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5300__auto__,k__5301__auto__){
var self__ = this;
var this__5300__auto____$1 = this;
return this__5300__auto____$1.cljs$core$ILookup$_lookup$arity$3(null, k__5301__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5302__auto__,k41813,else__5303__auto__){
var self__ = this;
var this__5302__auto____$1 = this;
var G__41825 = k41813;
var G__41825__$1 = (((G__41825 instanceof cljs.core.Keyword))?G__41825.fqn:null);
switch (G__41825__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k41813,else__5303__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5320__auto__,f__5321__auto__,init__5322__auto__){
var self__ = this;
var this__5320__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5323__auto__,p__41827){
var vec__41828 = p__41827;
var k__5324__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41828,(0),null);
var v__5325__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41828,(1),null);
return (f__5321__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5321__auto__.cljs$core$IFn$_invoke$arity$3(ret__5323__auto__,k__5324__auto__,v__5325__auto__) : f__5321__auto__.call(null, ret__5323__auto__,k__5324__auto__,v__5325__auto__));
}),init__5322__auto__,this__5320__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5315__auto__,writer__5316__auto__,opts__5317__auto__){
var self__ = this;
var this__5315__auto____$1 = this;
var pr_pair__5318__auto__ = (function (keyval__5319__auto__){
return cljs.core.pr_sequential_writer(writer__5316__auto__,cljs.core.pr_writer,""," ","",opts__5317__auto__,keyval__5319__auto__);
});
return cljs.core.pr_sequential_writer(writer__5316__auto__,pr_pair__5318__auto__,"#shadow.dom.Size{",", ","}",opts__5317__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__41812){
var self__ = this;
var G__41812__$1 = this;
return (new cljs.core.RecordIter((0),G__41812__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5298__auto__){
var self__ = this;
var this__5298__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5295__auto__){
var self__ = this;
var this__5295__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5304__auto__){
var self__ = this;
var this__5304__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5296__auto__){
var self__ = this;
var this__5296__auto____$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = (function (coll__5297__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__5297__auto__));
})(this__5296__auto____$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this41814,other41815){
var self__ = this;
var this41814__$1 = this;
return (((!((other41815 == null)))) && ((((this41814__$1.constructor === other41815.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41814__$1.w,other41815.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41814__$1.h,other41815.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41814__$1.__extmap,other41815.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5310__auto__,k__5311__auto__){
var self__ = this;
var this__5310__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__5311__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5310__auto____$1),self__.__meta),k__5311__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5311__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5307__auto__,k41813){
var self__ = this;
var this__5307__auto____$1 = this;
var G__41846 = k41813;
var G__41846__$1 = (((G__41846 instanceof cljs.core.Keyword))?G__41846.fqn:null);
switch (G__41846__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k41813);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5308__auto__,k__5309__auto__,G__41812){
var self__ = this;
var this__5308__auto____$1 = this;
var pred__41849 = cljs.core.keyword_identical_QMARK_;
var expr__41850 = k__5309__auto__;
if(cljs.core.truth_((pred__41849.cljs$core$IFn$_invoke$arity$2 ? pred__41849.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__41850) : pred__41849.call(null, new cljs.core.Keyword(null,"w","w",354169001),expr__41850)))){
return (new shadow.dom.Size(G__41812,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__41849.cljs$core$IFn$_invoke$arity$2 ? pred__41849.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__41850) : pred__41849.call(null, new cljs.core.Keyword(null,"h","h",1109658740),expr__41850)))){
return (new shadow.dom.Size(self__.w,G__41812,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5309__auto__,G__41812),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5313__auto__){
var self__ = this;
var this__5313__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5299__auto__,G__41812){
var self__ = this;
var this__5299__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__41812,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5305__auto__,entry__5306__auto__){
var self__ = this;
var this__5305__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5306__auto__)){
return this__5305__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null, cljs.core._nth(entry__5306__auto__,(0)),cljs.core._nth(entry__5306__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5305__auto____$1,entry__5306__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__5346__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__5346__auto__,writer__5347__auto__){
return cljs.core._write(writer__5347__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__41816){
var extmap__5342__auto__ = (function (){var G__41865 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__41816,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__41816)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__41865);
} else {
return G__41865;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__41816),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__41816),null,cljs.core.not_empty(extmap__5342__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__5590__auto__ = opts;
var l__5591__auto__ = a__5590__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__5591__auto__)){
var G__42420 = (i + (1));
var G__42421 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__42420;
ret = G__42421;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__41891){
var vec__41892 = p__41891;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41892,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41892,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__41902 = arguments.length;
switch (G__41902) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5821__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5821__auto__)){
var child = temp__5821__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__42423 = ps;
var G__42424 = (i + (1));
el__$1 = G__42423;
i = G__42424;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null, parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__41932 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41932,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41932,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41932,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__41935_42428 = cljs.core.seq(props);
var chunk__41936_42429 = null;
var count__41937_42430 = (0);
var i__41938_42431 = (0);
while(true){
if((i__41938_42431 < count__41937_42430)){
var vec__41948_42432 = chunk__41936_42429.cljs$core$IIndexed$_nth$arity$2(null, i__41938_42431);
var k_42433 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41948_42432,(0),null);
var v_42434 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41948_42432,(1),null);
el.setAttributeNS((function (){var temp__5823__auto__ = cljs.core.namespace(k_42433);
if(cljs.core.truth_(temp__5823__auto__)){
var ns = temp__5823__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_42433),v_42434);


var G__42436 = seq__41935_42428;
var G__42437 = chunk__41936_42429;
var G__42438 = count__41937_42430;
var G__42439 = (i__41938_42431 + (1));
seq__41935_42428 = G__42436;
chunk__41936_42429 = G__42437;
count__41937_42430 = G__42438;
i__41938_42431 = G__42439;
continue;
} else {
var temp__5823__auto___42440 = cljs.core.seq(seq__41935_42428);
if(temp__5823__auto___42440){
var seq__41935_42441__$1 = temp__5823__auto___42440;
if(cljs.core.chunked_seq_QMARK_(seq__41935_42441__$1)){
var c__5525__auto___42442 = cljs.core.chunk_first(seq__41935_42441__$1);
var G__42443 = cljs.core.chunk_rest(seq__41935_42441__$1);
var G__42444 = c__5525__auto___42442;
var G__42445 = cljs.core.count(c__5525__auto___42442);
var G__42446 = (0);
seq__41935_42428 = G__42443;
chunk__41936_42429 = G__42444;
count__41937_42430 = G__42445;
i__41938_42431 = G__42446;
continue;
} else {
var vec__41955_42447 = cljs.core.first(seq__41935_42441__$1);
var k_42448 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41955_42447,(0),null);
var v_42449 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41955_42447,(1),null);
el.setAttributeNS((function (){var temp__5823__auto____$1 = cljs.core.namespace(k_42448);
if(cljs.core.truth_(temp__5823__auto____$1)){
var ns = temp__5823__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_42448),v_42449);


var G__42452 = cljs.core.next(seq__41935_42441__$1);
var G__42453 = null;
var G__42454 = (0);
var G__42455 = (0);
seq__41935_42428 = G__42452;
chunk__41936_42429 = G__42453;
count__41937_42430 = G__42454;
i__41938_42431 = G__42455;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null, );
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__41967 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41967,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41967,(1),null);
var seq__41970_42457 = cljs.core.seq(node_children);
var chunk__41972_42458 = null;
var count__41973_42459 = (0);
var i__41974_42460 = (0);
while(true){
if((i__41974_42460 < count__41973_42459)){
var child_struct_42462 = chunk__41972_42458.cljs$core$IIndexed$_nth$arity$2(null, i__41974_42460);
if((!((child_struct_42462 == null)))){
if(typeof child_struct_42462 === 'string'){
var text_42463 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_42463),child_struct_42462].join(''));
} else {
var children_42464 = shadow.dom.svg_node(child_struct_42462);
if(cljs.core.seq_QMARK_(children_42464)){
var seq__42025_42465 = cljs.core.seq(children_42464);
var chunk__42027_42466 = null;
var count__42028_42467 = (0);
var i__42029_42468 = (0);
while(true){
if((i__42029_42468 < count__42028_42467)){
var child_42469 = chunk__42027_42466.cljs$core$IIndexed$_nth$arity$2(null, i__42029_42468);
if(cljs.core.truth_(child_42469)){
node.appendChild(child_42469);


var G__42470 = seq__42025_42465;
var G__42471 = chunk__42027_42466;
var G__42472 = count__42028_42467;
var G__42473 = (i__42029_42468 + (1));
seq__42025_42465 = G__42470;
chunk__42027_42466 = G__42471;
count__42028_42467 = G__42472;
i__42029_42468 = G__42473;
continue;
} else {
var G__42474 = seq__42025_42465;
var G__42475 = chunk__42027_42466;
var G__42476 = count__42028_42467;
var G__42477 = (i__42029_42468 + (1));
seq__42025_42465 = G__42474;
chunk__42027_42466 = G__42475;
count__42028_42467 = G__42476;
i__42029_42468 = G__42477;
continue;
}
} else {
var temp__5823__auto___42478 = cljs.core.seq(seq__42025_42465);
if(temp__5823__auto___42478){
var seq__42025_42479__$1 = temp__5823__auto___42478;
if(cljs.core.chunked_seq_QMARK_(seq__42025_42479__$1)){
var c__5525__auto___42480 = cljs.core.chunk_first(seq__42025_42479__$1);
var G__42481 = cljs.core.chunk_rest(seq__42025_42479__$1);
var G__42482 = c__5525__auto___42480;
var G__42483 = cljs.core.count(c__5525__auto___42480);
var G__42484 = (0);
seq__42025_42465 = G__42481;
chunk__42027_42466 = G__42482;
count__42028_42467 = G__42483;
i__42029_42468 = G__42484;
continue;
} else {
var child_42486 = cljs.core.first(seq__42025_42479__$1);
if(cljs.core.truth_(child_42486)){
node.appendChild(child_42486);


var G__42487 = cljs.core.next(seq__42025_42479__$1);
var G__42488 = null;
var G__42489 = (0);
var G__42490 = (0);
seq__42025_42465 = G__42487;
chunk__42027_42466 = G__42488;
count__42028_42467 = G__42489;
i__42029_42468 = G__42490;
continue;
} else {
var G__42492 = cljs.core.next(seq__42025_42479__$1);
var G__42493 = null;
var G__42494 = (0);
var G__42495 = (0);
seq__42025_42465 = G__42492;
chunk__42027_42466 = G__42493;
count__42028_42467 = G__42494;
i__42029_42468 = G__42495;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_42464);
}
}


var G__42496 = seq__41970_42457;
var G__42497 = chunk__41972_42458;
var G__42498 = count__41973_42459;
var G__42499 = (i__41974_42460 + (1));
seq__41970_42457 = G__42496;
chunk__41972_42458 = G__42497;
count__41973_42459 = G__42498;
i__41974_42460 = G__42499;
continue;
} else {
var G__42500 = seq__41970_42457;
var G__42501 = chunk__41972_42458;
var G__42502 = count__41973_42459;
var G__42503 = (i__41974_42460 + (1));
seq__41970_42457 = G__42500;
chunk__41972_42458 = G__42501;
count__41973_42459 = G__42502;
i__41974_42460 = G__42503;
continue;
}
} else {
var temp__5823__auto___42504 = cljs.core.seq(seq__41970_42457);
if(temp__5823__auto___42504){
var seq__41970_42505__$1 = temp__5823__auto___42504;
if(cljs.core.chunked_seq_QMARK_(seq__41970_42505__$1)){
var c__5525__auto___42506 = cljs.core.chunk_first(seq__41970_42505__$1);
var G__42508 = cljs.core.chunk_rest(seq__41970_42505__$1);
var G__42509 = c__5525__auto___42506;
var G__42510 = cljs.core.count(c__5525__auto___42506);
var G__42511 = (0);
seq__41970_42457 = G__42508;
chunk__41972_42458 = G__42509;
count__41973_42459 = G__42510;
i__41974_42460 = G__42511;
continue;
} else {
var child_struct_42513 = cljs.core.first(seq__41970_42505__$1);
if((!((child_struct_42513 == null)))){
if(typeof child_struct_42513 === 'string'){
var text_42520 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_42520),child_struct_42513].join(''));
} else {
var children_42521 = shadow.dom.svg_node(child_struct_42513);
if(cljs.core.seq_QMARK_(children_42521)){
var seq__42037_42522 = cljs.core.seq(children_42521);
var chunk__42039_42523 = null;
var count__42040_42524 = (0);
var i__42041_42525 = (0);
while(true){
if((i__42041_42525 < count__42040_42524)){
var child_42526 = chunk__42039_42523.cljs$core$IIndexed$_nth$arity$2(null, i__42041_42525);
if(cljs.core.truth_(child_42526)){
node.appendChild(child_42526);


var G__42528 = seq__42037_42522;
var G__42529 = chunk__42039_42523;
var G__42530 = count__42040_42524;
var G__42531 = (i__42041_42525 + (1));
seq__42037_42522 = G__42528;
chunk__42039_42523 = G__42529;
count__42040_42524 = G__42530;
i__42041_42525 = G__42531;
continue;
} else {
var G__42532 = seq__42037_42522;
var G__42533 = chunk__42039_42523;
var G__42534 = count__42040_42524;
var G__42535 = (i__42041_42525 + (1));
seq__42037_42522 = G__42532;
chunk__42039_42523 = G__42533;
count__42040_42524 = G__42534;
i__42041_42525 = G__42535;
continue;
}
} else {
var temp__5823__auto___42536__$1 = cljs.core.seq(seq__42037_42522);
if(temp__5823__auto___42536__$1){
var seq__42037_42537__$1 = temp__5823__auto___42536__$1;
if(cljs.core.chunked_seq_QMARK_(seq__42037_42537__$1)){
var c__5525__auto___42538 = cljs.core.chunk_first(seq__42037_42537__$1);
var G__42539 = cljs.core.chunk_rest(seq__42037_42537__$1);
var G__42540 = c__5525__auto___42538;
var G__42541 = cljs.core.count(c__5525__auto___42538);
var G__42542 = (0);
seq__42037_42522 = G__42539;
chunk__42039_42523 = G__42540;
count__42040_42524 = G__42541;
i__42041_42525 = G__42542;
continue;
} else {
var child_42543 = cljs.core.first(seq__42037_42537__$1);
if(cljs.core.truth_(child_42543)){
node.appendChild(child_42543);


var G__42544 = cljs.core.next(seq__42037_42537__$1);
var G__42545 = null;
var G__42546 = (0);
var G__42547 = (0);
seq__42037_42522 = G__42544;
chunk__42039_42523 = G__42545;
count__42040_42524 = G__42546;
i__42041_42525 = G__42547;
continue;
} else {
var G__42548 = cljs.core.next(seq__42037_42537__$1);
var G__42549 = null;
var G__42550 = (0);
var G__42551 = (0);
seq__42037_42522 = G__42548;
chunk__42039_42523 = G__42549;
count__42040_42524 = G__42550;
i__42041_42525 = G__42551;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_42521);
}
}


var G__42552 = cljs.core.next(seq__41970_42505__$1);
var G__42553 = null;
var G__42554 = (0);
var G__42555 = (0);
seq__41970_42457 = G__42552;
chunk__41972_42458 = G__42553;
count__41973_42459 = G__42554;
i__41974_42460 = G__42555;
continue;
} else {
var G__42556 = cljs.core.next(seq__41970_42505__$1);
var G__42557 = null;
var G__42558 = (0);
var G__42559 = (0);
seq__41970_42457 = G__42556;
chunk__41972_42458 = G__42557;
count__41973_42459 = G__42558;
i__41974_42460 = G__42559;
continue;
}
}
} else {
}
}
break;
}

return node;
});
(shadow.dom.SVGElement["string"] = true);

(shadow.dom._to_svg["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

(shadow.dom.SVGElement["null"] = true);

(shadow.dom._to_svg["null"] = (function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__5732__auto__ = [];
var len__5726__auto___42561 = arguments.length;
var i__5727__auto___42562 = (0);
while(true){
if((i__5727__auto___42562 < len__5726__auto___42561)){
args__5732__auto__.push((arguments[i__5727__auto___42562]));

var G__42564 = (i__5727__auto___42562 + (1));
i__5727__auto___42562 = G__42564;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq42059){
var G__42060 = cljs.core.first(seq42059);
var seq42059__$1 = cljs.core.next(seq42059);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__42060,seq42059__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__42090 = arguments.length;
switch (G__42090) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__5000__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__5000__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__5000__auto__;
}
})())){
var c__34495__auto___42576 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34496__auto__ = (function (){var switch__34331__auto__ = (function (state_42101){
var state_val_42102 = (state_42101[(1)]);
if((state_val_42102 === (1))){
var state_42101__$1 = state_42101;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42101__$1,(2),once_or_cleanup);
} else {
if((state_val_42102 === (2))){
var inst_42098 = (state_42101[(2)]);
var inst_42099 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_42101__$1 = (function (){var statearr_42104 = state_42101;
(statearr_42104[(7)] = inst_42098);

return statearr_42104;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_42101__$1,inst_42099);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__34332__auto__ = null;
var shadow$dom$state_machine__34332__auto____0 = (function (){
var statearr_42105 = [null,null,null,null,null,null,null,null];
(statearr_42105[(0)] = shadow$dom$state_machine__34332__auto__);

(statearr_42105[(1)] = (1));

return statearr_42105;
});
var shadow$dom$state_machine__34332__auto____1 = (function (state_42101){
while(true){
var ret_value__34333__auto__ = (function (){try{while(true){
var result__34334__auto__ = switch__34331__auto__(state_42101);
if(cljs.core.keyword_identical_QMARK_(result__34334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34334__auto__;
}
break;
}
}catch (e42106){var ex__34335__auto__ = e42106;
var statearr_42107_42581 = state_42101;
(statearr_42107_42581[(2)] = ex__34335__auto__);


if(cljs.core.seq((state_42101[(4)]))){
var statearr_42108_42582 = state_42101;
(statearr_42108_42582[(1)] = cljs.core.first((state_42101[(4)])));

} else {
throw ex__34335__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42583 = state_42101;
state_42101 = G__42583;
continue;
} else {
return ret_value__34333__auto__;
}
break;
}
});
shadow$dom$state_machine__34332__auto__ = function(state_42101){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__34332__auto____0.call(this);
case 1:
return shadow$dom$state_machine__34332__auto____1.call(this,state_42101);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__34332__auto____0;
shadow$dom$state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__34332__auto____1;
return shadow$dom$state_machine__34332__auto__;
})()
})();
var state__34497__auto__ = (function (){var statearr_42110 = f__34496__auto__();
(statearr_42110[(6)] = c__34495__auto___42576);

return statearr_42110;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34497__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
