goog.provide('kabel.client');
if(kabel.util.on_node_QMARK_()){
console.log("Patching global env for: W3C WebSocket API.");

(WebSocket = require("websocket").w3cwebsocket);
} else {
}
/**
 * Connects to url. Puts [in out] channels on return channel when ready.
 * Only supports websocket at the moment, but is supposed to dispatch on
 *   protocol of url. read-opts is ignored on cljs for now, use the
 *   platform-wide reader setup.
 */
kabel.client.client_connect_BANG_ = (function kabel$client$client_connect_BANG_(var_args){
var G__51908 = arguments.length;
switch (G__51908) {
case 3:
return kabel.client.client_connect_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return kabel.client.client_connect_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(kabel.client.client_connect_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (S,url,peer_id){
return kabel.client.client_connect_BANG_.cljs$core$IFn$_invoke$arity$5(S,url,peer_id,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY));
}));

(kabel.client.client_connect_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (S,url,peer_id,read_handlers,write_handlers){
var channel = (new goog.net.WebSocket(false));
var in_buffer = cljs.core.async.buffer((1024));
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(in_buffer);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var opener = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var host = (new goog.Uri(url.replace("ws","http"))).getDomain();
(function (){
var __run_fn_form = null;
var __kind = new cljs.core.Keyword(null,"log","log",-1595516004);
var __ns = "kabel.client";
var __id = null;
var __level = new cljs.core.Keyword(null,"info","info",-317069002);
if(cljs.core.truth_((function (){var sf = taoensso.telemere.impl._STAR_rt_call_filter_STAR_;
if(cljs.core.truth_(sf)){
return (sf.cljs$core$IFn$_invoke$arity$4 ? sf.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"log","log",-1595516004),__ns,__id,__level) : sf.call(null, new cljs.core.Keyword(null,"log","log",-1595516004),__ns,__id,__level));
} else {
return true;
}
})())){
var __inst = (new Date());
var __thread = null;
var __root0 = taoensso.telemere.impl._STAR_trace_root_STAR_;
var __otel_context1 = null;
var __uid = null;
var __root1 = __root0;
var __run_result = null;
var signal__43854__auto__ = (new cljs.core.Delay((function (){

var signal__43845__auto__ = (new taoensso.telemere.impl.Signal((1),__inst,__uid,__ns,null,null,__kind,__id,__level,taoensso.telemere._STAR_ctx_STAR_,taoensso.telemere.impl._STAR_trace_parent_STAR_,__root1,null,null,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"connecting-to","connecting-to",-1991299113),new cljs.core.Keyword(null,"url","url",276297046),url], null)], 0)),null,null,null,null,null,null,null,null));
var temp__5821__auto__ = taoensso.telemere._STAR_xfn_STAR_;
if(cljs.core.truth_(temp__5821__auto__)){
var xfn__43846__auto__ = temp__5821__auto__;
return (xfn__43846__auto__.cljs$core$IFn$_invoke$arity$1 ? xfn__43846__auto__.cljs$core$IFn$_invoke$arity$1(signal__43845__auto__) : xfn__43846__auto__.call(null, signal__43845__auto__));
} else {
return signal__43845__auto__;
}
}),null));
taoensso.telemere.impl.dispatch_signal_BANG_((new taoensso.telemere.impl.WrappedSignal(__kind,__ns,__id,__level,signal__43854__auto__)));

if(cljs.core.truth_(__run_result)){
return (__run_result.cljs$core$IFn$_invoke$arity$1 ? __run_result.cljs$core$IFn$_invoke$arity$1(signal__43854__auto__) : __run_result.call(null, signal__43854__auto__));
} else {
return true;
}
} else {
return null;
}
})();


var G__51925_52002 = channel;
goog.events.listen(G__51925_52002,goog.net.WebSocket.EventType.MESSAGE,(function (evt){
var v = evt.message;
try{if((cljs.core.count(in_buffer) > (100))){
channel.close();

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["incoming buffer for ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)," too full:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(in_buffer))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"count","count",2139924085),cljs.core.count(in_buffer)], null));
} else {
}

if(typeof v === 'string'){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(in$,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("kabel","serialization","kabel/serialization",437520425),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword("kabel","payload","kabel/payload",251259889),v], null));
} else {
return kabel.binary.from_binary(v,(function (p1__51903_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(in$,((cljs.core.map_QMARK_(p1__51903_SHARP_))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__51903_SHARP_,new cljs.core.Keyword("kabel","host","kabel/host",-1456877872),host):p1__51903_SHARP_));
}));
}
}catch (e51926){if((e51926 instanceof Error)){
var e = e51926;
(function (){
var __run_fn_form = null;
var __kind = new cljs.core.Keyword(null,"log","log",-1595516004);
var __ns = "kabel.client";
var __id = null;
var __level = new cljs.core.Keyword(null,"error","error",-978969032);
if(cljs.core.truth_((function (){var sf = taoensso.telemere.impl._STAR_rt_call_filter_STAR_;
if(cljs.core.truth_(sf)){
return (sf.cljs$core$IFn$_invoke$arity$4 ? sf.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"log","log",-1595516004),__ns,__id,__level) : sf.call(null, new cljs.core.Keyword(null,"log","log",-1595516004),__ns,__id,__level));
} else {
return true;
}
})())){
var __inst = (new Date());
var __thread = null;
var __root0 = taoensso.telemere.impl._STAR_trace_root_STAR_;
var __otel_context1 = null;
var __uid = null;
var __root1 = __root0;
var __run_result = null;
var signal__43854__auto__ = (new cljs.core.Delay((function (){

var signal__43845__auto__ = (new taoensso.telemere.impl.Signal((1),__inst,__uid,__ns,null,null,__kind,__id,__level,taoensso.telemere._STAR_ctx_STAR_,taoensso.telemere.impl._STAR_trace_parent_STAR_,__root1,null,null,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"cannot-read-message","cannot-read-message",-543619229),new cljs.core.Keyword(null,"error","error",-978969032),e], null)], 0)),null,null,null,null,null,null,null,null));
var temp__5821__auto__ = taoensso.telemere._STAR_xfn_STAR_;
if(cljs.core.truth_(temp__5821__auto__)){
var xfn__43846__auto__ = temp__5821__auto__;
return (xfn__43846__auto__.cljs$core$IFn$_invoke$arity$1 ? xfn__43846__auto__.cljs$core$IFn$_invoke$arity$1(signal__43845__auto__) : xfn__43846__auto__.call(null, signal__43845__auto__));
} else {
return signal__43845__auto__;
}
}),null));
taoensso.telemere.impl.dispatch_signal_BANG_((new taoensso.telemere.impl.WrappedSignal(__kind,__ns,__id,__level,signal__43854__auto__)));

if(cljs.core.truth_(__run_result)){
return (__run_result.cljs$core$IFn$_invoke$arity$1 ? __run_result.cljs$core$IFn$_invoke$arity$1(signal__43854__auto__) : __run_result.call(null, signal__43854__auto__));
} else {
return true;
}
} else {
return null;
}
})();


channel.close();

cljs.core.async.close_BANG_(opener);

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(superv.async._error(S),e);
} else {
throw e51926;

}
}}));

goog.events.listen(G__51925_52002,goog.net.WebSocket.EventType.CLOSED,(function (evt){
var e = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection closed!",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"event","event",301435442),evt], null));
(function (){
var __run_fn_form = null;
var __kind = new cljs.core.Keyword(null,"log","log",-1595516004);
var __ns = "kabel.client";
var __id = null;
var __level = new cljs.core.Keyword(null,"info","info",-317069002);
if(cljs.core.truth_((function (){var sf = taoensso.telemere.impl._STAR_rt_call_filter_STAR_;
if(cljs.core.truth_(sf)){
return (sf.cljs$core$IFn$_invoke$arity$4 ? sf.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"log","log",-1595516004),__ns,__id,__level) : sf.call(null, new cljs.core.Keyword(null,"log","log",-1595516004),__ns,__id,__level));
} else {
return true;
}
})())){
var __inst = (new Date());
var __thread = null;
var __root0 = taoensso.telemere.impl._STAR_trace_root_STAR_;
var __otel_context1 = null;
var __uid = null;
var __root1 = __root0;
var __run_result = null;
var signal__43854__auto__ = (new cljs.core.Delay((function (){

var signal__43845__auto__ = (new taoensso.telemere.impl.Signal((1),__inst,__uid,__ns,null,null,__kind,__id,__level,taoensso.telemere._STAR_ctx_STAR_,taoensso.telemere.impl._STAR_trace_parent_STAR_,__root1,null,null,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"connection-closed","connection-closed",579733998),new cljs.core.Keyword(null,"url","url",276297046),url], null)], 0)),null,null,null,null,null,null,null,null));
var temp__5821__auto__ = taoensso.telemere._STAR_xfn_STAR_;
if(cljs.core.truth_(temp__5821__auto__)){
var xfn__43846__auto__ = temp__5821__auto__;
return (xfn__43846__auto__.cljs$core$IFn$_invoke$arity$1 ? xfn__43846__auto__.cljs$core$IFn$_invoke$arity$1(signal__43845__auto__) : xfn__43846__auto__.call(null, signal__43845__auto__));
} else {
return signal__43845__auto__;
}
}),null));
taoensso.telemere.impl.dispatch_signal_BANG_((new taoensso.telemere.impl.WrappedSignal(__kind,__ns,__id,__level,signal__43854__auto__)));

if(cljs.core.truth_(__run_result)){
return (__run_result.cljs$core$IFn$_invoke$arity$1 ? __run_result.cljs$core$IFn$_invoke$arity$1(signal__43854__auto__) : __run_result.call(null, signal__43854__auto__));
} else {
return true;
}
} else {
return null;
}
})();


cljs.core.async.close_BANG_(in$);

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(superv.async._error(S),e);

try{cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(opener,e);
}catch (e51927){if((e51927 instanceof Object)){
var e_52003__$1 = e51927;
} else {
throw e51927;

}
}
channel.close();

return cljs.core.async.close_BANG_(opener);
}));

goog.events.listen(G__51925_52002,goog.net.WebSocket.EventType.OPENED,(function (evt){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(opener,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [in$,out], null));

return cljs.core.async.close_BANG_(opener);
}));

goog.events.listen(G__51925_52002,goog.net.WebSocket.EventType.ERROR,(function (evt){
var e = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection error!",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"event","event",301435442),evt], null));
(function (){
var __run_fn_form = null;
var __kind = new cljs.core.Keyword(null,"log","log",-1595516004);
var __ns = "kabel.client";
var __id = null;
var __level = new cljs.core.Keyword(null,"error","error",-978969032);
if(cljs.core.truth_((function (){var sf = taoensso.telemere.impl._STAR_rt_call_filter_STAR_;
if(cljs.core.truth_(sf)){
return (sf.cljs$core$IFn$_invoke$arity$4 ? sf.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"log","log",-1595516004),__ns,__id,__level) : sf.call(null, new cljs.core.Keyword(null,"log","log",-1595516004),__ns,__id,__level));
} else {
return true;
}
})())){
var __inst = (new Date());
var __thread = null;
var __root0 = taoensso.telemere.impl._STAR_trace_root_STAR_;
var __otel_context1 = null;
var __uid = null;
var __root1 = __root0;
var __run_result = null;
var signal__43854__auto__ = (new cljs.core.Delay((function (){

var signal__43845__auto__ = (new taoensso.telemere.impl.Signal((1),__inst,__uid,__ns,null,null,__kind,__id,__level,taoensso.telemere._STAR_ctx_STAR_,taoensso.telemere.impl._STAR_trace_parent_STAR_,__root1,null,null,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"websocket-error","websocket-error",941100166),new cljs.core.Keyword(null,"url","url",276297046),url], null)], 0)),null,null,null,null,null,null,null,null));
var temp__5821__auto__ = taoensso.telemere._STAR_xfn_STAR_;
if(cljs.core.truth_(temp__5821__auto__)){
var xfn__43846__auto__ = temp__5821__auto__;
return (xfn__43846__auto__.cljs$core$IFn$_invoke$arity$1 ? xfn__43846__auto__.cljs$core$IFn$_invoke$arity$1(signal__43845__auto__) : xfn__43846__auto__.call(null, signal__43845__auto__));
} else {
return signal__43845__auto__;
}
}),null));
taoensso.telemere.impl.dispatch_signal_BANG_((new taoensso.telemere.impl.WrappedSignal(__kind,__ns,__id,__level,signal__43854__auto__)));

if(cljs.core.truth_(__run_result)){
return (__run_result.cljs$core$IFn$_invoke$arity$1 ? __run_result.cljs$core$IFn$_invoke$arity$1(signal__43854__auto__) : __run_result.call(null, signal__43854__auto__));
} else {
return true;
}
} else {
return null;
}
})();


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(superv.async._error(S),e);

try{cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(opener,e);
}catch (e51928){if((e51928 instanceof Object)){
var e_52004__$1 = e51928;
} else {
throw e51928;

}
}
return cljs.core.async.close_BANG_(opener);
}));

try{
channel.open(url);
}catch (e51929){if((e51929 instanceof Object)){
var e_52006 = e51929;
var e_52007__$1 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection failed!",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"connection-failed","connection-failed",-1910345930),new cljs.core.Keyword(null,"error","error",-978969032),e_52006], null));
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(superv.async._error(S),e_52007__$1);

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(opener,e_52007__$1);

cljs.core.async.close_BANG_(opener);
} else {
throw e51929;

}
}

(function kabel$client$sender(){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(out,(function (m){
if(cljs.core.truth_(m)){
var c__34495__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34496__auto__ = (function (){var switch__34331__auto__ = (function (state_51970){
var state_val_51971 = (state_51970[(1)]);
if((state_val_51971 === (7))){
var inst_51938 = (state_51970[(2)]);
var state_51970__$1 = (function (){var statearr_51972 = state_51970;
(statearr_51972[(7)] = inst_51938);

return statearr_51972;
})();
var statearr_51973_52014 = state_51970__$1;
(statearr_51973_52014[(2)] = null);

(statearr_51973_52014[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51971 === (1))){
var state_51970__$1 = state_51970;
var statearr_51974_52015 = state_51970__$1;
(statearr_51974_52015[(2)] = null);

(statearr_51974_52015[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51971 === (4))){
var inst_51934 = (function (){return (function (){
var __run_fn_form = null;
var __kind = new cljs.core.Keyword(null,"log","log",-1595516004);
var __ns = "kabel.client";
var __id = null;
var __level = new cljs.core.Keyword(null,"debug","debug",-1608172596);
if(cljs.core.truth_((function (){var sf = taoensso.telemere.impl._STAR_rt_call_filter_STAR_;
if(cljs.core.truth_(sf)){
return (sf.cljs$core$IFn$_invoke$arity$4 ? sf.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"log","log",-1595516004),__ns,__id,__level) : sf.call(null, new cljs.core.Keyword(null,"log","log",-1595516004),__ns,__id,__level));
} else {
return true;
}
})())){
var __inst = (new Date());
var __thread = null;
var __root0 = taoensso.telemere.impl._STAR_trace_root_STAR_;
var __otel_context1 = null;
var __uid = null;
var __root1 = __root0;
var __run_result = null;
var signal__43854__auto__ = (new cljs.core.Delay((function (){

var signal__43845__auto__ = (new taoensso.telemere.impl.Signal((1),__inst,__uid,__ns,null,null,__kind,__id,__level,taoensso.telemere._STAR_ctx_STAR_,taoensso.telemere.impl._STAR_trace_parent_STAR_,__root1,null,null,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"output-blocked","output-blocked",-122311417),new cljs.core.Keyword(null,"buffered-amount","buffered-amount",-665650460),channel.getBufferedAmount()], null)], 0)),null,null,null,null,null,null,null,null));
var temp__5821__auto__ = taoensso.telemere._STAR_xfn_STAR_;
if(cljs.core.truth_(temp__5821__auto__)){
var xfn__43846__auto__ = temp__5821__auto__;
return (xfn__43846__auto__.cljs$core$IFn$_invoke$arity$1 ? xfn__43846__auto__.cljs$core$IFn$_invoke$arity$1(signal__43845__auto__) : xfn__43846__auto__.call(null, signal__43845__auto__));
} else {
return signal__43845__auto__;
}
}),null));
taoensso.telemere.impl.dispatch_signal_BANG_((new taoensso.telemere.impl.WrappedSignal(__kind,__ns,__id,__level,signal__43854__auto__)));

if(cljs.core.truth_(__run_result)){
return (__run_result.cljs$core$IFn$_invoke$arity$1 ? __run_result.cljs$core$IFn$_invoke$arity$1(signal__43854__auto__) : __run_result.call(null, signal__43854__auto__));
} else {
return true;
}
} else {
return null;
}
});
})();
var inst_51935 = inst_51934();
var inst_51936 = cljs.core.async.timeout((100));
var state_51970__$1 = (function (){var statearr_51975 = state_51970;
(statearr_51975[(8)] = inst_51935);

return statearr_51975;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51970__$1,(7),inst_51936);
} else {
if((state_val_51971 === (13))){
var inst_51961 = kabel.binary.to_binary(m);
var inst_51962 = channel.send(inst_51961);
var state_51970__$1 = state_51970;
var statearr_51976_52031 = state_51970__$1;
(statearr_51976_52031[(2)] = inst_51962);

(statearr_51976_52031[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51971 === (6))){
var inst_51942 = (state_51970[(2)]);
var state_51970__$1 = state_51970;
var statearr_51977_52032 = state_51970__$1;
(statearr_51977_52032[(2)] = inst_51942);

(statearr_51977_52032[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51971 === (3))){
var inst_51944 = (state_51970[(2)]);
var state_51970__$1 = (function (){var statearr_51978 = state_51970;
(statearr_51978[(9)] = inst_51944);

return statearr_51978;
})();
var statearr_51979_52033 = state_51970__$1;
(statearr_51979_52033[(2)] = null);

(statearr_51979_52033[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51971 === (12))){
var inst_51958 = new cljs.core.Keyword("kabel","payload","kabel/payload",251259889).cljs$core$IFn$_invoke$arity$1(m);
var inst_51959 = channel.send(inst_51958);
var state_51970__$1 = state_51970;
var statearr_51981_52037 = state_51970__$1;
(statearr_51981_52037[(2)] = inst_51959);

(statearr_51981_52037[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51971 === (2))){
var inst_51931 = channel.getBufferedAmount();
var inst_51932 = (inst_51931 > (0));
var state_51970__$1 = state_51970;
if(cljs.core.truth_(inst_51932)){
var statearr_51982_52040 = state_51970__$1;
(statearr_51982_52040[(1)] = (4));

} else {
var statearr_51983_52045 = state_51970__$1;
(statearr_51983_52045[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51971 === (11))){
var _ = (function (){var statearr_51984 = state_51970;
(statearr_51984[(4)] = cljs.core.rest((state_51970[(4)])));

return statearr_51984;
})();
var state_51970__$1 = state_51970;
var ex51980 = (state_51970__$1[(2)]);
var statearr_51985_52050 = state_51970__$1;
(statearr_51985_52050[(5)] = ex51980);


if((ex51980 instanceof Error)){
var statearr_51986_52052 = state_51970__$1;
(statearr_51986_52052[(1)] = (10));

(statearr_51986_52052[(5)] = null);

} else {
throw ex51980;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51971 === (9))){
var inst_51967 = (state_51970[(2)]);
var inst_51968 = kabel$client$sender();
var state_51970__$1 = (function (){var statearr_51987 = state_51970;
(statearr_51987[(10)] = inst_51967);

return statearr_51987;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_51970__$1,inst_51968);
} else {
if((state_val_51971 === (5))){
var state_51970__$1 = state_51970;
var statearr_51988_52062 = state_51970__$1;
(statearr_51988_52062[(2)] = null);

(statearr_51988_52062[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51971 === (14))){
var inst_51964 = (state_51970[(2)]);
var _ = (function (){var statearr_51989 = state_51970;
(statearr_51989[(4)] = cljs.core.rest((state_51970[(4)])));

return statearr_51989;
})();
var state_51970__$1 = state_51970;
var statearr_51990_52063 = state_51970__$1;
(statearr_51990_52063[(2)] = inst_51964);

(statearr_51990_52063[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51971 === (10))){
var inst_51945 = (state_51970[(2)]);
var inst_51946 = (function (){var e = inst_51945;
return (function (){
var __run_fn_form = null;
var __kind = new cljs.core.Keyword(null,"log","log",-1595516004);
var __ns = "kabel.client";
var __id = null;
var __level = new cljs.core.Keyword(null,"error","error",-978969032);
if(cljs.core.truth_((function (){var sf = taoensso.telemere.impl._STAR_rt_call_filter_STAR_;
if(cljs.core.truth_(sf)){
return (sf.cljs$core$IFn$_invoke$arity$4 ? sf.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"log","log",-1595516004),__ns,__id,__level) : sf.call(null, new cljs.core.Keyword(null,"log","log",-1595516004),__ns,__id,__level));
} else {
return true;
}
})())){
var __inst = (new Date());
var __thread = null;
var __root0 = taoensso.telemere.impl._STAR_trace_root_STAR_;
var __otel_context1 = null;
var __uid = null;
var __root1 = __root0;
var __run_result = null;
var signal__43854__auto__ = (new cljs.core.Delay((function (){

var signal__43845__auto__ = (new taoensso.telemere.impl.Signal((1),__inst,__uid,__ns,null,null,__kind,__id,__level,taoensso.telemere._STAR_ctx_STAR_,taoensso.telemere.impl._STAR_trace_parent_STAR_,__root1,null,null,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"cannot-send-transit-message","cannot-send-transit-message",-1612316504),new cljs.core.Keyword(null,"error","error",-978969032),e], null)], 0)),null,null,null,null,null,null,null,null));
var temp__5821__auto__ = taoensso.telemere._STAR_xfn_STAR_;
if(cljs.core.truth_(temp__5821__auto__)){
var xfn__43846__auto__ = temp__5821__auto__;
return (xfn__43846__auto__.cljs$core$IFn$_invoke$arity$1 ? xfn__43846__auto__.cljs$core$IFn$_invoke$arity$1(signal__43845__auto__) : xfn__43846__auto__.call(null, signal__43845__auto__));
} else {
return signal__43845__auto__;
}
}),null));
taoensso.telemere.impl.dispatch_signal_BANG_((new taoensso.telemere.impl.WrappedSignal(__kind,__ns,__id,__level,signal__43854__auto__)));

if(cljs.core.truth_(__run_result)){
return (__run_result.cljs$core$IFn$_invoke$arity$1 ? __run_result.cljs$core$IFn$_invoke$arity$1(signal__43854__auto__) : __run_result.call(null, signal__43854__auto__));
} else {
return true;
}
} else {
return null;
}
});
})();
var inst_51947 = inst_51946();
var inst_51948 = superv.async._error(S);
var inst_51949 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_51948,inst_51945);
var state_51970__$1 = (function (){var statearr_51991 = state_51970;
(statearr_51991[(11)] = inst_51947);

return statearr_51991;
})();
var statearr_51992_52083 = state_51970__$1;
(statearr_51992_52083[(2)] = inst_51949);

(statearr_51992_52083[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_51971 === (8))){
var _ = (function (){var statearr_51993 = state_51970;
(statearr_51993[(4)] = cljs.core.cons((11),(state_51970[(4)])));

return statearr_51993;
})();
var inst_51955 = new cljs.core.Keyword("kabel","serialization","kabel/serialization",437520425).cljs$core$IFn$_invoke$arity$1(m);
var inst_51956 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_51955,new cljs.core.Keyword(null,"string","string",-1989541586));
var state_51970__$1 = state_51970;
if(inst_51956){
var statearr_51994_52098 = state_51970__$1;
(statearr_51994_52098[(1)] = (12));

} else {
var statearr_51995_52099 = state_51970__$1;
(statearr_51995_52099[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var kabel$client$sender_$_state_machine__34332__auto__ = null;
var kabel$client$sender_$_state_machine__34332__auto____0 = (function (){
var statearr_51996 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_51996[(0)] = kabel$client$sender_$_state_machine__34332__auto__);

(statearr_51996[(1)] = (1));

return statearr_51996;
});
var kabel$client$sender_$_state_machine__34332__auto____1 = (function (state_51970){
while(true){
var ret_value__34333__auto__ = (function (){try{while(true){
var result__34334__auto__ = switch__34331__auto__(state_51970);
if(cljs.core.keyword_identical_QMARK_(result__34334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34334__auto__;
}
break;
}
}catch (e51997){var ex__34335__auto__ = e51997;
var statearr_51998_52103 = state_51970;
(statearr_51998_52103[(2)] = ex__34335__auto__);


if(cljs.core.seq((state_51970[(4)]))){
var statearr_51999_52104 = state_51970;
(statearr_51999_52104[(1)] = cljs.core.first((state_51970[(4)])));

} else {
throw ex__34335__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52105 = state_51970;
state_51970 = G__52105;
continue;
} else {
return ret_value__34333__auto__;
}
break;
}
});
kabel$client$sender_$_state_machine__34332__auto__ = function(state_51970){
switch(arguments.length){
case 0:
return kabel$client$sender_$_state_machine__34332__auto____0.call(this);
case 1:
return kabel$client$sender_$_state_machine__34332__auto____1.call(this,state_51970);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
kabel$client$sender_$_state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$0 = kabel$client$sender_$_state_machine__34332__auto____0;
kabel$client$sender_$_state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$1 = kabel$client$sender_$_state_machine__34332__auto____1;
return kabel$client$sender_$_state_machine__34332__auto__;
})()
})();
var state__34497__auto__ = (function (){var statearr_52000 = f__34496__auto__();
(statearr_52000[(6)] = c__34495__auto__);

return statearr_52000;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34497__auto__);
}));

return c__34495__auto__;
} else {
return channel.close();
}
}));
})();

return opener;
}));

(kabel.client.client_connect_BANG_.cljs$lang$maxFixedArity = 5);


//# sourceMappingURL=kabel.client.js.map
