goog.provide('hasch.core');
hasch.core.uuid4 = hasch.platform.uuid4;
hasch.core.uuid5 = hasch.platform.uuid5;
hasch.core.hash__GT_str = hasch.platform.hash__GT_str;
/**
 * Hash an edn value with SHA-512 by default or a compatible hash function of choice.
 * 
 *   Please use the write-handlers only in legacy cases and rather extend the PHashCoercion
 *   protocol to your own types.
 */
hasch.core.edn_hash = (function hasch$core$edn_hash(var_args){
var G__44266 = arguments.length;
switch (G__44266) {
case 1:
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$1 = (function (val){
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$2(val,cljs.core.PersistentArrayMap.EMPTY);
}));

(hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$2 = (function (val,write_handlers){
return hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$3(val,hasch.platform.sha512_message_digest,write_handlers);
}));

(hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$3 = (function (val,md_create_fn,write_handlers){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__44258_SHARP_){
if((p1__44258_SHARP_ < (0))){
return (p1__44258_SHARP_ + (256));
} else {
return p1__44258_SHARP_;
}
}),hasch.benc.digest(hasch.benc._coerce(val,md_create_fn,(function (){var or__5002__auto__ = write_handlers;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})()),md_create_fn));
}));

(hasch.core.edn_hash.cljs$lang$maxFixedArity = 3);

/**
 * Creates random UUID-4 without argument or UUID-5 for the argument value.
 * 
 *   Optionally an incognito-style write-handlers map can be supplied,
 *   which describes record serialization in terms of Clojure data
 *   structures.
 */
hasch.core.uuid = (function hasch$core$uuid(var_args){
var G__44301 = arguments.length;
switch (G__44301) {
case 0:
return hasch.core.uuid.cljs$core$IFn$_invoke$arity$0();

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___44318 = arguments.length;
var i__5727__auto___44319 = (0);
while(true){
if((i__5727__auto___44319 < len__5726__auto___44318)){
args_arr__5751__auto__.push((arguments[i__5727__auto___44319]));

var G__44320 = (i__5727__auto___44319 + (1));
i__5727__auto___44319 = G__44320;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((1) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((1)),(0),null)):null);
return hasch.core.uuid.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5752__auto__);

}
});

(hasch.core.uuid.cljs$core$IFn$_invoke$arity$0 = (function (){
return (hasch.core.uuid4.cljs$core$IFn$_invoke$arity$0 ? hasch.core.uuid4.cljs$core$IFn$_invoke$arity$0() : hasch.core.uuid4.call(null, ));
}));

(hasch.core.uuid.cljs$core$IFn$_invoke$arity$variadic = (function (val,p__44305){
var map__44306 = p__44305;
var map__44306__$1 = cljs.core.__destructure_map(map__44306);
var write_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44306__$1,new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911));
var G__44307 = hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$2(val,write_handlers);
return (hasch.core.uuid5.cljs$core$IFn$_invoke$arity$1 ? hasch.core.uuid5.cljs$core$IFn$_invoke$arity$1(G__44307) : hasch.core.uuid5.call(null, G__44307));
}));

/** @this {Function} */
(hasch.core.uuid.cljs$lang$applyTo = (function (seq44299){
var G__44300 = cljs.core.first(seq44299);
var seq44299__$1 = cljs.core.next(seq44299);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__44300,seq44299__$1);
}));

(hasch.core.uuid.cljs$lang$maxFixedArity = (1));

/**
 * Calculates a sequential UUID as described in
 *   https://github.com/clojure-cookbook/clojure-cookbook/blob/master/01_primitive-data/1-24_uuids.asciidoc
 */
hasch.core.squuid = (function hasch$core$squuid(var_args){
var G__44312 = arguments.length;
switch (G__44312) {
case 0:
return hasch.core.squuid.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return hasch.core.squuid.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(hasch.core.squuid.cljs$core$IFn$_invoke$arity$0 = (function (){
return hasch.core.squuid.cljs$core$IFn$_invoke$arity$1((hasch.core.uuid4.cljs$core$IFn$_invoke$arity$0 ? hasch.core.uuid4.cljs$core$IFn$_invoke$arity$0() : hasch.core.uuid4.call(null, )));
}));

(hasch.core.squuid.cljs$core$IFn$_invoke$arity$1 = (function (uuid){
var time = (new Date()).getTime();
var secs = cljs.core.quot(time,(1000));
var prefix = secs.toString((16));
return cljs.core.uuid([cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefix),cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(uuid),(8))].join(''));
}));

(hasch.core.squuid.cljs$lang$maxFixedArity = 1);

/**
 * Provides a base64 encoded string of the edn-hash of a value val. This contains
 *   all bits of the hash compared to 128 bits for the UUID-5. Both should be safe,
 *   but b64-hash is safer towards collisions.
 */
hasch.core.b64_hash = (function hasch$core$b64_hash(val){
return hasch.base64.encode(cljs.core.clj__GT_js(hasch.core.edn_hash.cljs$core$IFn$_invoke$arity$1(val)));
});

//# sourceMappingURL=hasch.core.js.map
