goog.provide('hasch.benc');

/**
 * @interface
 */
hasch.benc.PHashCoercion = function(){};

var hasch$benc$PHashCoercion$_coerce$dyn_44155 = (function (this$,md_create_fn,write_handlers){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (hasch.benc._coerce[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(this$,md_create_fn,write_handlers) : m__5351__auto__.call(null, this$,md_create_fn,write_handlers));
} else {
var m__5349__auto__ = (hasch.benc._coerce["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(this$,md_create_fn,write_handlers) : m__5349__auto__.call(null, this$,md_create_fn,write_handlers));
} else {
throw cljs.core.missing_protocol("PHashCoercion.-coerce",this$);
}
}
});
hasch.benc._coerce = (function hasch$benc$_coerce(this$,md_create_fn,write_handlers){
if((((!((this$ == null)))) && ((!((this$.hasch$benc$PHashCoercion$_coerce$arity$3 == null)))))){
return this$.hasch$benc$PHashCoercion$_coerce$arity$3(this$,md_create_fn,write_handlers);
} else {
return hasch$benc$PHashCoercion$_coerce$dyn_44155(this$,md_create_fn,write_handlers);
}
});

hasch.benc.magics = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"binary","binary",-1802232288),new cljs.core.Keyword(null,"inst","inst",645962501),new cljs.core.Keyword(null,"number","number",1570378438),new cljs.core.Keyword(null,"symbol","symbol",-1038572696),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"vector","vector",1902966158),new cljs.core.Keyword(null,"keyword","keyword",811389747),new cljs.core.Keyword(null,"nil","nil",99600501),new cljs.core.Keyword(null,"literal","literal",1664775605),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"seq","seq",-1817803783),new cljs.core.Keyword(null,"set","set",304602554),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"map","map",1371690461)],[(13),(6),(2),(4),(3),(9),(5),(0),(12),(7),(8),(11),(1),(10)]);
hasch.benc.split_size = (1024);
hasch.benc.max_entropy_byte_count = (32);
hasch.benc.byte_array = (function hasch$benc$byte_array(len){
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(len,(0)));
});
hasch.benc.digest = (function hasch$benc$digest(bytes_or_seq_of_bytes,md_create_fn){
var md = (md_create_fn.cljs$core$IFn$_invoke$arity$0 ? md_create_fn.cljs$core$IFn$_invoke$arity$0() : md_create_fn.call(null, ));
if(cljs.core.seq_QMARK_(bytes_or_seq_of_bytes)){
var seq__44135_44160 = cljs.core.seq(bytes_or_seq_of_bytes);
var chunk__44136_44161 = null;
var count__44137_44162 = (0);
var i__44138_44163 = (0);
while(true){
if((i__44138_44163 < count__44137_44162)){
var bs_44164 = chunk__44136_44161.cljs$core$IIndexed$_nth$arity$2(null, i__44138_44163);
md.update(bs_44164);


var G__44165 = seq__44135_44160;
var G__44166 = chunk__44136_44161;
var G__44167 = count__44137_44162;
var G__44168 = (i__44138_44163 + (1));
seq__44135_44160 = G__44165;
chunk__44136_44161 = G__44166;
count__44137_44162 = G__44167;
i__44138_44163 = G__44168;
continue;
} else {
var temp__5823__auto___44169 = cljs.core.seq(seq__44135_44160);
if(temp__5823__auto___44169){
var seq__44135_44170__$1 = temp__5823__auto___44169;
if(cljs.core.chunked_seq_QMARK_(seq__44135_44170__$1)){
var c__5525__auto___44171 = cljs.core.chunk_first(seq__44135_44170__$1);
var G__44172 = cljs.core.chunk_rest(seq__44135_44170__$1);
var G__44173 = c__5525__auto___44171;
var G__44174 = cljs.core.count(c__5525__auto___44171);
var G__44175 = (0);
seq__44135_44160 = G__44172;
chunk__44136_44161 = G__44173;
count__44137_44162 = G__44174;
i__44138_44163 = G__44175;
continue;
} else {
var bs_44176 = cljs.core.first(seq__44135_44170__$1);
md.update(bs_44176);


var G__44177 = cljs.core.next(seq__44135_44170__$1);
var G__44178 = null;
var G__44179 = (0);
var G__44180 = (0);
seq__44135_44160 = G__44177;
chunk__44136_44161 = G__44178;
count__44137_44162 = G__44179;
i__44138_44163 = G__44180;
continue;
}
} else {
}
}
break;
}
} else {
md.update(bytes_or_seq_of_bytes);
}

return md.digest();
});
hasch.benc.coerce_seq = (function hasch$benc$coerce_seq(seq,md_create_fn,write_handlers){
var seq_md = (md_create_fn.cljs$core$IFn$_invoke$arity$0 ? md_create_fn.cljs$core$IFn$_invoke$arity$0() : md_create_fn.call(null, ));
var s_44182 = seq;
while(true){
var vec__44144_44183 = s_44182;
var seq__44145_44184 = cljs.core.seq(vec__44144_44183);
var first__44146_44185 = cljs.core.first(seq__44145_44184);
var seq__44145_44186__$1 = cljs.core.next(seq__44145_44184);
var f_44187 = first__44146_44185;
var r_44188 = seq__44145_44186__$1;
seq_md.update(hasch.benc._coerce(f_44187,md_create_fn,write_handlers));

if(cljs.core.empty_QMARK_(r_44188)){
} else {
var G__44189 = cljs.core.rest(s_44182);
s_44182 = G__44189;
continue;
}
break;
}

return seq_md.digest();
});
/**
 * Commutatively coerces elements of collection, seq entries must already be crypto hashes
 *   to avoid collisions in XOR. Takes at maximum 32 bytes into account.
 */
hasch.benc.xor_hashes = (function hasch$benc$xor_hashes(seq){
var len = (function (){var x__5090__auto__ = cljs.core.count(cljs.core.first(seq));
var y__5091__auto__ = hasch.benc.max_entropy_byte_count;
return ((x__5090__auto__ < y__5091__auto__) ? x__5090__auto__ : y__5091__auto__);
})();
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,elem){
var i_44190 = (0);
while(true){
if((i_44190 < len)){
(acc[i_44190] = ((acc[i_44190]) ^ (elem[i_44190])));

var G__44191 = (i_44190 + (1));
i_44190 = G__44191;
continue;
} else {
}
break;
}

return acc;
}),hasch.benc.byte_array(len),seq);
});
hasch.benc.encode_safe = (function hasch$benc$encode_safe(a,md_create_fn){
if((cljs.core.count(a) < hasch.benc.split_size)){
var len = cljs.core.long$(a.length);
var ea = hasch.benc.byte_array(len);
var i_44192 = (0);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i_44192,len)){
} else {
var e_44193 = (a[i_44192]);
if((((e_44193 > (0))) && ((e_44193 < (30))))){
(ea[i_44192] = (1));
} else {
}

var G__44194 = (i_44192 + (1));
i_44192 = G__44194;
continue;
}
break;
}

return a.concat(ea);
} else {
return hasch.benc.digest(a,md_create_fn);
}
});

//# sourceMappingURL=hasch.benc.js.map
