goog.provide('cljs.core.async');
goog.scope(function(){
  cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async36988 = (function (f,blockable,meta36989){
this.f = f;
this.blockable = blockable;
this.meta36989 = meta36989;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async36988.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_36990,meta36989__$1){
var self__ = this;
var _36990__$1 = this;
return (new cljs.core.async.t_cljs$core$async36988(self__.f,self__.blockable,meta36989__$1));
}));

(cljs.core.async.t_cljs$core$async36988.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_36990){
var self__ = this;
var _36990__$1 = this;
return self__.meta36989;
}));

(cljs.core.async.t_cljs$core$async36988.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async36988.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async36988.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async36988.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async36988.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta36989","meta36989",1554899401,null)], null);
}));

(cljs.core.async.t_cljs$core$async36988.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async36988.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async36988");

(cljs.core.async.t_cljs$core$async36988.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async36988");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async36988.
 */
cljs.core.async.__GT_t_cljs$core$async36988 = (function cljs$core$async$__GT_t_cljs$core$async36988(f,blockable,meta36989){
return (new cljs.core.async.t_cljs$core$async36988(f,blockable,meta36989));
});


cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__36979 = arguments.length;
switch (G__36979) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
return (new cljs.core.async.t_cljs$core$async36988(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__37018 = arguments.length;
switch (G__37018) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__37029 = arguments.length;
switch (G__37029) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__37035 = arguments.length;
switch (G__37035) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_40733 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_40733) : fn1.call(null, val_40733));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_40733) : fn1.call(null, val_40733));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__37047 = arguments.length;
switch (G__37047) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5821__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5821__auto__)){
var ret = temp__5821__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5821__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5821__auto__)){
var retb = temp__5821__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null, ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null, ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5593__auto___40743 = n;
var x_40744 = (0);
while(true){
if((x_40744 < n__5593__auto___40743)){
(a[x_40744] = x_40744);

var G__40749 = (x_40744 + (1));
x_40744 = G__40749;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle(a);

return a;
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37056 = (function (flag,meta37057){
this.flag = flag;
this.meta37057 = meta37057;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async37056.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_37058,meta37057__$1){
var self__ = this;
var _37058__$1 = this;
return (new cljs.core.async.t_cljs$core$async37056(self__.flag,meta37057__$1));
}));

(cljs.core.async.t_cljs$core$async37056.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_37058){
var self__ = this;
var _37058__$1 = this;
return self__.meta37057;
}));

(cljs.core.async.t_cljs$core$async37056.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async37056.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async37056.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async37056.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async37056.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta37057","meta37057",-1805808601,null)], null);
}));

(cljs.core.async.t_cljs$core$async37056.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async37056.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37056");

(cljs.core.async.t_cljs$core$async37056.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async37056");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async37056.
 */
cljs.core.async.__GT_t_cljs$core$async37056 = (function cljs$core$async$__GT_t_cljs$core$async37056(flag,meta37057){
return (new cljs.core.async.t_cljs$core$async37056(flag,meta37057));
});


cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
return (new cljs.core.async.t_cljs$core$async37056(flag,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37066 = (function (flag,cb,meta37067){
this.flag = flag;
this.cb = cb;
this.meta37067 = meta37067;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async37066.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_37068,meta37067__$1){
var self__ = this;
var _37068__$1 = this;
return (new cljs.core.async.t_cljs$core$async37066(self__.flag,self__.cb,meta37067__$1));
}));

(cljs.core.async.t_cljs$core$async37066.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_37068){
var self__ = this;
var _37068__$1 = this;
return self__.meta37067;
}));

(cljs.core.async.t_cljs$core$async37066.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async37066.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async37066.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async37066.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async37066.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta37067","meta37067",-834480092,null)], null);
}));

(cljs.core.async.t_cljs$core$async37066.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async37066.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37066");

(cljs.core.async.t_cljs$core$async37066.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async37066");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async37066.
 */
cljs.core.async.__GT_t_cljs$core$async37066 = (function cljs$core$async$__GT_t_cljs$core$async37066(flag,cb,meta37067){
return (new cljs.core.async.t_cljs$core$async37066(flag,cb,meta37067));
});


cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
return (new cljs.core.async.t_cljs$core$async37066(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var ports__$1 = cljs.core.vec(ports);
var n = cljs.core.count(ports__$1);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports__$1,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null, (0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null, (1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,ports__$1,n,idxs,priority){
return (function (p1__37083_SHARP_){
var G__37092 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__37083_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__37092) : fret.call(null, G__37092));
});})(i,val,idx,port,wport,flag,ports__$1,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,ports__$1,n,idxs,priority){
return (function (p1__37084_SHARP_){
var G__37094 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__37084_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__37094) : fret.call(null, G__37094));
});})(i,idx,port,wport,flag,ports__$1,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__5002__auto__ = wport;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return port;
}
})()], null));
} else {
var G__40783 = (i + (1));
i = G__40783;
continue;
}
} else {
return null;
}
break;
}
})();
var or__5002__auto__ = ret;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5823__auto__ = (function (){var and__5000__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null, );
if(cljs.core.truth_(and__5000__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null, );
} else {
return and__5000__auto__;
}
})();
if(cljs.core.truth_(temp__5823__auto__)){
var got = temp__5823__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5732__auto__ = [];
var len__5726__auto___40784 = arguments.length;
var i__5727__auto___40785 = (0);
while(true){
if((i__5727__auto___40785 < len__5726__auto___40784)){
args__5732__auto__.push((arguments[i__5727__auto___40785]));

var G__40786 = (i__5727__auto___40785 + (1));
i__5727__auto___40785 = G__40786;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__37119){
var map__37120 = p__37119;
var map__37120__$1 = cljs.core.__destructure_map(map__37120);
var opts = map__37120__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq37113){
var G__37114 = cljs.core.first(seq37113);
var seq37113__$1 = cljs.core.next(seq37113);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__37114,seq37113__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__37127 = arguments.length;
switch (G__37127) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__34495__auto___40797 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34496__auto__ = (function (){var switch__34331__auto__ = (function (state_37278){
var state_val_37279 = (state_37278[(1)]);
if((state_val_37279 === (7))){
var inst_37263 = (state_37278[(2)]);
var state_37278__$1 = state_37278;
var statearr_37280_40798 = state_37278__$1;
(statearr_37280_40798[(2)] = inst_37263);

(statearr_37280_40798[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37279 === (1))){
var state_37278__$1 = state_37278;
var statearr_37281_40799 = state_37278__$1;
(statearr_37281_40799[(2)] = null);

(statearr_37281_40799[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37279 === (4))){
var inst_37183 = (state_37278[(7)]);
var inst_37183__$1 = (state_37278[(2)]);
var inst_37196 = (inst_37183__$1 == null);
var state_37278__$1 = (function (){var statearr_37282 = state_37278;
(statearr_37282[(7)] = inst_37183__$1);

return statearr_37282;
})();
if(cljs.core.truth_(inst_37196)){
var statearr_37283_40813 = state_37278__$1;
(statearr_37283_40813[(1)] = (5));

} else {
var statearr_37284_40814 = state_37278__$1;
(statearr_37284_40814[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37279 === (13))){
var state_37278__$1 = state_37278;
var statearr_37285_40817 = state_37278__$1;
(statearr_37285_40817[(2)] = null);

(statearr_37285_40817[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37279 === (6))){
var inst_37183 = (state_37278[(7)]);
var state_37278__$1 = state_37278;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37278__$1,(11),to,inst_37183);
} else {
if((state_val_37279 === (3))){
var inst_37269 = (state_37278[(2)]);
var state_37278__$1 = state_37278;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37278__$1,inst_37269);
} else {
if((state_val_37279 === (12))){
var state_37278__$1 = state_37278;
var statearr_37286_40823 = state_37278__$1;
(statearr_37286_40823[(2)] = null);

(statearr_37286_40823[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37279 === (2))){
var state_37278__$1 = state_37278;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37278__$1,(4),from);
} else {
if((state_val_37279 === (11))){
var inst_37256 = (state_37278[(2)]);
var state_37278__$1 = state_37278;
if(cljs.core.truth_(inst_37256)){
var statearr_37287_40828 = state_37278__$1;
(statearr_37287_40828[(1)] = (12));

} else {
var statearr_37288_40829 = state_37278__$1;
(statearr_37288_40829[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37279 === (9))){
var state_37278__$1 = state_37278;
var statearr_37289_40832 = state_37278__$1;
(statearr_37289_40832[(2)] = null);

(statearr_37289_40832[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37279 === (5))){
var state_37278__$1 = state_37278;
if(cljs.core.truth_(close_QMARK_)){
var statearr_37290_40836 = state_37278__$1;
(statearr_37290_40836[(1)] = (8));

} else {
var statearr_37291_40837 = state_37278__$1;
(statearr_37291_40837[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37279 === (14))){
var inst_37261 = (state_37278[(2)]);
var state_37278__$1 = state_37278;
var statearr_37292_40838 = state_37278__$1;
(statearr_37292_40838[(2)] = inst_37261);

(statearr_37292_40838[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37279 === (10))){
var inst_37253 = (state_37278[(2)]);
var state_37278__$1 = state_37278;
var statearr_37293_40839 = state_37278__$1;
(statearr_37293_40839[(2)] = inst_37253);

(statearr_37293_40839[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37279 === (8))){
var inst_37200 = cljs.core.async.close_BANG_(to);
var state_37278__$1 = state_37278;
var statearr_37294_40848 = state_37278__$1;
(statearr_37294_40848[(2)] = inst_37200);

(statearr_37294_40848[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__34332__auto__ = null;
var cljs$core$async$state_machine__34332__auto____0 = (function (){
var statearr_37310 = [null,null,null,null,null,null,null,null];
(statearr_37310[(0)] = cljs$core$async$state_machine__34332__auto__);

(statearr_37310[(1)] = (1));

return statearr_37310;
});
var cljs$core$async$state_machine__34332__auto____1 = (function (state_37278){
while(true){
var ret_value__34333__auto__ = (function (){try{while(true){
var result__34334__auto__ = switch__34331__auto__(state_37278);
if(cljs.core.keyword_identical_QMARK_(result__34334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34334__auto__;
}
break;
}
}catch (e37311){var ex__34335__auto__ = e37311;
var statearr_37312_40852 = state_37278;
(statearr_37312_40852[(2)] = ex__34335__auto__);


if(cljs.core.seq((state_37278[(4)]))){
var statearr_37313_40853 = state_37278;
(statearr_37313_40853[(1)] = cljs.core.first((state_37278[(4)])));

} else {
throw ex__34335__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40858 = state_37278;
state_37278 = G__40858;
continue;
} else {
return ret_value__34333__auto__;
}
break;
}
});
cljs$core$async$state_machine__34332__auto__ = function(state_37278){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__34332__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__34332__auto____1.call(this,state_37278);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__34332__auto____0;
cljs$core$async$state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__34332__auto____1;
return cljs$core$async$state_machine__34332__auto__;
})()
})();
var state__34497__auto__ = (function (){var statearr_37314 = f__34496__auto__();
(statearr_37314[(6)] = c__34495__auto___40797);

return statearr_37314;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34497__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process__$1 = (function (p__37315){
var vec__37316 = p__37315;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37316,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37316,(1),null);
var job = vec__37316;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__34495__auto___40874 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34496__auto__ = (function (){var switch__34331__auto__ = (function (state_37327){
var state_val_37328 = (state_37327[(1)]);
if((state_val_37328 === (1))){
var state_37327__$1 = state_37327;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37327__$1,(2),res,v);
} else {
if((state_val_37328 === (2))){
var inst_37324 = (state_37327[(2)]);
var inst_37325 = cljs.core.async.close_BANG_(res);
var state_37327__$1 = (function (){var statearr_37332 = state_37327;
(statearr_37332[(7)] = inst_37324);

return statearr_37332;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_37327__$1,inst_37325);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__34332__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__34332__auto____0 = (function (){
var statearr_37344 = [null,null,null,null,null,null,null,null];
(statearr_37344[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__34332__auto__);

(statearr_37344[(1)] = (1));

return statearr_37344;
});
var cljs$core$async$pipeline_STAR__$_state_machine__34332__auto____1 = (function (state_37327){
while(true){
var ret_value__34333__auto__ = (function (){try{while(true){
var result__34334__auto__ = switch__34331__auto__(state_37327);
if(cljs.core.keyword_identical_QMARK_(result__34334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34334__auto__;
}
break;
}
}catch (e37346){var ex__34335__auto__ = e37346;
var statearr_37347_40883 = state_37327;
(statearr_37347_40883[(2)] = ex__34335__auto__);


if(cljs.core.seq((state_37327[(4)]))){
var statearr_37348_40884 = state_37327;
(statearr_37348_40884[(1)] = cljs.core.first((state_37327[(4)])));

} else {
throw ex__34335__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40885 = state_37327;
state_37327 = G__40885;
continue;
} else {
return ret_value__34333__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__34332__auto__ = function(state_37327){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__34332__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__34332__auto____1.call(this,state_37327);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__34332__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__34332__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__34332__auto__;
})()
})();
var state__34497__auto__ = (function (){var statearr_37349 = f__34496__auto__();
(statearr_37349[(6)] = c__34495__auto___40874);

return statearr_37349;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34497__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__37350){
var vec__37351 = p__37350;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37351,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37351,(1),null);
var job = vec__37351;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null, v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__5593__auto___40891 = n;
var __40892 = (0);
while(true){
if((__40892 < n__5593__auto___40891)){
var G__37354_40893 = type;
var G__37354_40894__$1 = (((G__37354_40893 instanceof cljs.core.Keyword))?G__37354_40893.fqn:null);
switch (G__37354_40894__$1) {
case "compute":
var c__34495__auto___40896 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__40892,c__34495__auto___40896,G__37354_40893,G__37354_40894__$1,n__5593__auto___40891,jobs,results,process__$1,async){
return (function (){
var f__34496__auto__ = (function (){var switch__34331__auto__ = ((function (__40892,c__34495__auto___40896,G__37354_40893,G__37354_40894__$1,n__5593__auto___40891,jobs,results,process__$1,async){
return (function (state_37369){
var state_val_37370 = (state_37369[(1)]);
if((state_val_37370 === (1))){
var state_37369__$1 = state_37369;
var statearr_37371_40897 = state_37369__$1;
(statearr_37371_40897[(2)] = null);

(statearr_37371_40897[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37370 === (2))){
var state_37369__$1 = state_37369;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37369__$1,(4),jobs);
} else {
if((state_val_37370 === (3))){
var inst_37366 = (state_37369[(2)]);
var state_37369__$1 = state_37369;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37369__$1,inst_37366);
} else {
if((state_val_37370 === (4))){
var inst_37358 = (state_37369[(2)]);
var inst_37359 = process__$1(inst_37358);
var state_37369__$1 = state_37369;
if(cljs.core.truth_(inst_37359)){
var statearr_37372_40899 = state_37369__$1;
(statearr_37372_40899[(1)] = (5));

} else {
var statearr_37373_40916 = state_37369__$1;
(statearr_37373_40916[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37370 === (5))){
var state_37369__$1 = state_37369;
var statearr_37374_40920 = state_37369__$1;
(statearr_37374_40920[(2)] = null);

(statearr_37374_40920[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37370 === (6))){
var state_37369__$1 = state_37369;
var statearr_37375_40925 = state_37369__$1;
(statearr_37375_40925[(2)] = null);

(statearr_37375_40925[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37370 === (7))){
var inst_37364 = (state_37369[(2)]);
var state_37369__$1 = state_37369;
var statearr_37376_40929 = state_37369__$1;
(statearr_37376_40929[(2)] = inst_37364);

(statearr_37376_40929[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__40892,c__34495__auto___40896,G__37354_40893,G__37354_40894__$1,n__5593__auto___40891,jobs,results,process__$1,async))
;
return ((function (__40892,switch__34331__auto__,c__34495__auto___40896,G__37354_40893,G__37354_40894__$1,n__5593__auto___40891,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__34332__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__34332__auto____0 = (function (){
var statearr_37377 = [null,null,null,null,null,null,null];
(statearr_37377[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__34332__auto__);

(statearr_37377[(1)] = (1));

return statearr_37377;
});
var cljs$core$async$pipeline_STAR__$_state_machine__34332__auto____1 = (function (state_37369){
while(true){
var ret_value__34333__auto__ = (function (){try{while(true){
var result__34334__auto__ = switch__34331__auto__(state_37369);
if(cljs.core.keyword_identical_QMARK_(result__34334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34334__auto__;
}
break;
}
}catch (e37378){var ex__34335__auto__ = e37378;
var statearr_37379_40939 = state_37369;
(statearr_37379_40939[(2)] = ex__34335__auto__);


if(cljs.core.seq((state_37369[(4)]))){
var statearr_37380_40941 = state_37369;
(statearr_37380_40941[(1)] = cljs.core.first((state_37369[(4)])));

} else {
throw ex__34335__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40942 = state_37369;
state_37369 = G__40942;
continue;
} else {
return ret_value__34333__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__34332__auto__ = function(state_37369){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__34332__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__34332__auto____1.call(this,state_37369);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__34332__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__34332__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__34332__auto__;
})()
;})(__40892,switch__34331__auto__,c__34495__auto___40896,G__37354_40893,G__37354_40894__$1,n__5593__auto___40891,jobs,results,process__$1,async))
})();
var state__34497__auto__ = (function (){var statearr_37382 = f__34496__auto__();
(statearr_37382[(6)] = c__34495__auto___40896);

return statearr_37382;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34497__auto__);
});})(__40892,c__34495__auto___40896,G__37354_40893,G__37354_40894__$1,n__5593__auto___40891,jobs,results,process__$1,async))
);


break;
case "async":
var c__34495__auto___40955 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__40892,c__34495__auto___40955,G__37354_40893,G__37354_40894__$1,n__5593__auto___40891,jobs,results,process__$1,async){
return (function (){
var f__34496__auto__ = (function (){var switch__34331__auto__ = ((function (__40892,c__34495__auto___40955,G__37354_40893,G__37354_40894__$1,n__5593__auto___40891,jobs,results,process__$1,async){
return (function (state_37397){
var state_val_37398 = (state_37397[(1)]);
if((state_val_37398 === (1))){
var state_37397__$1 = state_37397;
var statearr_37402_40960 = state_37397__$1;
(statearr_37402_40960[(2)] = null);

(statearr_37402_40960[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37398 === (2))){
var state_37397__$1 = state_37397;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37397__$1,(4),jobs);
} else {
if((state_val_37398 === (3))){
var inst_37395 = (state_37397[(2)]);
var state_37397__$1 = state_37397;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37397__$1,inst_37395);
} else {
if((state_val_37398 === (4))){
var inst_37387 = (state_37397[(2)]);
var inst_37388 = async(inst_37387);
var state_37397__$1 = state_37397;
if(cljs.core.truth_(inst_37388)){
var statearr_37407_40962 = state_37397__$1;
(statearr_37407_40962[(1)] = (5));

} else {
var statearr_37408_40963 = state_37397__$1;
(statearr_37408_40963[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37398 === (5))){
var state_37397__$1 = state_37397;
var statearr_37409_40965 = state_37397__$1;
(statearr_37409_40965[(2)] = null);

(statearr_37409_40965[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37398 === (6))){
var state_37397__$1 = state_37397;
var statearr_37414_40966 = state_37397__$1;
(statearr_37414_40966[(2)] = null);

(statearr_37414_40966[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37398 === (7))){
var inst_37393 = (state_37397[(2)]);
var state_37397__$1 = state_37397;
var statearr_37415_40968 = state_37397__$1;
(statearr_37415_40968[(2)] = inst_37393);

(statearr_37415_40968[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__40892,c__34495__auto___40955,G__37354_40893,G__37354_40894__$1,n__5593__auto___40891,jobs,results,process__$1,async))
;
return ((function (__40892,switch__34331__auto__,c__34495__auto___40955,G__37354_40893,G__37354_40894__$1,n__5593__auto___40891,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__34332__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__34332__auto____0 = (function (){
var statearr_37418 = [null,null,null,null,null,null,null];
(statearr_37418[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__34332__auto__);

(statearr_37418[(1)] = (1));

return statearr_37418;
});
var cljs$core$async$pipeline_STAR__$_state_machine__34332__auto____1 = (function (state_37397){
while(true){
var ret_value__34333__auto__ = (function (){try{while(true){
var result__34334__auto__ = switch__34331__auto__(state_37397);
if(cljs.core.keyword_identical_QMARK_(result__34334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34334__auto__;
}
break;
}
}catch (e37419){var ex__34335__auto__ = e37419;
var statearr_37420_40989 = state_37397;
(statearr_37420_40989[(2)] = ex__34335__auto__);


if(cljs.core.seq((state_37397[(4)]))){
var statearr_37421_40990 = state_37397;
(statearr_37421_40990[(1)] = cljs.core.first((state_37397[(4)])));

} else {
throw ex__34335__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40996 = state_37397;
state_37397 = G__40996;
continue;
} else {
return ret_value__34333__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__34332__auto__ = function(state_37397){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__34332__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__34332__auto____1.call(this,state_37397);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__34332__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__34332__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__34332__auto__;
})()
;})(__40892,switch__34331__auto__,c__34495__auto___40955,G__37354_40893,G__37354_40894__$1,n__5593__auto___40891,jobs,results,process__$1,async))
})();
var state__34497__auto__ = (function (){var statearr_37423 = f__34496__auto__();
(statearr_37423[(6)] = c__34495__auto___40955);

return statearr_37423;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34497__auto__);
});})(__40892,c__34495__auto___40955,G__37354_40893,G__37354_40894__$1,n__5593__auto___40891,jobs,results,process__$1,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__37354_40894__$1)].join('')));

}

var G__40997 = (__40892 + (1));
__40892 = G__40997;
continue;
} else {
}
break;
}

var c__34495__auto___40998 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34496__auto__ = (function (){var switch__34331__auto__ = (function (state_37448){
var state_val_37449 = (state_37448[(1)]);
if((state_val_37449 === (7))){
var inst_37444 = (state_37448[(2)]);
var state_37448__$1 = state_37448;
var statearr_37451_40999 = state_37448__$1;
(statearr_37451_40999[(2)] = inst_37444);

(statearr_37451_40999[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37449 === (1))){
var state_37448__$1 = state_37448;
var statearr_37452_41004 = state_37448__$1;
(statearr_37452_41004[(2)] = null);

(statearr_37452_41004[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37449 === (4))){
var inst_37428 = (state_37448[(7)]);
var inst_37428__$1 = (state_37448[(2)]);
var inst_37429 = (inst_37428__$1 == null);
var state_37448__$1 = (function (){var statearr_37454 = state_37448;
(statearr_37454[(7)] = inst_37428__$1);

return statearr_37454;
})();
if(cljs.core.truth_(inst_37429)){
var statearr_37455_41013 = state_37448__$1;
(statearr_37455_41013[(1)] = (5));

} else {
var statearr_37456_41015 = state_37448__$1;
(statearr_37456_41015[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37449 === (6))){
var inst_37428 = (state_37448[(7)]);
var inst_37433 = (state_37448[(8)]);
var inst_37433__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_37434 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37435 = [inst_37428,inst_37433__$1];
var inst_37436 = (new cljs.core.PersistentVector(null,2,(5),inst_37434,inst_37435,null));
var state_37448__$1 = (function (){var statearr_37458 = state_37448;
(statearr_37458[(8)] = inst_37433__$1);

return statearr_37458;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37448__$1,(8),jobs,inst_37436);
} else {
if((state_val_37449 === (3))){
var inst_37446 = (state_37448[(2)]);
var state_37448__$1 = state_37448;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37448__$1,inst_37446);
} else {
if((state_val_37449 === (2))){
var state_37448__$1 = state_37448;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37448__$1,(4),from);
} else {
if((state_val_37449 === (9))){
var inst_37441 = (state_37448[(2)]);
var state_37448__$1 = (function (){var statearr_37460 = state_37448;
(statearr_37460[(9)] = inst_37441);

return statearr_37460;
})();
var statearr_37461_41018 = state_37448__$1;
(statearr_37461_41018[(2)] = null);

(statearr_37461_41018[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37449 === (5))){
var inst_37431 = cljs.core.async.close_BANG_(jobs);
var state_37448__$1 = state_37448;
var statearr_37462_41021 = state_37448__$1;
(statearr_37462_41021[(2)] = inst_37431);

(statearr_37462_41021[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37449 === (8))){
var inst_37433 = (state_37448[(8)]);
var inst_37439 = (state_37448[(2)]);
var state_37448__$1 = (function (){var statearr_37463 = state_37448;
(statearr_37463[(10)] = inst_37439);

return statearr_37463;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37448__$1,(9),results,inst_37433);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__34332__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__34332__auto____0 = (function (){
var statearr_37464 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_37464[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__34332__auto__);

(statearr_37464[(1)] = (1));

return statearr_37464;
});
var cljs$core$async$pipeline_STAR__$_state_machine__34332__auto____1 = (function (state_37448){
while(true){
var ret_value__34333__auto__ = (function (){try{while(true){
var result__34334__auto__ = switch__34331__auto__(state_37448);
if(cljs.core.keyword_identical_QMARK_(result__34334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34334__auto__;
}
break;
}
}catch (e37465){var ex__34335__auto__ = e37465;
var statearr_37466_41044 = state_37448;
(statearr_37466_41044[(2)] = ex__34335__auto__);


if(cljs.core.seq((state_37448[(4)]))){
var statearr_37467_41049 = state_37448;
(statearr_37467_41049[(1)] = cljs.core.first((state_37448[(4)])));

} else {
throw ex__34335__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41052 = state_37448;
state_37448 = G__41052;
continue;
} else {
return ret_value__34333__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__34332__auto__ = function(state_37448){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__34332__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__34332__auto____1.call(this,state_37448);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__34332__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__34332__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__34332__auto__;
})()
})();
var state__34497__auto__ = (function (){var statearr_37469 = f__34496__auto__();
(statearr_37469[(6)] = c__34495__auto___40998);

return statearr_37469;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34497__auto__);
}));


var c__34495__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34496__auto__ = (function (){var switch__34331__auto__ = (function (state_37517){
var state_val_37518 = (state_37517[(1)]);
if((state_val_37518 === (7))){
var inst_37513 = (state_37517[(2)]);
var state_37517__$1 = state_37517;
var statearr_37520_41062 = state_37517__$1;
(statearr_37520_41062[(2)] = inst_37513);

(statearr_37520_41062[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37518 === (20))){
var state_37517__$1 = state_37517;
var statearr_37522_41066 = state_37517__$1;
(statearr_37522_41066[(2)] = null);

(statearr_37522_41066[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37518 === (1))){
var state_37517__$1 = state_37517;
var statearr_37526_41068 = state_37517__$1;
(statearr_37526_41068[(2)] = null);

(statearr_37526_41068[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37518 === (4))){
var inst_37477 = (state_37517[(7)]);
var inst_37477__$1 = (state_37517[(2)]);
var inst_37478 = (inst_37477__$1 == null);
var state_37517__$1 = (function (){var statearr_37527 = state_37517;
(statearr_37527[(7)] = inst_37477__$1);

return statearr_37527;
})();
if(cljs.core.truth_(inst_37478)){
var statearr_37528_41077 = state_37517__$1;
(statearr_37528_41077[(1)] = (5));

} else {
var statearr_37529_41079 = state_37517__$1;
(statearr_37529_41079[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37518 === (15))){
var inst_37495 = (state_37517[(8)]);
var state_37517__$1 = state_37517;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37517__$1,(18),to,inst_37495);
} else {
if((state_val_37518 === (21))){
var inst_37508 = (state_37517[(2)]);
var state_37517__$1 = state_37517;
var statearr_37534_41084 = state_37517__$1;
(statearr_37534_41084[(2)] = inst_37508);

(statearr_37534_41084[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37518 === (13))){
var inst_37510 = (state_37517[(2)]);
var state_37517__$1 = (function (){var statearr_37535 = state_37517;
(statearr_37535[(9)] = inst_37510);

return statearr_37535;
})();
var statearr_37536_41085 = state_37517__$1;
(statearr_37536_41085[(2)] = null);

(statearr_37536_41085[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37518 === (6))){
var inst_37477 = (state_37517[(7)]);
var state_37517__$1 = state_37517;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37517__$1,(11),inst_37477);
} else {
if((state_val_37518 === (17))){
var inst_37503 = (state_37517[(2)]);
var state_37517__$1 = state_37517;
if(cljs.core.truth_(inst_37503)){
var statearr_37538_41088 = state_37517__$1;
(statearr_37538_41088[(1)] = (19));

} else {
var statearr_37539_41091 = state_37517__$1;
(statearr_37539_41091[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37518 === (3))){
var inst_37515 = (state_37517[(2)]);
var state_37517__$1 = state_37517;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37517__$1,inst_37515);
} else {
if((state_val_37518 === (12))){
var inst_37492 = (state_37517[(10)]);
var state_37517__$1 = state_37517;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37517__$1,(14),inst_37492);
} else {
if((state_val_37518 === (2))){
var state_37517__$1 = state_37517;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37517__$1,(4),results);
} else {
if((state_val_37518 === (19))){
var state_37517__$1 = state_37517;
var statearr_37542_41096 = state_37517__$1;
(statearr_37542_41096[(2)] = null);

(statearr_37542_41096[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37518 === (11))){
var inst_37492 = (state_37517[(2)]);
var state_37517__$1 = (function (){var statearr_37543 = state_37517;
(statearr_37543[(10)] = inst_37492);

return statearr_37543;
})();
var statearr_37545_41098 = state_37517__$1;
(statearr_37545_41098[(2)] = null);

(statearr_37545_41098[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37518 === (9))){
var state_37517__$1 = state_37517;
var statearr_37546_41099 = state_37517__$1;
(statearr_37546_41099[(2)] = null);

(statearr_37546_41099[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37518 === (5))){
var state_37517__$1 = state_37517;
if(cljs.core.truth_(close_QMARK_)){
var statearr_37547_41101 = state_37517__$1;
(statearr_37547_41101[(1)] = (8));

} else {
var statearr_37548_41102 = state_37517__$1;
(statearr_37548_41102[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37518 === (14))){
var inst_37495 = (state_37517[(8)]);
var inst_37497 = (state_37517[(11)]);
var inst_37495__$1 = (state_37517[(2)]);
var inst_37496 = (inst_37495__$1 == null);
var inst_37497__$1 = cljs.core.not(inst_37496);
var state_37517__$1 = (function (){var statearr_37551 = state_37517;
(statearr_37551[(8)] = inst_37495__$1);

(statearr_37551[(11)] = inst_37497__$1);

return statearr_37551;
})();
if(inst_37497__$1){
var statearr_37552_41105 = state_37517__$1;
(statearr_37552_41105[(1)] = (15));

} else {
var statearr_37556_41107 = state_37517__$1;
(statearr_37556_41107[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37518 === (16))){
var inst_37497 = (state_37517[(11)]);
var state_37517__$1 = state_37517;
var statearr_37557_41110 = state_37517__$1;
(statearr_37557_41110[(2)] = inst_37497);

(statearr_37557_41110[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37518 === (10))){
var inst_37489 = (state_37517[(2)]);
var state_37517__$1 = state_37517;
var statearr_37559_41115 = state_37517__$1;
(statearr_37559_41115[(2)] = inst_37489);

(statearr_37559_41115[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37518 === (18))){
var inst_37500 = (state_37517[(2)]);
var state_37517__$1 = state_37517;
var statearr_37560_41117 = state_37517__$1;
(statearr_37560_41117[(2)] = inst_37500);

(statearr_37560_41117[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37518 === (8))){
var inst_37481 = cljs.core.async.close_BANG_(to);
var state_37517__$1 = state_37517;
var statearr_37561_41123 = state_37517__$1;
(statearr_37561_41123[(2)] = inst_37481);

(statearr_37561_41123[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__34332__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__34332__auto____0 = (function (){
var statearr_37562 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37562[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__34332__auto__);

(statearr_37562[(1)] = (1));

return statearr_37562;
});
var cljs$core$async$pipeline_STAR__$_state_machine__34332__auto____1 = (function (state_37517){
while(true){
var ret_value__34333__auto__ = (function (){try{while(true){
var result__34334__auto__ = switch__34331__auto__(state_37517);
if(cljs.core.keyword_identical_QMARK_(result__34334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34334__auto__;
}
break;
}
}catch (e37572){var ex__34335__auto__ = e37572;
var statearr_37573_41125 = state_37517;
(statearr_37573_41125[(2)] = ex__34335__auto__);


if(cljs.core.seq((state_37517[(4)]))){
var statearr_37574_41126 = state_37517;
(statearr_37574_41126[(1)] = cljs.core.first((state_37517[(4)])));

} else {
throw ex__34335__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41127 = state_37517;
state_37517 = G__41127;
continue;
} else {
return ret_value__34333__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__34332__auto__ = function(state_37517){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__34332__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__34332__auto____1.call(this,state_37517);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__34332__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__34332__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__34332__auto__;
})()
})();
var state__34497__auto__ = (function (){var statearr_37590 = f__34496__auto__();
(statearr_37590[(6)] = c__34495__auto__);

return statearr_37590;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34497__auto__);
}));

return c__34495__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__37593 = arguments.length;
switch (G__37593) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__37604 = arguments.length;
switch (G__37604) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__37607 = arguments.length;
switch (G__37607) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__34495__auto___41160 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34496__auto__ = (function (){var switch__34331__auto__ = (function (state_37635){
var state_val_37636 = (state_37635[(1)]);
if((state_val_37636 === (7))){
var inst_37631 = (state_37635[(2)]);
var state_37635__$1 = state_37635;
var statearr_37637_41161 = state_37635__$1;
(statearr_37637_41161[(2)] = inst_37631);

(statearr_37637_41161[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37636 === (1))){
var state_37635__$1 = state_37635;
var statearr_37638_41166 = state_37635__$1;
(statearr_37638_41166[(2)] = null);

(statearr_37638_41166[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37636 === (4))){
var inst_37612 = (state_37635[(7)]);
var inst_37612__$1 = (state_37635[(2)]);
var inst_37613 = (inst_37612__$1 == null);
var state_37635__$1 = (function (){var statearr_37639 = state_37635;
(statearr_37639[(7)] = inst_37612__$1);

return statearr_37639;
})();
if(cljs.core.truth_(inst_37613)){
var statearr_37640_41170 = state_37635__$1;
(statearr_37640_41170[(1)] = (5));

} else {
var statearr_37641_41171 = state_37635__$1;
(statearr_37641_41171[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37636 === (13))){
var state_37635__$1 = state_37635;
var statearr_37642_41174 = state_37635__$1;
(statearr_37642_41174[(2)] = null);

(statearr_37642_41174[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37636 === (6))){
var inst_37612 = (state_37635[(7)]);
var inst_37618 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_37612) : p.call(null, inst_37612));
var state_37635__$1 = state_37635;
if(cljs.core.truth_(inst_37618)){
var statearr_37643_41175 = state_37635__$1;
(statearr_37643_41175[(1)] = (9));

} else {
var statearr_37645_41176 = state_37635__$1;
(statearr_37645_41176[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37636 === (3))){
var inst_37633 = (state_37635[(2)]);
var state_37635__$1 = state_37635;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37635__$1,inst_37633);
} else {
if((state_val_37636 === (12))){
var state_37635__$1 = state_37635;
var statearr_37646_41181 = state_37635__$1;
(statearr_37646_41181[(2)] = null);

(statearr_37646_41181[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37636 === (2))){
var state_37635__$1 = state_37635;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37635__$1,(4),ch);
} else {
if((state_val_37636 === (11))){
var inst_37612 = (state_37635[(7)]);
var inst_37622 = (state_37635[(2)]);
var state_37635__$1 = state_37635;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37635__$1,(8),inst_37622,inst_37612);
} else {
if((state_val_37636 === (9))){
var state_37635__$1 = state_37635;
var statearr_37651_41184 = state_37635__$1;
(statearr_37651_41184[(2)] = tc);

(statearr_37651_41184[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37636 === (5))){
var inst_37615 = cljs.core.async.close_BANG_(tc);
var inst_37616 = cljs.core.async.close_BANG_(fc);
var state_37635__$1 = (function (){var statearr_37652 = state_37635;
(statearr_37652[(8)] = inst_37615);

return statearr_37652;
})();
var statearr_37653_41185 = state_37635__$1;
(statearr_37653_41185[(2)] = inst_37616);

(statearr_37653_41185[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37636 === (14))){
var inst_37629 = (state_37635[(2)]);
var state_37635__$1 = state_37635;
var statearr_37654_41187 = state_37635__$1;
(statearr_37654_41187[(2)] = inst_37629);

(statearr_37654_41187[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37636 === (10))){
var state_37635__$1 = state_37635;
var statearr_37655_41188 = state_37635__$1;
(statearr_37655_41188[(2)] = fc);

(statearr_37655_41188[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37636 === (8))){
var inst_37624 = (state_37635[(2)]);
var state_37635__$1 = state_37635;
if(cljs.core.truth_(inst_37624)){
var statearr_37659_41190 = state_37635__$1;
(statearr_37659_41190[(1)] = (12));

} else {
var statearr_37660_41191 = state_37635__$1;
(statearr_37660_41191[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__34332__auto__ = null;
var cljs$core$async$state_machine__34332__auto____0 = (function (){
var statearr_37663 = [null,null,null,null,null,null,null,null,null];
(statearr_37663[(0)] = cljs$core$async$state_machine__34332__auto__);

(statearr_37663[(1)] = (1));

return statearr_37663;
});
var cljs$core$async$state_machine__34332__auto____1 = (function (state_37635){
while(true){
var ret_value__34333__auto__ = (function (){try{while(true){
var result__34334__auto__ = switch__34331__auto__(state_37635);
if(cljs.core.keyword_identical_QMARK_(result__34334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34334__auto__;
}
break;
}
}catch (e37665){var ex__34335__auto__ = e37665;
var statearr_37667_41196 = state_37635;
(statearr_37667_41196[(2)] = ex__34335__auto__);


if(cljs.core.seq((state_37635[(4)]))){
var statearr_37669_41197 = state_37635;
(statearr_37669_41197[(1)] = cljs.core.first((state_37635[(4)])));

} else {
throw ex__34335__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41198 = state_37635;
state_37635 = G__41198;
continue;
} else {
return ret_value__34333__auto__;
}
break;
}
});
cljs$core$async$state_machine__34332__auto__ = function(state_37635){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__34332__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__34332__auto____1.call(this,state_37635);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__34332__auto____0;
cljs$core$async$state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__34332__auto____1;
return cljs$core$async$state_machine__34332__auto__;
})()
})();
var state__34497__auto__ = (function (){var statearr_37672 = f__34496__auto__();
(statearr_37672[(6)] = c__34495__auto___41160);

return statearr_37672;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34497__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__34495__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34496__auto__ = (function (){var switch__34331__auto__ = (function (state_37696){
var state_val_37697 = (state_37696[(1)]);
if((state_val_37697 === (7))){
var inst_37692 = (state_37696[(2)]);
var state_37696__$1 = state_37696;
var statearr_37702_41201 = state_37696__$1;
(statearr_37702_41201[(2)] = inst_37692);

(statearr_37702_41201[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37697 === (1))){
var inst_37675 = init;
var inst_37676 = inst_37675;
var state_37696__$1 = (function (){var statearr_37703 = state_37696;
(statearr_37703[(7)] = inst_37676);

return statearr_37703;
})();
var statearr_37704_41205 = state_37696__$1;
(statearr_37704_41205[(2)] = null);

(statearr_37704_41205[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37697 === (4))){
var inst_37679 = (state_37696[(8)]);
var inst_37679__$1 = (state_37696[(2)]);
var inst_37680 = (inst_37679__$1 == null);
var state_37696__$1 = (function (){var statearr_37705 = state_37696;
(statearr_37705[(8)] = inst_37679__$1);

return statearr_37705;
})();
if(cljs.core.truth_(inst_37680)){
var statearr_37706_41208 = state_37696__$1;
(statearr_37706_41208[(1)] = (5));

} else {
var statearr_37707_41209 = state_37696__$1;
(statearr_37707_41209[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37697 === (6))){
var inst_37676 = (state_37696[(7)]);
var inst_37679 = (state_37696[(8)]);
var inst_37683 = (state_37696[(9)]);
var inst_37683__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_37676,inst_37679) : f.call(null, inst_37676,inst_37679));
var inst_37684 = cljs.core.reduced_QMARK_(inst_37683__$1);
var state_37696__$1 = (function (){var statearr_37715 = state_37696;
(statearr_37715[(9)] = inst_37683__$1);

return statearr_37715;
})();
if(inst_37684){
var statearr_37717_41211 = state_37696__$1;
(statearr_37717_41211[(1)] = (8));

} else {
var statearr_37718_41213 = state_37696__$1;
(statearr_37718_41213[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37697 === (3))){
var inst_37694 = (state_37696[(2)]);
var state_37696__$1 = state_37696;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37696__$1,inst_37694);
} else {
if((state_val_37697 === (2))){
var state_37696__$1 = state_37696;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37696__$1,(4),ch);
} else {
if((state_val_37697 === (9))){
var inst_37683 = (state_37696[(9)]);
var inst_37676 = inst_37683;
var state_37696__$1 = (function (){var statearr_37719 = state_37696;
(statearr_37719[(7)] = inst_37676);

return statearr_37719;
})();
var statearr_37720_41218 = state_37696__$1;
(statearr_37720_41218[(2)] = null);

(statearr_37720_41218[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37697 === (5))){
var inst_37676 = (state_37696[(7)]);
var state_37696__$1 = state_37696;
var statearr_37721_41223 = state_37696__$1;
(statearr_37721_41223[(2)] = inst_37676);

(statearr_37721_41223[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37697 === (10))){
var inst_37690 = (state_37696[(2)]);
var state_37696__$1 = state_37696;
var statearr_37725_41227 = state_37696__$1;
(statearr_37725_41227[(2)] = inst_37690);

(statearr_37725_41227[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37697 === (8))){
var inst_37683 = (state_37696[(9)]);
var inst_37686 = cljs.core.deref(inst_37683);
var state_37696__$1 = state_37696;
var statearr_37726_41229 = state_37696__$1;
(statearr_37726_41229[(2)] = inst_37686);

(statearr_37726_41229[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__34332__auto__ = null;
var cljs$core$async$reduce_$_state_machine__34332__auto____0 = (function (){
var statearr_37730 = [null,null,null,null,null,null,null,null,null,null];
(statearr_37730[(0)] = cljs$core$async$reduce_$_state_machine__34332__auto__);

(statearr_37730[(1)] = (1));

return statearr_37730;
});
var cljs$core$async$reduce_$_state_machine__34332__auto____1 = (function (state_37696){
while(true){
var ret_value__34333__auto__ = (function (){try{while(true){
var result__34334__auto__ = switch__34331__auto__(state_37696);
if(cljs.core.keyword_identical_QMARK_(result__34334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34334__auto__;
}
break;
}
}catch (e37731){var ex__34335__auto__ = e37731;
var statearr_37732_41241 = state_37696;
(statearr_37732_41241[(2)] = ex__34335__auto__);


if(cljs.core.seq((state_37696[(4)]))){
var statearr_37733_41245 = state_37696;
(statearr_37733_41245[(1)] = cljs.core.first((state_37696[(4)])));

} else {
throw ex__34335__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41248 = state_37696;
state_37696 = G__41248;
continue;
} else {
return ret_value__34333__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__34332__auto__ = function(state_37696){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__34332__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__34332__auto____1.call(this,state_37696);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__34332__auto____0;
cljs$core$async$reduce_$_state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__34332__auto____1;
return cljs$core$async$reduce_$_state_machine__34332__auto__;
})()
})();
var state__34497__auto__ = (function (){var statearr_37735 = f__34496__auto__();
(statearr_37735[(6)] = c__34495__auto__);

return statearr_37735;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34497__auto__);
}));

return c__34495__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null, f));
var c__34495__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34496__auto__ = (function (){var switch__34331__auto__ = (function (state_37743){
var state_val_37744 = (state_37743[(1)]);
if((state_val_37744 === (1))){
var inst_37738 = cljs.core.async.reduce(f__$1,init,ch);
var state_37743__$1 = state_37743;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37743__$1,(2),inst_37738);
} else {
if((state_val_37744 === (2))){
var inst_37740 = (state_37743[(2)]);
var inst_37741 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_37740) : f__$1.call(null, inst_37740));
var state_37743__$1 = state_37743;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37743__$1,inst_37741);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__34332__auto__ = null;
var cljs$core$async$transduce_$_state_machine__34332__auto____0 = (function (){
var statearr_37745 = [null,null,null,null,null,null,null];
(statearr_37745[(0)] = cljs$core$async$transduce_$_state_machine__34332__auto__);

(statearr_37745[(1)] = (1));

return statearr_37745;
});
var cljs$core$async$transduce_$_state_machine__34332__auto____1 = (function (state_37743){
while(true){
var ret_value__34333__auto__ = (function (){try{while(true){
var result__34334__auto__ = switch__34331__auto__(state_37743);
if(cljs.core.keyword_identical_QMARK_(result__34334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34334__auto__;
}
break;
}
}catch (e37746){var ex__34335__auto__ = e37746;
var statearr_37747_41266 = state_37743;
(statearr_37747_41266[(2)] = ex__34335__auto__);


if(cljs.core.seq((state_37743[(4)]))){
var statearr_37748_41272 = state_37743;
(statearr_37748_41272[(1)] = cljs.core.first((state_37743[(4)])));

} else {
throw ex__34335__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41279 = state_37743;
state_37743 = G__41279;
continue;
} else {
return ret_value__34333__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__34332__auto__ = function(state_37743){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__34332__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__34332__auto____1.call(this,state_37743);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__34332__auto____0;
cljs$core$async$transduce_$_state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__34332__auto____1;
return cljs$core$async$transduce_$_state_machine__34332__auto__;
})()
})();
var state__34497__auto__ = (function (){var statearr_37749 = f__34496__auto__();
(statearr_37749[(6)] = c__34495__auto__);

return statearr_37749;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34497__auto__);
}));

return c__34495__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__37751 = arguments.length;
switch (G__37751) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__34495__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34496__auto__ = (function (){var switch__34331__auto__ = (function (state_37793){
var state_val_37794 = (state_37793[(1)]);
if((state_val_37794 === (7))){
var inst_37775 = (state_37793[(2)]);
var state_37793__$1 = state_37793;
var statearr_37805_41311 = state_37793__$1;
(statearr_37805_41311[(2)] = inst_37775);

(statearr_37805_41311[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37794 === (1))){
var inst_37763 = cljs.core.seq(coll);
var inst_37765 = inst_37763;
var state_37793__$1 = (function (){var statearr_37806 = state_37793;
(statearr_37806[(7)] = inst_37765);

return statearr_37806;
})();
var statearr_37807_41312 = state_37793__$1;
(statearr_37807_41312[(2)] = null);

(statearr_37807_41312[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37794 === (4))){
var inst_37765 = (state_37793[(7)]);
var inst_37773 = cljs.core.first(inst_37765);
var state_37793__$1 = state_37793;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37793__$1,(7),ch,inst_37773);
} else {
if((state_val_37794 === (13))){
var inst_37787 = (state_37793[(2)]);
var state_37793__$1 = state_37793;
var statearr_37808_41321 = state_37793__$1;
(statearr_37808_41321[(2)] = inst_37787);

(statearr_37808_41321[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37794 === (6))){
var inst_37778 = (state_37793[(2)]);
var state_37793__$1 = state_37793;
if(cljs.core.truth_(inst_37778)){
var statearr_37809_41325 = state_37793__$1;
(statearr_37809_41325[(1)] = (8));

} else {
var statearr_37810_41327 = state_37793__$1;
(statearr_37810_41327[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37794 === (3))){
var inst_37791 = (state_37793[(2)]);
var state_37793__$1 = state_37793;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37793__$1,inst_37791);
} else {
if((state_val_37794 === (12))){
var state_37793__$1 = state_37793;
var statearr_37811_41334 = state_37793__$1;
(statearr_37811_41334[(2)] = null);

(statearr_37811_41334[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37794 === (2))){
var inst_37765 = (state_37793[(7)]);
var state_37793__$1 = state_37793;
if(cljs.core.truth_(inst_37765)){
var statearr_37812_41340 = state_37793__$1;
(statearr_37812_41340[(1)] = (4));

} else {
var statearr_37814_41345 = state_37793__$1;
(statearr_37814_41345[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37794 === (11))){
var inst_37784 = cljs.core.async.close_BANG_(ch);
var state_37793__$1 = state_37793;
var statearr_37815_41353 = state_37793__$1;
(statearr_37815_41353[(2)] = inst_37784);

(statearr_37815_41353[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37794 === (9))){
var state_37793__$1 = state_37793;
if(cljs.core.truth_(close_QMARK_)){
var statearr_37816_41354 = state_37793__$1;
(statearr_37816_41354[(1)] = (11));

} else {
var statearr_37817_41355 = state_37793__$1;
(statearr_37817_41355[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37794 === (5))){
var inst_37765 = (state_37793[(7)]);
var state_37793__$1 = state_37793;
var statearr_37818_41357 = state_37793__$1;
(statearr_37818_41357[(2)] = inst_37765);

(statearr_37818_41357[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37794 === (10))){
var inst_37789 = (state_37793[(2)]);
var state_37793__$1 = state_37793;
var statearr_37819_41364 = state_37793__$1;
(statearr_37819_41364[(2)] = inst_37789);

(statearr_37819_41364[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37794 === (8))){
var inst_37765 = (state_37793[(7)]);
var inst_37780 = cljs.core.next(inst_37765);
var inst_37765__$1 = inst_37780;
var state_37793__$1 = (function (){var statearr_37824 = state_37793;
(statearr_37824[(7)] = inst_37765__$1);

return statearr_37824;
})();
var statearr_37825_41369 = state_37793__$1;
(statearr_37825_41369[(2)] = null);

(statearr_37825_41369[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__34332__auto__ = null;
var cljs$core$async$state_machine__34332__auto____0 = (function (){
var statearr_37826 = [null,null,null,null,null,null,null,null];
(statearr_37826[(0)] = cljs$core$async$state_machine__34332__auto__);

(statearr_37826[(1)] = (1));

return statearr_37826;
});
var cljs$core$async$state_machine__34332__auto____1 = (function (state_37793){
while(true){
var ret_value__34333__auto__ = (function (){try{while(true){
var result__34334__auto__ = switch__34331__auto__(state_37793);
if(cljs.core.keyword_identical_QMARK_(result__34334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34334__auto__;
}
break;
}
}catch (e37828){var ex__34335__auto__ = e37828;
var statearr_37829_41378 = state_37793;
(statearr_37829_41378[(2)] = ex__34335__auto__);


if(cljs.core.seq((state_37793[(4)]))){
var statearr_37830_41382 = state_37793;
(statearr_37830_41382[(1)] = cljs.core.first((state_37793[(4)])));

} else {
throw ex__34335__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41391 = state_37793;
state_37793 = G__41391;
continue;
} else {
return ret_value__34333__auto__;
}
break;
}
});
cljs$core$async$state_machine__34332__auto__ = function(state_37793){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__34332__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__34332__auto____1.call(this,state_37793);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__34332__auto____0;
cljs$core$async$state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__34332__auto____1;
return cljs$core$async$state_machine__34332__auto__;
})()
})();
var state__34497__auto__ = (function (){var statearr_37831 = f__34496__auto__();
(statearr_37831[(6)] = c__34495__auto__);

return statearr_37831;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34497__auto__);
}));

return c__34495__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__37834 = arguments.length;
switch (G__37834) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_41403 = (function (_){
var x__5350__auto__ = (((_ == null))?null:_);
var m__5351__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5351__auto__.call(null, _));
} else {
var m__5349__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5349__auto__.call(null, _));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_41403(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_41425 = (function (m,ch,close_QMARK_){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5351__auto__.call(null, m,ch,close_QMARK_));
} else {
var m__5349__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5349__auto__.call(null, m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_41425(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_41435 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null, m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null, m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_41435(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_41443 = (function (m){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5351__auto__.call(null, m));
} else {
var m__5349__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5349__auto__.call(null, m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_41443(m);
}
});


/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37886 = (function (ch,cs,meta37887){
this.ch = ch;
this.cs = cs;
this.meta37887 = meta37887;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async37886.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_37888,meta37887__$1){
var self__ = this;
var _37888__$1 = this;
return (new cljs.core.async.t_cljs$core$async37886(self__.ch,self__.cs,meta37887__$1));
}));

(cljs.core.async.t_cljs$core$async37886.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_37888){
var self__ = this;
var _37888__$1 = this;
return self__.meta37887;
}));

(cljs.core.async.t_cljs$core$async37886.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async37886.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async37886.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async37886.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async37886.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async37886.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async37886.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta37887","meta37887",-701739122,null)], null);
}));

(cljs.core.async.t_cljs$core$async37886.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async37886.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37886");

(cljs.core.async.t_cljs$core$async37886.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async37886");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async37886.
 */
cljs.core.async.__GT_t_cljs$core$async37886 = (function cljs$core$async$__GT_t_cljs$core$async37886(ch,cs,meta37887){
return (new cljs.core.async.t_cljs$core$async37886(ch,cs,meta37887));
});


/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (new cljs.core.async.t_cljs$core$async37886(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__34495__auto___41458 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34496__auto__ = (function (){var switch__34331__auto__ = (function (state_38260){
var state_val_38261 = (state_38260[(1)]);
if((state_val_38261 === (7))){
var inst_38256 = (state_38260[(2)]);
var state_38260__$1 = state_38260;
var statearr_38262_41461 = state_38260__$1;
(statearr_38262_41461[(2)] = inst_38256);

(statearr_38262_41461[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (20))){
var inst_38082 = (state_38260[(7)]);
var inst_38110 = cljs.core.first(inst_38082);
var inst_38112 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38110,(0),null);
var inst_38113 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38110,(1),null);
var state_38260__$1 = (function (){var statearr_38263 = state_38260;
(statearr_38263[(8)] = inst_38112);

return statearr_38263;
})();
if(cljs.core.truth_(inst_38113)){
var statearr_38264_41467 = state_38260__$1;
(statearr_38264_41467[(1)] = (22));

} else {
var statearr_38265_41472 = state_38260__$1;
(statearr_38265_41472[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (27))){
var inst_38142 = (state_38260[(9)]);
var inst_38144 = (state_38260[(10)]);
var inst_38149 = (state_38260[(11)]);
var inst_38047 = (state_38260[(12)]);
var inst_38149__$1 = cljs.core._nth(inst_38142,inst_38144);
var inst_38150 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_38149__$1,inst_38047,done);
var state_38260__$1 = (function (){var statearr_38269 = state_38260;
(statearr_38269[(11)] = inst_38149__$1);

return statearr_38269;
})();
if(cljs.core.truth_(inst_38150)){
var statearr_38270_41479 = state_38260__$1;
(statearr_38270_41479[(1)] = (30));

} else {
var statearr_38271_41480 = state_38260__$1;
(statearr_38271_41480[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (1))){
var state_38260__$1 = state_38260;
var statearr_38272_41481 = state_38260__$1;
(statearr_38272_41481[(2)] = null);

(statearr_38272_41481[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (24))){
var inst_38082 = (state_38260[(7)]);
var inst_38119 = (state_38260[(2)]);
var inst_38120 = cljs.core.next(inst_38082);
var inst_38057 = inst_38120;
var inst_38058 = null;
var inst_38059 = (0);
var inst_38060 = (0);
var state_38260__$1 = (function (){var statearr_38273 = state_38260;
(statearr_38273[(13)] = inst_38119);

(statearr_38273[(14)] = inst_38057);

(statearr_38273[(15)] = inst_38058);

(statearr_38273[(16)] = inst_38059);

(statearr_38273[(17)] = inst_38060);

return statearr_38273;
})();
var statearr_38274_41482 = state_38260__$1;
(statearr_38274_41482[(2)] = null);

(statearr_38274_41482[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (39))){
var state_38260__$1 = state_38260;
var statearr_38280_41483 = state_38260__$1;
(statearr_38280_41483[(2)] = null);

(statearr_38280_41483[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (4))){
var inst_38047 = (state_38260[(12)]);
var inst_38047__$1 = (state_38260[(2)]);
var inst_38049 = (inst_38047__$1 == null);
var state_38260__$1 = (function (){var statearr_38281 = state_38260;
(statearr_38281[(12)] = inst_38047__$1);

return statearr_38281;
})();
if(cljs.core.truth_(inst_38049)){
var statearr_38282_41490 = state_38260__$1;
(statearr_38282_41490[(1)] = (5));

} else {
var statearr_38283_41491 = state_38260__$1;
(statearr_38283_41491[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (15))){
var inst_38060 = (state_38260[(17)]);
var inst_38057 = (state_38260[(14)]);
var inst_38058 = (state_38260[(15)]);
var inst_38059 = (state_38260[(16)]);
var inst_38076 = (state_38260[(2)]);
var inst_38077 = (inst_38060 + (1));
var tmp38275 = inst_38058;
var tmp38276 = inst_38057;
var tmp38277 = inst_38059;
var inst_38057__$1 = tmp38276;
var inst_38058__$1 = tmp38275;
var inst_38059__$1 = tmp38277;
var inst_38060__$1 = inst_38077;
var state_38260__$1 = (function (){var statearr_38284 = state_38260;
(statearr_38284[(18)] = inst_38076);

(statearr_38284[(14)] = inst_38057__$1);

(statearr_38284[(15)] = inst_38058__$1);

(statearr_38284[(16)] = inst_38059__$1);

(statearr_38284[(17)] = inst_38060__$1);

return statearr_38284;
})();
var statearr_38285_41495 = state_38260__$1;
(statearr_38285_41495[(2)] = null);

(statearr_38285_41495[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (21))){
var inst_38123 = (state_38260[(2)]);
var state_38260__$1 = state_38260;
var statearr_38289_41497 = state_38260__$1;
(statearr_38289_41497[(2)] = inst_38123);

(statearr_38289_41497[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (31))){
var inst_38149 = (state_38260[(11)]);
var inst_38212 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null, inst_38149);
var state_38260__$1 = state_38260;
var statearr_38290_41505 = state_38260__$1;
(statearr_38290_41505[(2)] = inst_38212);

(statearr_38290_41505[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (32))){
var inst_38144 = (state_38260[(10)]);
var inst_38141 = (state_38260[(19)]);
var inst_38142 = (state_38260[(9)]);
var inst_38143 = (state_38260[(20)]);
var inst_38214 = (state_38260[(2)]);
var inst_38216 = (inst_38144 + (1));
var tmp38286 = inst_38143;
var tmp38287 = inst_38141;
var tmp38288 = inst_38142;
var inst_38141__$1 = tmp38287;
var inst_38142__$1 = tmp38288;
var inst_38143__$1 = tmp38286;
var inst_38144__$1 = inst_38216;
var state_38260__$1 = (function (){var statearr_38291 = state_38260;
(statearr_38291[(21)] = inst_38214);

(statearr_38291[(19)] = inst_38141__$1);

(statearr_38291[(9)] = inst_38142__$1);

(statearr_38291[(20)] = inst_38143__$1);

(statearr_38291[(10)] = inst_38144__$1);

return statearr_38291;
})();
var statearr_38292_41512 = state_38260__$1;
(statearr_38292_41512[(2)] = null);

(statearr_38292_41512[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (40))){
var inst_38229 = (state_38260[(22)]);
var inst_38233 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null, inst_38229);
var state_38260__$1 = state_38260;
var statearr_38293_41514 = state_38260__$1;
(statearr_38293_41514[(2)] = inst_38233);

(statearr_38293_41514[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (33))){
var inst_38219 = (state_38260[(23)]);
var inst_38222 = cljs.core.chunked_seq_QMARK_(inst_38219);
var state_38260__$1 = state_38260;
if(inst_38222){
var statearr_38294_41517 = state_38260__$1;
(statearr_38294_41517[(1)] = (36));

} else {
var statearr_38295_41518 = state_38260__$1;
(statearr_38295_41518[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (13))){
var inst_38069 = (state_38260[(24)]);
var inst_38072 = cljs.core.async.close_BANG_(inst_38069);
var state_38260__$1 = state_38260;
var statearr_38297_41519 = state_38260__$1;
(statearr_38297_41519[(2)] = inst_38072);

(statearr_38297_41519[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (22))){
var inst_38112 = (state_38260[(8)]);
var inst_38116 = cljs.core.async.close_BANG_(inst_38112);
var state_38260__$1 = state_38260;
var statearr_38298_41527 = state_38260__$1;
(statearr_38298_41527[(2)] = inst_38116);

(statearr_38298_41527[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (36))){
var inst_38219 = (state_38260[(23)]);
var inst_38224 = cljs.core.chunk_first(inst_38219);
var inst_38225 = cljs.core.chunk_rest(inst_38219);
var inst_38226 = cljs.core.count(inst_38224);
var inst_38141 = inst_38225;
var inst_38142 = inst_38224;
var inst_38143 = inst_38226;
var inst_38144 = (0);
var state_38260__$1 = (function (){var statearr_38299 = state_38260;
(statearr_38299[(19)] = inst_38141);

(statearr_38299[(9)] = inst_38142);

(statearr_38299[(20)] = inst_38143);

(statearr_38299[(10)] = inst_38144);

return statearr_38299;
})();
var statearr_38300_41531 = state_38260__$1;
(statearr_38300_41531[(2)] = null);

(statearr_38300_41531[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (41))){
var inst_38219 = (state_38260[(23)]);
var inst_38235 = (state_38260[(2)]);
var inst_38236 = cljs.core.next(inst_38219);
var inst_38141 = inst_38236;
var inst_38142 = null;
var inst_38143 = (0);
var inst_38144 = (0);
var state_38260__$1 = (function (){var statearr_38301 = state_38260;
(statearr_38301[(25)] = inst_38235);

(statearr_38301[(19)] = inst_38141);

(statearr_38301[(9)] = inst_38142);

(statearr_38301[(20)] = inst_38143);

(statearr_38301[(10)] = inst_38144);

return statearr_38301;
})();
var statearr_38302_41534 = state_38260__$1;
(statearr_38302_41534[(2)] = null);

(statearr_38302_41534[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (43))){
var state_38260__$1 = state_38260;
var statearr_38303_41535 = state_38260__$1;
(statearr_38303_41535[(2)] = null);

(statearr_38303_41535[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (29))){
var inst_38244 = (state_38260[(2)]);
var state_38260__$1 = state_38260;
var statearr_38304_41538 = state_38260__$1;
(statearr_38304_41538[(2)] = inst_38244);

(statearr_38304_41538[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (44))){
var inst_38253 = (state_38260[(2)]);
var state_38260__$1 = (function (){var statearr_38308 = state_38260;
(statearr_38308[(26)] = inst_38253);

return statearr_38308;
})();
var statearr_38309_41540 = state_38260__$1;
(statearr_38309_41540[(2)] = null);

(statearr_38309_41540[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (6))){
var inst_38133 = (state_38260[(27)]);
var inst_38132 = cljs.core.deref(cs);
var inst_38133__$1 = cljs.core.keys(inst_38132);
var inst_38134 = cljs.core.count(inst_38133__$1);
var inst_38135 = cljs.core.reset_BANG_(dctr,inst_38134);
var inst_38140 = cljs.core.seq(inst_38133__$1);
var inst_38141 = inst_38140;
var inst_38142 = null;
var inst_38143 = (0);
var inst_38144 = (0);
var state_38260__$1 = (function (){var statearr_38311 = state_38260;
(statearr_38311[(27)] = inst_38133__$1);

(statearr_38311[(28)] = inst_38135);

(statearr_38311[(19)] = inst_38141);

(statearr_38311[(9)] = inst_38142);

(statearr_38311[(20)] = inst_38143);

(statearr_38311[(10)] = inst_38144);

return statearr_38311;
})();
var statearr_38312_41541 = state_38260__$1;
(statearr_38312_41541[(2)] = null);

(statearr_38312_41541[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (28))){
var inst_38141 = (state_38260[(19)]);
var inst_38219 = (state_38260[(23)]);
var inst_38219__$1 = cljs.core.seq(inst_38141);
var state_38260__$1 = (function (){var statearr_38321 = state_38260;
(statearr_38321[(23)] = inst_38219__$1);

return statearr_38321;
})();
if(inst_38219__$1){
var statearr_38322_41549 = state_38260__$1;
(statearr_38322_41549[(1)] = (33));

} else {
var statearr_38323_41551 = state_38260__$1;
(statearr_38323_41551[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (25))){
var inst_38144 = (state_38260[(10)]);
var inst_38143 = (state_38260[(20)]);
var inst_38146 = (inst_38144 < inst_38143);
var inst_38147 = inst_38146;
var state_38260__$1 = state_38260;
if(cljs.core.truth_(inst_38147)){
var statearr_38324_41557 = state_38260__$1;
(statearr_38324_41557[(1)] = (27));

} else {
var statearr_38325_41558 = state_38260__$1;
(statearr_38325_41558[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (34))){
var state_38260__$1 = state_38260;
var statearr_38327_41561 = state_38260__$1;
(statearr_38327_41561[(2)] = null);

(statearr_38327_41561[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (17))){
var state_38260__$1 = state_38260;
var statearr_38328_41568 = state_38260__$1;
(statearr_38328_41568[(2)] = null);

(statearr_38328_41568[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (3))){
var inst_38258 = (state_38260[(2)]);
var state_38260__$1 = state_38260;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38260__$1,inst_38258);
} else {
if((state_val_38261 === (12))){
var inst_38128 = (state_38260[(2)]);
var state_38260__$1 = state_38260;
var statearr_38329_41580 = state_38260__$1;
(statearr_38329_41580[(2)] = inst_38128);

(statearr_38329_41580[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (2))){
var state_38260__$1 = state_38260;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38260__$1,(4),ch);
} else {
if((state_val_38261 === (23))){
var state_38260__$1 = state_38260;
var statearr_38330_41583 = state_38260__$1;
(statearr_38330_41583[(2)] = null);

(statearr_38330_41583[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (35))){
var inst_38242 = (state_38260[(2)]);
var state_38260__$1 = state_38260;
var statearr_38331_41588 = state_38260__$1;
(statearr_38331_41588[(2)] = inst_38242);

(statearr_38331_41588[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (19))){
var inst_38082 = (state_38260[(7)]);
var inst_38087 = cljs.core.chunk_first(inst_38082);
var inst_38101 = cljs.core.chunk_rest(inst_38082);
var inst_38102 = cljs.core.count(inst_38087);
var inst_38057 = inst_38101;
var inst_38058 = inst_38087;
var inst_38059 = inst_38102;
var inst_38060 = (0);
var state_38260__$1 = (function (){var statearr_38332 = state_38260;
(statearr_38332[(14)] = inst_38057);

(statearr_38332[(15)] = inst_38058);

(statearr_38332[(16)] = inst_38059);

(statearr_38332[(17)] = inst_38060);

return statearr_38332;
})();
var statearr_38334_41605 = state_38260__$1;
(statearr_38334_41605[(2)] = null);

(statearr_38334_41605[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (11))){
var inst_38057 = (state_38260[(14)]);
var inst_38082 = (state_38260[(7)]);
var inst_38082__$1 = cljs.core.seq(inst_38057);
var state_38260__$1 = (function (){var statearr_38335 = state_38260;
(statearr_38335[(7)] = inst_38082__$1);

return statearr_38335;
})();
if(inst_38082__$1){
var statearr_38336_41625 = state_38260__$1;
(statearr_38336_41625[(1)] = (16));

} else {
var statearr_38337_41626 = state_38260__$1;
(statearr_38337_41626[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (9))){
var inst_38130 = (state_38260[(2)]);
var state_38260__$1 = state_38260;
var statearr_38338_41640 = state_38260__$1;
(statearr_38338_41640[(2)] = inst_38130);

(statearr_38338_41640[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (5))){
var inst_38055 = cljs.core.deref(cs);
var inst_38056 = cljs.core.seq(inst_38055);
var inst_38057 = inst_38056;
var inst_38058 = null;
var inst_38059 = (0);
var inst_38060 = (0);
var state_38260__$1 = (function (){var statearr_38339 = state_38260;
(statearr_38339[(14)] = inst_38057);

(statearr_38339[(15)] = inst_38058);

(statearr_38339[(16)] = inst_38059);

(statearr_38339[(17)] = inst_38060);

return statearr_38339;
})();
var statearr_38340_41649 = state_38260__$1;
(statearr_38340_41649[(2)] = null);

(statearr_38340_41649[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (14))){
var state_38260__$1 = state_38260;
var statearr_38341_41650 = state_38260__$1;
(statearr_38341_41650[(2)] = null);

(statearr_38341_41650[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (45))){
var inst_38250 = (state_38260[(2)]);
var state_38260__$1 = state_38260;
var statearr_38342_41658 = state_38260__$1;
(statearr_38342_41658[(2)] = inst_38250);

(statearr_38342_41658[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (26))){
var inst_38133 = (state_38260[(27)]);
var inst_38246 = (state_38260[(2)]);
var inst_38247 = cljs.core.seq(inst_38133);
var state_38260__$1 = (function (){var statearr_38343 = state_38260;
(statearr_38343[(29)] = inst_38246);

return statearr_38343;
})();
if(inst_38247){
var statearr_38345_41660 = state_38260__$1;
(statearr_38345_41660[(1)] = (42));

} else {
var statearr_38346_41661 = state_38260__$1;
(statearr_38346_41661[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (16))){
var inst_38082 = (state_38260[(7)]);
var inst_38085 = cljs.core.chunked_seq_QMARK_(inst_38082);
var state_38260__$1 = state_38260;
if(inst_38085){
var statearr_38350_41662 = state_38260__$1;
(statearr_38350_41662[(1)] = (19));

} else {
var statearr_38351_41663 = state_38260__$1;
(statearr_38351_41663[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (38))){
var inst_38239 = (state_38260[(2)]);
var state_38260__$1 = state_38260;
var statearr_38358_41664 = state_38260__$1;
(statearr_38358_41664[(2)] = inst_38239);

(statearr_38358_41664[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (30))){
var state_38260__$1 = state_38260;
var statearr_38359_41667 = state_38260__$1;
(statearr_38359_41667[(2)] = null);

(statearr_38359_41667[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (10))){
var inst_38058 = (state_38260[(15)]);
var inst_38060 = (state_38260[(17)]);
var inst_38068 = cljs.core._nth(inst_38058,inst_38060);
var inst_38069 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38068,(0),null);
var inst_38070 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38068,(1),null);
var state_38260__$1 = (function (){var statearr_38361 = state_38260;
(statearr_38361[(24)] = inst_38069);

return statearr_38361;
})();
if(cljs.core.truth_(inst_38070)){
var statearr_38362_41676 = state_38260__$1;
(statearr_38362_41676[(1)] = (13));

} else {
var statearr_38363_41677 = state_38260__$1;
(statearr_38363_41677[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (18))){
var inst_38126 = (state_38260[(2)]);
var state_38260__$1 = state_38260;
var statearr_38366_41679 = state_38260__$1;
(statearr_38366_41679[(2)] = inst_38126);

(statearr_38366_41679[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (42))){
var state_38260__$1 = state_38260;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38260__$1,(45),dchan);
} else {
if((state_val_38261 === (37))){
var inst_38219 = (state_38260[(23)]);
var inst_38229 = (state_38260[(22)]);
var inst_38047 = (state_38260[(12)]);
var inst_38229__$1 = cljs.core.first(inst_38219);
var inst_38230 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_38229__$1,inst_38047,done);
var state_38260__$1 = (function (){var statearr_38371 = state_38260;
(statearr_38371[(22)] = inst_38229__$1);

return statearr_38371;
})();
if(cljs.core.truth_(inst_38230)){
var statearr_38372_41680 = state_38260__$1;
(statearr_38372_41680[(1)] = (39));

} else {
var statearr_38373_41681 = state_38260__$1;
(statearr_38373_41681[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38261 === (8))){
var inst_38060 = (state_38260[(17)]);
var inst_38059 = (state_38260[(16)]);
var inst_38062 = (inst_38060 < inst_38059);
var inst_38063 = inst_38062;
var state_38260__$1 = state_38260;
if(cljs.core.truth_(inst_38063)){
var statearr_38374_41686 = state_38260__$1;
(statearr_38374_41686[(1)] = (10));

} else {
var statearr_38375_41687 = state_38260__$1;
(statearr_38375_41687[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__34332__auto__ = null;
var cljs$core$async$mult_$_state_machine__34332__auto____0 = (function (){
var statearr_38378 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38378[(0)] = cljs$core$async$mult_$_state_machine__34332__auto__);

(statearr_38378[(1)] = (1));

return statearr_38378;
});
var cljs$core$async$mult_$_state_machine__34332__auto____1 = (function (state_38260){
while(true){
var ret_value__34333__auto__ = (function (){try{while(true){
var result__34334__auto__ = switch__34331__auto__(state_38260);
if(cljs.core.keyword_identical_QMARK_(result__34334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34334__auto__;
}
break;
}
}catch (e38380){var ex__34335__auto__ = e38380;
var statearr_38382_41695 = state_38260;
(statearr_38382_41695[(2)] = ex__34335__auto__);


if(cljs.core.seq((state_38260[(4)]))){
var statearr_38383_41696 = state_38260;
(statearr_38383_41696[(1)] = cljs.core.first((state_38260[(4)])));

} else {
throw ex__34335__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41699 = state_38260;
state_38260 = G__41699;
continue;
} else {
return ret_value__34333__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__34332__auto__ = function(state_38260){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__34332__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__34332__auto____1.call(this,state_38260);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__34332__auto____0;
cljs$core$async$mult_$_state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__34332__auto____1;
return cljs$core$async$mult_$_state_machine__34332__auto__;
})()
})();
var state__34497__auto__ = (function (){var statearr_38390 = f__34496__auto__();
(statearr_38390[(6)] = c__34495__auto___41458);

return statearr_38390;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34497__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__38395 = arguments.length;
switch (G__38395) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_41710 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null, m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null, m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_41710(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_41726 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null, m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null, m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_41726(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_41743 = (function (m){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5351__auto__.call(null, m));
} else {
var m__5349__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5349__auto__.call(null, m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_41743(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_41745 = (function (m,state_map){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5351__auto__.call(null, m,state_map));
} else {
var m__5349__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5349__auto__.call(null, m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_41745(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_41750 = (function (m,mode){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5351__auto__.call(null, m,mode));
} else {
var m__5349__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5349__auto__.call(null, m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_41750(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5732__auto__ = [];
var len__5726__auto___41754 = arguments.length;
var i__5727__auto___41756 = (0);
while(true){
if((i__5727__auto___41756 < len__5726__auto___41754)){
args__5732__auto__.push((arguments[i__5727__auto___41756]));

var G__41757 = (i__5727__auto___41756 + (1));
i__5727__auto___41756 = G__41757;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((3) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5733__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__38465){
var map__38469 = p__38465;
var map__38469__$1 = cljs.core.__destructure_map(map__38469);
var opts = map__38469__$1;
var statearr_38470_41760 = state;
(statearr_38470_41760[(1)] = cont_block);


var temp__5823__auto__ = cljs.core.async.do_alts((function (val){
var statearr_38472_41761 = state;
(statearr_38472_41761[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5823__auto__)){
var cb = temp__5823__auto__;
var statearr_38476_41763 = state;
(statearr_38476_41763[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq38453){
var G__38454 = cljs.core.first(seq38453);
var seq38453__$1 = cljs.core.next(seq38453);
var G__38455 = cljs.core.first(seq38453__$1);
var seq38453__$2 = cljs.core.next(seq38453__$1);
var G__38456 = cljs.core.first(seq38453__$2);
var seq38453__$3 = cljs.core.next(seq38453__$2);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__38454,G__38455,G__38456,seq38453__$3);
}));


/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38484 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta38485){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta38485 = meta38485;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async38484.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38486,meta38485__$1){
var self__ = this;
var _38486__$1 = this;
return (new cljs.core.async.t_cljs$core$async38484(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta38485__$1));
}));

(cljs.core.async.t_cljs$core$async38484.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38486){
var self__ = this;
var _38486__$1 = this;
return self__.meta38485;
}));

(cljs.core.async.t_cljs$core$async38484.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38484.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async38484.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38484.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null, ));
}));

(cljs.core.async.t_cljs$core$async38484.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null, ));
}));

(cljs.core.async.t_cljs$core$async38484.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null, ));
}));

(cljs.core.async.t_cljs$core$async38484.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null, ));
}));

(cljs.core.async.t_cljs$core$async38484.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null, mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null, ));
}));

(cljs.core.async.t_cljs$core$async38484.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta38485","meta38485",-1841806397,null)], null);
}));

(cljs.core.async.t_cljs$core$async38484.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async38484.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38484");

(cljs.core.async.t_cljs$core$async38484.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async38484");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async38484.
 */
cljs.core.async.__GT_t_cljs$core$async38484 = (function cljs$core$async$__GT_t_cljs$core$async38484(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta38485){
return (new cljs.core.async.t_cljs$core$async38484(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta38485));
});


/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null, v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (cljs.core.seq(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (new cljs.core.async.t_cljs$core$async38484(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
var c__34495__auto___41787 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34496__auto__ = (function (){var switch__34331__auto__ = (function (state_38562){
var state_val_38563 = (state_38562[(1)]);
if((state_val_38563 === (7))){
var inst_38519 = (state_38562[(2)]);
var state_38562__$1 = state_38562;
if(cljs.core.truth_(inst_38519)){
var statearr_38564_41788 = state_38562__$1;
(statearr_38564_41788[(1)] = (8));

} else {
var statearr_38565_41789 = state_38562__$1;
(statearr_38565_41789[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38563 === (20))){
var inst_38511 = (state_38562[(7)]);
var state_38562__$1 = state_38562;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38562__$1,(23),out,inst_38511);
} else {
if((state_val_38563 === (1))){
var inst_38493 = calc_state();
var inst_38494 = cljs.core.__destructure_map(inst_38493);
var inst_38495 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38494,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_38496 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38494,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_38497 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38494,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_38498 = inst_38493;
var state_38562__$1 = (function (){var statearr_38569 = state_38562;
(statearr_38569[(8)] = inst_38495);

(statearr_38569[(9)] = inst_38496);

(statearr_38569[(10)] = inst_38497);

(statearr_38569[(11)] = inst_38498);

return statearr_38569;
})();
var statearr_38572_41791 = state_38562__$1;
(statearr_38572_41791[(2)] = null);

(statearr_38572_41791[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38563 === (24))){
var inst_38502 = (state_38562[(12)]);
var inst_38498 = inst_38502;
var state_38562__$1 = (function (){var statearr_38574 = state_38562;
(statearr_38574[(11)] = inst_38498);

return statearr_38574;
})();
var statearr_38575_41792 = state_38562__$1;
(statearr_38575_41792[(2)] = null);

(statearr_38575_41792[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38563 === (4))){
var inst_38511 = (state_38562[(7)]);
var inst_38514 = (state_38562[(13)]);
var inst_38510 = (state_38562[(2)]);
var inst_38511__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38510,(0),null);
var inst_38512 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38510,(1),null);
var inst_38514__$1 = (inst_38511__$1 == null);
var state_38562__$1 = (function (){var statearr_38579 = state_38562;
(statearr_38579[(7)] = inst_38511__$1);

(statearr_38579[(14)] = inst_38512);

(statearr_38579[(13)] = inst_38514__$1);

return statearr_38579;
})();
if(cljs.core.truth_(inst_38514__$1)){
var statearr_38580_41798 = state_38562__$1;
(statearr_38580_41798[(1)] = (5));

} else {
var statearr_38581_41799 = state_38562__$1;
(statearr_38581_41799[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38563 === (15))){
var inst_38503 = (state_38562[(15)]);
var inst_38536 = (state_38562[(16)]);
var inst_38536__$1 = cljs.core.empty_QMARK_(inst_38503);
var state_38562__$1 = (function (){var statearr_38582 = state_38562;
(statearr_38582[(16)] = inst_38536__$1);

return statearr_38582;
})();
if(inst_38536__$1){
var statearr_38584_41801 = state_38562__$1;
(statearr_38584_41801[(1)] = (17));

} else {
var statearr_38585_41802 = state_38562__$1;
(statearr_38585_41802[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38563 === (21))){
var inst_38502 = (state_38562[(12)]);
var inst_38498 = inst_38502;
var state_38562__$1 = (function (){var statearr_38587 = state_38562;
(statearr_38587[(11)] = inst_38498);

return statearr_38587;
})();
var statearr_38588_41803 = state_38562__$1;
(statearr_38588_41803[(2)] = null);

(statearr_38588_41803[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38563 === (13))){
var inst_38526 = (state_38562[(2)]);
var inst_38530 = calc_state();
var inst_38498 = inst_38530;
var state_38562__$1 = (function (){var statearr_38590 = state_38562;
(statearr_38590[(17)] = inst_38526);

(statearr_38590[(11)] = inst_38498);

return statearr_38590;
})();
var statearr_38591_41804 = state_38562__$1;
(statearr_38591_41804[(2)] = null);

(statearr_38591_41804[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38563 === (22))){
var inst_38556 = (state_38562[(2)]);
var state_38562__$1 = state_38562;
var statearr_38594_41805 = state_38562__$1;
(statearr_38594_41805[(2)] = inst_38556);

(statearr_38594_41805[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38563 === (6))){
var inst_38512 = (state_38562[(14)]);
var inst_38517 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_38512,change);
var state_38562__$1 = state_38562;
var statearr_38597_41807 = state_38562__$1;
(statearr_38597_41807[(2)] = inst_38517);

(statearr_38597_41807[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38563 === (25))){
var state_38562__$1 = state_38562;
var statearr_38599_41808 = state_38562__$1;
(statearr_38599_41808[(2)] = null);

(statearr_38599_41808[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38563 === (17))){
var inst_38504 = (state_38562[(18)]);
var inst_38512 = (state_38562[(14)]);
var inst_38538 = (inst_38504.cljs$core$IFn$_invoke$arity$1 ? inst_38504.cljs$core$IFn$_invoke$arity$1(inst_38512) : inst_38504.call(null, inst_38512));
var inst_38539 = cljs.core.not(inst_38538);
var state_38562__$1 = state_38562;
var statearr_38602_41810 = state_38562__$1;
(statearr_38602_41810[(2)] = inst_38539);

(statearr_38602_41810[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38563 === (3))){
var inst_38560 = (state_38562[(2)]);
var state_38562__$1 = state_38562;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38562__$1,inst_38560);
} else {
if((state_val_38563 === (12))){
var state_38562__$1 = state_38562;
var statearr_38605_41811 = state_38562__$1;
(statearr_38605_41811[(2)] = null);

(statearr_38605_41811[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38563 === (2))){
var inst_38498 = (state_38562[(11)]);
var inst_38502 = (state_38562[(12)]);
var inst_38502__$1 = cljs.core.__destructure_map(inst_38498);
var inst_38503 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38502__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_38504 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38502__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_38505 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38502__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_38562__$1 = (function (){var statearr_38608 = state_38562;
(statearr_38608[(12)] = inst_38502__$1);

(statearr_38608[(15)] = inst_38503);

(statearr_38608[(18)] = inst_38504);

return statearr_38608;
})();
return cljs.core.async.ioc_alts_BANG_(state_38562__$1,(4),inst_38505);
} else {
if((state_val_38563 === (23))){
var inst_38547 = (state_38562[(2)]);
var state_38562__$1 = state_38562;
if(cljs.core.truth_(inst_38547)){
var statearr_38610_41818 = state_38562__$1;
(statearr_38610_41818[(1)] = (24));

} else {
var statearr_38611_41823 = state_38562__$1;
(statearr_38611_41823[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38563 === (19))){
var inst_38542 = (state_38562[(2)]);
var state_38562__$1 = state_38562;
var statearr_38613_41824 = state_38562__$1;
(statearr_38613_41824[(2)] = inst_38542);

(statearr_38613_41824[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38563 === (11))){
var inst_38512 = (state_38562[(14)]);
var inst_38523 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_38512);
var state_38562__$1 = state_38562;
var statearr_38617_41826 = state_38562__$1;
(statearr_38617_41826[(2)] = inst_38523);

(statearr_38617_41826[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38563 === (9))){
var inst_38503 = (state_38562[(15)]);
var inst_38512 = (state_38562[(14)]);
var inst_38533 = (state_38562[(19)]);
var inst_38533__$1 = (inst_38503.cljs$core$IFn$_invoke$arity$1 ? inst_38503.cljs$core$IFn$_invoke$arity$1(inst_38512) : inst_38503.call(null, inst_38512));
var state_38562__$1 = (function (){var statearr_38621 = state_38562;
(statearr_38621[(19)] = inst_38533__$1);

return statearr_38621;
})();
if(cljs.core.truth_(inst_38533__$1)){
var statearr_38622_41831 = state_38562__$1;
(statearr_38622_41831[(1)] = (14));

} else {
var statearr_38623_41832 = state_38562__$1;
(statearr_38623_41832[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38563 === (5))){
var inst_38514 = (state_38562[(13)]);
var state_38562__$1 = state_38562;
var statearr_38626_41833 = state_38562__$1;
(statearr_38626_41833[(2)] = inst_38514);

(statearr_38626_41833[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38563 === (14))){
var inst_38533 = (state_38562[(19)]);
var state_38562__$1 = state_38562;
var statearr_38628_41835 = state_38562__$1;
(statearr_38628_41835[(2)] = inst_38533);

(statearr_38628_41835[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38563 === (26))){
var inst_38552 = (state_38562[(2)]);
var state_38562__$1 = state_38562;
var statearr_38630_41836 = state_38562__$1;
(statearr_38630_41836[(2)] = inst_38552);

(statearr_38630_41836[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38563 === (16))){
var inst_38544 = (state_38562[(2)]);
var state_38562__$1 = state_38562;
if(cljs.core.truth_(inst_38544)){
var statearr_38635_41837 = state_38562__$1;
(statearr_38635_41837[(1)] = (20));

} else {
var statearr_38637_41838 = state_38562__$1;
(statearr_38637_41838[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38563 === (10))){
var inst_38558 = (state_38562[(2)]);
var state_38562__$1 = state_38562;
var statearr_38638_41839 = state_38562__$1;
(statearr_38638_41839[(2)] = inst_38558);

(statearr_38638_41839[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38563 === (18))){
var inst_38536 = (state_38562[(16)]);
var state_38562__$1 = state_38562;
var statearr_38639_41840 = state_38562__$1;
(statearr_38639_41840[(2)] = inst_38536);

(statearr_38639_41840[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38563 === (8))){
var inst_38511 = (state_38562[(7)]);
var inst_38521 = (inst_38511 == null);
var state_38562__$1 = state_38562;
if(cljs.core.truth_(inst_38521)){
var statearr_38641_41843 = state_38562__$1;
(statearr_38641_41843[(1)] = (11));

} else {
var statearr_38642_41844 = state_38562__$1;
(statearr_38642_41844[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__34332__auto__ = null;
var cljs$core$async$mix_$_state_machine__34332__auto____0 = (function (){
var statearr_38646 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38646[(0)] = cljs$core$async$mix_$_state_machine__34332__auto__);

(statearr_38646[(1)] = (1));

return statearr_38646;
});
var cljs$core$async$mix_$_state_machine__34332__auto____1 = (function (state_38562){
while(true){
var ret_value__34333__auto__ = (function (){try{while(true){
var result__34334__auto__ = switch__34331__auto__(state_38562);
if(cljs.core.keyword_identical_QMARK_(result__34334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34334__auto__;
}
break;
}
}catch (e38647){var ex__34335__auto__ = e38647;
var statearr_38649_41847 = state_38562;
(statearr_38649_41847[(2)] = ex__34335__auto__);


if(cljs.core.seq((state_38562[(4)]))){
var statearr_38650_41848 = state_38562;
(statearr_38650_41848[(1)] = cljs.core.first((state_38562[(4)])));

} else {
throw ex__34335__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41853 = state_38562;
state_38562 = G__41853;
continue;
} else {
return ret_value__34333__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__34332__auto__ = function(state_38562){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__34332__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__34332__auto____1.call(this,state_38562);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__34332__auto____0;
cljs$core$async$mix_$_state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__34332__auto____1;
return cljs$core$async$mix_$_state_machine__34332__auto__;
})()
})();
var state__34497__auto__ = (function (){var statearr_38654 = f__34496__auto__();
(statearr_38654[(6)] = c__34495__auto___41787);

return statearr_38654;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34497__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_41864 = (function (p,v,ch,close_QMARK_){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5351__auto__.call(null, p,v,ch,close_QMARK_));
} else {
var m__5349__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5349__auto__.call(null, p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_41864(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_41869 = (function (p,v,ch){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5351__auto__.call(null, p,v,ch));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5349__auto__.call(null, p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_41869(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_41874 = (function() {
var G__41875 = null;
var G__41875__1 = (function (p){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5351__auto__.call(null, p));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5349__auto__.call(null, p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__41875__2 = (function (p,v){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5351__auto__.call(null, p,v));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5349__auto__.call(null, p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__41875 = function(p,v){
switch(arguments.length){
case 1:
return G__41875__1.call(this,p);
case 2:
return G__41875__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__41875.cljs$core$IFn$_invoke$arity$1 = G__41875__1;
G__41875.cljs$core$IFn$_invoke$arity$2 = G__41875__2;
return G__41875;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__38691 = arguments.length;
switch (G__38691) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_41874(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_41874(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);



/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38710 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta38711){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta38711 = meta38711;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async38710.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38712,meta38711__$1){
var self__ = this;
var _38712__$1 = this;
return (new cljs.core.async.t_cljs$core$async38710(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta38711__$1));
}));

(cljs.core.async.t_cljs$core$async38710.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38712){
var self__ = this;
var _38712__$1 = this;
return self__.meta38711;
}));

(cljs.core.async.t_cljs$core$async38710.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38710.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async38710.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38710.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null, topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async38710.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5823__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5823__auto__)){
var m = temp__5823__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async38710.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async38710.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async38710.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta38711","meta38711",-323661212,null)], null);
}));

(cljs.core.async.t_cljs$core$async38710.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async38710.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38710");

(cljs.core.async.t_cljs$core$async38710.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async38710");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async38710.
 */
cljs.core.async.__GT_t_cljs$core$async38710 = (function cljs$core$async$__GT_t_cljs$core$async38710(ch,topic_fn,buf_fn,mults,ensure_mult,meta38711){
return (new cljs.core.async.t_cljs$core$async38710(ch,topic_fn,buf_fn,mults,ensure_mult,meta38711));
});


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__38704 = arguments.length;
switch (G__38704) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__5002__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__38699_SHARP_){
if(cljs.core.truth_((p1__38699_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__38699_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__38699_SHARP_.call(null, topic)))){
return p1__38699_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__38699_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null, topic)))));
}
})),topic);
}
});
var p = (new cljs.core.async.t_cljs$core$async38710(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
var c__34495__auto___41930 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34496__auto__ = (function (){var switch__34331__auto__ = (function (state_38818){
var state_val_38819 = (state_38818[(1)]);
if((state_val_38819 === (7))){
var inst_38813 = (state_38818[(2)]);
var state_38818__$1 = state_38818;
var statearr_38824_41964 = state_38818__$1;
(statearr_38824_41964[(2)] = inst_38813);

(statearr_38824_41964[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38819 === (20))){
var state_38818__$1 = state_38818;
var statearr_38825_41966 = state_38818__$1;
(statearr_38825_41966[(2)] = null);

(statearr_38825_41966[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38819 === (1))){
var state_38818__$1 = state_38818;
var statearr_38841_41976 = state_38818__$1;
(statearr_38841_41976[(2)] = null);

(statearr_38841_41976[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38819 === (24))){
var inst_38796 = (state_38818[(7)]);
var inst_38805 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_38796);
var state_38818__$1 = state_38818;
var statearr_38847_41983 = state_38818__$1;
(statearr_38847_41983[(2)] = inst_38805);

(statearr_38847_41983[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38819 === (4))){
var inst_38741 = (state_38818[(8)]);
var inst_38741__$1 = (state_38818[(2)]);
var inst_38742 = (inst_38741__$1 == null);
var state_38818__$1 = (function (){var statearr_38855 = state_38818;
(statearr_38855[(8)] = inst_38741__$1);

return statearr_38855;
})();
if(cljs.core.truth_(inst_38742)){
var statearr_38862_41984 = state_38818__$1;
(statearr_38862_41984[(1)] = (5));

} else {
var statearr_38863_41985 = state_38818__$1;
(statearr_38863_41985[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38819 === (15))){
var inst_38789 = (state_38818[(2)]);
var state_38818__$1 = state_38818;
var statearr_38872_41986 = state_38818__$1;
(statearr_38872_41986[(2)] = inst_38789);

(statearr_38872_41986[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38819 === (21))){
var inst_38810 = (state_38818[(2)]);
var state_38818__$1 = (function (){var statearr_38879 = state_38818;
(statearr_38879[(9)] = inst_38810);

return statearr_38879;
})();
var statearr_38882_41992 = state_38818__$1;
(statearr_38882_41992[(2)] = null);

(statearr_38882_41992[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38819 === (13))){
var inst_38769 = (state_38818[(10)]);
var inst_38771 = cljs.core.chunked_seq_QMARK_(inst_38769);
var state_38818__$1 = state_38818;
if(inst_38771){
var statearr_38896_41993 = state_38818__$1;
(statearr_38896_41993[(1)] = (16));

} else {
var statearr_38899_41994 = state_38818__$1;
(statearr_38899_41994[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38819 === (22))){
var inst_38802 = (state_38818[(2)]);
var state_38818__$1 = state_38818;
if(cljs.core.truth_(inst_38802)){
var statearr_38907_41995 = state_38818__$1;
(statearr_38907_41995[(1)] = (23));

} else {
var statearr_38908_41996 = state_38818__$1;
(statearr_38908_41996[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38819 === (6))){
var inst_38741 = (state_38818[(8)]);
var inst_38796 = (state_38818[(7)]);
var inst_38798 = (state_38818[(11)]);
var inst_38796__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_38741) : topic_fn.call(null, inst_38741));
var inst_38797 = cljs.core.deref(mults);
var inst_38798__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38797,inst_38796__$1);
var state_38818__$1 = (function (){var statearr_38925 = state_38818;
(statearr_38925[(7)] = inst_38796__$1);

(statearr_38925[(11)] = inst_38798__$1);

return statearr_38925;
})();
if(cljs.core.truth_(inst_38798__$1)){
var statearr_38930_42023 = state_38818__$1;
(statearr_38930_42023[(1)] = (19));

} else {
var statearr_38931_42024 = state_38818__$1;
(statearr_38931_42024[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38819 === (25))){
var inst_38807 = (state_38818[(2)]);
var state_38818__$1 = state_38818;
var statearr_38936_42031 = state_38818__$1;
(statearr_38936_42031[(2)] = inst_38807);

(statearr_38936_42031[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38819 === (17))){
var inst_38769 = (state_38818[(10)]);
var inst_38778 = cljs.core.first(inst_38769);
var inst_38780 = cljs.core.async.muxch_STAR_(inst_38778);
var inst_38781 = cljs.core.async.close_BANG_(inst_38780);
var inst_38783 = cljs.core.next(inst_38769);
var inst_38753 = inst_38783;
var inst_38754 = null;
var inst_38755 = (0);
var inst_38756 = (0);
var state_38818__$1 = (function (){var statearr_38947 = state_38818;
(statearr_38947[(12)] = inst_38781);

(statearr_38947[(13)] = inst_38753);

(statearr_38947[(14)] = inst_38754);

(statearr_38947[(15)] = inst_38755);

(statearr_38947[(16)] = inst_38756);

return statearr_38947;
})();
var statearr_38955_42034 = state_38818__$1;
(statearr_38955_42034[(2)] = null);

(statearr_38955_42034[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38819 === (3))){
var inst_38815 = (state_38818[(2)]);
var state_38818__$1 = state_38818;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38818__$1,inst_38815);
} else {
if((state_val_38819 === (12))){
var inst_38791 = (state_38818[(2)]);
var state_38818__$1 = state_38818;
var statearr_38965_42035 = state_38818__$1;
(statearr_38965_42035[(2)] = inst_38791);

(statearr_38965_42035[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38819 === (2))){
var state_38818__$1 = state_38818;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38818__$1,(4),ch);
} else {
if((state_val_38819 === (23))){
var state_38818__$1 = state_38818;
var statearr_38977_42036 = state_38818__$1;
(statearr_38977_42036[(2)] = null);

(statearr_38977_42036[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38819 === (19))){
var inst_38798 = (state_38818[(11)]);
var inst_38741 = (state_38818[(8)]);
var inst_38800 = cljs.core.async.muxch_STAR_(inst_38798);
var state_38818__$1 = state_38818;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38818__$1,(22),inst_38800,inst_38741);
} else {
if((state_val_38819 === (11))){
var inst_38753 = (state_38818[(13)]);
var inst_38769 = (state_38818[(10)]);
var inst_38769__$1 = cljs.core.seq(inst_38753);
var state_38818__$1 = (function (){var statearr_38996 = state_38818;
(statearr_38996[(10)] = inst_38769__$1);

return statearr_38996;
})();
if(inst_38769__$1){
var statearr_38998_42043 = state_38818__$1;
(statearr_38998_42043[(1)] = (13));

} else {
var statearr_39002_42045 = state_38818__$1;
(statearr_39002_42045[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38819 === (9))){
var inst_38793 = (state_38818[(2)]);
var state_38818__$1 = state_38818;
var statearr_39009_42046 = state_38818__$1;
(statearr_39009_42046[(2)] = inst_38793);

(statearr_39009_42046[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38819 === (5))){
var inst_38748 = cljs.core.deref(mults);
var inst_38750 = cljs.core.vals(inst_38748);
var inst_38751 = cljs.core.seq(inst_38750);
var inst_38753 = inst_38751;
var inst_38754 = null;
var inst_38755 = (0);
var inst_38756 = (0);
var state_38818__$1 = (function (){var statearr_39014 = state_38818;
(statearr_39014[(13)] = inst_38753);

(statearr_39014[(14)] = inst_38754);

(statearr_39014[(15)] = inst_38755);

(statearr_39014[(16)] = inst_38756);

return statearr_39014;
})();
var statearr_39018_42048 = state_38818__$1;
(statearr_39018_42048[(2)] = null);

(statearr_39018_42048[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38819 === (14))){
var state_38818__$1 = state_38818;
var statearr_39027_42049 = state_38818__$1;
(statearr_39027_42049[(2)] = null);

(statearr_39027_42049[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38819 === (16))){
var inst_38769 = (state_38818[(10)]);
var inst_38773 = cljs.core.chunk_first(inst_38769);
var inst_38774 = cljs.core.chunk_rest(inst_38769);
var inst_38775 = cljs.core.count(inst_38773);
var inst_38753 = inst_38774;
var inst_38754 = inst_38773;
var inst_38755 = inst_38775;
var inst_38756 = (0);
var state_38818__$1 = (function (){var statearr_39038 = state_38818;
(statearr_39038[(13)] = inst_38753);

(statearr_39038[(14)] = inst_38754);

(statearr_39038[(15)] = inst_38755);

(statearr_39038[(16)] = inst_38756);

return statearr_39038;
})();
var statearr_39041_42050 = state_38818__$1;
(statearr_39041_42050[(2)] = null);

(statearr_39041_42050[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38819 === (10))){
var inst_38754 = (state_38818[(14)]);
var inst_38756 = (state_38818[(16)]);
var inst_38753 = (state_38818[(13)]);
var inst_38755 = (state_38818[(15)]);
var inst_38762 = cljs.core._nth(inst_38754,inst_38756);
var inst_38763 = cljs.core.async.muxch_STAR_(inst_38762);
var inst_38764 = cljs.core.async.close_BANG_(inst_38763);
var inst_38765 = (inst_38756 + (1));
var tmp39020 = inst_38755;
var tmp39021 = inst_38754;
var tmp39022 = inst_38753;
var inst_38753__$1 = tmp39022;
var inst_38754__$1 = tmp39021;
var inst_38755__$1 = tmp39020;
var inst_38756__$1 = inst_38765;
var state_38818__$1 = (function (){var statearr_39045 = state_38818;
(statearr_39045[(17)] = inst_38764);

(statearr_39045[(13)] = inst_38753__$1);

(statearr_39045[(14)] = inst_38754__$1);

(statearr_39045[(15)] = inst_38755__$1);

(statearr_39045[(16)] = inst_38756__$1);

return statearr_39045;
})();
var statearr_39053_42056 = state_38818__$1;
(statearr_39053_42056[(2)] = null);

(statearr_39053_42056[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38819 === (18))){
var inst_38786 = (state_38818[(2)]);
var state_38818__$1 = state_38818;
var statearr_39055_42058 = state_38818__$1;
(statearr_39055_42058[(2)] = inst_38786);

(statearr_39055_42058[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38819 === (8))){
var inst_38756 = (state_38818[(16)]);
var inst_38755 = (state_38818[(15)]);
var inst_38759 = (inst_38756 < inst_38755);
var inst_38760 = inst_38759;
var state_38818__$1 = state_38818;
if(cljs.core.truth_(inst_38760)){
var statearr_39057_42061 = state_38818__$1;
(statearr_39057_42061[(1)] = (10));

} else {
var statearr_39058_42062 = state_38818__$1;
(statearr_39058_42062[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__34332__auto__ = null;
var cljs$core$async$state_machine__34332__auto____0 = (function (){
var statearr_39071 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39071[(0)] = cljs$core$async$state_machine__34332__auto__);

(statearr_39071[(1)] = (1));

return statearr_39071;
});
var cljs$core$async$state_machine__34332__auto____1 = (function (state_38818){
while(true){
var ret_value__34333__auto__ = (function (){try{while(true){
var result__34334__auto__ = switch__34331__auto__(state_38818);
if(cljs.core.keyword_identical_QMARK_(result__34334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34334__auto__;
}
break;
}
}catch (e39072){var ex__34335__auto__ = e39072;
var statearr_39074_42070 = state_38818;
(statearr_39074_42070[(2)] = ex__34335__auto__);


if(cljs.core.seq((state_38818[(4)]))){
var statearr_39079_42078 = state_38818;
(statearr_39079_42078[(1)] = cljs.core.first((state_38818[(4)])));

} else {
throw ex__34335__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42088 = state_38818;
state_38818 = G__42088;
continue;
} else {
return ret_value__34333__auto__;
}
break;
}
});
cljs$core$async$state_machine__34332__auto__ = function(state_38818){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__34332__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__34332__auto____1.call(this,state_38818);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__34332__auto____0;
cljs$core$async$state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__34332__auto____1;
return cljs$core$async$state_machine__34332__auto__;
})()
})();
var state__34497__auto__ = (function (){var statearr_39081 = f__34496__auto__();
(statearr_39081[(6)] = c__34495__auto___41930);

return statearr_39081;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34497__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__39090 = arguments.length;
switch (G__39090) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__39102 = arguments.length;
switch (G__39102) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__39128 = arguments.length;
switch (G__39128) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_(out);
} else {
var c__34495__auto___42109 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34496__auto__ = (function (){var switch__34331__auto__ = (function (state_39217){
var state_val_39218 = (state_39217[(1)]);
if((state_val_39218 === (7))){
var state_39217__$1 = state_39217;
var statearr_39224_42111 = state_39217__$1;
(statearr_39224_42111[(2)] = null);

(statearr_39224_42111[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39218 === (1))){
var state_39217__$1 = state_39217;
var statearr_39226_42112 = state_39217__$1;
(statearr_39226_42112[(2)] = null);

(statearr_39226_42112[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39218 === (4))){
var inst_39155 = (state_39217[(7)]);
var inst_39153 = (state_39217[(8)]);
var inst_39158 = (inst_39155 < inst_39153);
var state_39217__$1 = state_39217;
if(cljs.core.truth_(inst_39158)){
var statearr_39231_42113 = state_39217__$1;
(statearr_39231_42113[(1)] = (6));

} else {
var statearr_39232_42117 = state_39217__$1;
(statearr_39232_42117[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39218 === (15))){
var inst_39203 = (state_39217[(9)]);
var inst_39208 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_39203);
var state_39217__$1 = state_39217;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_39217__$1,(17),out,inst_39208);
} else {
if((state_val_39218 === (13))){
var inst_39203 = (state_39217[(9)]);
var inst_39203__$1 = (state_39217[(2)]);
var inst_39204 = cljs.core.some(cljs.core.nil_QMARK_,inst_39203__$1);
var state_39217__$1 = (function (){var statearr_39242 = state_39217;
(statearr_39242[(9)] = inst_39203__$1);

return statearr_39242;
})();
if(cljs.core.truth_(inst_39204)){
var statearr_39243_42122 = state_39217__$1;
(statearr_39243_42122[(1)] = (14));

} else {
var statearr_39245_42123 = state_39217__$1;
(statearr_39245_42123[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39218 === (6))){
var state_39217__$1 = state_39217;
var statearr_39250_42127 = state_39217__$1;
(statearr_39250_42127[(2)] = null);

(statearr_39250_42127[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39218 === (17))){
var inst_39210 = (state_39217[(2)]);
var state_39217__$1 = (function (){var statearr_39256 = state_39217;
(statearr_39256[(10)] = inst_39210);

return statearr_39256;
})();
var statearr_39257_42128 = state_39217__$1;
(statearr_39257_42128[(2)] = null);

(statearr_39257_42128[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39218 === (3))){
var inst_39215 = (state_39217[(2)]);
var state_39217__$1 = state_39217;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39217__$1,inst_39215);
} else {
if((state_val_39218 === (12))){
var _ = (function (){var statearr_39260 = state_39217;
(statearr_39260[(4)] = cljs.core.rest((state_39217[(4)])));

return statearr_39260;
})();
var state_39217__$1 = state_39217;
var ex39255 = (state_39217__$1[(2)]);
var statearr_39261_42129 = state_39217__$1;
(statearr_39261_42129[(5)] = ex39255);


if((ex39255 instanceof Object)){
var statearr_39264_42130 = state_39217__$1;
(statearr_39264_42130[(1)] = (11));

(statearr_39264_42130[(5)] = null);

} else {
throw ex39255;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39218 === (2))){
var inst_39151 = cljs.core.reset_BANG_(dctr,cnt);
var inst_39153 = cnt;
var inst_39155 = (0);
var state_39217__$1 = (function (){var statearr_39272 = state_39217;
(statearr_39272[(11)] = inst_39151);

(statearr_39272[(8)] = inst_39153);

(statearr_39272[(7)] = inst_39155);

return statearr_39272;
})();
var statearr_39273_42135 = state_39217__$1;
(statearr_39273_42135[(2)] = null);

(statearr_39273_42135[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39218 === (11))){
var inst_39170 = (state_39217[(2)]);
var inst_39173 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_39217__$1 = (function (){var statearr_39278 = state_39217;
(statearr_39278[(12)] = inst_39170);

return statearr_39278;
})();
var statearr_39281_42140 = state_39217__$1;
(statearr_39281_42140[(2)] = inst_39173);

(statearr_39281_42140[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39218 === (9))){
var inst_39155 = (state_39217[(7)]);
var _ = (function (){var statearr_39283 = state_39217;
(statearr_39283[(4)] = cljs.core.cons((12),(state_39217[(4)])));

return statearr_39283;
})();
var inst_39181 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_39155) : chs__$1.call(null, inst_39155));
var inst_39183 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_39155) : done.call(null, inst_39155));
var inst_39184 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_39181,inst_39183);
var ___$1 = (function (){var statearr_39288 = state_39217;
(statearr_39288[(4)] = cljs.core.rest((state_39217[(4)])));

return statearr_39288;
})();
var state_39217__$1 = state_39217;
var statearr_39289_42143 = state_39217__$1;
(statearr_39289_42143[(2)] = inst_39184);

(statearr_39289_42143[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39218 === (5))){
var inst_39200 = (state_39217[(2)]);
var state_39217__$1 = (function (){var statearr_39293 = state_39217;
(statearr_39293[(13)] = inst_39200);

return statearr_39293;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39217__$1,(13),dchan);
} else {
if((state_val_39218 === (14))){
var inst_39206 = cljs.core.async.close_BANG_(out);
var state_39217__$1 = state_39217;
var statearr_39294_42146 = state_39217__$1;
(statearr_39294_42146[(2)] = inst_39206);

(statearr_39294_42146[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39218 === (16))){
var inst_39213 = (state_39217[(2)]);
var state_39217__$1 = state_39217;
var statearr_39295_42149 = state_39217__$1;
(statearr_39295_42149[(2)] = inst_39213);

(statearr_39295_42149[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39218 === (10))){
var inst_39155 = (state_39217[(7)]);
var inst_39187 = (state_39217[(2)]);
var inst_39189 = (inst_39155 + (1));
var inst_39155__$1 = inst_39189;
var state_39217__$1 = (function (){var statearr_39302 = state_39217;
(statearr_39302[(14)] = inst_39187);

(statearr_39302[(7)] = inst_39155__$1);

return statearr_39302;
})();
var statearr_39303_42153 = state_39217__$1;
(statearr_39303_42153[(2)] = null);

(statearr_39303_42153[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39218 === (8))){
var inst_39198 = (state_39217[(2)]);
var state_39217__$1 = state_39217;
var statearr_39305_42154 = state_39217__$1;
(statearr_39305_42154[(2)] = inst_39198);

(statearr_39305_42154[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__34332__auto__ = null;
var cljs$core$async$state_machine__34332__auto____0 = (function (){
var statearr_39310 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39310[(0)] = cljs$core$async$state_machine__34332__auto__);

(statearr_39310[(1)] = (1));

return statearr_39310;
});
var cljs$core$async$state_machine__34332__auto____1 = (function (state_39217){
while(true){
var ret_value__34333__auto__ = (function (){try{while(true){
var result__34334__auto__ = switch__34331__auto__(state_39217);
if(cljs.core.keyword_identical_QMARK_(result__34334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34334__auto__;
}
break;
}
}catch (e39314){var ex__34335__auto__ = e39314;
var statearr_39315_42169 = state_39217;
(statearr_39315_42169[(2)] = ex__34335__auto__);


if(cljs.core.seq((state_39217[(4)]))){
var statearr_39316_42174 = state_39217;
(statearr_39316_42174[(1)] = cljs.core.first((state_39217[(4)])));

} else {
throw ex__34335__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42181 = state_39217;
state_39217 = G__42181;
continue;
} else {
return ret_value__34333__auto__;
}
break;
}
});
cljs$core$async$state_machine__34332__auto__ = function(state_39217){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__34332__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__34332__auto____1.call(this,state_39217);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__34332__auto____0;
cljs$core$async$state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__34332__auto____1;
return cljs$core$async$state_machine__34332__auto__;
})()
})();
var state__34497__auto__ = (function (){var statearr_39319 = f__34496__auto__();
(statearr_39319[(6)] = c__34495__auto___42109);

return statearr_39319;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34497__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__39322 = arguments.length;
switch (G__39322) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__34495__auto___42212 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34496__auto__ = (function (){var switch__34331__auto__ = (function (state_39371){
var state_val_39372 = (state_39371[(1)]);
if((state_val_39372 === (7))){
var inst_39342 = (state_39371[(7)]);
var inst_39343 = (state_39371[(8)]);
var inst_39342__$1 = (state_39371[(2)]);
var inst_39343__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39342__$1,(0),null);
var inst_39344 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39342__$1,(1),null);
var inst_39346 = (inst_39343__$1 == null);
var state_39371__$1 = (function (){var statearr_39378 = state_39371;
(statearr_39378[(7)] = inst_39342__$1);

(statearr_39378[(8)] = inst_39343__$1);

(statearr_39378[(9)] = inst_39344);

return statearr_39378;
})();
if(cljs.core.truth_(inst_39346)){
var statearr_39379_42215 = state_39371__$1;
(statearr_39379_42215[(1)] = (8));

} else {
var statearr_39380_42216 = state_39371__$1;
(statearr_39380_42216[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39372 === (1))){
var inst_39332 = cljs.core.vec(chs);
var inst_39333 = inst_39332;
var state_39371__$1 = (function (){var statearr_39382 = state_39371;
(statearr_39382[(10)] = inst_39333);

return statearr_39382;
})();
var statearr_39383_42217 = state_39371__$1;
(statearr_39383_42217[(2)] = null);

(statearr_39383_42217[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39372 === (4))){
var inst_39333 = (state_39371[(10)]);
var state_39371__$1 = state_39371;
return cljs.core.async.ioc_alts_BANG_(state_39371__$1,(7),inst_39333);
} else {
if((state_val_39372 === (6))){
var inst_39362 = (state_39371[(2)]);
var state_39371__$1 = state_39371;
var statearr_39387_42218 = state_39371__$1;
(statearr_39387_42218[(2)] = inst_39362);

(statearr_39387_42218[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39372 === (3))){
var inst_39364 = (state_39371[(2)]);
var state_39371__$1 = state_39371;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39371__$1,inst_39364);
} else {
if((state_val_39372 === (2))){
var inst_39333 = (state_39371[(10)]);
var inst_39335 = cljs.core.count(inst_39333);
var inst_39336 = (inst_39335 > (0));
var state_39371__$1 = state_39371;
if(cljs.core.truth_(inst_39336)){
var statearr_39393_42220 = state_39371__$1;
(statearr_39393_42220[(1)] = (4));

} else {
var statearr_39394_42221 = state_39371__$1;
(statearr_39394_42221[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39372 === (11))){
var inst_39333 = (state_39371[(10)]);
var inst_39355 = (state_39371[(2)]);
var tmp39392 = inst_39333;
var inst_39333__$1 = tmp39392;
var state_39371__$1 = (function (){var statearr_39395 = state_39371;
(statearr_39395[(11)] = inst_39355);

(statearr_39395[(10)] = inst_39333__$1);

return statearr_39395;
})();
var statearr_39397_42222 = state_39371__$1;
(statearr_39397_42222[(2)] = null);

(statearr_39397_42222[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39372 === (9))){
var inst_39343 = (state_39371[(8)]);
var state_39371__$1 = state_39371;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_39371__$1,(11),out,inst_39343);
} else {
if((state_val_39372 === (5))){
var inst_39360 = cljs.core.async.close_BANG_(out);
var state_39371__$1 = state_39371;
var statearr_39407_42223 = state_39371__$1;
(statearr_39407_42223[(2)] = inst_39360);

(statearr_39407_42223[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39372 === (10))){
var inst_39358 = (state_39371[(2)]);
var state_39371__$1 = state_39371;
var statearr_39409_42239 = state_39371__$1;
(statearr_39409_42239[(2)] = inst_39358);

(statearr_39409_42239[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39372 === (8))){
var inst_39333 = (state_39371[(10)]);
var inst_39342 = (state_39371[(7)]);
var inst_39343 = (state_39371[(8)]);
var inst_39344 = (state_39371[(9)]);
var inst_39350 = (function (){var cs = inst_39333;
var vec__39338 = inst_39342;
var v = inst_39343;
var c = inst_39344;
return (function (p1__39320_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__39320_SHARP_);
});
})();
var inst_39351 = cljs.core.filterv(inst_39350,inst_39333);
var inst_39333__$1 = inst_39351;
var state_39371__$1 = (function (){var statearr_39410 = state_39371;
(statearr_39410[(10)] = inst_39333__$1);

return statearr_39410;
})();
var statearr_39411_42277 = state_39371__$1;
(statearr_39411_42277[(2)] = null);

(statearr_39411_42277[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__34332__auto__ = null;
var cljs$core$async$state_machine__34332__auto____0 = (function (){
var statearr_39413 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39413[(0)] = cljs$core$async$state_machine__34332__auto__);

(statearr_39413[(1)] = (1));

return statearr_39413;
});
var cljs$core$async$state_machine__34332__auto____1 = (function (state_39371){
while(true){
var ret_value__34333__auto__ = (function (){try{while(true){
var result__34334__auto__ = switch__34331__auto__(state_39371);
if(cljs.core.keyword_identical_QMARK_(result__34334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34334__auto__;
}
break;
}
}catch (e39419){var ex__34335__auto__ = e39419;
var statearr_39423_42310 = state_39371;
(statearr_39423_42310[(2)] = ex__34335__auto__);


if(cljs.core.seq((state_39371[(4)]))){
var statearr_39425_42312 = state_39371;
(statearr_39425_42312[(1)] = cljs.core.first((state_39371[(4)])));

} else {
throw ex__34335__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42317 = state_39371;
state_39371 = G__42317;
continue;
} else {
return ret_value__34333__auto__;
}
break;
}
});
cljs$core$async$state_machine__34332__auto__ = function(state_39371){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__34332__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__34332__auto____1.call(this,state_39371);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__34332__auto____0;
cljs$core$async$state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__34332__auto____1;
return cljs$core$async$state_machine__34332__auto__;
})()
})();
var state__34497__auto__ = (function (){var statearr_39432 = f__34496__auto__();
(statearr_39432[(6)] = c__34495__auto___42212);

return statearr_39432;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34497__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__39434 = arguments.length;
switch (G__39434) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__34495__auto___42355 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34496__auto__ = (function (){var switch__34331__auto__ = (function (state_39468){
var state_val_39469 = (state_39468[(1)]);
if((state_val_39469 === (7))){
var inst_39446 = (state_39468[(7)]);
var inst_39446__$1 = (state_39468[(2)]);
var inst_39447 = (inst_39446__$1 == null);
var inst_39448 = cljs.core.not(inst_39447);
var state_39468__$1 = (function (){var statearr_39479 = state_39468;
(statearr_39479[(7)] = inst_39446__$1);

return statearr_39479;
})();
if(inst_39448){
var statearr_39485_42381 = state_39468__$1;
(statearr_39485_42381[(1)] = (8));

} else {
var statearr_39486_42382 = state_39468__$1;
(statearr_39486_42382[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39469 === (1))){
var inst_39441 = (0);
var state_39468__$1 = (function (){var statearr_39487 = state_39468;
(statearr_39487[(8)] = inst_39441);

return statearr_39487;
})();
var statearr_39488_42384 = state_39468__$1;
(statearr_39488_42384[(2)] = null);

(statearr_39488_42384[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39469 === (4))){
var state_39468__$1 = state_39468;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39468__$1,(7),ch);
} else {
if((state_val_39469 === (6))){
var inst_39463 = (state_39468[(2)]);
var state_39468__$1 = state_39468;
var statearr_39489_42385 = state_39468__$1;
(statearr_39489_42385[(2)] = inst_39463);

(statearr_39489_42385[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39469 === (3))){
var inst_39465 = (state_39468[(2)]);
var inst_39466 = cljs.core.async.close_BANG_(out);
var state_39468__$1 = (function (){var statearr_39491 = state_39468;
(statearr_39491[(9)] = inst_39465);

return statearr_39491;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_39468__$1,inst_39466);
} else {
if((state_val_39469 === (2))){
var inst_39441 = (state_39468[(8)]);
var inst_39443 = (inst_39441 < n);
var state_39468__$1 = state_39468;
if(cljs.core.truth_(inst_39443)){
var statearr_39497_42390 = state_39468__$1;
(statearr_39497_42390[(1)] = (4));

} else {
var statearr_39501_42391 = state_39468__$1;
(statearr_39501_42391[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39469 === (11))){
var inst_39441 = (state_39468[(8)]);
var inst_39451 = (state_39468[(2)]);
var inst_39453 = (inst_39441 + (1));
var inst_39441__$1 = inst_39453;
var state_39468__$1 = (function (){var statearr_39505 = state_39468;
(statearr_39505[(10)] = inst_39451);

(statearr_39505[(8)] = inst_39441__$1);

return statearr_39505;
})();
var statearr_39507_42400 = state_39468__$1;
(statearr_39507_42400[(2)] = null);

(statearr_39507_42400[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39469 === (9))){
var state_39468__$1 = state_39468;
var statearr_39509_42402 = state_39468__$1;
(statearr_39509_42402[(2)] = null);

(statearr_39509_42402[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39469 === (5))){
var state_39468__$1 = state_39468;
var statearr_39510_42403 = state_39468__$1;
(statearr_39510_42403[(2)] = null);

(statearr_39510_42403[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39469 === (10))){
var inst_39460 = (state_39468[(2)]);
var state_39468__$1 = state_39468;
var statearr_39511_42404 = state_39468__$1;
(statearr_39511_42404[(2)] = inst_39460);

(statearr_39511_42404[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39469 === (8))){
var inst_39446 = (state_39468[(7)]);
var state_39468__$1 = state_39468;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_39468__$1,(11),out,inst_39446);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__34332__auto__ = null;
var cljs$core$async$state_machine__34332__auto____0 = (function (){
var statearr_39516 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_39516[(0)] = cljs$core$async$state_machine__34332__auto__);

(statearr_39516[(1)] = (1));

return statearr_39516;
});
var cljs$core$async$state_machine__34332__auto____1 = (function (state_39468){
while(true){
var ret_value__34333__auto__ = (function (){try{while(true){
var result__34334__auto__ = switch__34331__auto__(state_39468);
if(cljs.core.keyword_identical_QMARK_(result__34334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34334__auto__;
}
break;
}
}catch (e39517){var ex__34335__auto__ = e39517;
var statearr_39520_42406 = state_39468;
(statearr_39520_42406[(2)] = ex__34335__auto__);


if(cljs.core.seq((state_39468[(4)]))){
var statearr_39524_42407 = state_39468;
(statearr_39524_42407[(1)] = cljs.core.first((state_39468[(4)])));

} else {
throw ex__34335__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42410 = state_39468;
state_39468 = G__42410;
continue;
} else {
return ret_value__34333__auto__;
}
break;
}
});
cljs$core$async$state_machine__34332__auto__ = function(state_39468){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__34332__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__34332__auto____1.call(this,state_39468);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__34332__auto____0;
cljs$core$async$state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__34332__auto____1;
return cljs$core$async$state_machine__34332__auto__;
})()
})();
var state__34497__auto__ = (function (){var statearr_39538 = f__34496__auto__();
(statearr_39538[(6)] = c__34495__auto___42355);

return statearr_39538;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34497__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async39587 = (function (f,ch,meta39563,_,fn1,meta39588){
this.f = f;
this.ch = ch;
this.meta39563 = meta39563;
this._ = _;
this.fn1 = fn1;
this.meta39588 = meta39588;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async39587.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39589,meta39588__$1){
var self__ = this;
var _39589__$1 = this;
return (new cljs.core.async.t_cljs$core$async39587(self__.f,self__.ch,self__.meta39563,self__._,self__.fn1,meta39588__$1));
}));

(cljs.core.async.t_cljs$core$async39587.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39589){
var self__ = this;
var _39589__$1 = this;
return self__.meta39588;
}));

(cljs.core.async.t_cljs$core$async39587.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async39587.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async39587.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async39587.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__39557_SHARP_){
var G__39603 = (((p1__39557_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__39557_SHARP_) : self__.f.call(null, p1__39557_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__39603) : f1.call(null, G__39603));
});
}));

(cljs.core.async.t_cljs$core$async39587.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta39563","meta39563",900355882,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async39562","cljs.core.async/t_cljs$core$async39562",-376405319,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta39588","meta39588",-1171106684,null)], null);
}));

(cljs.core.async.t_cljs$core$async39587.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async39587.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async39587");

(cljs.core.async.t_cljs$core$async39587.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async39587");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async39587.
 */
cljs.core.async.__GT_t_cljs$core$async39587 = (function cljs$core$async$__GT_t_cljs$core$async39587(f,ch,meta39563,_,fn1,meta39588){
return (new cljs.core.async.t_cljs$core$async39587(f,ch,meta39563,_,fn1,meta39588));
});



/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async39562 = (function (f,ch,meta39563){
this.f = f;
this.ch = ch;
this.meta39563 = meta39563;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async39562.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39564,meta39563__$1){
var self__ = this;
var _39564__$1 = this;
return (new cljs.core.async.t_cljs$core$async39562(self__.f,self__.ch,meta39563__$1));
}));

(cljs.core.async.t_cljs$core$async39562.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39564){
var self__ = this;
var _39564__$1 = this;
return self__.meta39563;
}));

(cljs.core.async.t_cljs$core$async39562.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async39562.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async39562.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async39562.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async39562.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(new cljs.core.async.t_cljs$core$async39587(self__.f,self__.ch,self__.meta39563,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY)));
if(cljs.core.truth_((function (){var and__5000__auto__ = ret;
if(cljs.core.truth_(and__5000__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__5000__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__39618 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__39618) : self__.f.call(null, G__39618));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async39562.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async39562.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async39562.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta39563","meta39563",900355882,null)], null);
}));

(cljs.core.async.t_cljs$core$async39562.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async39562.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async39562");

(cljs.core.async.t_cljs$core$async39562.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async39562");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async39562.
 */
cljs.core.async.__GT_t_cljs$core$async39562 = (function cljs$core$async$__GT_t_cljs$core$async39562(f,ch,meta39563){
return (new cljs.core.async.t_cljs$core$async39562(f,ch,meta39563));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
return (new cljs.core.async.t_cljs$core$async39562(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async39633 = (function (f,ch,meta39634){
this.f = f;
this.ch = ch;
this.meta39634 = meta39634;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async39633.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39635,meta39634__$1){
var self__ = this;
var _39635__$1 = this;
return (new cljs.core.async.t_cljs$core$async39633(self__.f,self__.ch,meta39634__$1));
}));

(cljs.core.async.t_cljs$core$async39633.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39635){
var self__ = this;
var _39635__$1 = this;
return self__.meta39634;
}));

(cljs.core.async.t_cljs$core$async39633.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async39633.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async39633.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async39633.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async39633.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async39633.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null, val)),fn1);
}));

(cljs.core.async.t_cljs$core$async39633.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta39634","meta39634",-218574474,null)], null);
}));

(cljs.core.async.t_cljs$core$async39633.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async39633.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async39633");

(cljs.core.async.t_cljs$core$async39633.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async39633");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async39633.
 */
cljs.core.async.__GT_t_cljs$core$async39633 = (function cljs$core$async$__GT_t_cljs$core$async39633(f,ch,meta39634){
return (new cljs.core.async.t_cljs$core$async39633(f,ch,meta39634));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
return (new cljs.core.async.t_cljs$core$async39633(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async39651 = (function (p,ch,meta39652){
this.p = p;
this.ch = ch;
this.meta39652 = meta39652;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async39651.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39653,meta39652__$1){
var self__ = this;
var _39653__$1 = this;
return (new cljs.core.async.t_cljs$core$async39651(self__.p,self__.ch,meta39652__$1));
}));

(cljs.core.async.t_cljs$core$async39651.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39653){
var self__ = this;
var _39653__$1 = this;
return self__.meta39652;
}));

(cljs.core.async.t_cljs$core$async39651.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async39651.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async39651.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async39651.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async39651.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async39651.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async39651.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null, val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async39651.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta39652","meta39652",-781326622,null)], null);
}));

(cljs.core.async.t_cljs$core$async39651.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async39651.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async39651");

(cljs.core.async.t_cljs$core$async39651.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async39651");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async39651.
 */
cljs.core.async.__GT_t_cljs$core$async39651 = (function cljs$core$async$__GT_t_cljs$core$async39651(p,ch,meta39652){
return (new cljs.core.async.t_cljs$core$async39651(p,ch,meta39652));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
return (new cljs.core.async.t_cljs$core$async39651(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__39688 = arguments.length;
switch (G__39688) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__34495__auto___42426 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34496__auto__ = (function (){var switch__34331__auto__ = (function (state_39733){
var state_val_39734 = (state_39733[(1)]);
if((state_val_39734 === (7))){
var inst_39726 = (state_39733[(2)]);
var state_39733__$1 = state_39733;
var statearr_39741_42427 = state_39733__$1;
(statearr_39741_42427[(2)] = inst_39726);

(statearr_39741_42427[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39734 === (1))){
var state_39733__$1 = state_39733;
var statearr_39742_42435 = state_39733__$1;
(statearr_39742_42435[(2)] = null);

(statearr_39742_42435[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39734 === (4))){
var inst_39708 = (state_39733[(7)]);
var inst_39708__$1 = (state_39733[(2)]);
var inst_39709 = (inst_39708__$1 == null);
var state_39733__$1 = (function (){var statearr_39744 = state_39733;
(statearr_39744[(7)] = inst_39708__$1);

return statearr_39744;
})();
if(cljs.core.truth_(inst_39709)){
var statearr_39745_42450 = state_39733__$1;
(statearr_39745_42450[(1)] = (5));

} else {
var statearr_39746_42451 = state_39733__$1;
(statearr_39746_42451[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39734 === (6))){
var inst_39708 = (state_39733[(7)]);
var inst_39716 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_39708) : p.call(null, inst_39708));
var state_39733__$1 = state_39733;
if(cljs.core.truth_(inst_39716)){
var statearr_39747_42456 = state_39733__$1;
(statearr_39747_42456[(1)] = (8));

} else {
var statearr_39748_42461 = state_39733__$1;
(statearr_39748_42461[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39734 === (3))){
var inst_39728 = (state_39733[(2)]);
var state_39733__$1 = state_39733;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39733__$1,inst_39728);
} else {
if((state_val_39734 === (2))){
var state_39733__$1 = state_39733;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39733__$1,(4),ch);
} else {
if((state_val_39734 === (11))){
var inst_39720 = (state_39733[(2)]);
var state_39733__$1 = state_39733;
var statearr_39753_42485 = state_39733__$1;
(statearr_39753_42485[(2)] = inst_39720);

(statearr_39753_42485[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39734 === (9))){
var state_39733__$1 = state_39733;
var statearr_39759_42491 = state_39733__$1;
(statearr_39759_42491[(2)] = null);

(statearr_39759_42491[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39734 === (5))){
var inst_39711 = cljs.core.async.close_BANG_(out);
var state_39733__$1 = state_39733;
var statearr_39763_42507 = state_39733__$1;
(statearr_39763_42507[(2)] = inst_39711);

(statearr_39763_42507[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39734 === (10))){
var inst_39723 = (state_39733[(2)]);
var state_39733__$1 = (function (){var statearr_39764 = state_39733;
(statearr_39764[(8)] = inst_39723);

return statearr_39764;
})();
var statearr_39765_42527 = state_39733__$1;
(statearr_39765_42527[(2)] = null);

(statearr_39765_42527[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39734 === (8))){
var inst_39708 = (state_39733[(7)]);
var state_39733__$1 = state_39733;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_39733__$1,(11),out,inst_39708);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__34332__auto__ = null;
var cljs$core$async$state_machine__34332__auto____0 = (function (){
var statearr_39770 = [null,null,null,null,null,null,null,null,null];
(statearr_39770[(0)] = cljs$core$async$state_machine__34332__auto__);

(statearr_39770[(1)] = (1));

return statearr_39770;
});
var cljs$core$async$state_machine__34332__auto____1 = (function (state_39733){
while(true){
var ret_value__34333__auto__ = (function (){try{while(true){
var result__34334__auto__ = switch__34331__auto__(state_39733);
if(cljs.core.keyword_identical_QMARK_(result__34334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34334__auto__;
}
break;
}
}catch (e39772){var ex__34335__auto__ = e39772;
var statearr_39773_42560 = state_39733;
(statearr_39773_42560[(2)] = ex__34335__auto__);


if(cljs.core.seq((state_39733[(4)]))){
var statearr_39777_42563 = state_39733;
(statearr_39777_42563[(1)] = cljs.core.first((state_39733[(4)])));

} else {
throw ex__34335__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42565 = state_39733;
state_39733 = G__42565;
continue;
} else {
return ret_value__34333__auto__;
}
break;
}
});
cljs$core$async$state_machine__34332__auto__ = function(state_39733){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__34332__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__34332__auto____1.call(this,state_39733);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__34332__auto____0;
cljs$core$async$state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__34332__auto____1;
return cljs$core$async$state_machine__34332__auto__;
})()
})();
var state__34497__auto__ = (function (){var statearr_39783 = f__34496__auto__();
(statearr_39783[(6)] = c__34495__auto___42426);

return statearr_39783;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34497__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__39792 = arguments.length;
switch (G__39792) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__34495__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34496__auto__ = (function (){var switch__34331__auto__ = (function (state_39865){
var state_val_39867 = (state_39865[(1)]);
if((state_val_39867 === (7))){
var inst_39861 = (state_39865[(2)]);
var state_39865__$1 = state_39865;
var statearr_39871_42584 = state_39865__$1;
(statearr_39871_42584[(2)] = inst_39861);

(statearr_39871_42584[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39867 === (20))){
var inst_39828 = (state_39865[(7)]);
var inst_39839 = (state_39865[(2)]);
var inst_39840 = cljs.core.next(inst_39828);
var inst_39814 = inst_39840;
var inst_39815 = null;
var inst_39816 = (0);
var inst_39817 = (0);
var state_39865__$1 = (function (){var statearr_39875 = state_39865;
(statearr_39875[(8)] = inst_39839);

(statearr_39875[(9)] = inst_39814);

(statearr_39875[(10)] = inst_39815);

(statearr_39875[(11)] = inst_39816);

(statearr_39875[(12)] = inst_39817);

return statearr_39875;
})();
var statearr_39876_42590 = state_39865__$1;
(statearr_39876_42590[(2)] = null);

(statearr_39876_42590[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39867 === (1))){
var state_39865__$1 = state_39865;
var statearr_39889_42592 = state_39865__$1;
(statearr_39889_42592[(2)] = null);

(statearr_39889_42592[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39867 === (4))){
var inst_39803 = (state_39865[(13)]);
var inst_39803__$1 = (state_39865[(2)]);
var inst_39804 = (inst_39803__$1 == null);
var state_39865__$1 = (function (){var statearr_39893 = state_39865;
(statearr_39893[(13)] = inst_39803__$1);

return statearr_39893;
})();
if(cljs.core.truth_(inst_39804)){
var statearr_39894_42594 = state_39865__$1;
(statearr_39894_42594[(1)] = (5));

} else {
var statearr_39895_42595 = state_39865__$1;
(statearr_39895_42595[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39867 === (15))){
var state_39865__$1 = state_39865;
var statearr_39906_42596 = state_39865__$1;
(statearr_39906_42596[(2)] = null);

(statearr_39906_42596[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39867 === (21))){
var state_39865__$1 = state_39865;
var statearr_39907_42601 = state_39865__$1;
(statearr_39907_42601[(2)] = null);

(statearr_39907_42601[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39867 === (13))){
var inst_39817 = (state_39865[(12)]);
var inst_39814 = (state_39865[(9)]);
var inst_39815 = (state_39865[(10)]);
var inst_39816 = (state_39865[(11)]);
var inst_39824 = (state_39865[(2)]);
var inst_39825 = (inst_39817 + (1));
var tmp39896 = inst_39814;
var tmp39897 = inst_39815;
var tmp39899 = inst_39816;
var inst_39814__$1 = tmp39896;
var inst_39815__$1 = tmp39897;
var inst_39816__$1 = tmp39899;
var inst_39817__$1 = inst_39825;
var state_39865__$1 = (function (){var statearr_39926 = state_39865;
(statearr_39926[(14)] = inst_39824);

(statearr_39926[(9)] = inst_39814__$1);

(statearr_39926[(10)] = inst_39815__$1);

(statearr_39926[(11)] = inst_39816__$1);

(statearr_39926[(12)] = inst_39817__$1);

return statearr_39926;
})();
var statearr_39930_42602 = state_39865__$1;
(statearr_39930_42602[(2)] = null);

(statearr_39930_42602[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39867 === (22))){
var state_39865__$1 = state_39865;
var statearr_39931_42603 = state_39865__$1;
(statearr_39931_42603[(2)] = null);

(statearr_39931_42603[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39867 === (6))){
var inst_39803 = (state_39865[(13)]);
var inst_39812 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_39803) : f.call(null, inst_39803));
var inst_39813 = cljs.core.seq(inst_39812);
var inst_39814 = inst_39813;
var inst_39815 = null;
var inst_39816 = (0);
var inst_39817 = (0);
var state_39865__$1 = (function (){var statearr_39945 = state_39865;
(statearr_39945[(9)] = inst_39814);

(statearr_39945[(10)] = inst_39815);

(statearr_39945[(11)] = inst_39816);

(statearr_39945[(12)] = inst_39817);

return statearr_39945;
})();
var statearr_39955_42604 = state_39865__$1;
(statearr_39955_42604[(2)] = null);

(statearr_39955_42604[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39867 === (17))){
var inst_39828 = (state_39865[(7)]);
var inst_39832 = cljs.core.chunk_first(inst_39828);
var inst_39833 = cljs.core.chunk_rest(inst_39828);
var inst_39834 = cljs.core.count(inst_39832);
var inst_39814 = inst_39833;
var inst_39815 = inst_39832;
var inst_39816 = inst_39834;
var inst_39817 = (0);
var state_39865__$1 = (function (){var statearr_39963 = state_39865;
(statearr_39963[(9)] = inst_39814);

(statearr_39963[(10)] = inst_39815);

(statearr_39963[(11)] = inst_39816);

(statearr_39963[(12)] = inst_39817);

return statearr_39963;
})();
var statearr_39967_42605 = state_39865__$1;
(statearr_39967_42605[(2)] = null);

(statearr_39967_42605[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39867 === (3))){
var inst_39863 = (state_39865[(2)]);
var state_39865__$1 = state_39865;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39865__$1,inst_39863);
} else {
if((state_val_39867 === (12))){
var inst_39848 = (state_39865[(2)]);
var state_39865__$1 = state_39865;
var statearr_39971_42606 = state_39865__$1;
(statearr_39971_42606[(2)] = inst_39848);

(statearr_39971_42606[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39867 === (2))){
var state_39865__$1 = state_39865;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39865__$1,(4),in$);
} else {
if((state_val_39867 === (23))){
var inst_39859 = (state_39865[(2)]);
var state_39865__$1 = state_39865;
var statearr_39989_42607 = state_39865__$1;
(statearr_39989_42607[(2)] = inst_39859);

(statearr_39989_42607[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39867 === (19))){
var inst_39843 = (state_39865[(2)]);
var state_39865__$1 = state_39865;
var statearr_39990_42608 = state_39865__$1;
(statearr_39990_42608[(2)] = inst_39843);

(statearr_39990_42608[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39867 === (11))){
var inst_39814 = (state_39865[(9)]);
var inst_39828 = (state_39865[(7)]);
var inst_39828__$1 = cljs.core.seq(inst_39814);
var state_39865__$1 = (function (){var statearr_40000 = state_39865;
(statearr_40000[(7)] = inst_39828__$1);

return statearr_40000;
})();
if(inst_39828__$1){
var statearr_40004_42609 = state_39865__$1;
(statearr_40004_42609[(1)] = (14));

} else {
var statearr_40005_42610 = state_39865__$1;
(statearr_40005_42610[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39867 === (9))){
var inst_39850 = (state_39865[(2)]);
var inst_39851 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_39865__$1 = (function (){var statearr_40007 = state_39865;
(statearr_40007[(15)] = inst_39850);

return statearr_40007;
})();
if(cljs.core.truth_(inst_39851)){
var statearr_40011_42614 = state_39865__$1;
(statearr_40011_42614[(1)] = (21));

} else {
var statearr_40019_42615 = state_39865__$1;
(statearr_40019_42615[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39867 === (5))){
var inst_39806 = cljs.core.async.close_BANG_(out);
var state_39865__$1 = state_39865;
var statearr_40026_42617 = state_39865__$1;
(statearr_40026_42617[(2)] = inst_39806);

(statearr_40026_42617[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39867 === (14))){
var inst_39828 = (state_39865[(7)]);
var inst_39830 = cljs.core.chunked_seq_QMARK_(inst_39828);
var state_39865__$1 = state_39865;
if(inst_39830){
var statearr_40031_42625 = state_39865__$1;
(statearr_40031_42625[(1)] = (17));

} else {
var statearr_40032_42626 = state_39865__$1;
(statearr_40032_42626[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39867 === (16))){
var inst_39846 = (state_39865[(2)]);
var state_39865__$1 = state_39865;
var statearr_40034_42627 = state_39865__$1;
(statearr_40034_42627[(2)] = inst_39846);

(statearr_40034_42627[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39867 === (10))){
var inst_39815 = (state_39865[(10)]);
var inst_39817 = (state_39865[(12)]);
var inst_39822 = cljs.core._nth(inst_39815,inst_39817);
var state_39865__$1 = state_39865;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_39865__$1,(13),out,inst_39822);
} else {
if((state_val_39867 === (18))){
var inst_39828 = (state_39865[(7)]);
var inst_39837 = cljs.core.first(inst_39828);
var state_39865__$1 = state_39865;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_39865__$1,(20),out,inst_39837);
} else {
if((state_val_39867 === (8))){
var inst_39817 = (state_39865[(12)]);
var inst_39816 = (state_39865[(11)]);
var inst_39819 = (inst_39817 < inst_39816);
var inst_39820 = inst_39819;
var state_39865__$1 = state_39865;
if(cljs.core.truth_(inst_39820)){
var statearr_40039_42631 = state_39865__$1;
(statearr_40039_42631[(1)] = (10));

} else {
var statearr_40040_42632 = state_39865__$1;
(statearr_40040_42632[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__34332__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__34332__auto____0 = (function (){
var statearr_40047 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40047[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__34332__auto__);

(statearr_40047[(1)] = (1));

return statearr_40047;
});
var cljs$core$async$mapcat_STAR__$_state_machine__34332__auto____1 = (function (state_39865){
while(true){
var ret_value__34333__auto__ = (function (){try{while(true){
var result__34334__auto__ = switch__34331__auto__(state_39865);
if(cljs.core.keyword_identical_QMARK_(result__34334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34334__auto__;
}
break;
}
}catch (e40049){var ex__34335__auto__ = e40049;
var statearr_40050_42637 = state_39865;
(statearr_40050_42637[(2)] = ex__34335__auto__);


if(cljs.core.seq((state_39865[(4)]))){
var statearr_40051_42638 = state_39865;
(statearr_40051_42638[(1)] = cljs.core.first((state_39865[(4)])));

} else {
throw ex__34335__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42639 = state_39865;
state_39865 = G__42639;
continue;
} else {
return ret_value__34333__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__34332__auto__ = function(state_39865){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__34332__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__34332__auto____1.call(this,state_39865);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__34332__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__34332__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__34332__auto__;
})()
})();
var state__34497__auto__ = (function (){var statearr_40066 = f__34496__auto__();
(statearr_40066[(6)] = c__34495__auto__);

return statearr_40066;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34497__auto__);
}));

return c__34495__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__40073 = arguments.length;
switch (G__40073) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__40093 = arguments.length;
switch (G__40093) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__40116 = arguments.length;
switch (G__40116) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__34495__auto___42643 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34496__auto__ = (function (){var switch__34331__auto__ = (function (state_40150){
var state_val_40151 = (state_40150[(1)]);
if((state_val_40151 === (7))){
var inst_40145 = (state_40150[(2)]);
var state_40150__$1 = state_40150;
var statearr_40161_42644 = state_40150__$1;
(statearr_40161_42644[(2)] = inst_40145);

(statearr_40161_42644[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40151 === (1))){
var inst_40127 = null;
var state_40150__$1 = (function (){var statearr_40162 = state_40150;
(statearr_40162[(7)] = inst_40127);

return statearr_40162;
})();
var statearr_40163_42645 = state_40150__$1;
(statearr_40163_42645[(2)] = null);

(statearr_40163_42645[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40151 === (4))){
var inst_40130 = (state_40150[(8)]);
var inst_40130__$1 = (state_40150[(2)]);
var inst_40131 = (inst_40130__$1 == null);
var inst_40132 = cljs.core.not(inst_40131);
var state_40150__$1 = (function (){var statearr_40168 = state_40150;
(statearr_40168[(8)] = inst_40130__$1);

return statearr_40168;
})();
if(inst_40132){
var statearr_40171_42646 = state_40150__$1;
(statearr_40171_42646[(1)] = (5));

} else {
var statearr_40172_42647 = state_40150__$1;
(statearr_40172_42647[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40151 === (6))){
var state_40150__$1 = state_40150;
var statearr_40176_42648 = state_40150__$1;
(statearr_40176_42648[(2)] = null);

(statearr_40176_42648[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40151 === (3))){
var inst_40147 = (state_40150[(2)]);
var inst_40148 = cljs.core.async.close_BANG_(out);
var state_40150__$1 = (function (){var statearr_40179 = state_40150;
(statearr_40179[(9)] = inst_40147);

return statearr_40179;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_40150__$1,inst_40148);
} else {
if((state_val_40151 === (2))){
var state_40150__$1 = state_40150;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40150__$1,(4),ch);
} else {
if((state_val_40151 === (11))){
var inst_40130 = (state_40150[(8)]);
var inst_40139 = (state_40150[(2)]);
var inst_40127 = inst_40130;
var state_40150__$1 = (function (){var statearr_40194 = state_40150;
(statearr_40194[(10)] = inst_40139);

(statearr_40194[(7)] = inst_40127);

return statearr_40194;
})();
var statearr_40195_42651 = state_40150__$1;
(statearr_40195_42651[(2)] = null);

(statearr_40195_42651[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40151 === (9))){
var inst_40130 = (state_40150[(8)]);
var state_40150__$1 = state_40150;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_40150__$1,(11),out,inst_40130);
} else {
if((state_val_40151 === (5))){
var inst_40130 = (state_40150[(8)]);
var inst_40127 = (state_40150[(7)]);
var inst_40134 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_40130,inst_40127);
var state_40150__$1 = state_40150;
if(inst_40134){
var statearr_40197_42653 = state_40150__$1;
(statearr_40197_42653[(1)] = (8));

} else {
var statearr_40198_42655 = state_40150__$1;
(statearr_40198_42655[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40151 === (10))){
var inst_40142 = (state_40150[(2)]);
var state_40150__$1 = state_40150;
var statearr_40199_42656 = state_40150__$1;
(statearr_40199_42656[(2)] = inst_40142);

(statearr_40199_42656[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40151 === (8))){
var inst_40127 = (state_40150[(7)]);
var tmp40196 = inst_40127;
var inst_40127__$1 = tmp40196;
var state_40150__$1 = (function (){var statearr_40200 = state_40150;
(statearr_40200[(7)] = inst_40127__$1);

return statearr_40200;
})();
var statearr_40201_42657 = state_40150__$1;
(statearr_40201_42657[(2)] = null);

(statearr_40201_42657[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__34332__auto__ = null;
var cljs$core$async$state_machine__34332__auto____0 = (function (){
var statearr_40202 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_40202[(0)] = cljs$core$async$state_machine__34332__auto__);

(statearr_40202[(1)] = (1));

return statearr_40202;
});
var cljs$core$async$state_machine__34332__auto____1 = (function (state_40150){
while(true){
var ret_value__34333__auto__ = (function (){try{while(true){
var result__34334__auto__ = switch__34331__auto__(state_40150);
if(cljs.core.keyword_identical_QMARK_(result__34334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34334__auto__;
}
break;
}
}catch (e40206){var ex__34335__auto__ = e40206;
var statearr_40207_42665 = state_40150;
(statearr_40207_42665[(2)] = ex__34335__auto__);


if(cljs.core.seq((state_40150[(4)]))){
var statearr_40208_42666 = state_40150;
(statearr_40208_42666[(1)] = cljs.core.first((state_40150[(4)])));

} else {
throw ex__34335__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42667 = state_40150;
state_40150 = G__42667;
continue;
} else {
return ret_value__34333__auto__;
}
break;
}
});
cljs$core$async$state_machine__34332__auto__ = function(state_40150){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__34332__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__34332__auto____1.call(this,state_40150);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__34332__auto____0;
cljs$core$async$state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__34332__auto____1;
return cljs$core$async$state_machine__34332__auto__;
})()
})();
var state__34497__auto__ = (function (){var statearr_40213 = f__34496__auto__();
(statearr_40213[(6)] = c__34495__auto___42643);

return statearr_40213;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34497__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__40233 = arguments.length;
switch (G__40233) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__34495__auto___42669 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34496__auto__ = (function (){var switch__34331__auto__ = (function (state_40288){
var state_val_40289 = (state_40288[(1)]);
if((state_val_40289 === (7))){
var inst_40284 = (state_40288[(2)]);
var state_40288__$1 = state_40288;
var statearr_40293_42674 = state_40288__$1;
(statearr_40293_42674[(2)] = inst_40284);

(statearr_40293_42674[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40289 === (1))){
var inst_40244 = (new Array(n));
var inst_40245 = inst_40244;
var inst_40246 = (0);
var state_40288__$1 = (function (){var statearr_40299 = state_40288;
(statearr_40299[(7)] = inst_40245);

(statearr_40299[(8)] = inst_40246);

return statearr_40299;
})();
var statearr_40312_42699 = state_40288__$1;
(statearr_40312_42699[(2)] = null);

(statearr_40312_42699[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40289 === (4))){
var inst_40249 = (state_40288[(9)]);
var inst_40249__$1 = (state_40288[(2)]);
var inst_40250 = (inst_40249__$1 == null);
var inst_40251 = cljs.core.not(inst_40250);
var state_40288__$1 = (function (){var statearr_40322 = state_40288;
(statearr_40322[(9)] = inst_40249__$1);

return statearr_40322;
})();
if(inst_40251){
var statearr_40323_42700 = state_40288__$1;
(statearr_40323_42700[(1)] = (5));

} else {
var statearr_40324_42706 = state_40288__$1;
(statearr_40324_42706[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40289 === (15))){
var inst_40276 = (state_40288[(2)]);
var state_40288__$1 = state_40288;
var statearr_40333_42707 = state_40288__$1;
(statearr_40333_42707[(2)] = inst_40276);

(statearr_40333_42707[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40289 === (13))){
var state_40288__$1 = state_40288;
var statearr_40349_42708 = state_40288__$1;
(statearr_40349_42708[(2)] = null);

(statearr_40349_42708[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40289 === (6))){
var inst_40246 = (state_40288[(8)]);
var inst_40272 = (inst_40246 > (0));
var state_40288__$1 = state_40288;
if(cljs.core.truth_(inst_40272)){
var statearr_40355_42710 = state_40288__$1;
(statearr_40355_42710[(1)] = (12));

} else {
var statearr_40356_42711 = state_40288__$1;
(statearr_40356_42711[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40289 === (3))){
var inst_40286 = (state_40288[(2)]);
var state_40288__$1 = state_40288;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40288__$1,inst_40286);
} else {
if((state_val_40289 === (12))){
var inst_40245 = (state_40288[(7)]);
var inst_40274 = cljs.core.vec(inst_40245);
var state_40288__$1 = state_40288;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_40288__$1,(15),out,inst_40274);
} else {
if((state_val_40289 === (2))){
var state_40288__$1 = state_40288;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40288__$1,(4),ch);
} else {
if((state_val_40289 === (11))){
var inst_40264 = (state_40288[(2)]);
var inst_40265 = (new Array(n));
var inst_40245 = inst_40265;
var inst_40246 = (0);
var state_40288__$1 = (function (){var statearr_40373 = state_40288;
(statearr_40373[(10)] = inst_40264);

(statearr_40373[(7)] = inst_40245);

(statearr_40373[(8)] = inst_40246);

return statearr_40373;
})();
var statearr_40375_42712 = state_40288__$1;
(statearr_40375_42712[(2)] = null);

(statearr_40375_42712[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40289 === (9))){
var inst_40245 = (state_40288[(7)]);
var inst_40262 = cljs.core.vec(inst_40245);
var state_40288__$1 = state_40288;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_40288__$1,(11),out,inst_40262);
} else {
if((state_val_40289 === (5))){
var inst_40245 = (state_40288[(7)]);
var inst_40246 = (state_40288[(8)]);
var inst_40249 = (state_40288[(9)]);
var inst_40254 = (state_40288[(11)]);
var inst_40253 = (inst_40245[inst_40246] = inst_40249);
var inst_40254__$1 = (inst_40246 + (1));
var inst_40255 = (inst_40254__$1 < n);
var state_40288__$1 = (function (){var statearr_40379 = state_40288;
(statearr_40379[(12)] = inst_40253);

(statearr_40379[(11)] = inst_40254__$1);

return statearr_40379;
})();
if(cljs.core.truth_(inst_40255)){
var statearr_40382_42714 = state_40288__$1;
(statearr_40382_42714[(1)] = (8));

} else {
var statearr_40383_42715 = state_40288__$1;
(statearr_40383_42715[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40289 === (14))){
var inst_40279 = (state_40288[(2)]);
var inst_40282 = cljs.core.async.close_BANG_(out);
var state_40288__$1 = (function (){var statearr_40385 = state_40288;
(statearr_40385[(13)] = inst_40279);

return statearr_40385;
})();
var statearr_40386_42716 = state_40288__$1;
(statearr_40386_42716[(2)] = inst_40282);

(statearr_40386_42716[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40289 === (10))){
var inst_40268 = (state_40288[(2)]);
var state_40288__$1 = state_40288;
var statearr_40393_42718 = state_40288__$1;
(statearr_40393_42718[(2)] = inst_40268);

(statearr_40393_42718[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40289 === (8))){
var inst_40245 = (state_40288[(7)]);
var inst_40254 = (state_40288[(11)]);
var tmp40384 = inst_40245;
var inst_40245__$1 = tmp40384;
var inst_40246 = inst_40254;
var state_40288__$1 = (function (){var statearr_40397 = state_40288;
(statearr_40397[(7)] = inst_40245__$1);

(statearr_40397[(8)] = inst_40246);

return statearr_40397;
})();
var statearr_40398_42719 = state_40288__$1;
(statearr_40398_42719[(2)] = null);

(statearr_40398_42719[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__34332__auto__ = null;
var cljs$core$async$state_machine__34332__auto____0 = (function (){
var statearr_40407 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40407[(0)] = cljs$core$async$state_machine__34332__auto__);

(statearr_40407[(1)] = (1));

return statearr_40407;
});
var cljs$core$async$state_machine__34332__auto____1 = (function (state_40288){
while(true){
var ret_value__34333__auto__ = (function (){try{while(true){
var result__34334__auto__ = switch__34331__auto__(state_40288);
if(cljs.core.keyword_identical_QMARK_(result__34334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34334__auto__;
}
break;
}
}catch (e40408){var ex__34335__auto__ = e40408;
var statearr_40412_42726 = state_40288;
(statearr_40412_42726[(2)] = ex__34335__auto__);


if(cljs.core.seq((state_40288[(4)]))){
var statearr_40443_42727 = state_40288;
(statearr_40443_42727[(1)] = cljs.core.first((state_40288[(4)])));

} else {
throw ex__34335__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42730 = state_40288;
state_40288 = G__42730;
continue;
} else {
return ret_value__34333__auto__;
}
break;
}
});
cljs$core$async$state_machine__34332__auto__ = function(state_40288){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__34332__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__34332__auto____1.call(this,state_40288);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__34332__auto____0;
cljs$core$async$state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__34332__auto____1;
return cljs$core$async$state_machine__34332__auto__;
})()
})();
var state__34497__auto__ = (function (){var statearr_40458 = f__34496__auto__();
(statearr_40458[(6)] = c__34495__auto___42669);

return statearr_40458;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34497__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__40465 = arguments.length;
switch (G__40465) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__34495__auto___42739 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__34496__auto__ = (function (){var switch__34331__auto__ = (function (state_40521){
var state_val_40522 = (state_40521[(1)]);
if((state_val_40522 === (7))){
var inst_40516 = (state_40521[(2)]);
var state_40521__$1 = state_40521;
var statearr_40524_42740 = state_40521__$1;
(statearr_40524_42740[(2)] = inst_40516);

(statearr_40524_42740[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40522 === (1))){
var inst_40471 = [];
var inst_40472 = inst_40471;
var inst_40473 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_40521__$1 = (function (){var statearr_40525 = state_40521;
(statearr_40525[(7)] = inst_40472);

(statearr_40525[(8)] = inst_40473);

return statearr_40525;
})();
var statearr_40526_42752 = state_40521__$1;
(statearr_40526_42752[(2)] = null);

(statearr_40526_42752[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40522 === (4))){
var inst_40476 = (state_40521[(9)]);
var inst_40476__$1 = (state_40521[(2)]);
var inst_40477 = (inst_40476__$1 == null);
var inst_40478 = cljs.core.not(inst_40477);
var state_40521__$1 = (function (){var statearr_40529 = state_40521;
(statearr_40529[(9)] = inst_40476__$1);

return statearr_40529;
})();
if(inst_40478){
var statearr_40530_42753 = state_40521__$1;
(statearr_40530_42753[(1)] = (5));

} else {
var statearr_40531_42754 = state_40521__$1;
(statearr_40531_42754[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40522 === (15))){
var inst_40472 = (state_40521[(7)]);
var inst_40508 = cljs.core.vec(inst_40472);
var state_40521__$1 = state_40521;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_40521__$1,(18),out,inst_40508);
} else {
if((state_val_40522 === (13))){
var inst_40503 = (state_40521[(2)]);
var state_40521__$1 = state_40521;
var statearr_40532_42759 = state_40521__$1;
(statearr_40532_42759[(2)] = inst_40503);

(statearr_40532_42759[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40522 === (6))){
var inst_40472 = (state_40521[(7)]);
var inst_40505 = inst_40472.length;
var inst_40506 = (inst_40505 > (0));
var state_40521__$1 = state_40521;
if(cljs.core.truth_(inst_40506)){
var statearr_40533_42760 = state_40521__$1;
(statearr_40533_42760[(1)] = (15));

} else {
var statearr_40534_42761 = state_40521__$1;
(statearr_40534_42761[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40522 === (17))){
var inst_40513 = (state_40521[(2)]);
var inst_40514 = cljs.core.async.close_BANG_(out);
var state_40521__$1 = (function (){var statearr_40535 = state_40521;
(statearr_40535[(10)] = inst_40513);

return statearr_40535;
})();
var statearr_40539_42762 = state_40521__$1;
(statearr_40539_42762[(2)] = inst_40514);

(statearr_40539_42762[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40522 === (3))){
var inst_40518 = (state_40521[(2)]);
var state_40521__$1 = state_40521;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40521__$1,inst_40518);
} else {
if((state_val_40522 === (12))){
var inst_40472 = (state_40521[(7)]);
var inst_40493 = cljs.core.vec(inst_40472);
var state_40521__$1 = state_40521;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_40521__$1,(14),out,inst_40493);
} else {
if((state_val_40522 === (2))){
var state_40521__$1 = state_40521;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40521__$1,(4),ch);
} else {
if((state_val_40522 === (11))){
var inst_40472 = (state_40521[(7)]);
var inst_40476 = (state_40521[(9)]);
var inst_40480 = (state_40521[(11)]);
var inst_40490 = inst_40472.push(inst_40476);
var tmp40546 = inst_40472;
var inst_40472__$1 = tmp40546;
var inst_40473 = inst_40480;
var state_40521__$1 = (function (){var statearr_40555 = state_40521;
(statearr_40555[(12)] = inst_40490);

(statearr_40555[(7)] = inst_40472__$1);

(statearr_40555[(8)] = inst_40473);

return statearr_40555;
})();
var statearr_40556_42763 = state_40521__$1;
(statearr_40556_42763[(2)] = null);

(statearr_40556_42763[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40522 === (9))){
var inst_40473 = (state_40521[(8)]);
var inst_40486 = cljs.core.keyword_identical_QMARK_(inst_40473,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_40521__$1 = state_40521;
var statearr_40565_42764 = state_40521__$1;
(statearr_40565_42764[(2)] = inst_40486);

(statearr_40565_42764[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40522 === (5))){
var inst_40476 = (state_40521[(9)]);
var inst_40480 = (state_40521[(11)]);
var inst_40473 = (state_40521[(8)]);
var inst_40481 = (state_40521[(13)]);
var inst_40480__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_40476) : f.call(null, inst_40476));
var inst_40481__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_40480__$1,inst_40473);
var state_40521__$1 = (function (){var statearr_40568 = state_40521;
(statearr_40568[(11)] = inst_40480__$1);

(statearr_40568[(13)] = inst_40481__$1);

return statearr_40568;
})();
if(inst_40481__$1){
var statearr_40572_42778 = state_40521__$1;
(statearr_40572_42778[(1)] = (8));

} else {
var statearr_40573_42779 = state_40521__$1;
(statearr_40573_42779[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40522 === (14))){
var inst_40476 = (state_40521[(9)]);
var inst_40480 = (state_40521[(11)]);
var inst_40495 = (state_40521[(2)]);
var inst_40496 = [];
var inst_40500 = inst_40496.push(inst_40476);
var inst_40472 = inst_40496;
var inst_40473 = inst_40480;
var state_40521__$1 = (function (){var statearr_40577 = state_40521;
(statearr_40577[(14)] = inst_40495);

(statearr_40577[(15)] = inst_40500);

(statearr_40577[(7)] = inst_40472);

(statearr_40577[(8)] = inst_40473);

return statearr_40577;
})();
var statearr_40584_42784 = state_40521__$1;
(statearr_40584_42784[(2)] = null);

(statearr_40584_42784[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40522 === (16))){
var state_40521__$1 = state_40521;
var statearr_40585_42788 = state_40521__$1;
(statearr_40585_42788[(2)] = null);

(statearr_40585_42788[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40522 === (10))){
var inst_40488 = (state_40521[(2)]);
var state_40521__$1 = state_40521;
if(cljs.core.truth_(inst_40488)){
var statearr_40589_42789 = state_40521__$1;
(statearr_40589_42789[(1)] = (11));

} else {
var statearr_40595_42790 = state_40521__$1;
(statearr_40595_42790[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40522 === (18))){
var inst_40510 = (state_40521[(2)]);
var state_40521__$1 = state_40521;
var statearr_40598_42791 = state_40521__$1;
(statearr_40598_42791[(2)] = inst_40510);

(statearr_40598_42791[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40522 === (8))){
var inst_40481 = (state_40521[(13)]);
var state_40521__$1 = state_40521;
var statearr_40599_42792 = state_40521__$1;
(statearr_40599_42792[(2)] = inst_40481);

(statearr_40599_42792[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__34332__auto__ = null;
var cljs$core$async$state_machine__34332__auto____0 = (function (){
var statearr_40605 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40605[(0)] = cljs$core$async$state_machine__34332__auto__);

(statearr_40605[(1)] = (1));

return statearr_40605;
});
var cljs$core$async$state_machine__34332__auto____1 = (function (state_40521){
while(true){
var ret_value__34333__auto__ = (function (){try{while(true){
var result__34334__auto__ = switch__34331__auto__(state_40521);
if(cljs.core.keyword_identical_QMARK_(result__34334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__34334__auto__;
}
break;
}
}catch (e40606){var ex__34335__auto__ = e40606;
var statearr_40607_42796 = state_40521;
(statearr_40607_42796[(2)] = ex__34335__auto__);


if(cljs.core.seq((state_40521[(4)]))){
var statearr_40608_42797 = state_40521;
(statearr_40608_42797[(1)] = cljs.core.first((state_40521[(4)])));

} else {
throw ex__34335__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__34333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42798 = state_40521;
state_40521 = G__42798;
continue;
} else {
return ret_value__34333__auto__;
}
break;
}
});
cljs$core$async$state_machine__34332__auto__ = function(state_40521){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__34332__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__34332__auto____1.call(this,state_40521);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__34332__auto____0;
cljs$core$async$state_machine__34332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__34332__auto____1;
return cljs$core$async$state_machine__34332__auto__;
})()
})();
var state__34497__auto__ = (function (){var statearr_40614 = f__34496__auto__();
(statearr_40614[(6)] = c__34495__auto___42739);

return statearr_40614;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__34497__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
