(ns reactstrap-cljs.core
  (:require [reactstrap]
            [reagent.core :as r]))

(defn adapt
  [tag]
  (r/adapt-react-class
   (aget reactstrap tag)))

(def alert (adapt "Alert"))
(def badge (adapt "Badge"))
(def breadcrumb (adapt "Breadcrumb"))
(def breadcrumb-item (adapt "BreadcrumbItem"))
(def button (adapt "Button"))
(def button-dropdown (adapt "ButtonDropdown"))
(def button-group (adapt "ButtonGroup"))
(def button-toolbar (adapt "ButtonToolbar"))
(def card (adapt "Card"))
(def card-body (adapt "CardBody"))
(def card-columns (adapt "CardColumns"))
(def card-deck (adapt "CardDeck"))
(def card-footer (adapt "CardFooter"))
(def card-group (adapt "CardGroup"))
(def card-header (adapt "CardHeader"))
(def card-img (adapt "CardImg"))
(def card-img-overlay (adapt "CardImgOverlay"))
(def card-link (adapt "CardLink"))
(def card-subtitle (adapt "CardSubtitle"))
(def card-text (adapt "CardText"))
(def card-title (adapt "CardTitle"))
(def carousel (adapt "Carousel"))
(def carousel-caption (adapt "CarouselCaption"))
(def carousel-control (adapt "CarouselControl"))
(def carousel-indicators (adapt "CarouselIndicators"))
(def carousel-item (adapt "CarouselItem"))
(def col (adapt "Col"))
(def collapse (adapt "Collapse"))
(def container (adapt "Container"))
(def dropdown (adapt "Dropdown"))
(def dropdown-item (adapt "DropdownItem"))
(def dropdown-menu (adapt "DropdownMenu"))
(def dropdown-toggle (adapt "DropdownToggle"))
(def fade (adapt "Fade"))
(def form (adapt "Form"))
(def form-feedback (adapt "FormFeedback"))
(def form-group (adapt "FormGroup"))
(def form-text (adapt "FormText"))
(def input (adapt "Input"))
(def input-group (adapt "InputGroup"))
(def input-group-text (adapt "InputGroupText"))
(def label (adapt "Label"))
(def list-group (adapt "ListGroup"))
(def list-group-item (adapt "ListGroupItem"))
(def list-group-item-heading (adapt "ListGroupItemHeading"))
(def list-group-item-text (adapt "ListGroupItemText"))
(def media (adapt "Media"))
(def modal (adapt "Modal"))
(def modal-body (adapt "ModalBody"))
(def modal-footer (adapt "ModalFooter"))
(def modal-header (adapt "ModalHeader"))
(def nav (adapt "Nav"))
(def nav-item (adapt "NavItem"))
(def nav-link (adapt "NavLink"))
(def navbar (adapt "Navbar"))
(def navbar-brand (adapt "NavbarBrand"))
(def navbar-toggler (adapt "NavbarToggler"))
(def pagination (adapt "Pagination"))
(def pagination-item (adapt "PaginationItem"))
(def pagination-link (adapt "PaginationLink"))
(def popover (adapt "Popover"))
(def popover-body (adapt "PopoverBody"))
(def popover-header (adapt "PopoverHeader"))
(def popper-content (adapt "PopperContent"))
(def popper-target-helper (adapt "PopperTargetHelper"))
(def progress (adapt "Progress"))
(def row (adapt "Row"))
(def tab-content (adapt "TabContent"))
(def tab-pane (adapt "TabPane"))
(def table (adapt "Table"))
(def tooltip (adapt "Tooltip"))
(def uncontrolled-alert (adapt "UncontrolledAlert"))
(def uncontrolled-button-dropdown (adapt "UncontrolledButtonDropdown"))
(def uncontrolled-carousel (adapt "UncontrolledCarousel"))
(def uncontrolled-dropdown (adapt "UncontrolledDropdown"))
(def uncontrolled-tooltip (adapt "UncontrolledTooltip"))
