(ns volga.middleware.core)

(defn wrap-memoize [f]
  (let [cache (volatile! {})]
    (fn [request]
      (let [request-hash (hash request)
            response (get @cache request-hash)]
        (or response
            (get (vswap! cache assoc request-hash (f request))
                 request-hash))))))

(defn wrap-debug [f log-fn]
  (fn [request]
    (log-fn "== Incomming request ==")
    (log-fn request)
    (log-fn "=======================")
    (let [response (f request)]
      (log-fn "== Outgoing response ==")
      (log-fn response)
      (log-fn "=======================")
      response)))
