(ns volga-firebird.specs.rest-unit
  (:require [clojure.spec.alpha :as s]
            [spec-tools.spec :as spec]
            [volga-firebird.specs.common :as common]
            [volga-firebird.specs.parameter :as parameter]))

(s/def ::type #{"REST"})

(s/def ::http-method ::common/http-method)

(s/def ::timeout spec/integer?)

(s/def ::cache-expiration spec/integer?)

(s/def ::range (s/coll-of spec/integer?
                          :into []
                          :min-count 2
                          :max-count 2))

(s/def ::valid-response-codes (s/coll-of (s/or :integer spec/integer?
                                               :range ::range)
                                         :into []))

(s/def ::parameters ::parameter/parameters)

(s/def ::config (s/keys :req-un [::type
                                 ::common/url
                                 ::http-method
                                 ::parameters]
                        :opt-un [::timeout
                                 ::cache-expiration
                                 ::valid-response-codes]))
