(ns volga-firebird.unit.common.url
  (:require [clojure.string :as string]
            [org.bovinegenius.exploding-fish :as uri]))

(defn interpolate [s m]
  (loop [[n v] (first m)
         vs    (rest m)
         s     s]
    (if v
      (recur (first vs)
             (rest vs)
             (string/replace s
                             (re-pattern (str "(:" (name n) "|\\{" (name n) "\\})"))
                             (str v)))
      s)))

(defn str->url [url]
  (uri/uri url))

(defn url->scheme [url]
  (uri/scheme url))

(defn url->host [url]
  (uri/host url))

(defn url->path [url]
  (uri/path url))

(defn url->query [url]
  (uri/query url))

(defn- add-index [extra-query]
  (loop [param (first extra-query) params (rest extra-query) acc []]
    (if param
      (let [index (count
                   (filter (fn [[param-name _ _]]
                             (= param-name (first param)))
                           acc))]
        (recur (first params) (rest params) (conj acc (conj param index))))
      acc)))

(defn- url->query* [url params]
  (if-let [param (first params)]
    (let [params (rest params)
          [param-name param-value param-index] param
          param-name (if (keyword? param-name)
                       (name param-name)
                       param-name)
          url (uri/param url param-name param-value param-index)]
      (url->query* url params))
    url))

(defn add-query [url extra-query]
  (url->query* url (add-index
                    (concat (uri/query-pairs url)
                            (vec extra-query)))))
