(ns volga-firebird.unit.rest
  (:require [volga-firebird.unit :as unit]
            [volga-firebird.unit.common.excel-transform :as excel-transform]
            [volga-firebird.unit.common.http-client :as http-client]
            [volga-firebird.unit.common.http-response-code :as http-response-code]
            [volga-firebird.unit.common.url :as url]))

(defmethod unit/unit->unit-fn "REST"
  [{{:keys [url http-method parameters timeout valid-response-codes]} :config}]
  (let [{:keys [query body header path]} parameters
        path-transform-function          (excel-transform/->transform-function path)
        query-transform-function         (excel-transform/->transform-function query)
        body-transform-function          (excel-transform/->transform-function body)
        header-transform-function        (excel-transform/->transform-function header)]
    (fn [{:keys [context] :as request}]
      (let [query-params   (query-transform-function request)
            body           (body-transform-function request)
            headers        (header-transform-function request)
            url            (->> request
                               path-transform-function
                               (url/interpolate url))
            params         {:method       http-method
                            :url          url
                            :headers      headers
                            :query-params query-params
                            :body         body
                            :timeout      timeout}
            {status :status
             :as    response} (http-client/request params context)]
        (if (http-response-code/unexceptional? status valid-response-codes)
          response
          (throw (ex-info "HTTP Exception" response)))))))
