/*
 * Decompiled with CFR 0.152.
 */
package io.xapix.flink;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.types.Row;

public class XapixMapOutput
implements MapFunction<Row, String>,
Serializable {
    private static final ObjectMapper mapper = new ObjectMapper();
    private final List<String> fields;
    private final Meta meta;

    public XapixMapOutput(List<String> fields, Meta meta) {
        this.fields = fields;
        this.meta = meta;
    }

    public String map(Row row) throws Exception {
        ObjectNode obj = mapper.createObjectNode();
        for (Map.Entry<String, String> entry : this.meta.getFields().entrySet()) {
            obj.put(entry.getKey(), entry.getValue());
        }
        ObjectNode data = obj.putObject("row");
        for (int i = 0; i < this.fields.size(); ++i) {
            data.set(this.fields.get(i), mapper.convertValue(row.getField(i), JsonNode.class));
        }
        return mapper.writeValueAsString(obj);
    }

    public static class Meta
    implements Serializable {
        private final Map<String, String> fields = new HashMap<String, String>();

        public Meta(String program) {
            this.fields.put("clojud-source-type", "flink");
            this.fields.put("clojud-program", program);
        }

        public Map<String, String> getFields() {
            return this.fields;
        }
    }
}

