/*
 * Decompiled with CFR 0.152.
 */
package io.xapix.capbac.cli;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.converters.FileConverter;
import com.beust.jcommander.converters.URLConverter;
import com.google.protobuf.util.JsonFormat;
import io.xapix.capbac.CapBAC;
import io.xapix.capbac.CapBACCertificate;
import io.xapix.capbac.CapBACHolder;
import io.xapix.capbac.CapBACInvocation;
import io.xapix.capbac.CapBACProto;
import io.xapix.capbac.CapBACPubs;
import io.xapix.capbac.CapBACValidator;
import io.xapix.capbac.trust.PatternChecker;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CapBACCli {
    private final ValidateArgs validateArgs = new ValidateArgs();
    private final HolderArgs holderArgs = new HolderArgs();
    private final PubsArgs pubs = new PubsArgs();
    private final CertificateArgs certArgs = new CertificateArgs();
    private final InvokeArgs invokeArgs = new InvokeArgs();

    private void run(String[] argv) {
        Security.addProvider(new BouncyCastleProvider());
        JCommander jc = JCommander.newBuilder().addCommand("forge", new Object[]{this.holderArgs, this.certArgs}, new String[0]).addCommand("delegate", new Object[]{this.holderArgs, this.certArgs}, new String[0]).addCommand("invoke", new Object[]{this.holderArgs, this.invokeArgs}, new String[0]).addCommand("certificate", new Object(), new String[0]).addCommand("certificate-validate", new Object[]{this.validateArgs, this.pubs}, new String[0]).addCommand("invocation", new Object(), new String[0]).addCommand("invocation-validate", new Object[]{this.validateArgs, this.pubs}, new String[0]).build();
        jc.parse(argv);
        if (jc.getParsedCommand() == null) {
            jc.usage();
            System.exit(1);
        }
        try {
            switch (jc.getParsedCommand()) {
                case "forge": {
                    this.runForge();
                    break;
                }
                case "delegate": {
                    this.runDelegate();
                    break;
                }
                case "invoke": {
                    this.runInvoke();
                    break;
                }
                case "certificate": {
                    CapBACCli.printCertificate();
                    break;
                }
                case "certificate-validate": {
                    CapBACCertificate cert = CapBACCli.printCertificate();
                    new CapBACValidator(new PatternChecker(this.validateArgs.trustRegex), this.pubs).validate(cert, this.validateArgs.now);
                    break;
                }
                case "invocation": {
                    CapBACCli.printInvocation();
                    break;
                }
                case "invocation-validate": {
                    CapBACInvocation inv = CapBACCli.printInvocation();
                    new CapBACValidator(new PatternChecker(this.validateArgs.trustRegex), this.pubs).validate(inv, this.validateArgs.now);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (CapBAC.Malformed e) {
            System.err.println(e.toString());
            System.exit(11);
        }
        catch (CapBAC.BadID e) {
            System.err.println(e.toString());
            System.exit(12);
        }
        catch (CapBAC.Invalid e) {
            System.err.println(e.toString());
            System.exit(13);
        }
        catch (CapBAC.Expired e) {
            System.err.println(e.toString());
            System.exit(14);
        }
        catch (CapBAC.BadSign e) {
            System.err.println(e.toString());
            System.exit(15);
        }
    }

    private void runForge() throws CapBAC.BadID {
        try {
            CapBACHolder holder = this.makeHolder();
            CapBACCertificate.Builder builder = this.makeCertBuilder();
            CapBACCertificate res = holder.forge(builder);
            System.out.write(res.encode());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void runInvoke() throws CapBAC.Malformed {
        try {
            CapBACHolder holder = this.makeHolder();
            CapBACInvocation.Builder builder = this.makeInvokeBuilder();
            CapBACInvocation res = holder.invoke(builder);
            System.out.write(res.encode());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void runDelegate() throws IOException, CapBAC.Malformed {
        byte[] input = IOUtils.toByteArray(System.in);
        CapBACHolder holder = this.makeHolder();
        CapBACCertificate.Builder builder = this.makeCertBuilder();
        CapBACCertificate res = holder.delegate(new CapBACCertificate(input), builder);
        System.out.write(res.encode());
    }

    private CapBACCertificate.Builder makeCertBuilder() {
        return new CapBACCertificate.Builder(this.certArgs.subject, this.certArgs.capability.getBytes()).withExp(this.certArgs.exp);
    }

    private CapBACInvocation.Builder makeInvokeBuilder() throws CapBAC.Malformed {
        try {
            return new CapBACInvocation.Builder(new CapBACCertificate(FileUtils.readFileToByteArray(this.invokeArgs.cert)), this.invokeArgs.action.getBytes()).withExp(this.certArgs.exp);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private CapBACHolder makeHolder() {
        return new CapBACHolder(this.holderArgs.me, this.holderArgs.sk);
    }

    public static void main(String[] argv) {
        new CapBACCli().run(argv);
    }

    private static CapBACCertificate printCertificate() throws CapBAC.Malformed {
        byte[] bytes;
        try {
            bytes = IOUtils.toByteArray(System.in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return CapBACCli.printCertificate(new CapBACCertificate(bytes));
    }

    private static CapBACCertificate printCertificate(CapBACCertificate rootCert) {
        try {
            for (CapBACCertificate cert = rootCert; cert != null; cert = cert.getParent()) {
                CapBACProto.Certificate.Payload payload = CapBACProto.Certificate.Payload.parseFrom(cert.getProto().getPayload());
                System.out.println(JsonFormat.printer().print(cert.getProto()));
                System.out.println(JsonFormat.printer().print(payload));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return rootCert;
    }

    private static CapBACInvocation printInvocation() throws CapBAC.Malformed {
        try {
            byte[] bytes = IOUtils.toByteArray(System.in);
            CapBACInvocation inv = new CapBACInvocation(bytes);
            System.out.println(JsonFormat.printer().print(inv.getProto()));
            CapBACProto.Invocation.Payload payload = CapBACProto.Invocation.Payload.parseFrom(inv.getProto().getPayload());
            System.out.println(JsonFormat.printer().print(payload));
            CapBACCli.printCertificate(inv.getCertificate());
            return inv;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static class ValidateArgs {
        @Parameter(names={"--trust-ids"}, description="Regexp to check that id is trusted. By default everything is valid", converter=PatternConverter.class)
        Pattern trustRegex = Pattern.compile(".*");
        @Parameter(names={"--now"}, description="Current time in seconds regarding expiration validation. By default is system time")
        long now = new Date().toInstant().toEpochMilli() / 1000L;

        ValidateArgs() {
        }
    }

    static class HolderArgs {
        @Parameter(names={"--me"}, description="ID of holder", required=true, converter=URLConverter.class)
        URL me;
        @Parameter(names={"--sk"}, description="Private key", converter=Converter.class)
        ECPrivateKey sk;

        HolderArgs() {
        }

        static class Converter
        implements IStringConverter<ECPrivateKey> {
            Converter() {
            }

            @Override
            public ECPrivateKey convert(String path) {
                try {
                    byte[] content = FileUtils.readFileToByteArray(new File(path));
                    PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(content);
                    KeyFactory factory = KeyFactory.getInstance("ECDSA");
                    return (ECPrivateKey)factory.generatePrivate(spec);
                }
                catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    static class PubsArgs
    implements CapBACPubs {
        @Parameter(names={"--pub"}, description="ID to public key map", converter=PKMapping.Converter.class)
        List<PKMapping> ids = new ArrayList<PKMapping>();

        PubsArgs() {
        }

        @Override
        public ECPublicKey get(URL id) {
            for (PKMapping mapping : this.ids) {
                if (!mapping.id.equals(id)) continue;
                return (ECPublicKey)mapping.val;
            }
            return null;
        }
    }

    static class CertificateArgs {
        @Parameter(names={"--capability"}, description="Capability", required=true)
        String capability;
        @Parameter(names={"--exp"}, description="Expiration time")
        long exp = 0L;
        @Parameter(names={"--subject"}, description="Target subject", required=true, converter=URLConverter.class)
        URL subject;

        CertificateArgs() {
        }
    }

    static class InvokeArgs {
        @Parameter(names={"--action"}, description="Action", required=true)
        String action;
        @Parameter(names={"--cert"}, description="Certificate for invocation", required=true, converter=FileConverter.class)
        File cert;
        @Parameter(names={"--exp"}, description="Expiration time")
        long exp = 0L;

        InvokeArgs() {
        }
    }

    static class PKMapping
    extends IDMapping<ECPublicKey> {
        PKMapping(String val) {
            super(val);
        }

        @Override
        public ECPublicKey parse(byte[] content) {
            try {
                KeyFactory kf = KeyFactory.getInstance("EC");
                X509EncodedKeySpec keySpec = new X509EncodedKeySpec(content);
                return (ECPublicKey)kf.generatePublic(keySpec);
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                throw new RuntimeException(e);
            }
        }

        static class Converter
        implements IStringConverter<PKMapping> {
            Converter() {
            }

            @Override
            public PKMapping convert(String value) {
                return new PKMapping(value);
            }
        }
    }

    static abstract class IDMapping<T> {
        final URL id;
        final T val;

        public IDMapping(String val) {
            try {
                String[] parts = val.split("=");
                this.id = new URL(parts[0]);
                this.val = this.parse(FileUtils.readFileToByteArray(new File(parts[1])));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        abstract T parse(byte[] var1);
    }

    static class PatternConverter
    implements IStringConverter<Pattern> {
        PatternConverter() {
        }

        @Override
        public Pattern convert(String value) {
            return Pattern.compile(value);
        }
    }

    static class UrlConverter
    implements IStringConverter<URL> {
        UrlConverter() {
        }

        @Override
        public URL convert(String value) {
            try {
                return new URL(value);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

