(defproject io.trosa/heyoka "0.1.0-SNAPSHOT"
  :description "A fully featured Telegram API wrapper"
  :url "https://github.com/iomonad/heyoka"
  :license {:name "EPL-2.0 OR GPL-2.0-or-later WITH Classpath-exception-2.0"
            :url "https://www.eclipse.org/legal/epl-2.0/"}
  :deploy-repositories [["snapshots" {:url "https://repo.clojars.org"
                                      :username :env/clojars_username
                                      :password :env/clojars_password
                                      :sign-releases false}]
                        ["releases"  {:url "https://repo.clojars.org"
                                      :username :env/clojars_username
                                      :password :env/clojars_password
                                      :sign-releases false}]]
  :dependencies [[org.clojure/clojure    "1.11.1"]
                 [prismatic/schema       "1.4.1"]
                 [metosin/jsonista       "0.3.7"]
                 [org.clojure/core.async "1.6.681"]
                 [clj-http               "3.12.3"
                  :exclusions [cheshire]]]
  :plugins [[lein-marginalia "0.9.1"]
            [lein-cloverage  "1.2.2"]]
  :profiles {:dev {:dependencies   [[org.clojure/tools.namespace "1.4.4"]]
                   :source-paths   ["dev"]
                   :resource-paths ["dev-resources"]
                   :repl-options {:init-ns user}}}
  :global-vars {*warn-on-reflection* true})
