(ns heyoka.utils
  (:require [clojure.string :as str]))


(defn kebabize-key
  "Convert API Json Snakecase to kebab
   one"
  {:added "0.1.0"}
  [k]
  (-> (name k)
      (str/replace #"_" "-")
      keyword))


(defn params->multiparts
  "Convert params to multiparts"
  [params]
  {:added "0.1.0"}
  (for [[k v] params]
    {:part-name (name k)
     :content (if-not (string? v) (str v) v)}))
