(ns heyoka.models
  (:require [schema.core :refer :all]))

;;; Telegram Models

(def ChatID (either Int Str))

(def User
  "This object represents a Telegram user or bot."
  {:id	                                       Int
   :is_bot	                               Bool
   :first_name	                               Str
   (optional-key :last_name)	               Str
   (optional-key :username)	               Str
   (optional-key :language_code)	       Str
   (optional-key :is_premium)	               Bool
   (optional-key :added_to_attachment_menu)    Bool
   (optional-key :can_join_groups)             Bool
   (optional-key :can_read_all_group_messages) Bool
   (optional-key :supports_inline_queries)     Bool})

(def MessageEntity
  "This object represents one special entity in a text message.
  For example, hashtags, usernames, URLs, etc."
  {:type	                   Str
   :offset	                   Num
   :length	                   Num
   (optional-key :url)	           Str
   (optional-key :user)	           User
   (optional-key :language)	   Str
   (optional-key :custom_emoji_id) Str})

(def InlineKeyboardMarkup
  {})

(def ReplyKeyboardMarkup
  {})

(def ReplyKeyboardRemove
  {})

(def ForceReply
  {})

(def ReplyMarkup (either InlineKeyboardMarkup
                         ReplyKeyboardMarkup
                         ReplyKeyboardRemove
                         ForceReply))

;;; Heyoka Call Models

(def MessagePayload
  "Payload schema that will be checked before API
   call."
  {:chat_id                                    ChatID
   :text                                       Str
   (optional-key :message_thread_id)           Int
   (optional-key :parse_mode)                  Str
   (optional-key :entities)                    [MessageEntity]
   (optional-key :disable_web_page_preview)    Bool
   (optional-key :disable_notification)        Bool
   (optional-key :protect_content)             Bool
   (optional-key :reply_to_message_id)         Int
   (optional-key :allow_sending_without_reply) Bool
   (optional-key :reply_markup )               ReplyMarkup})


(def MessageForwardPayload
  "Forward paylaod message"
  {:chat_id	                        ChatID
   (optional-key :message_thread_id)	Int
   :from_chat_id	                ChatID
   (optional-key :disable_notification)	Bool
   (optional-key :protect_content)	Bool
   :message_id	                        Int})


(def MessageCopyPayload
  {:chat_id	                               ChatID
   (optional-key :message_thread_id)	       Int
   :from_chat_id	                       ChatID
   :message_id	                               Int
   (optional-key :caption)	               Str
   (optional-key :parse_mode)	               Str
   (optional-key :caption_entities)	       [MessageEntity]
   (optional-key :disable_notification)	       Bool
   (optional-key :protect_content)	       Bool
   (optional-key :reply_to_message_id)	       Int
   (optional-key :allow_sending_without_reply) Bool
   (optional-key :reply_markup)	               ReplyMarkup})
