(ns geospatial.codecs.formats.geojson
  (:require [geospatial.codecs.core :as codec]
            [geospatial.codecs.models :as models]
            [geospatial.codecs.formats]
            [geospatial.geojson :as geojson]
            [malli.core :as m]
            [clojure.string :as str])
  (:import geospatial.codecs.formats.GeoJSON))

(defn- decode-to-canonical*
  [data]
  (let [entities
        (->> (:features data)
             (mapv (fn [{:keys [type properties geometry] :as data}]
                     {:entity/geometry
                      {:geometry/type (keyword (str/lower-case (name (get-in geometry [:type]))))
                       :geometry/coordinates (get-in geometry [:coordinates])}})))]
    {:doc/entities entities}))

(defn- encode-to-canonical*
  [{:keys [type] :as data}]
  (->> (:doc/entities data)
       (mapv (fn [entity]
               {:type "Feature"
                :geometry {:type "Point"
                           :coordinates (get-in entity [:entity/geometry :geometry/coordinates])}
                :properties (get-in entity [:entity/attributes])}))))

(extend-type GeoJSON
  codec/GeoCodec

  (-decode [_ data]
    (let [geojson (geojson/validate-geojson data)]
      (decode-to-canonical* data)))

  (-encode [_ data]
    (m/assert models/Document data)
    {:type "FeatureCollection"
     :features (encode-to-canonical* data)}))
