(ns geospatial.codecs.models
  (:require [malli.core :as m]
            [malli.generator :as mg]))

(def CRS
  [:map
   [:id keyword?]
   [:authority {:optional true} string?]
   [:definition {:optional true} map?]])

(def GeometryType
  [:enum
   :point
   :line
   :polygon
   :multi-point
   :multi-line
   :multi-polygon
   :geometry-collection])

(def Geometry
  [:map
   [:geometry/type GeometryType]
   [:geometry/coordinates any?]])

(def Entity
  [:map
   [:entity/id {:optional true} uuid?]
   [:entity/geometry {:optional true} Geometry]
   [:entity/attributes {:optional true} [:map-of keyword? any?]]])

(def Document
  [:map
   [:doc/crs {:optional true} CRS]
   [:doc/entities [:vector Entity]]])
